package appplatform

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ActionType enumerates the values for action type.
type ActionType string

const (
	// ActionTypeInternal ...
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns an array of possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{ActionTypeInternal}
}

// APIPortalProvisioningState enumerates the values for api portal provisioning state.
type APIPortalProvisioningState string

const (
	// APIPortalProvisioningStateCreating ...
	APIPortalProvisioningStateCreating APIPortalProvisioningState = "Creating"
	// APIPortalProvisioningStateDeleting ...
	APIPortalProvisioningStateDeleting APIPortalProvisioningState = "Deleting"
	// APIPortalProvisioningStateFailed ...
	APIPortalProvisioningStateFailed APIPortalProvisioningState = "Failed"
	// APIPortalProvisioningStateSucceeded ...
	APIPortalProvisioningStateSucceeded APIPortalProvisioningState = "Succeeded"
	// APIPortalProvisioningStateUpdating ...
	APIPortalProvisioningStateUpdating APIPortalProvisioningState = "Updating"
)

// PossibleAPIPortalProvisioningStateValues returns an array of possible values for the APIPortalProvisioningState const type.
func PossibleAPIPortalProvisioningStateValues() []APIPortalProvisioningState {
	return []APIPortalProvisioningState{APIPortalProvisioningStateCreating, APIPortalProvisioningStateDeleting, APIPortalProvisioningStateFailed, APIPortalProvisioningStateSucceeded, APIPortalProvisioningStateUpdating}
}

// AppResourceProvisioningState enumerates the values for app resource provisioning state.
type AppResourceProvisioningState string

const (
	// AppResourceProvisioningStateCreating ...
	AppResourceProvisioningStateCreating AppResourceProvisioningState = "Creating"
	// AppResourceProvisioningStateDeleting ...
	AppResourceProvisioningStateDeleting AppResourceProvisioningState = "Deleting"
	// AppResourceProvisioningStateFailed ...
	AppResourceProvisioningStateFailed AppResourceProvisioningState = "Failed"
	// AppResourceProvisioningStateSucceeded ...
	AppResourceProvisioningStateSucceeded AppResourceProvisioningState = "Succeeded"
	// AppResourceProvisioningStateUpdating ...
	AppResourceProvisioningStateUpdating AppResourceProvisioningState = "Updating"
)

// PossibleAppResourceProvisioningStateValues returns an array of possible values for the AppResourceProvisioningState const type.
func PossibleAppResourceProvisioningStateValues() []AppResourceProvisioningState {
	return []AppResourceProvisioningState{AppResourceProvisioningStateCreating, AppResourceProvisioningStateDeleting, AppResourceProvisioningStateFailed, AppResourceProvisioningStateSucceeded, AppResourceProvisioningStateUpdating}
}

// BindingType enumerates the values for binding type.
type BindingType string

const (
	// BindingTypeApacheSkyWalking ...
	BindingTypeApacheSkyWalking BindingType = "ApacheSkyWalking"
	// BindingTypeAppDynamics ...
	BindingTypeAppDynamics BindingType = "AppDynamics"
	// BindingTypeApplicationInsights ...
	BindingTypeApplicationInsights BindingType = "ApplicationInsights"
	// BindingTypeDynatrace ...
	BindingTypeDynatrace BindingType = "Dynatrace"
	// BindingTypeElasticAPM ...
	BindingTypeElasticAPM BindingType = "ElasticAPM"
	// BindingTypeNewRelic ...
	BindingTypeNewRelic BindingType = "NewRelic"
)

// PossibleBindingTypeValues returns an array of possible values for the BindingType const type.
func PossibleBindingTypeValues() []BindingType {
	return []BindingType{BindingTypeApacheSkyWalking, BindingTypeAppDynamics, BindingTypeApplicationInsights, BindingTypeDynatrace, BindingTypeElasticAPM, BindingTypeNewRelic}
}

// BuilderProvisioningState enumerates the values for builder provisioning state.
type BuilderProvisioningState string

const (
	// BuilderProvisioningStateCreating ...
	BuilderProvisioningStateCreating BuilderProvisioningState = "Creating"
	// BuilderProvisioningStateDeleting ...
	BuilderProvisioningStateDeleting BuilderProvisioningState = "Deleting"
	// BuilderProvisioningStateFailed ...
	BuilderProvisioningStateFailed BuilderProvisioningState = "Failed"
	// BuilderProvisioningStateSucceeded ...
	BuilderProvisioningStateSucceeded BuilderProvisioningState = "Succeeded"
	// BuilderProvisioningStateUpdating ...
	BuilderProvisioningStateUpdating BuilderProvisioningState = "Updating"
)

// PossibleBuilderProvisioningStateValues returns an array of possible values for the BuilderProvisioningState const type.
func PossibleBuilderProvisioningStateValues() []BuilderProvisioningState {
	return []BuilderProvisioningState{BuilderProvisioningStateCreating, BuilderProvisioningStateDeleting, BuilderProvisioningStateFailed, BuilderProvisioningStateSucceeded, BuilderProvisioningStateUpdating}
}

// BuildpackBindingProvisioningState enumerates the values for buildpack binding provisioning state.
type BuildpackBindingProvisioningState string

const (
	// BuildpackBindingProvisioningStateCreating ...
	BuildpackBindingProvisioningStateCreating BuildpackBindingProvisioningState = "Creating"
	// BuildpackBindingProvisioningStateDeleting ...
	BuildpackBindingProvisioningStateDeleting BuildpackBindingProvisioningState = "Deleting"
	// BuildpackBindingProvisioningStateFailed ...
	BuildpackBindingProvisioningStateFailed BuildpackBindingProvisioningState = "Failed"
	// BuildpackBindingProvisioningStateSucceeded ...
	BuildpackBindingProvisioningStateSucceeded BuildpackBindingProvisioningState = "Succeeded"
	// BuildpackBindingProvisioningStateUpdating ...
	BuildpackBindingProvisioningStateUpdating BuildpackBindingProvisioningState = "Updating"
)

// PossibleBuildpackBindingProvisioningStateValues returns an array of possible values for the BuildpackBindingProvisioningState const type.
func PossibleBuildpackBindingProvisioningStateValues() []BuildpackBindingProvisioningState {
	return []BuildpackBindingProvisioningState{BuildpackBindingProvisioningStateCreating, BuildpackBindingProvisioningStateDeleting, BuildpackBindingProvisioningStateFailed, BuildpackBindingProvisioningStateSucceeded, BuildpackBindingProvisioningStateUpdating}
}

// BuildProvisioningState enumerates the values for build provisioning state.
type BuildProvisioningState string

const (
	// BuildProvisioningStateCreating ...
	BuildProvisioningStateCreating BuildProvisioningState = "Creating"
	// BuildProvisioningStateDeleting ...
	BuildProvisioningStateDeleting BuildProvisioningState = "Deleting"
	// BuildProvisioningStateFailed ...
	BuildProvisioningStateFailed BuildProvisioningState = "Failed"
	// BuildProvisioningStateSucceeded ...
	BuildProvisioningStateSucceeded BuildProvisioningState = "Succeeded"
	// BuildProvisioningStateUpdating ...
	BuildProvisioningStateUpdating BuildProvisioningState = "Updating"
)

// PossibleBuildProvisioningStateValues returns an array of possible values for the BuildProvisioningState const type.
func PossibleBuildProvisioningStateValues() []BuildProvisioningState {
	return []BuildProvisioningState{BuildProvisioningStateCreating, BuildProvisioningStateDeleting, BuildProvisioningStateFailed, BuildProvisioningStateSucceeded, BuildProvisioningStateUpdating}
}

// BuildResultProvisioningState enumerates the values for build result provisioning state.
type BuildResultProvisioningState string

const (
	// BuildResultProvisioningStateBuilding ...
	BuildResultProvisioningStateBuilding BuildResultProvisioningState = "Building"
	// BuildResultProvisioningStateDeleting ...
	BuildResultProvisioningStateDeleting BuildResultProvisioningState = "Deleting"
	// BuildResultProvisioningStateFailed ...
	BuildResultProvisioningStateFailed BuildResultProvisioningState = "Failed"
	// BuildResultProvisioningStateQueuing ...
	BuildResultProvisioningStateQueuing BuildResultProvisioningState = "Queuing"
	// BuildResultProvisioningStateSucceeded ...
	BuildResultProvisioningStateSucceeded BuildResultProvisioningState = "Succeeded"
)

// PossibleBuildResultProvisioningStateValues returns an array of possible values for the BuildResultProvisioningState const type.
func PossibleBuildResultProvisioningStateValues() []BuildResultProvisioningState {
	return []BuildResultProvisioningState{BuildResultProvisioningStateBuilding, BuildResultProvisioningStateDeleting, BuildResultProvisioningStateFailed, BuildResultProvisioningStateQueuing, BuildResultProvisioningStateSucceeded}
}

// BuildServiceProvisioningState enumerates the values for build service provisioning state.
type BuildServiceProvisioningState string

const (
	// BuildServiceProvisioningStateCreating ...
	BuildServiceProvisioningStateCreating BuildServiceProvisioningState = "Creating"
	// BuildServiceProvisioningStateDeleting ...
	BuildServiceProvisioningStateDeleting BuildServiceProvisioningState = "Deleting"
	// BuildServiceProvisioningStateFailed ...
	BuildServiceProvisioningStateFailed BuildServiceProvisioningState = "Failed"
	// BuildServiceProvisioningStateSucceeded ...
	BuildServiceProvisioningStateSucceeded BuildServiceProvisioningState = "Succeeded"
	// BuildServiceProvisioningStateUpdating ...
	BuildServiceProvisioningStateUpdating BuildServiceProvisioningState = "Updating"
)

// PossibleBuildServiceProvisioningStateValues returns an array of possible values for the BuildServiceProvisioningState const type.
func PossibleBuildServiceProvisioningStateValues() []BuildServiceProvisioningState {
	return []BuildServiceProvisioningState{BuildServiceProvisioningStateCreating, BuildServiceProvisioningStateDeleting, BuildServiceProvisioningStateFailed, BuildServiceProvisioningStateSucceeded, BuildServiceProvisioningStateUpdating}
}

// ConfigServerState enumerates the values for config server state.
type ConfigServerState string

const (
	// ConfigServerStateDeleted ...
	ConfigServerStateDeleted ConfigServerState = "Deleted"
	// ConfigServerStateFailed ...
	ConfigServerStateFailed ConfigServerState = "Failed"
	// ConfigServerStateNotAvailable ...
	ConfigServerStateNotAvailable ConfigServerState = "NotAvailable"
	// ConfigServerStateSucceeded ...
	ConfigServerStateSucceeded ConfigServerState = "Succeeded"
	// ConfigServerStateUpdating ...
	ConfigServerStateUpdating ConfigServerState = "Updating"
)

// PossibleConfigServerStateValues returns an array of possible values for the ConfigServerState const type.
func PossibleConfigServerStateValues() []ConfigServerState {
	return []ConfigServerState{ConfigServerStateDeleted, ConfigServerStateFailed, ConfigServerStateNotAvailable, ConfigServerStateSucceeded, ConfigServerStateUpdating}
}

// ConfigurationServiceProvisioningState enumerates the values for configuration service provisioning state.
type ConfigurationServiceProvisioningState string

const (
	// ConfigurationServiceProvisioningStateCreating ...
	ConfigurationServiceProvisioningStateCreating ConfigurationServiceProvisioningState = "Creating"
	// ConfigurationServiceProvisioningStateDeleting ...
	ConfigurationServiceProvisioningStateDeleting ConfigurationServiceProvisioningState = "Deleting"
	// ConfigurationServiceProvisioningStateFailed ...
	ConfigurationServiceProvisioningStateFailed ConfigurationServiceProvisioningState = "Failed"
	// ConfigurationServiceProvisioningStateSucceeded ...
	ConfigurationServiceProvisioningStateSucceeded ConfigurationServiceProvisioningState = "Succeeded"
	// ConfigurationServiceProvisioningStateUpdating ...
	ConfigurationServiceProvisioningStateUpdating ConfigurationServiceProvisioningState = "Updating"
)

// PossibleConfigurationServiceProvisioningStateValues returns an array of possible values for the ConfigurationServiceProvisioningState const type.
func PossibleConfigurationServiceProvisioningStateValues() []ConfigurationServiceProvisioningState {
	return []ConfigurationServiceProvisioningState{ConfigurationServiceProvisioningStateCreating, ConfigurationServiceProvisioningStateDeleting, ConfigurationServiceProvisioningStateFailed, ConfigurationServiceProvisioningStateSucceeded, ConfigurationServiceProvisioningStateUpdating}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DeploymentResourceProvisioningState enumerates the values for deployment resource provisioning state.
type DeploymentResourceProvisioningState string

const (
	// DeploymentResourceProvisioningStateCreating ...
	DeploymentResourceProvisioningStateCreating DeploymentResourceProvisioningState = "Creating"
	// DeploymentResourceProvisioningStateFailed ...
	DeploymentResourceProvisioningStateFailed DeploymentResourceProvisioningState = "Failed"
	// DeploymentResourceProvisioningStateSucceeded ...
	DeploymentResourceProvisioningStateSucceeded DeploymentResourceProvisioningState = "Succeeded"
	// DeploymentResourceProvisioningStateUpdating ...
	DeploymentResourceProvisioningStateUpdating DeploymentResourceProvisioningState = "Updating"
)

// PossibleDeploymentResourceProvisioningStateValues returns an array of possible values for the DeploymentResourceProvisioningState const type.
func PossibleDeploymentResourceProvisioningStateValues() []DeploymentResourceProvisioningState {
	return []DeploymentResourceProvisioningState{DeploymentResourceProvisioningStateCreating, DeploymentResourceProvisioningStateFailed, DeploymentResourceProvisioningStateSucceeded, DeploymentResourceProvisioningStateUpdating}
}

// DeploymentResourceStatus enumerates the values for deployment resource status.
type DeploymentResourceStatus string

const (
	// DeploymentResourceStatusRunning ...
	DeploymentResourceStatusRunning DeploymentResourceStatus = "Running"
	// DeploymentResourceStatusStopped ...
	DeploymentResourceStatusStopped DeploymentResourceStatus = "Stopped"
)

// PossibleDeploymentResourceStatusValues returns an array of possible values for the DeploymentResourceStatus const type.
func PossibleDeploymentResourceStatusValues() []DeploymentResourceStatus {
	return []DeploymentResourceStatus{DeploymentResourceStatusRunning, DeploymentResourceStatusStopped}
}

// GatewayProvisioningState enumerates the values for gateway provisioning state.
type GatewayProvisioningState string

const (
	// GatewayProvisioningStateCreating ...
	GatewayProvisioningStateCreating GatewayProvisioningState = "Creating"
	// GatewayProvisioningStateDeleting ...
	GatewayProvisioningStateDeleting GatewayProvisioningState = "Deleting"
	// GatewayProvisioningStateFailed ...
	GatewayProvisioningStateFailed GatewayProvisioningState = "Failed"
	// GatewayProvisioningStateSucceeded ...
	GatewayProvisioningStateSucceeded GatewayProvisioningState = "Succeeded"
	// GatewayProvisioningStateUpdating ...
	GatewayProvisioningStateUpdating GatewayProvisioningState = "Updating"
)

// PossibleGatewayProvisioningStateValues returns an array of possible values for the GatewayProvisioningState const type.
func PossibleGatewayProvisioningStateValues() []GatewayProvisioningState {
	return []GatewayProvisioningState{GatewayProvisioningStateCreating, GatewayProvisioningStateDeleting, GatewayProvisioningStateFailed, GatewayProvisioningStateSucceeded, GatewayProvisioningStateUpdating}
}

// KPackBuildStageProvisioningState enumerates the values for k pack build stage provisioning state.
type KPackBuildStageProvisioningState string

const (
	// KPackBuildStageProvisioningStateFailed ...
	KPackBuildStageProvisioningStateFailed KPackBuildStageProvisioningState = "Failed"
	// KPackBuildStageProvisioningStateNotStarted ...
	KPackBuildStageProvisioningStateNotStarted KPackBuildStageProvisioningState = "NotStarted"
	// KPackBuildStageProvisioningStateRunning ...
	KPackBuildStageProvisioningStateRunning KPackBuildStageProvisioningState = "Running"
	// KPackBuildStageProvisioningStateSucceeded ...
	KPackBuildStageProvisioningStateSucceeded KPackBuildStageProvisioningState = "Succeeded"
)

// PossibleKPackBuildStageProvisioningStateValues returns an array of possible values for the KPackBuildStageProvisioningState const type.
func PossibleKPackBuildStageProvisioningStateValues() []KPackBuildStageProvisioningState {
	return []KPackBuildStageProvisioningState{KPackBuildStageProvisioningStateFailed, KPackBuildStageProvisioningStateNotStarted, KPackBuildStageProvisioningStateRunning, KPackBuildStageProvisioningStateSucceeded}
}

// LastModifiedByType enumerates the values for last modified by type.
type LastModifiedByType string

const (
	// LastModifiedByTypeApplication ...
	LastModifiedByTypeApplication LastModifiedByType = "Application"
	// LastModifiedByTypeKey ...
	LastModifiedByTypeKey LastModifiedByType = "Key"
	// LastModifiedByTypeManagedIdentity ...
	LastModifiedByTypeManagedIdentity LastModifiedByType = "ManagedIdentity"
	// LastModifiedByTypeUser ...
	LastModifiedByTypeUser LastModifiedByType = "User"
)

// PossibleLastModifiedByTypeValues returns an array of possible values for the LastModifiedByType const type.
func PossibleLastModifiedByTypeValues() []LastModifiedByType {
	return []LastModifiedByType{LastModifiedByTypeApplication, LastModifiedByTypeKey, LastModifiedByTypeManagedIdentity, LastModifiedByTypeUser}
}

// ManagedIdentityType enumerates the values for managed identity type.
type ManagedIdentityType string

const (
	// ManagedIdentityTypeNone ...
	ManagedIdentityTypeNone ManagedIdentityType = "None"
	// ManagedIdentityTypeSystemAssigned ...
	ManagedIdentityTypeSystemAssigned ManagedIdentityType = "SystemAssigned"
	// ManagedIdentityTypeSystemAssignedUserAssigned ...
	ManagedIdentityTypeSystemAssignedUserAssigned ManagedIdentityType = "SystemAssigned,UserAssigned"
	// ManagedIdentityTypeUserAssigned ...
	ManagedIdentityTypeUserAssigned ManagedIdentityType = "UserAssigned"
)

// PossibleManagedIdentityTypeValues returns an array of possible values for the ManagedIdentityType const type.
func PossibleManagedIdentityTypeValues() []ManagedIdentityType {
	return []ManagedIdentityType{ManagedIdentityTypeNone, ManagedIdentityTypeSystemAssigned, ManagedIdentityTypeSystemAssignedUserAssigned, ManagedIdentityTypeUserAssigned}
}

// MonitoringSettingState enumerates the values for monitoring setting state.
type MonitoringSettingState string

const (
	// MonitoringSettingStateFailed ...
	MonitoringSettingStateFailed MonitoringSettingState = "Failed"
	// MonitoringSettingStateNotAvailable ...
	MonitoringSettingStateNotAvailable MonitoringSettingState = "NotAvailable"
	// MonitoringSettingStateSucceeded ...
	MonitoringSettingStateSucceeded MonitoringSettingState = "Succeeded"
	// MonitoringSettingStateUpdating ...
	MonitoringSettingStateUpdating MonitoringSettingState = "Updating"
)

// PossibleMonitoringSettingStateValues returns an array of possible values for the MonitoringSettingState const type.
func PossibleMonitoringSettingStateValues() []MonitoringSettingState {
	return []MonitoringSettingState{MonitoringSettingStateFailed, MonitoringSettingStateNotAvailable, MonitoringSettingStateSucceeded, MonitoringSettingStateUpdating}
}

// PowerState enumerates the values for power state.
type PowerState string

const (
	// PowerStateRunning ...
	PowerStateRunning PowerState = "Running"
	// PowerStateStopped ...
	PowerStateStopped PowerState = "Stopped"
)

// PossiblePowerStateValues returns an array of possible values for the PowerState const type.
func PossiblePowerStateValues() []PowerState {
	return []PowerState{PowerStateRunning, PowerStateStopped}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleted ...
	ProvisioningStateDeleted ProvisioningState = "Deleted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateMoved ...
	ProvisioningStateMoved ProvisioningState = "Moved"
	// ProvisioningStateMoveFailed ...
	ProvisioningStateMoveFailed ProvisioningState = "MoveFailed"
	// ProvisioningStateMoving ...
	ProvisioningStateMoving ProvisioningState = "Moving"
	// ProvisioningStateStarting ...
	ProvisioningStateStarting ProvisioningState = "Starting"
	// ProvisioningStateStopping ...
	ProvisioningStateStopping ProvisioningState = "Stopping"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateMoved, ProvisioningStateMoveFailed, ProvisioningStateMoving, ProvisioningStateStarting, ProvisioningStateStopping, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ...
	ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// ResourceSkuRestrictionsReasonCodeQuotaID ...
	ResourceSkuRestrictionsReasonCodeQuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription, ResourceSkuRestrictionsReasonCodeQuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// ResourceSkuRestrictionsTypeLocation ...
	ResourceSkuRestrictionsTypeLocation ResourceSkuRestrictionsType = "Location"
	// ResourceSkuRestrictionsTypeZone ...
	ResourceSkuRestrictionsTypeZone ResourceSkuRestrictionsType = "Zone"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{ResourceSkuRestrictionsTypeLocation, ResourceSkuRestrictionsTypeZone}
}

// ServiceRegistryProvisioningState enumerates the values for service registry provisioning state.
type ServiceRegistryProvisioningState string

const (
	// ServiceRegistryProvisioningStateCreating ...
	ServiceRegistryProvisioningStateCreating ServiceRegistryProvisioningState = "Creating"
	// ServiceRegistryProvisioningStateDeleting ...
	ServiceRegistryProvisioningStateDeleting ServiceRegistryProvisioningState = "Deleting"
	// ServiceRegistryProvisioningStateFailed ...
	ServiceRegistryProvisioningStateFailed ServiceRegistryProvisioningState = "Failed"
	// ServiceRegistryProvisioningStateSucceeded ...
	ServiceRegistryProvisioningStateSucceeded ServiceRegistryProvisioningState = "Succeeded"
	// ServiceRegistryProvisioningStateUpdating ...
	ServiceRegistryProvisioningStateUpdating ServiceRegistryProvisioningState = "Updating"
)

// PossibleServiceRegistryProvisioningStateValues returns an array of possible values for the ServiceRegistryProvisioningState const type.
func PossibleServiceRegistryProvisioningStateValues() []ServiceRegistryProvisioningState {
	return []ServiceRegistryProvisioningState{ServiceRegistryProvisioningStateCreating, ServiceRegistryProvisioningStateDeleting, ServiceRegistryProvisioningStateFailed, ServiceRegistryProvisioningStateSucceeded, ServiceRegistryProvisioningStateUpdating}
}

// SkuScaleType enumerates the values for sku scale type.
type SkuScaleType string

const (
	// SkuScaleTypeAutomatic ...
	SkuScaleTypeAutomatic SkuScaleType = "Automatic"
	// SkuScaleTypeManual ...
	SkuScaleTypeManual SkuScaleType = "Manual"
	// SkuScaleTypeNone ...
	SkuScaleTypeNone SkuScaleType = "None"
)

// PossibleSkuScaleTypeValues returns an array of possible values for the SkuScaleType const type.
func PossibleSkuScaleTypeValues() []SkuScaleType {
	return []SkuScaleType{SkuScaleTypeAutomatic, SkuScaleTypeManual, SkuScaleTypeNone}
}

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeStorageAccount ...
	StorageTypeStorageAccount StorageType = "StorageAccount"
	// StorageTypeStorageProperties ...
	StorageTypeStorageProperties StorageType = "StorageProperties"
)

// PossibleStorageTypeValues returns an array of possible values for the StorageType const type.
func PossibleStorageTypeValues() []StorageType {
	return []StorageType{StorageTypeStorageAccount, StorageTypeStorageProperties}
}

// SupportedRuntimePlatform enumerates the values for supported runtime platform.
type SupportedRuntimePlatform string

const (
	// SupportedRuntimePlatformJava ...
	SupportedRuntimePlatformJava SupportedRuntimePlatform = "Java"
	// SupportedRuntimePlatformNETCore ...
	SupportedRuntimePlatformNETCore SupportedRuntimePlatform = ".NET Core"
)

// PossibleSupportedRuntimePlatformValues returns an array of possible values for the SupportedRuntimePlatform const type.
func PossibleSupportedRuntimePlatformValues() []SupportedRuntimePlatform {
	return []SupportedRuntimePlatform{SupportedRuntimePlatformJava, SupportedRuntimePlatformNETCore}
}

// SupportedRuntimeValue enumerates the values for supported runtime value.
type SupportedRuntimeValue string

const (
	// SupportedRuntimeValueJava11 ...
	SupportedRuntimeValueJava11 SupportedRuntimeValue = "Java_11"
	// SupportedRuntimeValueJava17 ...
	SupportedRuntimeValueJava17 SupportedRuntimeValue = "Java_17"
	// SupportedRuntimeValueJava8 ...
	SupportedRuntimeValueJava8 SupportedRuntimeValue = "Java_8"
	// SupportedRuntimeValueNetCore31 ...
	SupportedRuntimeValueNetCore31 SupportedRuntimeValue = "NetCore_31"
)

// PossibleSupportedRuntimeValueValues returns an array of possible values for the SupportedRuntimeValue const type.
func PossibleSupportedRuntimeValueValues() []SupportedRuntimeValue {
	return []SupportedRuntimeValue{SupportedRuntimeValueJava11, SupportedRuntimeValueJava17, SupportedRuntimeValueJava8, SupportedRuntimeValueNetCore31}
}

// TestKeyType enumerates the values for test key type.
type TestKeyType string

const (
	// TestKeyTypePrimary ...
	TestKeyTypePrimary TestKeyType = "Primary"
	// TestKeyTypeSecondary ...
	TestKeyTypeSecondary TestKeyType = "Secondary"
)

// PossibleTestKeyTypeValues returns an array of possible values for the TestKeyType const type.
func PossibleTestKeyTypeValues() []TestKeyType {
	return []TestKeyType{TestKeyTypePrimary, TestKeyTypeSecondary}
}

// TrafficDirection enumerates the values for traffic direction.
type TrafficDirection string

const (
	// TrafficDirectionInbound ...
	TrafficDirectionInbound TrafficDirection = "Inbound"
	// TrafficDirectionOutbound ...
	TrafficDirectionOutbound TrafficDirection = "Outbound"
)

// PossibleTrafficDirectionValues returns an array of possible values for the TrafficDirection const type.
func PossibleTrafficDirectionValues() []TrafficDirection {
	return []TrafficDirection{TrafficDirectionInbound, TrafficDirectionOutbound}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAzureFileVolume ...
	TypeAzureFileVolume Type = "AzureFileVolume"
	// TypeCustomPersistentDiskProperties ...
	TypeCustomPersistentDiskProperties Type = "CustomPersistentDiskProperties"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAzureFileVolume, TypeCustomPersistentDiskProperties}
}

// TypeBasicCertificateProperties enumerates the values for type basic certificate properties.
type TypeBasicCertificateProperties string

const (
	// TypeBasicCertificatePropertiesTypeCertificateProperties ...
	TypeBasicCertificatePropertiesTypeCertificateProperties TypeBasicCertificateProperties = "CertificateProperties"
	// TypeBasicCertificatePropertiesTypeContentCertificate ...
	TypeBasicCertificatePropertiesTypeContentCertificate TypeBasicCertificateProperties = "ContentCertificate"
	// TypeBasicCertificatePropertiesTypeKeyVaultCertificate ...
	TypeBasicCertificatePropertiesTypeKeyVaultCertificate TypeBasicCertificateProperties = "KeyVaultCertificate"
)

// PossibleTypeBasicCertificatePropertiesValues returns an array of possible values for the TypeBasicCertificateProperties const type.
func PossibleTypeBasicCertificatePropertiesValues() []TypeBasicCertificateProperties {
	return []TypeBasicCertificateProperties{TypeBasicCertificatePropertiesTypeCertificateProperties, TypeBasicCertificatePropertiesTypeContentCertificate, TypeBasicCertificatePropertiesTypeKeyVaultCertificate}
}

// TypeBasicUserSourceInfo enumerates the values for type basic user source info.
type TypeBasicUserSourceInfo string

const (
	// TypeBasicUserSourceInfoTypeBuildResult ...
	TypeBasicUserSourceInfoTypeBuildResult TypeBasicUserSourceInfo = "BuildResult"
	// TypeBasicUserSourceInfoTypeContainer ...
	TypeBasicUserSourceInfoTypeContainer TypeBasicUserSourceInfo = "Container"
	// TypeBasicUserSourceInfoTypeJar ...
	TypeBasicUserSourceInfoTypeJar TypeBasicUserSourceInfo = "Jar"
	// TypeBasicUserSourceInfoTypeNetCoreZip ...
	TypeBasicUserSourceInfoTypeNetCoreZip TypeBasicUserSourceInfo = "NetCoreZip"
	// TypeBasicUserSourceInfoTypeSource ...
	TypeBasicUserSourceInfoTypeSource TypeBasicUserSourceInfo = "Source"
	// TypeBasicUserSourceInfoTypeUploadedUserSourceInfo ...
	TypeBasicUserSourceInfoTypeUploadedUserSourceInfo TypeBasicUserSourceInfo = "UploadedUserSourceInfo"
	// TypeBasicUserSourceInfoTypeUserSourceInfo ...
	TypeBasicUserSourceInfoTypeUserSourceInfo TypeBasicUserSourceInfo = "UserSourceInfo"
)

// PossibleTypeBasicUserSourceInfoValues returns an array of possible values for the TypeBasicUserSourceInfo const type.
func PossibleTypeBasicUserSourceInfoValues() []TypeBasicUserSourceInfo {
	return []TypeBasicUserSourceInfo{TypeBasicUserSourceInfoTypeBuildResult, TypeBasicUserSourceInfoTypeContainer, TypeBasicUserSourceInfoTypeJar, TypeBasicUserSourceInfoTypeNetCoreZip, TypeBasicUserSourceInfoTypeSource, TypeBasicUserSourceInfoTypeUploadedUserSourceInfo, TypeBasicUserSourceInfoTypeUserSourceInfo}
}
