package catalog

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/datalake/analytics/2015-10-01-preview/catalog"

// DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters dataLakeAnalytics DataLakeAnalyticsAccount
// information.
type DataLakeAnalyticsCatalogSecretCreateOrUpdateParameters struct {
	// Password - the password for the secret to pass in
	Password *string `json:"password,omitempty"`
	// URI - the URI identifier for the secret in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
}

// DdlName a Data Lake Analytics DDL name item.
type DdlName struct {
	// FirstPart - the name of the table associated with this database and schema.
	FirstPart *string `json:"firstPart,omitempty"`
	// SecondPart - the name of the table associated with this database and schema.
	SecondPart *string `json:"secondPart,omitempty"`
	// ThirdPart - the name of the table associated with this database and schema.
	ThirdPart *string `json:"thirdPart,omitempty"`
	// Server - the name of the table associated with this database and schema.
	Server *string `json:"server,omitempty"`
}

// EntityID a Data Lake Analytics catalog entity identifier object.
type EntityID struct {
	// Name - the name of the external table associated with this database, schema and table.
	Name *DdlName `json:"name,omitempty"`
	// Version - the version of the external data source.
	Version *uuid.UUID `json:"version,omitempty"`
}

// ExternalTable a Data Lake Analytics catalog external table item.
type ExternalTable struct {
	// TableName - the name of the table associated with this database and schema.
	TableName *string `json:"tableName,omitempty"`
	// DataSource - the data source associated with this external table.
	DataSource *EntityID `json:"dataSource,omitempty"`
}

// Item a Data Lake Analytics catalog item.
type Item struct {
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// ItemList a Data Lake Analytics catalog item list.
type ItemList struct {
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TypeFieldInfo a Data Lake Analytics catalog type field information item.
type TypeFieldInfo struct {
	// Name - the name of the field associated with this type.
	Name *string `json:"name,omitempty"`
	// Type - the type of the field.
	Type *string `json:"type,omitempty"`
}

// USQLAssembly a Data Lake Analytics catalog U-SQL Assembly.
type USQLAssembly struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the assembly.
	Name *string `json:"assemblyName,omitempty"`
	// ClrName - the name of the CLR.
	ClrName *string `json:"clrName,omitempty"`
	// IsVisible - the switch indicating if this assembly is visible or not.
	IsVisible *bool `json:"isVisible,omitempty"`
	// IsUserDefined - the switch indicating if this assembly is user defined or not.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// Files - the list of files associated with the assembly
	Files *[]USQLAssemblyFileInfo `json:"files,omitempty"`
	// Dependencies - the list of dependencies associated with the assembly
	Dependencies *[]USQLAssemblyDependencyInfo `json:"dependencies,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLAssemblyClr a Data Lake Analytics catalog U-SQL assembly CLR item.
type USQLAssemblyClr struct {
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the assembly.
	Name *string `json:"assemblyClrName,omitempty"`
	// ClrName - the name of the CLR.
	ClrName *string `json:"clrName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLAssemblyDependencyInfo a Data Lake Analytics catalog U-SQL dependency information item.
type USQLAssemblyDependencyInfo struct {
	// EntityID - the EntityId of the dependency.
	EntityID *EntityID `json:"entityId,omitempty"`
}

// USQLAssemblyFileInfo a Data Lake Analytics catalog U-SQL assembly file information item.
type USQLAssemblyFileInfo struct {
	// Type - the assembly file type. Possible values include: 'Assembly', 'Resource'
	Type FileType `json:"type,omitempty"`
	// OriginalPath - The original path to the assembly file.
	OriginalPath *string `json:"originalPath,omitempty"`
	// ContentPath - The content path to the assembly file.
	ContentPath *string `json:"contentPath,omitempty"`
}

// USQLAssemblyList a Data Lake Analytics catalog U-SQL assembly CLR item list.
type USQLAssemblyList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of assemblies in the database
	Value *[]USQLAssemblyClr `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLAssemblyList.
func (usal USQLAssemblyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usal.Count != nil {
		objectMap["count"] = usal.Count
	}
	if usal.NextLink != nil {
		objectMap["nextLink"] = usal.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLAssemblyListIterator provides access to a complete listing of USQLAssemblyClr values.
type USQLAssemblyListIterator struct {
	i    int
	page USQLAssemblyListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLAssemblyListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLAssemblyListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLAssemblyListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLAssemblyListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLAssemblyListIterator) Response() USQLAssemblyList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLAssemblyListIterator) Value() USQLAssemblyClr {
	if !iter.page.NotDone() {
		return USQLAssemblyClr{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLAssemblyListIterator type.
func NewUSQLAssemblyListIterator(page USQLAssemblyListPage) USQLAssemblyListIterator {
	return USQLAssemblyListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usal USQLAssemblyList) IsEmpty() bool {
	return usal.Value == nil || len(*usal.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usal USQLAssemblyList) hasNextLink() bool {
	return usal.NextLink != nil && len(*usal.NextLink) != 0
}

// uSQLAssemblyListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usal USQLAssemblyList) uSQLAssemblyListPreparer(ctx context.Context) (*http.Request, error) {
	if !usal.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usal.NextLink)))
}

// USQLAssemblyListPage contains a page of USQLAssemblyClr values.
type USQLAssemblyListPage struct {
	fn  func(context.Context, USQLAssemblyList) (USQLAssemblyList, error)
	ual USQLAssemblyList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLAssemblyListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLAssemblyListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ual)
		if err != nil {
			return err
		}
		page.ual = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLAssemblyListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLAssemblyListPage) NotDone() bool {
	return !page.ual.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLAssemblyListPage) Response() USQLAssemblyList {
	return page.ual
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLAssemblyListPage) Values() []USQLAssemblyClr {
	if page.ual.IsEmpty() {
		return nil
	}
	return *page.ual.Value
}

// Creates a new instance of the USQLAssemblyListPage type.
func NewUSQLAssemblyListPage(cur USQLAssemblyList, getNextPage func(context.Context, USQLAssemblyList) (USQLAssemblyList, error)) USQLAssemblyListPage {
	return USQLAssemblyListPage{
		fn:  getNextPage,
		ual: cur,
	}
}

// USQLCredential a Data Lake Analytics catalog U-SQL credential item.
type USQLCredential struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database the credential is in.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Identity - the name of the secret associated with the credential.
	Identity *string `json:"identity,omitempty"`
	// Name - the name of the credential.
	Name *string `json:"credentialName,omitempty"`
	// UserName - the user name associated with the credential.
	UserName *string `json:"userName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLCredentialList a Data Lake Analytics catalog U-SQL credential item list.
type USQLCredentialList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of credentials in the database
	Value *[]USQLCredential `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLCredentialList.
func (uscl USQLCredentialList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uscl.Count != nil {
		objectMap["count"] = uscl.Count
	}
	if uscl.NextLink != nil {
		objectMap["nextLink"] = uscl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLCredentialListIterator provides access to a complete listing of USQLCredential values.
type USQLCredentialListIterator struct {
	i    int
	page USQLCredentialListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLCredentialListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLCredentialListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLCredentialListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLCredentialListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLCredentialListIterator) Response() USQLCredentialList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLCredentialListIterator) Value() USQLCredential {
	if !iter.page.NotDone() {
		return USQLCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLCredentialListIterator type.
func NewUSQLCredentialListIterator(page USQLCredentialListPage) USQLCredentialListIterator {
	return USQLCredentialListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uscl USQLCredentialList) IsEmpty() bool {
	return uscl.Value == nil || len(*uscl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uscl USQLCredentialList) hasNextLink() bool {
	return uscl.NextLink != nil && len(*uscl.NextLink) != 0
}

// uSQLCredentialListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uscl USQLCredentialList) uSQLCredentialListPreparer(ctx context.Context) (*http.Request, error) {
	if !uscl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uscl.NextLink)))
}

// USQLCredentialListPage contains a page of USQLCredential values.
type USQLCredentialListPage struct {
	fn  func(context.Context, USQLCredentialList) (USQLCredentialList, error)
	ucl USQLCredentialList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLCredentialListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLCredentialListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ucl)
		if err != nil {
			return err
		}
		page.ucl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLCredentialListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLCredentialListPage) NotDone() bool {
	return !page.ucl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLCredentialListPage) Response() USQLCredentialList {
	return page.ucl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLCredentialListPage) Values() []USQLCredential {
	if page.ucl.IsEmpty() {
		return nil
	}
	return *page.ucl.Value
}

// Creates a new instance of the USQLCredentialListPage type.
func NewUSQLCredentialListPage(cur USQLCredentialList, getNextPage func(context.Context, USQLCredentialList) (USQLCredentialList, error)) USQLCredentialListPage {
	return USQLCredentialListPage{
		fn:  getNextPage,
		ucl: cur,
	}
}

// USQLDatabase a Data Lake Analytics catalog U-SQL database item.
type USQLDatabase struct {
	autorest.Response `json:"-"`
	// Name - the name of the database.
	Name *string `json:"databaseName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLDatabaseList a Data Lake Analytics catalog U-SQL database item list.
type USQLDatabaseList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of databases
	Value *[]USQLDatabase `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLDatabaseList.
func (usdl USQLDatabaseList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usdl.Count != nil {
		objectMap["count"] = usdl.Count
	}
	if usdl.NextLink != nil {
		objectMap["nextLink"] = usdl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLDatabaseListIterator provides access to a complete listing of USQLDatabase values.
type USQLDatabaseListIterator struct {
	i    int
	page USQLDatabaseListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLDatabaseListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLDatabaseListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLDatabaseListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLDatabaseListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLDatabaseListIterator) Response() USQLDatabaseList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLDatabaseListIterator) Value() USQLDatabase {
	if !iter.page.NotDone() {
		return USQLDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLDatabaseListIterator type.
func NewUSQLDatabaseListIterator(page USQLDatabaseListPage) USQLDatabaseListIterator {
	return USQLDatabaseListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usdl USQLDatabaseList) IsEmpty() bool {
	return usdl.Value == nil || len(*usdl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usdl USQLDatabaseList) hasNextLink() bool {
	return usdl.NextLink != nil && len(*usdl.NextLink) != 0
}

// uSQLDatabaseListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usdl USQLDatabaseList) uSQLDatabaseListPreparer(ctx context.Context) (*http.Request, error) {
	if !usdl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usdl.NextLink)))
}

// USQLDatabaseListPage contains a page of USQLDatabase values.
type USQLDatabaseListPage struct {
	fn  func(context.Context, USQLDatabaseList) (USQLDatabaseList, error)
	udl USQLDatabaseList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLDatabaseListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLDatabaseListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.udl)
		if err != nil {
			return err
		}
		page.udl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLDatabaseListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLDatabaseListPage) NotDone() bool {
	return !page.udl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLDatabaseListPage) Response() USQLDatabaseList {
	return page.udl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLDatabaseListPage) Values() []USQLDatabase {
	if page.udl.IsEmpty() {
		return nil
	}
	return *page.udl.Value
}

// Creates a new instance of the USQLDatabaseListPage type.
func NewUSQLDatabaseListPage(cur USQLDatabaseList, getNextPage func(context.Context, USQLDatabaseList) (USQLDatabaseList, error)) USQLDatabaseListPage {
	return USQLDatabaseListPage{
		fn:  getNextPage,
		udl: cur,
	}
}

// USQLDirectedColumn a Data Lake Analytics catalog U-SQL directed column item.
type USQLDirectedColumn struct {
	// Name - the name of the index in the table.
	Name *string `json:"name,omitempty"`
	// Descending - the switch indicating if the index is descending or not.
	Descending *bool `json:"descending,omitempty"`
}

// USQLDistributionInfo a Data Lake Analytics catalog U-SQL distribution information object.
type USQLDistributionInfo struct {
	// Type - the type of this distribution.
	Type *int32 `json:"type,omitempty"`
	// Keys - the list of directed columns in the distribution
	Keys *[]USQLDirectedColumn `json:"keys,omitempty"`
	// Count - the count of indices using this distribution.
	Count *int32 `json:"count,omitempty"`
	// DynamicCount - the dynamic count of indices using this distribution.
	DynamicCount *int32 `json:"dynamicCount,omitempty"`
}

// USQLExternalDataSource a Data Lake Analytics catalog U-SQL external datasource item.
type USQLExternalDataSource struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the external data source.
	Name *string `json:"externalDataSourceName,omitempty"`
	// Provider - the name of the provider for the external data source.
	Provider *string `json:"provider,omitempty"`
	// ProviderString - the name of the provider string for the external data source.
	ProviderString *string `json:"providerString,omitempty"`
	// PushdownTypes - the list of types to push down from the external data source.
	PushdownTypes *[]string `json:"pushdownTypes,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLExternalDataSourceList a Data Lake Analytics catalog U-SQL external datasource item list.
type USQLExternalDataSourceList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of external data sources in the database
	Value *[]USQLExternalDataSource `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLExternalDataSourceList.
func (usedsl USQLExternalDataSourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usedsl.Count != nil {
		objectMap["count"] = usedsl.Count
	}
	if usedsl.NextLink != nil {
		objectMap["nextLink"] = usedsl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLExternalDataSourceListIterator provides access to a complete listing of USQLExternalDataSource
// values.
type USQLExternalDataSourceListIterator struct {
	i    int
	page USQLExternalDataSourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLExternalDataSourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLExternalDataSourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLExternalDataSourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLExternalDataSourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLExternalDataSourceListIterator) Response() USQLExternalDataSourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLExternalDataSourceListIterator) Value() USQLExternalDataSource {
	if !iter.page.NotDone() {
		return USQLExternalDataSource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLExternalDataSourceListIterator type.
func NewUSQLExternalDataSourceListIterator(page USQLExternalDataSourceListPage) USQLExternalDataSourceListIterator {
	return USQLExternalDataSourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usedsl USQLExternalDataSourceList) IsEmpty() bool {
	return usedsl.Value == nil || len(*usedsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usedsl USQLExternalDataSourceList) hasNextLink() bool {
	return usedsl.NextLink != nil && len(*usedsl.NextLink) != 0
}

// uSQLExternalDataSourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usedsl USQLExternalDataSourceList) uSQLExternalDataSourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !usedsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usedsl.NextLink)))
}

// USQLExternalDataSourceListPage contains a page of USQLExternalDataSource values.
type USQLExternalDataSourceListPage struct {
	fn    func(context.Context, USQLExternalDataSourceList) (USQLExternalDataSourceList, error)
	uedsl USQLExternalDataSourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLExternalDataSourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLExternalDataSourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uedsl)
		if err != nil {
			return err
		}
		page.uedsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLExternalDataSourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLExternalDataSourceListPage) NotDone() bool {
	return !page.uedsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLExternalDataSourceListPage) Response() USQLExternalDataSourceList {
	return page.uedsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLExternalDataSourceListPage) Values() []USQLExternalDataSource {
	if page.uedsl.IsEmpty() {
		return nil
	}
	return *page.uedsl.Value
}

// Creates a new instance of the USQLExternalDataSourceListPage type.
func NewUSQLExternalDataSourceListPage(cur USQLExternalDataSourceList, getNextPage func(context.Context, USQLExternalDataSourceList) (USQLExternalDataSourceList, error)) USQLExternalDataSourceListPage {
	return USQLExternalDataSourceListPage{
		fn:    getNextPage,
		uedsl: cur,
	}
}

// USQLIndex a Data Lake Analytics catalog U-SQL table index item.
type USQLIndex struct {
	// Name - the name of the index in the table.
	Name *string `json:"name,omitempty"`
	// IndexKeys - the list of directed columns in the index
	IndexKeys *[]USQLDirectedColumn `json:"indexKeys,omitempty"`
	// Columns - the list of columns in the index
	Columns *[]string `json:"columns,omitempty"`
	// DistributionInfo - the distributions info of the index
	DistributionInfo *USQLDistributionInfo `json:"distributionInfo,omitempty"`
	// PartitionFunction - partition function ID for the index.
	PartitionFunction *uuid.UUID `json:"partitionFunction,omitempty"`
	// PartitionKeyList - the list of partition keys in the index
	PartitionKeyList *[]string `json:"partitionKeyList,omitempty"`
	// StreamNames - the list of full paths to the streams that contain this index in the DataLake account.
	StreamNames *[]string `json:"streamNames,omitempty"`
	// IsColumnstore - the switch indicating if this index is a columnstore index.
	IsColumnstore *bool `json:"isColumnstore,omitempty"`
	// IndexID - the ID of this index within the table.
	IndexID *int32 `json:"indexId,omitempty"`
	// IsUnique - the switch indicating if this index is a unique index.
	IsUnique *bool `json:"isUnique,omitempty"`
}

// USQLProcedure a Data Lake Analytics catalog U-SQL procedure item.
type USQLProcedure struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this procedure and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the procedure.
	Name *string `json:"procName,omitempty"`
	// Definition - the defined query of the procedure.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLProcedureList a Data Lake Analytics catalog U-SQL procedure item list.
type USQLProcedureList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of procedure in the database and schema combination
	Value *[]USQLProcedure `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLProcedureList.
func (uspl USQLProcedureList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uspl.Count != nil {
		objectMap["count"] = uspl.Count
	}
	if uspl.NextLink != nil {
		objectMap["nextLink"] = uspl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLProcedureListIterator provides access to a complete listing of USQLProcedure values.
type USQLProcedureListIterator struct {
	i    int
	page USQLProcedureListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLProcedureListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLProcedureListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLProcedureListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLProcedureListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLProcedureListIterator) Response() USQLProcedureList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLProcedureListIterator) Value() USQLProcedure {
	if !iter.page.NotDone() {
		return USQLProcedure{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLProcedureListIterator type.
func NewUSQLProcedureListIterator(page USQLProcedureListPage) USQLProcedureListIterator {
	return USQLProcedureListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uspl USQLProcedureList) IsEmpty() bool {
	return uspl.Value == nil || len(*uspl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uspl USQLProcedureList) hasNextLink() bool {
	return uspl.NextLink != nil && len(*uspl.NextLink) != 0
}

// uSQLProcedureListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uspl USQLProcedureList) uSQLProcedureListPreparer(ctx context.Context) (*http.Request, error) {
	if !uspl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uspl.NextLink)))
}

// USQLProcedureListPage contains a page of USQLProcedure values.
type USQLProcedureListPage struct {
	fn  func(context.Context, USQLProcedureList) (USQLProcedureList, error)
	upl USQLProcedureList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLProcedureListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLProcedureListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.upl)
		if err != nil {
			return err
		}
		page.upl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLProcedureListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLProcedureListPage) NotDone() bool {
	return !page.upl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLProcedureListPage) Response() USQLProcedureList {
	return page.upl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLProcedureListPage) Values() []USQLProcedure {
	if page.upl.IsEmpty() {
		return nil
	}
	return *page.upl.Value
}

// Creates a new instance of the USQLProcedureListPage type.
func NewUSQLProcedureListPage(cur USQLProcedureList, getNextPage func(context.Context, USQLProcedureList) (USQLProcedureList, error)) USQLProcedureListPage {
	return USQLProcedureListPage{
		fn:  getNextPage,
		upl: cur,
	}
}

// USQLSchema a Data Lake Analytics catalog U-SQL schema item.
type USQLSchema struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the schema.
	Name *string `json:"schemaName,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLSchemaList a Data Lake Analytics catalog U-SQL schema item list.
type USQLSchemaList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of schemas in the database
	Value *[]USQLSchema `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLSchemaList.
func (ussl USQLSchemaList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ussl.Count != nil {
		objectMap["count"] = ussl.Count
	}
	if ussl.NextLink != nil {
		objectMap["nextLink"] = ussl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLSchemaListIterator provides access to a complete listing of USQLSchema values.
type USQLSchemaListIterator struct {
	i    int
	page USQLSchemaListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLSchemaListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLSchemaListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLSchemaListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLSchemaListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLSchemaListIterator) Response() USQLSchemaList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLSchemaListIterator) Value() USQLSchema {
	if !iter.page.NotDone() {
		return USQLSchema{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLSchemaListIterator type.
func NewUSQLSchemaListIterator(page USQLSchemaListPage) USQLSchemaListIterator {
	return USQLSchemaListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ussl USQLSchemaList) IsEmpty() bool {
	return ussl.Value == nil || len(*ussl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ussl USQLSchemaList) hasNextLink() bool {
	return ussl.NextLink != nil && len(*ussl.NextLink) != 0
}

// uSQLSchemaListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ussl USQLSchemaList) uSQLSchemaListPreparer(ctx context.Context) (*http.Request, error) {
	if !ussl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ussl.NextLink)))
}

// USQLSchemaListPage contains a page of USQLSchema values.
type USQLSchemaListPage struct {
	fn  func(context.Context, USQLSchemaList) (USQLSchemaList, error)
	usl USQLSchemaList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLSchemaListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLSchemaListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.usl)
		if err != nil {
			return err
		}
		page.usl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLSchemaListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLSchemaListPage) NotDone() bool {
	return !page.usl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLSchemaListPage) Response() USQLSchemaList {
	return page.usl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLSchemaListPage) Values() []USQLSchema {
	if page.usl.IsEmpty() {
		return nil
	}
	return *page.usl.Value
}

// Creates a new instance of the USQLSchemaListPage type.
func NewUSQLSchemaListPage(cur USQLSchemaList, getNextPage func(context.Context, USQLSchemaList) (USQLSchemaList, error)) USQLSchemaListPage {
	return USQLSchemaListPage{
		fn:  getNextPage,
		usl: cur,
	}
}

// USQLSecret a Data Lake Analytics catalog U-SQL secret item.
type USQLSecret struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Name - the name of the secret.
	Name *string `json:"secretName,omitempty"`
	// CreationTime - the creation time of the credential object. This is the only information returned about a secret from a GET.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// URI - the URI identifier for the secret in the format <hostname>:<port>
	URI *string `json:"uri,omitempty"`
	// Password - the password for the secret to pass in
	Password *string `json:"password,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTable a Data Lake Analytics catalog U-SQL table item.
type USQLTable struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table.
	Name *string `json:"tableName,omitempty"`
	// ColumnList - the list of columns in this table
	ColumnList *[]USQLTableColumn `json:"columnList,omitempty"`
	// IndexList - the list of indices in this table
	IndexList *[]USQLIndex `json:"indexList,omitempty"`
	// PartitionKeyList - the list of partition keys in the table
	PartitionKeyList *[]string `json:"partitionKeyList,omitempty"`
	// ExternalTable - the external table associated with the table.
	ExternalTable *ExternalTable `json:"externalTable,omitempty"`
	// DistributionInfo - the distributions info of the table
	DistributionInfo *USQLDistributionInfo `json:"distributionInfo,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableColumn a Data Lake Analytics catalog U-SQL table column item.
type USQLTableColumn struct {
	// Name - the name of the column in the table.
	Name *string `json:"name,omitempty"`
	// Type - the object type of the specified column (such as System.String).
	Type *string `json:"type,omitempty"`
}

// USQLTableList a Data Lake Analytics catalog U-SQL table item list.
type USQLTableList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of tables in the database and schema combination
	Value *[]USQLTable `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTableList.
func (ustl USQLTableList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustl.Count != nil {
		objectMap["count"] = ustl.Count
	}
	if ustl.NextLink != nil {
		objectMap["nextLink"] = ustl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTableListIterator provides access to a complete listing of USQLTable values.
type USQLTableListIterator struct {
	i    int
	page USQLTableListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableListIterator) Response() USQLTableList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableListIterator) Value() USQLTable {
	if !iter.page.NotDone() {
		return USQLTable{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableListIterator type.
func NewUSQLTableListIterator(page USQLTableListPage) USQLTableListIterator {
	return USQLTableListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustl USQLTableList) IsEmpty() bool {
	return ustl.Value == nil || len(*ustl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ustl USQLTableList) hasNextLink() bool {
	return ustl.NextLink != nil && len(*ustl.NextLink) != 0
}

// uSQLTableListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustl USQLTableList) uSQLTableListPreparer(ctx context.Context) (*http.Request, error) {
	if !ustl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustl.NextLink)))
}

// USQLTableListPage contains a page of USQLTable values.
type USQLTableListPage struct {
	fn  func(context.Context, USQLTableList) (USQLTableList, error)
	utl USQLTableList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.utl)
		if err != nil {
			return err
		}
		page.utl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableListPage) NotDone() bool {
	return !page.utl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableListPage) Response() USQLTableList {
	return page.utl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableListPage) Values() []USQLTable {
	if page.utl.IsEmpty() {
		return nil
	}
	return *page.utl.Value
}

// Creates a new instance of the USQLTableListPage type.
func NewUSQLTableListPage(cur USQLTableList, getNextPage func(context.Context, USQLTableList) (USQLTableList, error)) USQLTableListPage {
	return USQLTableListPage{
		fn:  getNextPage,
		utl: cur,
	}
}

// USQLTablePartition a Data Lake Analytics catalog U-SQL table partition item.
type USQLTablePartition struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table partition and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table partition.
	Name *string `json:"partitionName,omitempty"`
	// ParentName - the Ddl object of the partition's parent.
	ParentName *DdlName `json:"parentName,omitempty"`
	// IndexID - the index ID for this partition.
	IndexID *int32 `json:"indexId,omitempty"`
	// Label - the list of labels associated with this partition.
	Label *[]string `json:"label,omitempty"`
	// CreateDate - the creation time of the partition
	CreateDate *date.Time `json:"createDate,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTablePartitionList a Data Lake Analytics catalog U-SQL table partition item list.
type USQLTablePartitionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of table partitions in the database, schema and table combination
	Value *[]USQLTablePartition `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTablePartitionList.
func (ustpl USQLTablePartitionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustpl.Count != nil {
		objectMap["count"] = ustpl.Count
	}
	if ustpl.NextLink != nil {
		objectMap["nextLink"] = ustpl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTablePartitionListIterator provides access to a complete listing of USQLTablePartition values.
type USQLTablePartitionListIterator struct {
	i    int
	page USQLTablePartitionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTablePartitionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTablePartitionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTablePartitionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTablePartitionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTablePartitionListIterator) Response() USQLTablePartitionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTablePartitionListIterator) Value() USQLTablePartition {
	if !iter.page.NotDone() {
		return USQLTablePartition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTablePartitionListIterator type.
func NewUSQLTablePartitionListIterator(page USQLTablePartitionListPage) USQLTablePartitionListIterator {
	return USQLTablePartitionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustpl USQLTablePartitionList) IsEmpty() bool {
	return ustpl.Value == nil || len(*ustpl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ustpl USQLTablePartitionList) hasNextLink() bool {
	return ustpl.NextLink != nil && len(*ustpl.NextLink) != 0
}

// uSQLTablePartitionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustpl USQLTablePartitionList) uSQLTablePartitionListPreparer(ctx context.Context) (*http.Request, error) {
	if !ustpl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustpl.NextLink)))
}

// USQLTablePartitionListPage contains a page of USQLTablePartition values.
type USQLTablePartitionListPage struct {
	fn   func(context.Context, USQLTablePartitionList) (USQLTablePartitionList, error)
	utpl USQLTablePartitionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTablePartitionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTablePartitionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.utpl)
		if err != nil {
			return err
		}
		page.utpl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTablePartitionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTablePartitionListPage) NotDone() bool {
	return !page.utpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTablePartitionListPage) Response() USQLTablePartitionList {
	return page.utpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTablePartitionListPage) Values() []USQLTablePartition {
	if page.utpl.IsEmpty() {
		return nil
	}
	return *page.utpl.Value
}

// Creates a new instance of the USQLTablePartitionListPage type.
func NewUSQLTablePartitionListPage(cur USQLTablePartitionList, getNextPage func(context.Context, USQLTablePartitionList) (USQLTablePartitionList, error)) USQLTablePartitionListPage {
	return USQLTablePartitionListPage{
		fn:   getNextPage,
		utpl: cur,
	}
}

// USQLTableStatistics a Data Lake Analytics catalog U-SQL table statistics item.
type USQLTableStatistics struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - the name of the table.
	TableName *string `json:"tableName,omitempty"`
	// Name - the name of the table statistics.
	Name *string `json:"statisticsName,omitempty"`
	// UserStatName - the name of the user statistics.
	UserStatName *string `json:"userStatName,omitempty"`
	// StatDataPath - the path to the statistics data.
	StatDataPath *string `json:"statDataPath,omitempty"`
	// CreateTime - the creation time of the statistics.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// UpdateTime - the last time the statistics were updated.
	UpdateTime *date.Time `json:"updateTime,omitempty"`
	// IsUserCreated - the switch indicating if these statistics are user created.
	IsUserCreated *bool `json:"isUserCreated,omitempty"`
	// IsAutoCreated - the switch indicating if these statistics are automatically created.
	IsAutoCreated *bool `json:"isAutoCreated,omitempty"`
	// HasFilter - the switch indicating if these statistics have a filter.
	HasFilter *bool `json:"hasFilter,omitempty"`
	// FilterDefinition - the filter definition for the statistics.
	FilterDefinition *string `json:"filterDefinition,omitempty"`
	// ColNames - the list of column names associated with these statistics.
	ColNames *[]string `json:"colNames,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableStatisticsList a Data Lake Analytics catalog U-SQL table statistics item list.
type USQLTableStatisticsList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of table statistics in the database, schema and table combination
	Value *[]USQLTableStatistics `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTableStatisticsList.
func (ustsl USQLTableStatisticsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustsl.Count != nil {
		objectMap["count"] = ustsl.Count
	}
	if ustsl.NextLink != nil {
		objectMap["nextLink"] = ustsl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTableStatisticsListIterator provides access to a complete listing of USQLTableStatistics values.
type USQLTableStatisticsListIterator struct {
	i    int
	page USQLTableStatisticsListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableStatisticsListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableStatisticsListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableStatisticsListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableStatisticsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableStatisticsListIterator) Response() USQLTableStatisticsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableStatisticsListIterator) Value() USQLTableStatistics {
	if !iter.page.NotDone() {
		return USQLTableStatistics{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableStatisticsListIterator type.
func NewUSQLTableStatisticsListIterator(page USQLTableStatisticsListPage) USQLTableStatisticsListIterator {
	return USQLTableStatisticsListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustsl USQLTableStatisticsList) IsEmpty() bool {
	return ustsl.Value == nil || len(*ustsl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ustsl USQLTableStatisticsList) hasNextLink() bool {
	return ustsl.NextLink != nil && len(*ustsl.NextLink) != 0
}

// uSQLTableStatisticsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustsl USQLTableStatisticsList) uSQLTableStatisticsListPreparer(ctx context.Context) (*http.Request, error) {
	if !ustsl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustsl.NextLink)))
}

// USQLTableStatisticsListPage contains a page of USQLTableStatistics values.
type USQLTableStatisticsListPage struct {
	fn   func(context.Context, USQLTableStatisticsList) (USQLTableStatisticsList, error)
	utsl USQLTableStatisticsList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableStatisticsListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableStatisticsListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.utsl)
		if err != nil {
			return err
		}
		page.utsl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableStatisticsListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableStatisticsListPage) NotDone() bool {
	return !page.utsl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableStatisticsListPage) Response() USQLTableStatisticsList {
	return page.utsl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableStatisticsListPage) Values() []USQLTableStatistics {
	if page.utsl.IsEmpty() {
		return nil
	}
	return *page.utsl.Value
}

// Creates a new instance of the USQLTableStatisticsListPage type.
func NewUSQLTableStatisticsListPage(cur USQLTableStatisticsList, getNextPage func(context.Context, USQLTableStatisticsList) (USQLTableStatisticsList, error)) USQLTableStatisticsListPage {
	return USQLTableStatisticsListPage{
		fn:   getNextPage,
		utsl: cur,
	}
}

// USQLTableType a Data Lake Analytics catalog U-SQL table type item.
type USQLTableType struct {
	autorest.Response `json:"-"`
	// Columns - READ-ONLY; the type field information associated with this table type.
	Columns *[]TypeFieldInfo `json:"columns,omitempty"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of type for this type.
	Name *string `json:"typeName,omitempty"`
	// TypeFamily - the type family for this type.
	TypeFamily *string `json:"typeFamily,omitempty"`
	// CSharpName - the C# name for this type.
	CSharpName *string `json:"cSharpName,omitempty"`
	// FullCSharpName - the fully qualified C# name for this type.
	FullCSharpName *string `json:"fullCSharpName,omitempty"`
	// SystemTypeID - the system type ID for this type.
	SystemTypeID *int32 `json:"systemTypeId,omitempty"`
	// UserTypeID - the user type ID for this type.
	UserTypeID *int32 `json:"userTypeId,omitempty"`
	// SchemaID - the schema ID for this type.
	SchemaID *int32 `json:"schemaId,omitempty"`
	// PrincipalID - the principal ID for this type.
	PrincipalID *int32 `json:"principalId,omitempty"`
	// IsNullable - The switch indicating if this type is nullable.
	IsNullable *bool `json:"isNullable,omitempty"`
	// IsUserDefined - The switch indicating if this type is user defined.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// IsAssemblyType - The switch indicating if this type is an assembly type.
	IsAssemblyType *bool `json:"isAssemblyType,omitempty"`
	// IsTableType - The switch indicating if this type is a table type.
	IsTableType *bool `json:"isTableType,omitempty"`
	// IsComplexType - The switch indicating if this type is a complex type.
	IsComplexType *bool `json:"isComplexType,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTableType.
func (ustt USQLTableType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustt.DatabaseName != nil {
		objectMap["databaseName"] = ustt.DatabaseName
	}
	if ustt.SchemaName != nil {
		objectMap["schemaName"] = ustt.SchemaName
	}
	if ustt.Name != nil {
		objectMap["typeName"] = ustt.Name
	}
	if ustt.TypeFamily != nil {
		objectMap["typeFamily"] = ustt.TypeFamily
	}
	if ustt.CSharpName != nil {
		objectMap["cSharpName"] = ustt.CSharpName
	}
	if ustt.FullCSharpName != nil {
		objectMap["fullCSharpName"] = ustt.FullCSharpName
	}
	if ustt.SystemTypeID != nil {
		objectMap["systemTypeId"] = ustt.SystemTypeID
	}
	if ustt.UserTypeID != nil {
		objectMap["userTypeId"] = ustt.UserTypeID
	}
	if ustt.SchemaID != nil {
		objectMap["schemaId"] = ustt.SchemaID
	}
	if ustt.PrincipalID != nil {
		objectMap["principalId"] = ustt.PrincipalID
	}
	if ustt.IsNullable != nil {
		objectMap["isNullable"] = ustt.IsNullable
	}
	if ustt.IsUserDefined != nil {
		objectMap["isUserDefined"] = ustt.IsUserDefined
	}
	if ustt.IsAssemblyType != nil {
		objectMap["isAssemblyType"] = ustt.IsAssemblyType
	}
	if ustt.IsTableType != nil {
		objectMap["isTableType"] = ustt.IsTableType
	}
	if ustt.IsComplexType != nil {
		objectMap["isComplexType"] = ustt.IsComplexType
	}
	if ustt.ComputeAccountName != nil {
		objectMap["computeAccountName"] = ustt.ComputeAccountName
	}
	if ustt.Version != nil {
		objectMap["version"] = ustt.Version
	}
	return json.Marshal(objectMap)
}

// USQLTableTypeList a Data Lake Analytics catalog U-SQL table type item list.
type USQLTableTypeList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of table types in the database and schema combination
	Value *[]USQLTableType `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTableTypeList.
func (usttl USQLTableTypeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usttl.Count != nil {
		objectMap["count"] = usttl.Count
	}
	if usttl.NextLink != nil {
		objectMap["nextLink"] = usttl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTableTypeListIterator provides access to a complete listing of USQLTableType values.
type USQLTableTypeListIterator struct {
	i    int
	page USQLTableTypeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableTypeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableTypeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableTypeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableTypeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableTypeListIterator) Response() USQLTableTypeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableTypeListIterator) Value() USQLTableType {
	if !iter.page.NotDone() {
		return USQLTableType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableTypeListIterator type.
func NewUSQLTableTypeListIterator(page USQLTableTypeListPage) USQLTableTypeListIterator {
	return USQLTableTypeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usttl USQLTableTypeList) IsEmpty() bool {
	return usttl.Value == nil || len(*usttl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usttl USQLTableTypeList) hasNextLink() bool {
	return usttl.NextLink != nil && len(*usttl.NextLink) != 0
}

// uSQLTableTypeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usttl USQLTableTypeList) uSQLTableTypeListPreparer(ctx context.Context) (*http.Request, error) {
	if !usttl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usttl.NextLink)))
}

// USQLTableTypeListPage contains a page of USQLTableType values.
type USQLTableTypeListPage struct {
	fn   func(context.Context, USQLTableTypeList) (USQLTableTypeList, error)
	uttl USQLTableTypeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableTypeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableTypeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uttl)
		if err != nil {
			return err
		}
		page.uttl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableTypeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableTypeListPage) NotDone() bool {
	return !page.uttl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableTypeListPage) Response() USQLTableTypeList {
	return page.uttl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableTypeListPage) Values() []USQLTableType {
	if page.uttl.IsEmpty() {
		return nil
	}
	return *page.uttl.Value
}

// Creates a new instance of the USQLTableTypeListPage type.
func NewUSQLTableTypeListPage(cur USQLTableTypeList, getNextPage func(context.Context, USQLTableTypeList) (USQLTableTypeList, error)) USQLTableTypeListPage {
	return USQLTableTypeListPage{
		fn:   getNextPage,
		uttl: cur,
	}
}

// USQLTableValuedFunction a Data Lake Analytics catalog U-SQL table valued function item.
type USQLTableValuedFunction struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the table valued function.
	Name *string `json:"tvfName,omitempty"`
	// Definition - the definition of the table valued function.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTableValuedFunctionList a Data Lake Analytics catalog U-SQL table valued function item list.
type USQLTableValuedFunctionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of table valued functions in the database and schema combination
	Value *[]USQLTableValuedFunction `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTableValuedFunctionList.
func (ustvfl USQLTableValuedFunctionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustvfl.Count != nil {
		objectMap["count"] = ustvfl.Count
	}
	if ustvfl.NextLink != nil {
		objectMap["nextLink"] = ustvfl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTableValuedFunctionListIterator provides access to a complete listing of USQLTableValuedFunction
// values.
type USQLTableValuedFunctionListIterator struct {
	i    int
	page USQLTableValuedFunctionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTableValuedFunctionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableValuedFunctionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTableValuedFunctionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTableValuedFunctionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTableValuedFunctionListIterator) Response() USQLTableValuedFunctionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTableValuedFunctionListIterator) Value() USQLTableValuedFunction {
	if !iter.page.NotDone() {
		return USQLTableValuedFunction{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTableValuedFunctionListIterator type.
func NewUSQLTableValuedFunctionListIterator(page USQLTableValuedFunctionListPage) USQLTableValuedFunctionListIterator {
	return USQLTableValuedFunctionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustvfl USQLTableValuedFunctionList) IsEmpty() bool {
	return ustvfl.Value == nil || len(*ustvfl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ustvfl USQLTableValuedFunctionList) hasNextLink() bool {
	return ustvfl.NextLink != nil && len(*ustvfl.NextLink) != 0
}

// uSQLTableValuedFunctionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustvfl USQLTableValuedFunctionList) uSQLTableValuedFunctionListPreparer(ctx context.Context) (*http.Request, error) {
	if !ustvfl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustvfl.NextLink)))
}

// USQLTableValuedFunctionListPage contains a page of USQLTableValuedFunction values.
type USQLTableValuedFunctionListPage struct {
	fn    func(context.Context, USQLTableValuedFunctionList) (USQLTableValuedFunctionList, error)
	utvfl USQLTableValuedFunctionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTableValuedFunctionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTableValuedFunctionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.utvfl)
		if err != nil {
			return err
		}
		page.utvfl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTableValuedFunctionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTableValuedFunctionListPage) NotDone() bool {
	return !page.utvfl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTableValuedFunctionListPage) Response() USQLTableValuedFunctionList {
	return page.utvfl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTableValuedFunctionListPage) Values() []USQLTableValuedFunction {
	if page.utvfl.IsEmpty() {
		return nil
	}
	return *page.utvfl.Value
}

// Creates a new instance of the USQLTableValuedFunctionListPage type.
func NewUSQLTableValuedFunctionListPage(cur USQLTableValuedFunctionList, getNextPage func(context.Context, USQLTableValuedFunctionList) (USQLTableValuedFunctionList, error)) USQLTableValuedFunctionListPage {
	return USQLTableValuedFunctionListPage{
		fn:    getNextPage,
		utvfl: cur,
	}
}

// USQLType a Data Lake Analytics catalog U-SQL type item.
type USQLType struct {
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this table and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of type for this type.
	Name *string `json:"typeName,omitempty"`
	// TypeFamily - the type family for this type.
	TypeFamily *string `json:"typeFamily,omitempty"`
	// CSharpName - the C# name for this type.
	CSharpName *string `json:"cSharpName,omitempty"`
	// FullCSharpName - the fully qualified C# name for this type.
	FullCSharpName *string `json:"fullCSharpName,omitempty"`
	// SystemTypeID - the system type ID for this type.
	SystemTypeID *int32 `json:"systemTypeId,omitempty"`
	// UserTypeID - the user type ID for this type.
	UserTypeID *int32 `json:"userTypeId,omitempty"`
	// SchemaID - the schema ID for this type.
	SchemaID *int32 `json:"schemaId,omitempty"`
	// PrincipalID - the principal ID for this type.
	PrincipalID *int32 `json:"principalId,omitempty"`
	// IsNullable - The switch indicating if this type is nullable.
	IsNullable *bool `json:"isNullable,omitempty"`
	// IsUserDefined - The switch indicating if this type is user defined.
	IsUserDefined *bool `json:"isUserDefined,omitempty"`
	// IsAssemblyType - The switch indicating if this type is an assembly type.
	IsAssemblyType *bool `json:"isAssemblyType,omitempty"`
	// IsTableType - The switch indicating if this type is a table type.
	IsTableType *bool `json:"isTableType,omitempty"`
	// IsComplexType - The switch indicating if this type is a complex type.
	IsComplexType *bool `json:"isComplexType,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLTypeList a Data Lake Analytics catalog U-SQL type item list.
type USQLTypeList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of types in the database and schema combination
	Value *[]USQLType `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLTypeList.
func (ustl USQLTypeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ustl.Count != nil {
		objectMap["count"] = ustl.Count
	}
	if ustl.NextLink != nil {
		objectMap["nextLink"] = ustl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLTypeListIterator provides access to a complete listing of USQLType values.
type USQLTypeListIterator struct {
	i    int
	page USQLTypeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLTypeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTypeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLTypeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLTypeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLTypeListIterator) Response() USQLTypeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLTypeListIterator) Value() USQLType {
	if !iter.page.NotDone() {
		return USQLType{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLTypeListIterator type.
func NewUSQLTypeListIterator(page USQLTypeListPage) USQLTypeListIterator {
	return USQLTypeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ustl USQLTypeList) IsEmpty() bool {
	return ustl.Value == nil || len(*ustl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ustl USQLTypeList) hasNextLink() bool {
	return ustl.NextLink != nil && len(*ustl.NextLink) != 0
}

// uSQLTypeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ustl USQLTypeList) uSQLTypeListPreparer(ctx context.Context) (*http.Request, error) {
	if !ustl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ustl.NextLink)))
}

// USQLTypeListPage contains a page of USQLType values.
type USQLTypeListPage struct {
	fn  func(context.Context, USQLTypeList) (USQLTypeList, error)
	utl USQLTypeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLTypeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLTypeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.utl)
		if err != nil {
			return err
		}
		page.utl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLTypeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLTypeListPage) NotDone() bool {
	return !page.utl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLTypeListPage) Response() USQLTypeList {
	return page.utl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLTypeListPage) Values() []USQLType {
	if page.utl.IsEmpty() {
		return nil
	}
	return *page.utl.Value
}

// Creates a new instance of the USQLTypeListPage type.
func NewUSQLTypeListPage(cur USQLTypeList, getNextPage func(context.Context, USQLTypeList) (USQLTypeList, error)) USQLTypeListPage {
	return USQLTypeListPage{
		fn:  getNextPage,
		utl: cur,
	}
}

// USQLView a Data Lake Analytics catalog U-SQL view item.
type USQLView struct {
	autorest.Response `json:"-"`
	// DatabaseName - the name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - the name of the schema associated with this view and database.
	SchemaName *string `json:"schemaName,omitempty"`
	// Name - the name of the view.
	Name *string `json:"viewName,omitempty"`
	// Definition - the defined query of the view.
	Definition *string `json:"definition,omitempty"`
	// ComputeAccountName - the name of the Data Lake Analytics account.
	ComputeAccountName *string `json:"computeAccountName,omitempty"`
	// Version - the version of the catalog item.
	Version *uuid.UUID `json:"version,omitempty"`
}

// USQLViewList a Data Lake Analytics catalog U-SQL view item list.
type USQLViewList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; the list of view in the database and schema combination
	Value *[]USQLView `json:"value,omitempty"`
	// Count - the count of items in the list.
	Count *int32 `json:"count,omitempty"`
	// NextLink - the link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for USQLViewList.
func (usvl USQLViewList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if usvl.Count != nil {
		objectMap["count"] = usvl.Count
	}
	if usvl.NextLink != nil {
		objectMap["nextLink"] = usvl.NextLink
	}
	return json.Marshal(objectMap)
}

// USQLViewListIterator provides access to a complete listing of USQLView values.
type USQLViewListIterator struct {
	i    int
	page USQLViewListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *USQLViewListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLViewListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *USQLViewListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter USQLViewListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter USQLViewListIterator) Response() USQLViewList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter USQLViewListIterator) Value() USQLView {
	if !iter.page.NotDone() {
		return USQLView{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the USQLViewListIterator type.
func NewUSQLViewListIterator(page USQLViewListPage) USQLViewListIterator {
	return USQLViewListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usvl USQLViewList) IsEmpty() bool {
	return usvl.Value == nil || len(*usvl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (usvl USQLViewList) hasNextLink() bool {
	return usvl.NextLink != nil && len(*usvl.NextLink) != 0
}

// uSQLViewListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usvl USQLViewList) uSQLViewListPreparer(ctx context.Context) (*http.Request, error) {
	if !usvl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usvl.NextLink)))
}

// USQLViewListPage contains a page of USQLView values.
type USQLViewListPage struct {
	fn  func(context.Context, USQLViewList) (USQLViewList, error)
	uvl USQLViewList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *USQLViewListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/USQLViewListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uvl)
		if err != nil {
			return err
		}
		page.uvl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *USQLViewListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page USQLViewListPage) NotDone() bool {
	return !page.uvl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page USQLViewListPage) Response() USQLViewList {
	return page.uvl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page USQLViewListPage) Values() []USQLView {
	if page.uvl.IsEmpty() {
		return nil
	}
	return *page.uvl.Value
}

// Creates a new instance of the USQLViewListPage type.
func NewUSQLViewListPage(cur USQLViewList, getNextPage func(context.Context, USQLViewList) (USQLViewList, error)) USQLViewListPage {
	return USQLViewListPage{
		fn:  getNextPage,
		uvl: cur,
	}
}
