
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_krylov.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABGetPrecondMatrix_pre( precision, solver, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetPrecondMatrix_pre( precision, solver, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BiCGSTABSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_BiCGSTABSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRDestroy( HYPRE_Solver solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRDestroy_pre( precision, solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precondT, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetPrecond_pre( precision, solver, precond, precondT, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CGNRSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_CGNRSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetCGS( HYPRE_Solver solver, HYPRE_Int *cgs )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetCGS_pre( precision, solver, cgs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetConverged( HYPRE_Solver solver, HYPRE_Int *converged )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetConverged_pre( precision, solver, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetConvergenceFactorTol( HYPRE_Solver solver, void *cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetKDim( HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetLogging( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetLogging_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetMinIter( HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESGetUnroll( HYPRE_Solver solver, HYPRE_Int *unroll )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESGetUnroll_pre( precision, solver, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetCGS( HYPRE_Solver solver, HYPRE_Int cgs )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetCGS_pre( precision, solver, cgs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetModifyPC( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetModifyPC_pre( precision, solver, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetUnroll( HYPRE_Solver solver, HYPRE_Int unroll )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetUnroll_pre( precision, solver, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_COGMRESSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_COGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetConverged( HYPRE_Solver solver, HYPRE_Int *converged )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetConverged_pre( precision, solver, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetConvergenceFactorTol( HYPRE_Solver solver, void *cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetKDim( HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetLogging( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetLogging_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetMinIter( HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetModifyPC( HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetModifyPC_pre( precision, solver, modify_pc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FlexGMRESSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_FlexGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetAbsoluteTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetAbsoluteTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetConverged( HYPRE_Solver solver, HYPRE_Int *converged )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetConverged_pre( precision, solver, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetConvergenceFactorTol( HYPRE_Solver solver, void *cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetKDim( HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetLogging( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetLogging_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetMinIter( HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetPrecondMatrix_pre( precision, solver, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetRefSolution( HYPRE_Solver solver, HYPRE_Vector *xref )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetRefSolution_pre( precision, solver, xref );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetRelChange( HYPRE_Solver solver, HYPRE_Int *rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetSkipRealResidualCheck( HYPRE_Solver solver, HYPRE_Int *skip_real_r_check )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetSkipRealResidualCheck_pre( precision, solver, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetStopCrit( HYPRE_Solver solver, HYPRE_Int *stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetPrecondMatrix_pre( precision, solver, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetRefSolution( HYPRE_Solver solver, HYPRE_Vector xref )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetRefSolution_pre( precision, solver, xref );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetSkipRealResidualCheck( HYPRE_Solver solver, HYPRE_Int skip_real_r_check )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetSkipRealResidualCheck_pre( precision, solver, skip_real_r_check );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_GMRESSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_GMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetAugDim( HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetAugDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetConverged( HYPRE_Solver solver, HYPRE_Int *converged )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetConverged_pre( precision, solver, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetConvergenceFactorTol( HYPRE_Solver solver, void *cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetKDim( HYPRE_Solver solver, HYPRE_Int *k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetLogging( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetLogging_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetMinIter( HYPRE_Solver solver, HYPRE_Int *min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetAugDim( HYPRE_Solver solver, HYPRE_Int aug_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetAugDim_pre( precision, solver, aug_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetKDim( HYPRE_Solver solver, HYPRE_Int k_dim )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetKDim_pre( precision, solver, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetMinIter( HYPRE_Solver solver, HYPRE_Int min_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetMinIter_pre( precision, solver, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_LGMRESSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_LGMRESSolve_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetAbsoluteTolFactor( HYPRE_Solver solver, void *abstolf )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetAbsoluteTolFactor_pre( precision, solver, abstolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetConverged( HYPRE_Solver solver, HYPRE_Int *converged )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetConverged_pre( precision, solver, converged );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetConvergenceFactorTol( HYPRE_Solver solver, void *cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetFinalRelativeResidualNorm( HYPRE_Solver solver, void *norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetFinalRelativeResidualNorm_pre( precision, solver, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetFlex( HYPRE_Solver solver, HYPRE_Int *flex )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetFlex_pre( precision, solver, flex );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetLogging( HYPRE_Solver solver, HYPRE_Int *logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetMaxIter( HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetNumIterations( HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetNumIterations_pre( precision, solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrecond( HYPRE_Solver solver, HYPRE_Solver *precond_data_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetPrecond_pre( precision, solver, precond_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix *precond_matrix_ptr )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetPrecondMatrix_pre( precision, solver, precond_matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetPrintLevel( HYPRE_Solver solver, HYPRE_Int *level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetRelChange( HYPRE_Solver solver, HYPRE_Int *rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetResidual( HYPRE_Solver solver, void *residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetResidual_pre( precision, solver, residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetResidualTol( HYPRE_Solver solver, void *rtol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetResidualTol_pre( precision, solver, rtol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetSkipBreak( HYPRE_Solver solver, HYPRE_Int *skip_break )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetSkipBreak_pre( precision, solver, skip_break );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetStopCrit( HYPRE_Solver solver, HYPRE_Int *stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetTol( HYPRE_Solver solver, void *tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGGetTwoNorm( HYPRE_Solver solver, HYPRE_Int *two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGGetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetAbsoluteTol( HYPRE_Solver solver, hypre_long_double a_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetAbsoluteTol_pre( precision, solver, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetAbsoluteTolFactor( HYPRE_Solver solver, hypre_long_double abstolf )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetAbsoluteTolFactor_pre( precision, solver, abstolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetConvergenceFactorTol( HYPRE_Solver solver, hypre_long_double cf_tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetConvergenceFactorTol_pre( precision, solver, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetFlex( HYPRE_Solver solver, HYPRE_Int flex )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetFlex_pre( precision, solver, flex );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetLogging( HYPRE_Solver solver, HYPRE_Int logging )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetLogging_pre( precision, solver, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetMaxIter( HYPRE_Solver solver, HYPRE_Int max_iter )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetMaxIter_pre( precision, solver, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrecond( HYPRE_Solver solver, HYPRE_PtrToSolverFcn precond, HYPRE_PtrToSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetPrecond_pre( precision, solver, precond, precond_setup, precond_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrecondMatrix( HYPRE_Solver solver, HYPRE_Matrix precond_matrix )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetPrecondMatrix_pre( precision, solver, precond_matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPreconditioner( HYPRE_Solver solver, HYPRE_Solver precond )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetPreconditioner_pre( precision, solver, precond );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetPrintLevel( HYPRE_Solver solver, HYPRE_Int level )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetPrintLevel_pre( precision, solver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRecomputeResidual( HYPRE_Solver solver, HYPRE_Int recompute_residual )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetRecomputeResidual_pre( precision, solver, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRecomputeResidualP( HYPRE_Solver solver, HYPRE_Int recompute_residual_p )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetRecomputeResidualP_pre( precision, solver, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetRelChange( HYPRE_Solver solver, HYPRE_Int rel_change )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetRelChange_pre( precision, solver, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetResidualTol( HYPRE_Solver solver, hypre_long_double rtol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetResidualTol_pre( precision, solver, rtol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetSkipBreak( HYPRE_Solver solver, HYPRE_Int skip_break )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetSkipBreak_pre( precision, solver, skip_break );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetStopCrit( HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetStopCrit_pre( precision, solver, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetTol( HYPRE_Solver solver, hypre_long_double tol )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetTol_pre( precision, solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetTwoNorm( HYPRE_Solver solver, HYPRE_Int two_norm )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetTwoNorm_pre( precision, solver, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSetup( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSetup_pre( precision, solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_PCGSolve( HYPRE_Solver solver, HYPRE_Matrix A, HYPRE_Vector b, HYPRE_Vector x )
{
   HYPRE_Precision precision = hypre_GlobalPrecision();
   return HYPRE_PCGSolve_pre( precision, solver, A, b, x );
}



#endif

