#
# PySNMP MIB module ISDN-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/ISDN-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:19:03 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, SingleValueConstraint, ValueSizeConstraint, ConstraintsUnion, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsUnion", "ValueRangeConstraint")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( InterfaceIndex, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex", "ifIndex")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( TimeTicks, MibIdentifier, Counter64, Unsigned32, transmission, iso, Integer32, ObjectIdentity, IpAddress, Gauge32, Counter32, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, Bits, ModuleIdentity, ) = mibBuilder.importSymbols("SNMPv2-SMI", "TimeTicks", "MibIdentifier", "Counter64", "Unsigned32", "transmission", "iso", "Integer32", "ObjectIdentity", "IpAddress", "Gauge32", "Counter32", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Bits", "ModuleIdentity")
( TimeStamp, TruthValue, TestAndIncr, DisplayString, TextualConvention, RowStatus, ) = mibBuilder.importSymbols("SNMPv2-TC", "TimeStamp", "TruthValue", "TestAndIncr", "DisplayString", "TextualConvention", "RowStatus")
isdnMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 20))
if mibBuilder.loadTexts: isdnMib.setLastUpdated('9609231642Z')
if mibBuilder.loadTexts: isdnMib.setOrganization('IETF ISDN MIB Working Group')
if mibBuilder.loadTexts: isdnMib.setContactInfo('        Guenter Roeck\n             Postal: cisco Systems\n                     170 West Tasman Drive\n                     San Jose, CA 95134\n                     U.S.A.\n             Phone:  +1 408 527 3143\n             E-mail: groeck@cisco.com')
if mibBuilder.loadTexts: isdnMib.setDescription('The MIB module to describe the\n             management of ISDN interfaces.')
class IsdnSignalingProtocol(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,))
    namedValues = NamedValues(("other", 1), ("dss1", 2), ("etsi", 3), ("dass2", 4), ("ess4", 5), ("ess5", 6), ("dms100", 7), ("dms250", 8), ("ni1", 9), ("ni2", 10), ("ni3", 11), ("vn2", 12), ("vn3", 13), ("vn4", 14), ("vn6", 15), ("kdd", 16), ("ins64", 17), ("ins1500", 18), ("itr6", 19), ("cornet", 20), ("ts013", 21), ("ts014", 22), ("qsig", 23), ("swissnet2", 24), ("swissnet3", 25),)

isdnMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1))
isdnBasicRateGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1, 1))
isdnBasicRateTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1), )
if mibBuilder.loadTexts: isdnBasicRateTable.setDescription('Table containing configuration and operational\n             parameters for all physical Basic Rate\n             interfaces on this managed device.')
isdnBasicRateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: isdnBasicRateEntry.setDescription('An entry in the ISDN Basic Rate Table.')
isdnBasicRateIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(75, 76,))).clone(namedValues=NamedValues(("isdns", 75), ("isdnu", 76),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnBasicRateIfType.setDescription("The physical interface type. For 'S/T' interfaces,\n             also called 'Four-wire Basic Access Interface',\n             the value of this object is isdns(75).\n             For 'U' interfaces, also called 'Two-wire Basic\n             Access Interface', the value of this object is\n             isdnu(76).")
isdnBasicRateLineTopology = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("pointToPoint", 1), ("pointToMultipoint", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnBasicRateLineTopology.setDescription('The line topology to be used for this interface.\n             Note that setting isdnBasicRateIfType to isdns(75)\n             does not necessarily mean a line topology of\n             point-to-multipoint.')
isdnBasicRateIfMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("te", 1), ("nt", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnBasicRateIfMode.setDescription('The physical interface mode. For TE mode, the value\n             of this object is te(1). For NT mode, the value\n             of this object is nt(2).')
isdnBasicRateSignalMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("active", 1), ("inactive", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnBasicRateSignalMode.setDescription('The signaling channel operational mode for this interface.\n             If active(1) there is a signaling channel on this\n             interface. If inactive(2) a signaling channel is\n             not available.')
isdnBearerGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1, 2))
isdnBearerTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1), )
if mibBuilder.loadTexts: isdnBearerTable.setDescription('This table defines port specific operational, statistics\n             and active call data for ISDN B channels. Each entry\n             in this table describes one B (bearer) channel.')
isdnBearerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: isdnBearerEntry.setDescription('Operational and statistics information relating to\n             one port. A port is a single B channel.')
isdnBearerChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("dialup", 1), ("leased", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnBearerChannelType.setDescription('The B channel type. If the B channel is connected\n             to a dialup line, this object has a value of\n             dialup(1). In this case, it is controlled by\n             an associated signaling channel. If the B channel\n             is connected to a leased line, this object has\n             a value of leased(2). For leased line B channels, there\n             is no signaling channel control available.')
isdnBearerOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("idle", 1), ("connecting", 2), ("connected", 3), ("active", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerOperStatus.setDescription('The current call control state for this port.\n             idle(1):       The B channel is idle.\n                            No call or call attempt is going on.\n             connecting(2): A connection attempt (outgoing call)\n                            is being made on this interface.\n             connected(3):  An incoming call is in the process\n                            of validation.\n             active(4):     A call is active on this interface.')
isdnBearerChannelNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerChannelNumber.setDescription('The identifier being used by a signaling protocol\n             to identify this B channel, also referred to as\n             B channel number. If the Agent also supports the DS0 MIB,\n             the values of isdnBearerChannelNumber and dsx0Ds0Number\n             must be identical for a given B channel.')
isdnBearerPeerAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 4), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerPeerAddress.setDescription("The ISDN address the current or last call is or was\n             connected to.\n\n             In some cases, the format of this information can not\n             be predicted, since it largely depends on the type\n             of switch or PBX the device is connected to. Therefore,\n             the detailed format of this information is not\n             specified and is implementation dependent.\n\n             If possible, the agent should supply this information\n             using the E.164 format. In this case, the number must\n             start with '+'. Otherwise, IA5 number digits must be used.\n\n             If the peer ISDN address is not available,\n             this object has a length of zero.")
isdnBearerPeerSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 5), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerPeerSubAddress.setDescription('The ISDN subaddress the current or last call is or was\n             connected to.\n\n             The subaddress is an user supplied string of up to 20\n             IA5 characters and is transmitted transparently through\n             the network.\n\n             If the peer subaddress is not available, this object\n             has a length of zero.')
isdnBearerCallOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unknown", 1), ("originate", 2), ("answer", 3), ("callback", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerCallOrigin.setDescription('The call origin for the current or last call. If since\n             system startup there was no call on this interface,\n             this object has a value of unknown(1).')
isdnBearerInfoType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9,))).clone(namedValues=NamedValues(("unknown", 1), ("speech", 2), ("unrestrictedDigital", 3), ("unrestrictedDigital56", 4), ("restrictedDigital", 5), ("audio31", 6), ("audio7", 7), ("video", 8), ("packetSwitched", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerInfoType.setDescription("The Information Transfer Capability for the current\n             or last call.\n\n             speech(2) refers to a non-data connection, whereas\n             audio31(6) and audio7(7) refer to data mode connections.\n\n             Note that Q.931, chapter 4.5.5, originally defined\n             audio7(7) as '7 kHz audio' and now defines it as\n             'Unrestricted digital information with tones/\n             announcements'.\n\n             If since system startup there has been no call on this\n             interface, this object has a value of unknown(1).")
isdnBearerMultirate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerMultirate.setDescription('This flag indicates if the current or last call used\n             multirate. The actual information transfer rate,\n             in detail specified in octet 4.1 (rate multiplier),\n             is the sum of all B channel ifSpeed values for\n             the hyperchannel.\n\n             If since system startup there was no call on this\n             interface, this object has a value of false(2).')
isdnBearerCallSetupTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerCallSetupTime.setDescription('The value of sysUpTime when the ISDN setup message for\n             the current or last call was sent or received. If since\n             system startup there has been no call on this interface,\n             this object has a value of zero.')
isdnBearerCallConnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerCallConnectTime.setDescription('The value of sysUpTime when the ISDN connect message for\n             the current or last call was sent or received. If since\n             system startup there has been no call on this interface,\n             this object has a value of zero.')
isdnBearerChargedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 2, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnBearerChargedUnits.setDescription('The number of charged units for the current or last\n             connection. For incoming calls or if charging information\n             is not supplied by the switch, the value of this object\n             is zero.')
isdnSignalingGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1, 3))
isdnSignalingGetIndex = MibScalar((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnSignalingGetIndex.setDescription('The recommended procedure for selecting a new index for\n             isdnSignalingTable row creation is to GET the value of\n             this object, and then to SET the object with the same\n             value. If the SET operation succeeds, the manager can use\n             this value as an index to create a new row in this table.')
isdnSignalingTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2), )
if mibBuilder.loadTexts: isdnSignalingTable.setDescription('ISDN signaling table containing configuration and\n             operational parameters for all ISDN signaling\n             channels on this managed device.')
isdnSignalingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1), ).setIndexNames((0, "ISDN-MIB", "isdnSignalingIndex"))
if mibBuilder.loadTexts: isdnSignalingEntry.setDescription('An entry in the ISDN Signaling Table. To create a new\n             entry, only isdnSignalingProtocol needs to be specified\n             before isdnSignalingStatus can become active(1).')
isdnSignalingIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: isdnSignalingIndex.setDescription('The index value which uniquely identifies an entry\n             in the isdnSignalingTable.')
isdnSignalingIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSignalingIfIndex.setDescription('The ifIndex value of the interface associated with this\n             signaling channel.')
isdnSignalingProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 3), IsdnSignalingProtocol()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingProtocol.setDescription('The particular protocol type supported by the\n             switch providing access to the ISDN network\n             to which this signaling channel is connected.')
isdnSignalingCallingAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 4), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingCallingAddress.setDescription("The ISDN Address to be assigned to this signaling\n             channel. More specifically, this is the 'Calling Address\n             information element' as being passed to the switch\n             in outgoing call setup messages.\n\n             It can be an EAZ (1TR6), a calling number (DSS1, ETSI)\n             or any other number necessary to identify a signaling\n             interface. If there is no such number defined or required,\n             this is a zero length string. It is represented in\n             DisplayString form.\n\n             Incoming calls can also be identified by this number.\n             If the Directory Number, i.e. the Called Number in\n             incoming calls, is different to this number, the\n             isdnDirectoryTable has to be used to specify all\n             possible Directory Numbers.\n\n             The format of this information largely depends on the type\n             of switch or PBX the device is connected to. Therefore,\n             the detailed format of this information is not\n             specified and is implementation dependent.\n\n             If possible, the agent should implement this information\n             using the E.164 number format. In this case, the number\n             must start with '+'. Otherwise, IA5 number digits must\n             be used.")
isdnSignalingSubAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 5), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingSubAddress.setDescription('Supplementary information to the ISDN address assigned\n             to this signaling channel. Usually, this is the\n             subaddress as defined in Q.931.\n             If there is no such number defined or required, this is\n             a zero length string.\n             The subaddress is used for incoming calls as well as\n             for outgoing calls.\n             The subaddress is an user supplied string of up to 20\n             IA5 characters and is transmitted transparently through\n             the network.')
isdnSignalingBchannelCount = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingBchannelCount.setDescription('The total number of B channels (bearer channels)\n             managed by this signaling channel. The default value\n             of this object depends on the physical interface type\n             and is either 2 for Basic Rate interfaces or\n             24 (30) for Primary Rate interfaces.')
isdnSignalingInfoTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),)).clone('disabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingInfoTrapEnable.setDescription('Indicates whether isdnMibCallInformation traps\n             should be generated for calls on this signaling\n             channel.')
isdnSignalingStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 2, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnSignalingStatus.setDescription('This object is used to create and delete rows in the\n             isdnSignalingTable.')
isdnSignalingStatsTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3), )
if mibBuilder.loadTexts: isdnSignalingStatsTable.setDescription('ISDN signaling table containing statistics\n             information for all ISDN signaling channels\n             on this managed device.\n             Only statistical information which is not already being\n             counted in the ifTable is being defined in this table.')
isdnSignalingStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1), )
isdnSignalingEntry.registerAugmentions(("ISDN-MIB", "isdnSignalingStatsEntry"))
isdnSignalingStatsEntry.setIndexNames(*isdnSignalingEntry.getIndexNames())
if mibBuilder.loadTexts: isdnSignalingStatsEntry.setDescription('An entry in the ISDN Signaling statistics Table.')
isdnSigStatsInCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSigStatsInCalls.setDescription('The number of incoming calls on this interface.')
isdnSigStatsInConnected = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSigStatsInConnected.setDescription('The number of incoming calls on this interface\n             which were actually connected.')
isdnSigStatsOutCalls = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSigStatsOutCalls.setDescription('The number of outgoing calls on this interface.')
isdnSigStatsOutConnected = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSigStatsOutConnected.setDescription('The number of outgoing calls on this interface\n             which were actually connected.')
isdnSigStatsChargedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnSigStatsChargedUnits.setDescription("The number of charging units on this interface since\n             system startup.\n             Only the charging units applying to the local interface,\n             i.e. for originated calls or for calls with 'Reverse\n             charging' being active, are counted here.")
isdnLapdTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4), )
if mibBuilder.loadTexts: isdnLapdTable.setDescription('Table containing configuration and statistics\n             information for all LAPD (D channel Data Link)\n             interfaces on this managed device.\n             Only statistical information which is not already being\n             counted in the ifTable is being defined in this table.')
isdnLapdEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: isdnLapdEntry.setDescription('An entry in the LAPD Table.')
isdnLapdPrimaryChannel = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnLapdPrimaryChannel.setDescription('If set to true(1), this D channel is the designated\n             primary D channel if D channel backup is active.\n             There must be exactly one primary D channel\n             configured. If D channel backup is not used, this\n             object has a value of true(1).')
isdnLapdOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("inactive", 1), ("l1Active", 2), ("l2Active", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnLapdOperStatus.setDescription('The operational status of this interface:\n\n             inactive  all layers are inactive\n             l1Active  layer 1 is activated,\n                       layer 2 datalink not established\n             l2Active  layer 1 is activated,\n                       layer 2 datalink established.')
isdnLapdPeerSabme = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnLapdPeerSabme.setDescription('The number of peer SABME frames received on this\n             interface. This is the number of peer-initiated\n             new connections on this interface.')
isdnLapdRecvdFrmr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 3, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnLapdRecvdFrmr.setDescription('The number of LAPD FRMR response frames received.\n             This is the number of framing errors on this\n             interface.')
isdnEndpointGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1, 4))
isdnEndpointGetIndex = MibScalar((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: isdnEndpointGetIndex.setDescription('The recommended procedure for selecting a new index for\n             isdnEndpointTable row creation is to GET the value of\n             this object, and then to SET the object with the same\n             value. If the SET operation succeeds, the manager can use\n             this value as an index to create a new row in this table.')
isdnEndpointTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2), )
if mibBuilder.loadTexts: isdnEndpointTable.setDescription('Table containing configuration for Terminal\n             Endpoints.')
isdnEndpointEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1), ).setIndexNames((0, "ISDN-MIB", "isdnEndpointIndex"))
if mibBuilder.loadTexts: isdnEndpointEntry.setDescription('An entry in the Terminal Endpoint Table. The value\n             of isdnEndpointIfType must be supplied for a row\n             in this table to become active.')
isdnEndpointIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: isdnEndpointIndex.setDescription('The index value which uniquely identifies an entry\n             in the isdnEndpointTable.')
isdnEndpointIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 2), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: isdnEndpointIfIndex.setDescription('The ifIndex value of the interface associated with this\n             Terminal Endpoint.')
isdnEndpointIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 3), IANAifType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnEndpointIfType.setDescription('The interface type for this Terminal Endpoint.\n             Interface types of x25ple(40) and isdn(63) are allowed.\n             The interface type is identical to the value of\n             ifType in the associated ifEntry.')
isdnEndpointTeiType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("dynamic", 1), ("static", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnEndpointTeiType.setDescription('The type of TEI (Terminal Endpoint Identifier)\n             used for this Terminal Endpoint. In case of dynamic(1),\n             the TEI value is selected by the switch. In\n             case of static(2), a valid TEI value has to be\n             entered in the isdnEndpointTeiValue object.\n             The default value for this object depends on the\n             interface type as well as the Terminal Endpoint type.\n             On Primary Rate interfaces the default value is\n             static(2). On Basic Rate interfaces the default value\n             is dynamic(1) for isdn(63) Terminal Endpoints and\n             static(2) for x25ple(40) Terminal Endpoints.')
isdnEndpointTeiValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnEndpointTeiValue.setDescription('The TEI (Terminal Endpoint Identifier) value\n             for this Terminal Endpoint. If isdnEndpointTeiType\n             is set to static(2), valid numbers are 0..63,\n             while otherwise the value is set internally.\n             The default value of this object is 0 for static\n             TEI assignment.\n             The default value for dynamic TEI assignment is also\n             0 as long as no TEI has been assigned. After TEI\n             assignment, the assigned TEI value is returned.')
isdnEndpointSpid = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 6), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnEndpointSpid.setDescription('The Service profile IDentifier (SPID) information\n             for this Terminal Endpoint.\n\n             The SPID is composed of 9-20 numeric characters.\n\n             This information has to be defined in addition to\n             the local number for some switch protocol types,\n             e.g. Bellcore NI-1 and NI-2.\n\n             If this object is not required, it is a\n             zero length string.')
isdnEndpointStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 4, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnEndpointStatus.setDescription('This object is used to create and delete rows in the\n             isdnEndpointTable.')
isdnDirectoryGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 1, 5))
isdnDirectoryTable = MibTable((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1), )
if mibBuilder.loadTexts: isdnDirectoryTable.setDescription('Table containing Directory Numbers.')
isdnDirectoryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1, 1), ).setIndexNames((0, "ISDN-MIB", "isdnDirectoryIndex"))
if mibBuilder.loadTexts: isdnDirectoryEntry.setDescription('An entry in the Directory Number Table. All objects\n             in an entry must be set for a new row to become active.')
isdnDirectoryIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: isdnDirectoryIndex.setDescription('The index value which uniquely identifies an entry\n             in the isdnDirectoryTable.')
isdnDirectoryNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1, 1, 2), DisplayString()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnDirectoryNumber.setDescription("A Directory Number. Directory Numbers are used\n             to identify incoming calls on the signaling\n             channel given in isdnDirectorySigIndex.\n\n             The format of this information largely depends on the type\n             of switch or PBX the device is connected to. Therefore,\n             the detailed format of this information is not\n             specified and is implementation dependent.\n\n             If possible, the agent should implement this information\n             using the E.164 number format. In this case, the number\n             must start with '+'. Otherwise, IA5 number digits must\n             be used.")
isdnDirectorySigIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnDirectorySigIndex.setDescription('An index pointing to an ISDN signaling channel.\n             Incoming calls are accepted on this\n             signaling channel if the isdnDirectoryNumber is\n             presented as Called Number in the SETUP message.')
isdnDirectoryStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 20, 1, 5, 1, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: isdnDirectoryStatus.setDescription('This object is used to create and delete rows in the\n             isdnDirectoryTable.')
isdnMibTrapPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 2))
isdnMibTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 2, 0))
isdnMibCallInformation = NotificationType((1, 3, 6, 1, 2, 1, 10, 20, 2, 0, 1)).setObjects(*(("ISDN-MIB", "ifIndex"), ("ISDN-MIB", "isdnBearerOperStatus"), ("ISDN-MIB", "isdnBearerPeerAddress"), ("ISDN-MIB", "isdnBearerPeerSubAddress"), ("ISDN-MIB", "isdnBearerCallSetupTime"), ("ISDN-MIB", "isdnBearerInfoType"), ("ISDN-MIB", "isdnBearerCallOrigin"),))
if mibBuilder.loadTexts: isdnMibCallInformation.setDescription('This trap/inform is sent to the manager under the\n             following condidions:\n             - on incoming calls for each call which is rejected for\n               policy reasons (e.g. unknown neighbor or access\n               violation)\n             - on outgoing calls whenever a call attempt is determined\n               to have ultimately failed. In the event that call retry\n               is active, then this will be after all retry attempts\n               have failed.\n             - whenever a call connects. In this case, the object\n               isdnBearerCallConnectTime should be included in the\n               trap.\n\n             Only one such trap is sent in between successful or\n             unsuccessful call attempts from or to a single neighbor;\n             subsequent call attempts result in no trap.\n\n             If the Dial Control MIB objects dialCtlNbrCfgId and\n             dialCtlNbrCfgIndex are known by the entity generating\n             this trap, both objects should be included in the trap\n             as well. The receipt of this trap with no dial neighbor\n             information indicates that the manager must poll the\n             callHistoryTable of the Dial Control MIB to see what\n             changed.')
isdnMibConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 3))
isdnMibCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 3, 1))
isdnMibGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 20, 3, 2))
isdnMibCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 20, 3, 1, 1)).setObjects(*(("ISDN-MIB", "isdnMibSignalingGroup"), ("ISDN-MIB", "isdnMibBearerGroup"), ("ISDN-MIB", "isdnMibBasicRateGroup"), ("ISDN-MIB", "isdnMibEndpointGroup"), ("ISDN-MIB", "isdnMibDirectoryGroup"),))
if mibBuilder.loadTexts: isdnMibCompliance.setDescription('The compliance statement for entities which implement\n             the ISDN MIB.')
isdnMibBasicRateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 20, 3, 2, 1)).setObjects(*(("ISDN-MIB", "isdnBasicRateIfType"), ("ISDN-MIB", "isdnBasicRateLineTopology"), ("ISDN-MIB", "isdnBasicRateIfMode"), ("ISDN-MIB", "isdnBasicRateSignalMode"),))
if mibBuilder.loadTexts: isdnMibBasicRateGroup.setDescription('A collection of objects required for ISDN Basic Rate\n             physical interface configuration and statistics.')
isdnMibBearerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 20, 3, 2, 2)).setObjects(*(("ISDN-MIB", "isdnBearerChannelType"), ("ISDN-MIB", "isdnBearerOperStatus"), ("ISDN-MIB", "isdnBearerChannelNumber"), ("ISDN-MIB", "isdnBearerPeerAddress"), ("ISDN-MIB", "isdnBearerPeerSubAddress"), ("ISDN-MIB", "isdnBearerCallOrigin"), ("ISDN-MIB", "isdnBearerInfoType"), ("ISDN-MIB", "isdnBearerMultirate"), ("ISDN-MIB", "isdnBearerCallSetupTime"), ("ISDN-MIB", "isdnBearerCallConnectTime"), ("ISDN-MIB", "isdnBearerChargedUnits"),))
if mibBuilder.loadTexts: isdnMibBearerGroup.setDescription('A collection of objects required for ISDN Bearer channel\n             control and statistics.')
isdnMibSignalingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 20, 3, 2, 3)).setObjects(*(("ISDN-MIB", "isdnSignalingGetIndex"), ("ISDN-MIB", "isdnSignalingIfIndex"), ("ISDN-MIB", "isdnSignalingProtocol"), ("ISDN-MIB", "isdnSignalingCallingAddress"), ("ISDN-MIB", "isdnSignalingSubAddress"), ("ISDN-MIB", "isdnSignalingBchannelCount"), ("ISDN-MIB", "isdnSignalingInfoTrapEnable"), ("ISDN-MIB", "isdnSignalingStatus"), ("ISDN-MIB", "isdnSigStatsInCalls"), ("ISDN-MIB", "isdnSigStatsInConnected"), ("ISDN-MIB", "isdnSigStatsOutCalls"), ("ISDN-MIB", "isdnSigStatsOutConnected"), ("ISDN-MIB", "isdnSigStatsChargedUnits"), ("ISDN-MIB", "isdnLapdPrimaryChannel"), ("ISDN-MIB", "isdnLapdOperStatus"), ("ISDN-MIB", "isdnLapdPeerSabme"), ("ISDN-MIB", "isdnLapdRecvdFrmr"),))
if mibBuilder.loadTexts: isdnMibSignalingGroup.setDescription('A collection of objects required for ISDN D channel\n             configuration and statistics.')
isdnMibEndpointGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 20, 3, 2, 4)).setObjects(*(("ISDN-MIB", "isdnEndpointGetIndex"), ("ISDN-MIB", "isdnEndpointIfIndex"), ("ISDN-MIB", "isdnEndpointIfType"), ("ISDN-MIB", "isdnEndpointTeiType"), ("ISDN-MIB", "isdnEndpointTeiValue"), ("ISDN-MIB", "isdnEndpointSpid"), ("ISDN-MIB", "isdnEndpointStatus"),))
if mibBuilder.loadTexts: isdnMibEndpointGroup.setDescription('A collection of objects describing Terminal Endpoints.')
isdnMibDirectoryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 20, 3, 2, 5)).setObjects(*(("ISDN-MIB", "isdnDirectoryNumber"), ("ISDN-MIB", "isdnDirectorySigIndex"), ("ISDN-MIB", "isdnDirectoryStatus"),))
if mibBuilder.loadTexts: isdnMibDirectoryGroup.setDescription('A collection of objects describing directory numbers.')
mibBuilder.exportSymbols("ISDN-MIB", isdnBearerGroup=isdnBearerGroup, isdnMib=isdnMib, isdnBasicRateGroup=isdnBasicRateGroup, isdnLapdRecvdFrmr=isdnLapdRecvdFrmr, PYSNMP_MODULE_ID=isdnMib, isdnBasicRateIfType=isdnBasicRateIfType, isdnEndpointGetIndex=isdnEndpointGetIndex, isdnDirectoryStatus=isdnDirectoryStatus, isdnEndpointIndex=isdnEndpointIndex, isdnDirectoryNumber=isdnDirectoryNumber, isdnSignalingProtocol=isdnSignalingProtocol, isdnBearerEntry=isdnBearerEntry, isdnBearerMultirate=isdnBearerMultirate, isdnLapdTable=isdnLapdTable, isdnSignalingGroup=isdnSignalingGroup, isdnBasicRateIfMode=isdnBasicRateIfMode, isdnEndpointSpid=isdnEndpointSpid, isdnMibSignalingGroup=isdnMibSignalingGroup, isdnBearerCallConnectTime=isdnBearerCallConnectTime, isdnSignalingStatus=isdnSignalingStatus, isdnEndpointTeiValue=isdnEndpointTeiValue, isdnMibTrapPrefix=isdnMibTrapPrefix, isdnBearerInfoType=isdnBearerInfoType, isdnLapdPrimaryChannel=isdnLapdPrimaryChannel, isdnSignalingEntry=isdnSignalingEntry, isdnMibObjects=isdnMibObjects, isdnEndpointIfType=isdnEndpointIfType, isdnBearerPeerSubAddress=isdnBearerPeerSubAddress, isdnSignalingIfIndex=isdnSignalingIfIndex, isdnSignalingBchannelCount=isdnSignalingBchannelCount, isdnDirectoryTable=isdnDirectoryTable, isdnBasicRateEntry=isdnBasicRateEntry, isdnMibCallInformation=isdnMibCallInformation, isdnSigStatsOutConnected=isdnSigStatsOutConnected, isdnEndpointStatus=isdnEndpointStatus, isdnBearerChannelNumber=isdnBearerChannelNumber, isdnMibCompliances=isdnMibCompliances, isdnMibBearerGroup=isdnMibBearerGroup, isdnSigStatsInConnected=isdnSigStatsInConnected, isdnEndpointIfIndex=isdnEndpointIfIndex, isdnBearerCallOrigin=isdnBearerCallOrigin, isdnSignalingCallingAddress=isdnSignalingCallingAddress, IsdnSignalingProtocol=IsdnSignalingProtocol, isdnBearerChannelType=isdnBearerChannelType, isdnMibGroups=isdnMibGroups, isdnBasicRateTable=isdnBasicRateTable, isdnBasicRateLineTopology=isdnBasicRateLineTopology, isdnBearerTable=isdnBearerTable, isdnEndpointTable=isdnEndpointTable, isdnEndpointEntry=isdnEndpointEntry, isdnSignalingTable=isdnSignalingTable, isdnBearerPeerAddress=isdnBearerPeerAddress, isdnSigStatsOutCalls=isdnSigStatsOutCalls, isdnMibCompliance=isdnMibCompliance, isdnDirectorySigIndex=isdnDirectorySigIndex, isdnMibBasicRateGroup=isdnMibBasicRateGroup, isdnDirectoryGroup=isdnDirectoryGroup, isdnSigStatsChargedUnits=isdnSigStatsChargedUnits, isdnMibConformance=isdnMibConformance, isdnSignalingIndex=isdnSignalingIndex, isdnMibDirectoryGroup=isdnMibDirectoryGroup, isdnSigStatsInCalls=isdnSigStatsInCalls, isdnLapdOperStatus=isdnLapdOperStatus, isdnSignalingStatsEntry=isdnSignalingStatsEntry, isdnDirectoryIndex=isdnDirectoryIndex, isdnMibEndpointGroup=isdnMibEndpointGroup, isdnMibTraps=isdnMibTraps, isdnBearerOperStatus=isdnBearerOperStatus, isdnBearerCallSetupTime=isdnBearerCallSetupTime, isdnEndpointTeiType=isdnEndpointTeiType, isdnBasicRateSignalMode=isdnBasicRateSignalMode, isdnSignalingInfoTrapEnable=isdnSignalingInfoTrapEnable, isdnSignalingGetIndex=isdnSignalingGetIndex, isdnSignalingStatsTable=isdnSignalingStatsTable, isdnEndpointGroup=isdnEndpointGroup, isdnDirectoryEntry=isdnDirectoryEntry, isdnBearerChargedUnits=isdnBearerChargedUnits, isdnSignalingSubAddress=isdnSignalingSubAddress, isdnLapdEntry=isdnLapdEntry, isdnLapdPeerSabme=isdnLapdPeerSabme)
