% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpt-plotting.r
\name{plot.DPT}
\alias{plot.DPT}
\alias{plot,DPT,numeric-method}
\alias{plot,DPT,missing-method}
\title{Plot DPT}
\usage{
plot.DPT(
  x,
  root = NULL,
  paths_to = integer(0L),
  dcs = 1:2,
  divide = integer(0L),
  w_width = 0.1,
  col_by = "dpt",
  col_path = rev(palette()),
  col_tip = "red",
  ...,
  col = NULL,
  legend_main = col_by
)

\S4method{plot}{DPT,numeric}(x, y, ...)

\S4method{plot}{DPT,missing}(x, y, ...)
}
\arguments{
\item{x}{A \code{\link{DPT}} object.}

\item{paths_to}{Numeric Branch IDs. Are used as target(s) for the path(s) to draw.}

\item{dcs}{The dimensions to use from the DiffusionMap}

\item{divide}{If \code{col_by = 'branch'}, this specifies which branches to divide. (see \code{\link{branch_divide}})}

\item{w_width}{Window width for smoothing the path (see \code{\link[smoother]{smth.gaussian}})}

\item{col_by}{Color by 'dpt' (DPT starting at \code{branches[[1]]}), 'branch', or a veriable of the data.}

\item{col_path}{Colors for the path or a function creating n colors}

\item{col_tip}{Color for branch tips}

\item{...}{Graphical parameters supplied to \code{\link{plot.DiffusionMap}}}

\item{col}{See \code{\link{plot.DiffusionMap}}. This overrides \code{col_by}}

\item{legend_main}{See \code{\link{plot.DiffusionMap}}.}

\item{y, root}{Root branch ID. Will be used as the start of the DPT. (default: lowest branch ID)
(If longer than size 1, will be interpreted as \code{c(root, branches)})}
}
\value{
The return value of the underlying call is returned, i.e. a scatterplot3d or rgl object for 3D plots.
}
\description{
Plots diffusion components from a Diffusion Map and the accompanying Diffusion Pseudo Time (\code{\link{DPT}})
}
\examples{
data(guo_norm)
dm <- DiffusionMap(guo_norm)
dpt <- DPT(dm)
plot(dpt)
plot(dpt, 2L,      col_by = 'branch')
plot(dpt, 1L, 2:3, col_by = 'num_cells')
plot(dpt, col_by = 'DPT3')

}
