% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-dirs.R
\name{check_dirs}
\alias{check_dirs}
\title{Check Directories Exist}
\usage{
check_dirs(x, exists = TRUE, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{exists}{A flag specifying whether the files/directories must (or must not) exist.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks if all directories exist (or if exists = FALSE do not exist as directories or files).
}
\examples{
check_dirs(tempdir())
try(check_dirs(tempdir(), exists = FALSE))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_files}()},
\code{\link{check_key}()},
\code{\link{check_length}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
