% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_draws.R
\name{example_draws}
\alias{example_draws}
\title{Example \code{draws} objects}
\usage{
example_draws(example = "eight_schools")
}
\arguments{
\item{example}{(string) The name of the example \code{draws} object. See
\strong{Details} for available options.}
}
\value{
A \code{draws} object.
}
\description{
Objects for use in examples, vignettes, and tests.
}
\details{
The following example \code{draws} objects are available.

\strong{eight_schools}: A \code{\link{draws_array}} object with 100 iterations
from each of 4 Markov chains obtained by fitting the eight schools model
described in Gelman et al. (2013) with \href{https://mc-stan.org}{Stan}. The
variables are:
\itemize{
\item \code{mu}: Overall mean of the eight schools
\item \code{tau}: Standard deviation between schools
\item \code{theta}: Individual means of each of the eight schools
}

\strong{multi_normal}: A \code{\link{draws_array}} object with 100 iterations from each of
the 4 Markov chains obtained by fitting a 3-dimensional multivariate normal
model to 100 simulated observations. The variables are:
\itemize{
\item \code{mu}: Mean parameter vector of length 3
\item \code{Sigma}: Covariance matrix of dimension 3 x 3
}
}
\note{
These objects are only intended to be used in demonstrations and tests.
They contain fewer iterations and chains than recommended for performing
actual inference.
}
\examples{
draws_eight_schools <- example_draws("eight_schools")
summarise_draws(draws_eight_schools)

draws_multi_normal <- example_draws("multi_normal")
summarise_draws(draws_multi_normal)

}
\references{
Andrew Gelman, John B. Carlin, Hal S. Stern, David B. Dunson, Aki Vehtari and
Donald B. Rubin (2013). Bayesian Data Analysis, Third Edition. Chapman and
Hall/CRC.
}
