% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Compute model quality}
\usage{
cv(x, ...)
}
\arguments{
\item{x}{Fitted linear model of class \code{lm}, \code{merMod} (\pkg{lme4})
or \code{lme} (\pkg{nlme}).}

\item{...}{More fitted model objects, to compute multiple coefficients of
variation at once.}
}
\value{
Numeric, the coefficient of variation.
}
\description{
Compute the coefficient of variation.
}
\details{
The advantage of the cv is that it is unitless. This allows
coefficient of variation to be compared to each other in ways
that other measures, like standard deviations or root mean
squared residuals, cannot be.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c160age + c12hour, data = efc)
cv(fit)

}
