## RabbitMQ 3.5.7

RabbitMQ `3.5.7` is primarily a bug fix release.

### Server

#### Bug Fixes

 * Fix a race condition that could prevent nodes from stopping.

   GitHub issue: [rabbitmq-server#465](https://github.com/rabbitmq/rabbitmq-server/issues/465)

 * `file_handle_cache:clear_read_cache/0` no longer silently fails.

   The function is mean to be used with `rabbitmqctl eval` in environments where
   in-process buffering of file data is enabled.

   GitHub issue: [rabbitmq-server#436](https://github.com/rabbitmq/rabbitmq-server/issues/436)

 * Default `RABBITMQ_PLUGINS_DIR` value on Windows should be calculated as relative to RabbitMQ
   server installation directory, not `RABBITMQ_BASE`.

   If you override `RABBITMQ_BASE`, you may need to copy plugins from `%RABBITMQ_BASE%\plugins`
   to the `plugins` directory under RabbitMQ installation.

   GitHub issue: [rabbitmq-server#433](https://github.com/rabbitmq/rabbitmq-server/issues/433)

 * When rabbitmq-server failed to start due to an unreadable config file, exit code was 0

   GitHub issue: [rabbitmq-server#464](https://github.com/rabbitmq/rabbitmq-server/issues/464)

 * Overriding `RABBITMQ_LOGS` and `RABBITMQ_SASL_LOGS` on Windows prevented node from starting.

   GitHub issue: [rabbitmq-server#375](https://github.com/rabbitmq/rabbitmq-server/issues/375)

 * Some startup code bits assumed IPv4 is enabled in the environment

   GitHub issue: [rabbitmq-server#117](https://github.com/rabbitmq/rabbitmq-server/issues/117)

 * More robust disk monitor, fewer errors logged.

   GitHub issue: [rabbitmq-server#91](https://github.com/rabbitmq/rabbitmq-server/issues/91)

 * `rabbitmqctl forget_cluster_node` no longer attempts to impersonate live
   (reachable) nodes.

   GitHub issue: [rabbitmq-server#470](https://github.com/rabbitmq/rabbitmq-server/issues/470)

 * `rabbitmq-plugins` was using an incorrect env variable.

   GitHub issue: [rabbitmq-server#451](https://github.com/rabbitmq/rabbitmq-server/issues/451)

#### Enhancements

 * RAM watermark can be configured as an absolute value in bytes (just like with disk space monitoring):

   ```
   [{rabbit, [{vm_memory_high_watermark, {absolute, 1073741824}}]}].
   ```

   GitHub issue: [rabbitmq-server#207](https://github.com/rabbitmq/rabbitmq-server/issues/207)

 * `rabbitmqctl authenticate_user` is a new command that can be used to test user authentication.

   GitHub issue: [rabbitmq-server#119](https://github.com/rabbitmq/rabbitmq-server/issues/119)

 * `rabbitmqctl` now supports `exclusive` as a queue info item.

   Contributed by Alexey Lebedeff (@binarin).

   GitHub issue: [rabbitmq-server#371](https://github.com/rabbitmq/rabbitmq-server/issues/371)


### Java client

#### Enhancements

 * Heartbeats are now enabled by default.

   GitHub issue: [rabbitmq-java-client#109](https://github.com/rabbitmq/rabbitmq-java-client/issues/109).

#### Bug Fixes

 * `AutorecoveringChannel#basicCancel` could throw a `NullPointerException`.

   GitHub issue: [rabbitmq-java-client#105](https://github.com/rabbitmq/rabbitmq-java-client/issues/105)


### .NET client

#### Enhancements

 * Heartbeats are now enabled by default.

   GitHub issue: [rabbitmq-dotnet-client#142](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/142).


#### Bug Fixes

 * `IConnection.Dispose` could throw an exception.

   GitHub issue: [rabbitmq-dotnet-client#133](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/133)


### MQTT plugin

#### Bug Fixes

 * Auto-deletion of queues that back QoS 1 subscriptions is again controlled
   by the clean session flag.

   GitHub issues: [rabbitmq-mqtt#30](https://github.com/rabbitmq/rabbitmq-mqtt/issues/30) (original report which introduced the issue), [rabbitmq-mqtt#37](https://github.com/rabbitmq/rabbitmq-mqtt/issues/37) (clarification and fix)



### STOMP plugin

#### Enhancements

 * Queue names now can be set explicitly using the `x-queue-name` header, for all
   destination types.

   GitHub issue: [rabbitmq-stomp#43](https://github.com/rabbitmq/rabbitmq-stomp/issues/43)



### Management plugin

#### Bug Fixes

 * Management plugin could prevent a node from starting when it recovers after a network split.

   GitHub issue: [rabbitmq-management#81](https://github.com/rabbitmq/rabbitmq-management/issues/81)

 * Sorting arrow direction in the UI is now more conventional.

   Contributed by Philippe Serhal.

   GitHub issue: [rabbitmq-management#88](https://github.com/rabbitmq/rabbitmq-management/pull/88).

 * 401 responses correctly set content type to `application/json`

   GitHub issue: [rabbitmq-management#67](https://github.com/rabbitmq/rabbitmq-management/issues/67)

 * Consumer utilisation is correctly reported as a number instead of `""` when it equals 0.

   GitHub issue: [rabbitmq-management#26](https://github.com/rabbitmq/rabbitmq-management/issues/26)

 * `rabbitmqadmin` misinterpreted boolean settings in config as strings

   GitHub issue: [rabbitmq-management#20](https://github.com/rabbitmq/rabbitmq-management/issues/20)
   

### AMQP 1.0 plugin

#### Bug Fixes

 * Fixed an edge case in serialisation of collections.

   GitHub issue: [rabbitmq-amqp1.0#21](https://github.com/rabbitmq/rabbitmq-amqp1.0/issues/21)


### Erlang client

#### Enhancements

 * Heartbeats are now enabled by default.

   GitHub issue: [rabbitmq-erlang-client#25](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/25).
