# Announce: Rakudo Perl 6 compiler, Release #108 (2017.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2017 release of Rakudo Perl 6 #108. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.02:
 + 6.d.PREVIEW changes:
    + It is now possible to use different language versions in different comp units.
        Pragma `use v6.d.PREVIEW;` loads PREVIEW version of 6.d language [9044fca]
    + Made `await` non-blocking (i.e. not using a thread for waiting) [dd1cb5f]
    + Made `react` non-blocking [4aa8d70]
    + Various improvements to error reporting [ee7c1bb][a2d69a0][f22170f]
 + Fixes:
    + Fixed data race in NFA cache [8f53a6f]
    + Fixed handling of Unicode characters on Windows command line [8f53a6f]
    + Fixed overflow during full GC collection on 32-bit systems [8f53a6f]
    + Fixed GC problem in string repeat op [8f53a6f]
    + Fixed .perl.EVAL roundtripping for circular Arrays and
         Hashes [67aeefa][673f06b]
    + Fixed instantiation of subclasses of classes that do Rational [7f245f7]
    + Fixed incorrect handling of precision flag in sprintf '%d' [a1c7d01]
    + Fixed `infix:<xx>(..., *)` for empty Slips [4e49ec1]
    + Fixed .pairs, .values, and .kv with native shaped arrays not having values
        in writable containers [0fdb9e4][1181afe][e195e5f]
    + Changed Pair.AT-KEY on non-existent key to return Nil [9728c4a]
    + Fixed Slip.List not returning a Slip instead of a List [4d4822a]
    + Made Map.List and Hash.List always return  a List [6dd542f]
    + Fixed crash when using `.=` to initialize attributes [700a077]
    + Fixed leak of asynchronous task handles [483e4fd]
    + Fixed issues in .skip-one in internal Mappy iterator [3a77cb5][e7ea4c2]
    + Fixed count-only on all Hash based .kv methods reporting only half of
        actual value [aecbb3e]
    + Fixed crash in internal iterator used by .rotor and .batch [bcd902a]
    + Fixed LAST phaser called twice in sunk do for {} loops [3424465]
    + Fixed various discrepancies as a result of inlining non-native types [f8b3469]
    + Fixed leaks and an invalid read in synchronous sockets on errors [9ed4449]
    + Fixed NFA generation for the constructs `x ** 1..2` and `:i <[A..Z]>`,
        and hardened NFA processing in MoarVM so as to not read out of bounds [9ed4449]
    + Fixed memory leaks on startup and module load with augmented types [9ed4449]
    + Fixed smartmatch of Complex against Ranges [f2894d3]
    + Fixed premature overflow of `div` on native int types [c98b3a5]
    + Fixed flat()/Iterable.flat not propagating `is-lazy` [51b0aba][ca102c5]
    + Fixed hang with `*@` slurpies when given infinite list [51b0aba]
    + Fixed abs() failing with negative zeros [f85978b]
    + Fixed List.perl of containerized empty lists [a148c70]
    + Fixed at-times incorrect result of Rational.ceiling [6372417][79553d0]
    + Fixed Rational.norm failing to normalize the Rational [aac9efc]
    + Fixed issues with close() and read() on closed async sockes [f16cf37]
    + Fixed occasional disordering of messages in Supplier::Preserving [cabf6fb]
    + Fixed a data race in NFA caching causing SEGV [62bd30b]
    + Fixed data races and over-sharing of %*ENV in precompilation [bab1c02]
    + Fixed data races in CompUnit::PrecompilationStore::File
        [accc156][39c517e][917d473][a88da2e][6c374d5][2b1eb64]
    + Various improvements to error reporting [10bcec2][5822605][f230224][b51a550]
        [8733aa5][483e4fd][f0b9234][e922275][51ebfb1][acae345][1b99196][301bcf9]
 + Additions:
    + Implemented Array.clone [dc69daf]
    + Implemented Mu:U.clone [11d005e][4b85db6]
    + Added experimental `infix:<unicmp>` [6f6f0cf][5870ef9][eb3356c][6990133]
    + Added experimental `infix:<coll>`, `Any.collate`, and `$*COLLATION`
        [2061485][4efcc29][46313fa][1923878][5611425][6990133][f85978b]
    + Implemented Any.skip [8a6bfc6]
    + Implemented Supply.skip [d71bf1e][15753fd]
    + Implemented Any.batch [e0201f1][f6531d3]
    + Added Supply.rotor($batch) candidate [5694727]
    + Added support for all Nd characers in sprintf format strings [483e4fd]
    + Added support for more named Unicode sequences [3a77406]
    + Made named Unicode lookups (e.g. "\c[...]") case insensitive [3a77406]
    + Added support for Support East_Asian_Width Unicode property [9ed4449]
    + Made CompUnitHandle.globalish-package return the actual Stash [960a789]
    + Made Test.pm6's skip() only accept Int test counts [ae9d517]
    + Numerious fixes related to colonpair-extended names on subroutines [48abeee]
    + Made merging of Perl 5 symbols use the same mechanism as for Perl 6 [4e7ab20]
    + Included try-load in CompUnit::PrecompilationRepository's interface [d932355]
    + Made S/// set $/ to Match objects made during substitution and avoid
        returning the result in $/ causing container-reuse in loops [97359ae]
    + Made CompUnit::Repository::Installation sort binaries by version [7c39bbf]
    + Made it possible to call IO::Path.s on a directory [25fd1ca]
    + Gave fakesignature a $/, $_, and $! to avoid unintended sharing [71a1283]
    + Implemented smartmatch of character Ranges [8477f3b]
    + Str ~~ Numeric no longer throws if Str cannot be coerced to Numeric [1615c83]
 + Efficiency:
    + Made SetHash.iterator|pairs|antipairs|kv|values about 20x faster [a2fbe20]
    + Made Int.WHICH about 1.7x faster [9841313]
    + Made Baggy.kv about 15% faster [e995107]
    + Made Baggy.kxxv about 30% faster [5db0b29]
    + Made Baggy.antipairs about 25% faster [2922ec4]
    + Sped up postincrement and postdecrement by about 5% [fd74c91]
    + Internal improvements for 1%+ faster parsing [dd514da][9493ffb][951a441]
    + Made `<ws>` parsing 5%+ faster [0bb7c20][d5262e6]
    + Generalized sink branch optimize logic improving performance for
        sunk post increment [5401a1a]
    + Improved radix operations (50% faster with non-ASCII digits) [9ed4449][c98b3a5]
    + Made uniprop/unival/unimatch 1.1x to 2.1x faster [411782e]
    + Fixed performance loss on `infix:<x>` with very large number [8878af8]
    + Made Map.sort about 1.5x faster (also affecting its .perl/.gist/.Str) [0ee3b7d]
    + Made an improvement in candidate selection order of &sort [b7c6e73]
    + Made .skip of internal mappy iterator about 15% faster [54f647d]
    + Made List.keys on lazy lists a bit faster [0ad05ce]
    + Made Seq.InfiniteLoopIter about 6% faster [00e60d9]
    + Made do repeat while about 3%-11% faster [a832944][af49026]
    + Made `do while foo { bar }` loops about 20% faster [4932112]
    + Made `do repeat while foo { bar }` about 20% faster [3888b42]
    + Made `do loop ( init; while; next ) { }` loops about 6% faster [c2eb7fb]
    + Made `.map: -> $_ --> non-Slippy-Foo { ... }` maps about 2x faster [fdcf462]
    + Made firing of phasers about 25% faster [7e98504]
    + Made `my @a = do for @b { ...; PHASER foo }` about 1.5x faster [031efe0][3424465]
    + Made `for @b { ...; PHASER foo }` about 15% faster [031efe0]
    + Made `@b = @a.map: { }` 10% and `@b = do for @a { }` 20% faster [3e28b1e]
    + Made `for @a { ... }` about 1% faster [d69f375]
    + Made `my @b = @a.map: -> \a,\b { }` about 15% faster [9f15a4d]
    + Made `for @a -> \a, \b { }` about 2% faster [7384939]
    + Made .tail on reified List/Array about 8x as fast as `[*-1]` and .tail(N)
        about 16x as fast as `[*-N .. *-1] [*-N .. *-1]` [833fe43]
    + Made improvements and refactoring of various internal iterators
        [f2b97b0][18e6f0d][87f61d9][c069f45][ad90806][4ef37cf][54f647d][49e2d40a]
        [7c26985][4d8fc05][b1afc13][072d959][9d5c3fd][6b6a0b4][b31c591][b9d9279]
        [f799a03][98f9d8a]
    + Made improvements to performance of internals [ed4ef3b][f85978b]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Samantha McVey, Pawel Murias,
Will "Coke" Coleda, Jonathan Worthington, Wenzel P. P. Peppmeyer,
Antonio Quinonez, Altai-man, Cale, Daniel Green, Tom Browder, Moritz Lenz,
Christian Bartolomäus, Ronald Schmidt, Stefan Seifert, Larry Wall,
Aleks-Daniel Jakimenko-Aleksejev, JJ Merelo, Jonathan Stowe, Timo Paulssen,
Brad Gilbert, Christopher Bottoms, Will Coleda, Christian Walde,
Siavash Askari Nasr, Nic, Curt Tilmes, raiph, Carl Masak, smls,
Jan-Olof Hendig, Sam S

as well as

A. Sinan Unur, Bart Wiegmans, Benny Siegert, Jeff Linahan, Jimmy Zhuo, Lucas Buchala, M. Faiz Zakwan Zamzuri

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#109), is tentatively scheduled for 2017-03-18.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation,
and other software that can be used with the Rakudo compiler to enhance its utility.
