# 2022-06-28 Triage Log

Overall, a positive week for compiler performance with regressions mainly being relegated to smaller issues. This can be see by the fact that 95 test cases in real world crates were improvements while regressions only happened in 22 test cases. The largest improvement was by @nnethercote where the compilation of `#[derive(Debug)]` was improved. This led to an average of 1% improvement in compile times across 124 real world crate test cases.

Triage done by **@rylev**.
Revision range: [abace0a1f17986d89aedf610819deab2b4afee56..baf382e63c023259fa1f9042f8f479f183ca6ed3](https://perf.rust-lang.org/?start=abace0a1f17986d89aedf610819deab2b4afee56&end=baf382e63c023259fa1f9042f8f479f183ca6ed3&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 2.4% | 22    |
| Regressions 😿 <br /> (secondary) | 0.5% | 1.0% | 35    |
| Improvements 🎉 <br /> (primary) | -1.1% | -5.2% | 95    |
| Improvements 🎉 <br /> (secondary) | -2.3% | -10.3% | 35    |
| All 😿🎉 (primary) | -0.8% | -5.2% | 117   |


3 Regressions, 3 Improvements, 4 Mixed; 5 of them in rollups
34 artifact comparisons made in total

#### Regressions


Rollup of 16 pull requests [#98438](https://github.com/rust-lang/rust/pull/98438) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=43347397f7c5ca9a670a3bb3890c7187e24a52ab&end=e605a88441e5f6092194c914912142db635dfe21&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.3% | 0.4% | 37    |
| Regressions 😿 <br /> (secondary) | 0.4% | 0.6% | 17    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.4% | -0.5% | 3     |
| All 😿🎉 (primary) | 0.3% | 0.4% | 37    |
- Given the difficulty of investigation and the relatively small magnitude of the regression, I've marked this as triaged.

fix universes in the NLL type tests [#98109](https://github.com/rust-lang/rust/pull/98109) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fc96600bf6a52f92aeeee60a92a161a82b61c0ef&end=d017d59ed013a4bc2431d023077eb7209fe9c60d&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 1.9% | 31    |
| Regressions 😿 <br /> (secondary) | 0.9% | 2.0% | 35    |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.6% | 1.9% | 31    |
- This was a high-priority correctness fix, so the regressions are acceptable at least in the short term.
- [Oli already commented](https://github.com/rust-lang/rust/pull/98109#issuecomment-1165569316) on possible ideas for fixing the regression.



Rollup of 9 pull requests [#98591](https://github.com/rust-lang/rust/pull/98591) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f3ddd9f594adf9773547aa7cedb43c4ac8ffd2f&end=7f08d04d60d03e1a52dae61ce6aa50996898702b&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.2% | 1.7% | 7     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | N/A  | N/A | 0     |
- [#98576](https://github.com/rust-lang/rust/pull/98576) is probably the only likely candidate for this regression. 
- The cahcegrind didn't reveal anything super interesting though unfortunately.
- Left a comment [here](https://github.com/rust-lang/rust/pull/98591#issuecomment-1168877399).


#### Improvements

Rollup of 11 pull requests [#98335](https://github.com/rust-lang/rust/pull/98335) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a25b1315ee968146a5b206a8f3c670c5b307ebfe&end=72fd41a8b4d3488c97df3c3c75ddd9951aa3c73f&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | 1.1% | 1.1% | 1     |
| Improvements 🎉 <br /> (primary) | -0.9% | -1.2% | 8     |
| Improvements 🎉 <br /> (secondary) | -0.6% | -0.7% | 13    |
| All 😿🎉 (primary) | -0.9% | -1.2% | 8     |


proc_macro/bridge: cache static spans in proc_macro's client thread-local state [#98187](https://github.com/rust-lang/rust/pull/98187) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c80c4b8fdcf3da69cd483e2fec172c9b1f95842c&end=3b0d4813ab461ec81eab8980bb884691c97c5a35&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.4% | -0.7% | 12    |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | -0.4% | -0.7% | 12    |


Only keep a single query for well-formed checking [#98222](https://github.com/rust-lang/rust/pull/98222) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7f08d04d60d03e1a52dae61ce6aa50996898702b&end=5ffa8f67b75be56cf829bfc9d055082c8382c0cf&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | N/A  | N/A | 0     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.2% | -0.3% | 2     |
| Improvements 🎉 <br /> (secondary) | -0.2% | -0.3% | 7     |
| All 😿🎉 (primary) | -0.2% | -0.3% | 2     |


#### Mixed

Remove dereferencing of Box from codegen [#95576](https://github.com/rust-lang/rust/pull/95576) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=abace0a1f17986d89aedf610819deab2b4afee56&end=a25b1315ee968146a5b206a8f3c670c5b307ebfe&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.6% | 1.6% | 5     |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.8% | 17    |
| Improvements 🎉 <br /> (primary) | -0.5% | -0.5% | 1     |
| Improvements 🎉 <br /> (secondary) | -1.2% | -1.7% | 8     |
| All 😿🎉 (primary) | 0.4% | 1.6% | 6     |
- Some light investigation from Oli [already done](https://github.com/rust-lang/rust/pull/95576#issuecomment-1161901041).
- Seems like we're spending a bit more time in trait obligation resolution
- Asked Oli whether [this is acceptable](https://github.com/rust-lang/rust/pull/95576#issuecomment-1168899350).


Rollup of 6 pull requests [#98359](https://github.com/rust-lang/rust/pull/98359) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dc80ca78b6ec2b6bba02560470347433bcd0bb3c&end=a09c668c965f735f4cd59e7158662b9daa0b71ba&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.8% | 1.0% | 6     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | -0.3% | -0.6% | 14    |
| Improvements 🎉 <br /> (secondary) | N/A  | N/A | 0     |
| All 😿🎉 (primary) | 0.0% | 1.0% | 20    |
- By in large, a wash in terms of change to overall performance.
- The regressions are contained to diesel. 
- If I had to guess about a place to investigate, it would be [#87867](https://github.com/rust-lang/rust/pull/97867), but it might not be worth the effort. 


Rollup of 9 pull requests [#98447](https://github.com/rust-lang/rust/pull/98447) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d017d59ed013a4bc2431d023077eb7209fe9c60d&end=7036449c774860a5b348dbbe01c20704c557382e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 2.1% | 2.1% | 1     |
| Regressions 😿 <br /> (secondary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (primary) | N/A  | N/A | 0     |
| Improvements 🎉 <br /> (secondary) | -0.3% | -0.3% | 1     |
| All 😿🎉 (primary) | 2.1% | 2.1% | 1     |
- The regressions are contained to only one test case (regex opt) in codegen related queries.
- I didn't find any PRs that seemed like likely culprits.


Improve `derive(Debug)` [#98190](https://github.com/rust-lang/rust/pull/98190) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7125846d17a549866aa1ed0ea28778537378fca8&end=788ddedb0d88e40db9cd62b6163d5a471813044b&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions 😿 <br /> (primary) | 0.5% | 0.6% | 4     |
| Regressions 😿 <br /> (secondary) | 0.5% | 0.8% | 13    |
| Improvements 🎉 <br /> (primary) | -1.0% | -5.3% | 120   |
| Improvements 🎉 <br /> (secondary) | -1.8% | -10.3% | 69    |
| All 😿🎉 (primary) | -1.0% | -5.3% | 124   |
- Largely a very positive win.
