/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.skiplist;

import edu.jhu.skiplist.SkipList;
import edu.jhu.skiplist.SkipListElement;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SkipListRenderer
extends Canvas {
    protected final int POINTERBOX_HEIGHT = 20;
    protected final int POINTERBOX_WIDTH = 20;
    protected final int TEXTBOX_WIDTH = 40;
    protected final int BOX_GAP = 20;
    protected final int Y_OFFSET = 200;
    protected final int X_OFFSET = 10;
    protected final long NIL_KEY = Long.MAX_VALUE;
    private Applet myApplet;
    private SkipList mySkipList;
    private int myXOffset;

    public SkipListRenderer(Applet applet, SkipList skipList) {
        this.setBackground(Color.white);
        this.resize(800, 200);
        this.myApplet = applet;
        this.mySkipList = skipList;
        this.myXOffset = 0;
    }

    public void paint(Graphics graphics) {
        int[] nArray = new int[this.mySkipList.getMaxLevel() + 1];
        int n = 0;
        while (n <= this.mySkipList.getMaxLevel()) {
            nArray[n] = 0;
            ++n;
        }
        String string = "";
        string = string + "Level of this SkipList is " + (this.mySkipList.getLevel() + 1) + ".  ";
        string = string + "Maximum would be " + (this.mySkipList.getMaxLevel() + 1) + ".  ";
        string = string + "Probability is " + this.mySkipList.getProbability() + ".";
        graphics.setColor(Color.red);
        graphics.drawString(string, 10, 20);
        int n2 = 0;
        SkipListElement skipListElement = this.mySkipList.getHeader();
        while (skipListElement != null) {
            this.renderNode(graphics, skipListElement, n2, nArray);
            int n3 = 0;
            while (n3 <= skipListElement.getLevel()) {
                nArray[n3] = n2;
                ++n3;
            }
            skipListElement = skipListElement.forward[0];
            ++n2;
        }
    }

    private int calculateLeftX(int n) {
        int n2 = this.myXOffset + 10 + n * 80;
        return n2;
    }

    private int calculateRightX(int n) {
        int n2 = this.calculateLeftX(n);
        return n2 += 60;
    }

    private void renderNode(Graphics graphics, SkipListElement skipListElement, int n, int[] nArray) {
        int n2 = this.calculateLeftX(n);
        int n3 = this.calculateRightX(n);
        int n4 = 200;
        int n5 = 200 - (skipListElement.getLevel() + 1) * 20;
        graphics.setColor(Color.black);
        graphics.drawRect(n2, n5, n3 - n2, n4 - n5);
        int n6 = 0;
        while (n6 <= skipListElement.getLevel()) {
            graphics.drawRect(n2 + 40, n5 + n6 * 20, 20, 20);
            ++n6;
        }
        long l = skipListElement.key;
        String string = l == -2L ? "HDR" : (l == Long.MAX_VALUE ? "NIL" : Long.toString(l));
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n7 = (40 - fontMetrics.stringWidth(string)) / 2;
        int n8 = (n4 - n5) / 2 + fontMetrics.getHeight() / 2;
        graphics.drawString(string, n2 + n7, n5 + n8);
        if (n > 0) {
            int n9 = 0;
            while (n9 <= skipListElement.getLevel()) {
                int n10 = this.calculateRightX(nArray[n9]) - 10;
                int n11 = n2;
                int n12 = n4 - (int)(((double)n9 + 0.5) * 20.0);
                graphics.drawLine(n10, n12, n11, n12);
                graphics.drawLine(n11, n12, n11 - 7, n12 - 3);
                graphics.drawLine(n11, n12, n11 - 7, n12 + 3);
                graphics.fillOval(n10 - 3, n12 - 3, 6, 6);
                ++n9;
            }
        }
    }

    public int calculateImageWidth() {
        SkipListElement skipListElement = this.mySkipList.getHeader();
        int n = 0;
        while (skipListElement != null) {
            ++n;
            skipListElement = skipListElement.forward[0];
        }
        return n * 80;
    }

    public SkipListElement findElementAt(int n, int n2) {
        int n3 = (n += -this.myXOffset - 10) / 80;
        int n4 = n % 80;
        if (n4 < 60 && n4 > 0) {
            SkipListElement skipListElement = this.mySkipList.getHeader();
            int n5 = 0;
            while (n5 < n3 && skipListElement != null) {
                skipListElement = skipListElement.forward[0];
                ++n5;
            }
            return skipListElement;
        }
        return null;
    }

    public void setXOffset(int n) {
        this.myXOffset = n;
    }

    public void setSkipList(SkipList skipList) {
        this.mySkipList = skipList;
    }
}

