
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsesource.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsesource.h>


#line 27 "bsesource.proc"


/* --- set-input-by-id --- */
static GType type_id_set_input_by_id = 0;
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsesource.proc"
 {
#line 31 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("imodule", "Input Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("output-channel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 30 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 43 "bsesource.proc"
 }
static BseErrorType
#line 43 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 46 "bsesource.proc"
{
#line 47 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  guint ichannel     = g_value_get_uint (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  guint ochannel     = g_value_get_uint (in_values++);
  BseErrorType error;

#line 54 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 59 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  
#line 62 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static GType type_id_set_input = 0;
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 68 "bsesource.proc"
 {
#line 70 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("imodule", "Input Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_string ("output-channel", "Output Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 69 "bsesource.proc"
  proc->help = "Connect a module input to another module's output.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 82 "bsesource.proc"
 }
static BseErrorType
#line 82 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 85 "bsesource.proc"
{
#line 86 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  gchar *ichannel    = g_value_get_string (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  gchar *ochannel    = g_value_get_string (in_values++);
  BseErrorType error;

#line 93 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 99 "bsesource.proc"
  
  error = bse_source_set_input (isource, bse_source_find_ichannel (isource, ichannel),
				osource, bse_source_find_ochannel (osource, ochannel));
  
#line 103 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static GType type_id_unset_input_by_id = 0;
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 109 "bsesource.proc"
 {
#line 111 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("output-channel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 110 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 123 "bsesource.proc"
 }
static BseErrorType
#line 123 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 126 "bsesource.proc"
{
#line 127 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  guint ichannel     = g_value_get_uint (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  guint ochannel     = g_value_get_uint (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 134 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 139 "bsesource.proc"
  
  error = bse_source_unset_input (isource, ichannel, osource, ochannel);

#line 142 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static GType type_id_unset_input = 0;
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 148 "bsesource.proc"
 {
#line 150 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_object ("omodule", "Output Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("output-channel", "Output Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_enum ("error", "Error", NULL,
			     BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
			     BSE_PARAM_DEFAULT);
}
#line 149 "bsesource.proc"
  proc->help = "Disconnect a module input.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 162 "bsesource.proc"
 }
static BseErrorType
#line 162 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 165 "bsesource.proc"
{
#line 166 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);
  gchar *ichannel    = g_value_get_string (in_values++);
  BseSource *osource = g_value_get_object (in_values++);
  gchar *ochannel    = g_value_get_string (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 173 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel || !ochannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 179 "bsesource.proc"
  
  error = bse_source_unset_input (isource, bse_source_find_ichannel (isource, ichannel),
				  osource, bse_source_find_ochannel (osource, ochannel));

#line 183 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static GType type_id_clear_inputs = 0;
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 189 "bsesource.proc"
 {
#line 191 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 190 "bsesource.proc"
  proc->help = "Disconnect all module inputs.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 194 "bsesource.proc"
 }
static BseErrorType
#line 194 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 197 "bsesource.proc"
{
#line 198 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);

#line 201 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 205 "bsesource.proc"
  
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static GType type_id_clear_outputs = 0;
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 211 "bsesource.proc"
 {
#line 213 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 212 "bsesource.proc"
  proc->help = "Disconnect all module outputs.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 216 "bsesource.proc"
 }
static BseErrorType
#line 216 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 219 "bsesource.proc"
{
#line 220 "bsesource.proc"
  
  BseSource *isource = g_value_get_object (in_values++);

#line 223 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 227 "bsesource.proc"
  
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static GType type_id_n_ichannels = 0;
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 233 "bsesource.proc"
 {
#line 235 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_channels", "Number of Channels", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 234 "bsesource.proc"
  proc->help = "Get the number of input channels of a module.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 240 "bsesource.proc"
 }
static BseErrorType
#line 240 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 243 "bsesource.proc"
{
#line 244 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);

#line 247 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 251 "bsesource.proc"
  
  g_value_set_uint (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-name --- */
static GType type_id_ichannel_name = 0;
static void
ichannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 257 "bsesource.proc"
 {
#line 259 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 258 "bsesource.proc"
  proc->help = "Get input channel name.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 266 "bsesource.proc"
 }
static BseErrorType
#line 266 "bsesource.proc"
ichannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 269 "bsesource.proc"
{
#line 270 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 274 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 278 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_NAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-cname --- */
static GType type_id_ichannel_cname = 0;
static void
ichannel_cname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 284 "bsesource.proc"
 {
#line 286 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 285 "bsesource.proc"
  proc->help = "Get canonical input channel name.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 293 "bsesource.proc"
 }
static BseErrorType
#line 293 "bsesource.proc"
ichannel_cname_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 296 "bsesource.proc"
{
#line 297 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 301 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 305 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_CNAME (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static GType type_id_ichannel_blurb = 0;
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 311 "bsesource.proc"
 {
#line 313 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_blurb", "Channel Blurb", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 312 "bsesource.proc"
  proc->help = "Get input channel description.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 320 "bsesource.proc"
 }
static BseErrorType
#line 320 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 323 "bsesource.proc"
{
#line 324 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 328 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 332 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static GType type_id_is_joint_ichannel_by_id = 0;
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 338 "bsesource.proc"
 {
#line 340 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_jchannel", "Is Joint Channel", NULL,
				FALSE, BSE_PARAM_DEFAULT);
}
#line 339 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 347 "bsesource.proc"
 }
static BseErrorType
#line 347 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 350 "bsesource.proc"
{
#line 351 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);

#line 355 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 359 "bsesource.proc"
  
  g_value_set_boolean (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static GType type_id_is_joint_ichannel = 0;
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 365 "bsesource.proc"
 {
#line 367 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++)    = g_param_spec_string ("input-channel", "Input Channel", NULL,
			       NULL, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_boolean ("is_jchannel", "Is Joint Channel", NULL,
				FALSE, BSE_PARAM_DEFAULT);
}
#line 366 "bsesource.proc"
  proc->help = "Check if an input channel is a joint (multi-connect) channel.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 374 "bsesource.proc"
 }
static BseErrorType
#line 374 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 377 "bsesource.proc"
{
#line 378 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  gchar *ichannel   = g_value_get_string (in_values++);
  guint id;

#line 383 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 387 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  g_value_set_boolean (out_values++,
		       id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static GType type_id_ichannel_get_n_joints = 0;
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 395 "bsesource.proc"
 {
#line 397 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_joints", "Number of Connections", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 396 "bsesource.proc"
  proc->help = "Retrive the number of inputs connected to an input channel.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 404 "bsesource.proc"
 }
static BseErrorType
#line 404 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 407 "bsesource.proc"
{
#line 408 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 413 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 417 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    g_value_set_uint (out_values++, input->jdata.n_joints);
  else
    g_value_set_uint (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static GType type_id_ichannel_get_osource = 0;
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 427 "bsesource.proc"
 {
#line 429 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-joint", "Input Joint", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_object ("osource", "Output Source", NULL,
			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
}
#line 428 "bsesource.proc"
  proc->help = "Retrive output module connected to a specific joint of an input channel";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 438 "bsesource.proc"
 }
static BseErrorType
#line 438 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 441 "bsesource.proc"
{
#line 442 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  guint joint       = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 448 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 452 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    g_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    g_value_set_object (out_values++, input->idata.osource);
  else
    g_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static GType type_id_ichannel_get_ochannel = 0;
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 464 "bsesource.proc"
 {
#line 466 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-joint", "Input Joint", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("ochannel", "Output Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 465 "bsesource.proc"
  proc->help = "Retrive output channel of the module connected to a specific joint of an input channel.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 475 "bsesource.proc"
 }
static BseErrorType
#line 475 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 478 "bsesource.proc"
{
#line 479 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ichannel    = g_value_get_uint (in_values++);
  guint joint       = g_value_get_uint (in_values++);
  BseSourceInput *input;

#line 485 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 489 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    g_value_set_uint (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    g_value_set_uint (out_values++, input->idata.ochannel);
  else
    g_value_set_uint (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static GType type_id_n_ochannels = 0;
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 501 "bsesource.proc"
 {
#line 503 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_uint ("n_channels", "Number of Channels", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
}
#line 502 "bsesource.proc"
  proc->help = "Get the number of output channels of a module.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 508 "bsesource.proc"
 }
static BseErrorType
#line 508 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 511 "bsesource.proc"
{
#line 512 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);

#line 515 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 519 "bsesource.proc"
  
  g_value_set_uint (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-name --- */
static GType type_id_ochannel_name = 0;
static void
ochannel_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 525 "bsesource.proc"
 {
#line 527 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 526 "bsesource.proc"
  proc->help = "Get output channel name.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 534 "bsesource.proc"
 }
static BseErrorType
#line 534 "bsesource.proc"
ochannel_name_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 537 "bsesource.proc"
{
#line 538 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 542 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 546 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_NAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-cname --- */
static GType type_id_ochannel_cname = 0;
static void
ochannel_cname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 552 "bsesource.proc"
 {
#line 554 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_name", "Channel Name", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 553 "bsesource.proc"
  proc->help = "Get canonical output channel name.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 561 "bsesource.proc"
 }
static BseErrorType
#line 561 "bsesource.proc"
ochannel_cname_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 564 "bsesource.proc"
{
#line 565 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 569 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 573 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_CNAME (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static GType type_id_ochannel_blurb = 0;
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 579 "bsesource.proc"
 {
#line 581 "bsesource.proc"
  *(in_pspecs++) = g_param_spec_object ("module", "Module", NULL,
 			       BSE_TYPE_SOURCE, BSE_PARAM_DEFAULT);
  *(in_pspecs++) = g_param_spec_uint ("input-channel", "Input Channel", NULL,
			     0, G_MAXINT, 0, BSE_PARAM_DEFAULT);
  *(out_pspecs++)   = g_param_spec_string ("channel_blurb", "Channel Blurb", NULL,
			       NULL, BSE_PARAM_DEFAULT);
}
#line 580 "bsesource.proc"
  proc->help = "Get output channel description.";
#line 24 "bsesource.proc"
  proc->author = "Tim Janik <timj@gtk.org>";
#line 25 "bsesource.proc"
  proc->copyright = "Tim Janik";
#line 26 "bsesource.proc"
  proc->date = "2001";
#line 588 "bsesource.proc"
 }
static BseErrorType
#line 588 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 591 "bsesource.proc"
{
#line 592 "bsesource.proc"
  
  BseSource *source = g_value_get_object (in_values++);
  guint ochannel    = g_value_get_uint (in_values++);

#line 596 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 600 "bsesource.proc"
  
  g_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_set_input_by_id, "BseSource+set-input-by-id", NULL, 0, set_input_by_id_setup, set_input_by_id_exec, NULL, "/Method/BseSource/General/Set Input By Id", { 0, }, },
  { &type_id_set_input, "BseSource+set-input", NULL, 0, set_input_setup, set_input_exec, NULL, "/Method/BseSource/General/Set Input", { 0, }, },
  { &type_id_unset_input_by_id, "BseSource+unset-input-by-id", NULL, 0, unset_input_by_id_setup, unset_input_by_id_exec, NULL, "/Method/BseSource/General/Unset Input By Id", { 0, }, },
  { &type_id_unset_input, "BseSource+unset-input", NULL, 0, unset_input_setup, unset_input_exec, NULL, "/Method/BseSource/General/Unset Input", { 0, }, },
  { &type_id_clear_inputs, "BseSource+clear-inputs", NULL, 0, clear_inputs_setup, clear_inputs_exec, NULL, "/Method/BseSource/General/Clear Inputs", { 0, }, },
  { &type_id_clear_outputs, "BseSource+clear-outputs", NULL, 0, clear_outputs_setup, clear_outputs_exec, NULL, "/Method/BseSource/General/Clear Outputs", { 0, }, },
  { &type_id_n_ichannels, "BseSource+n-ichannels", NULL, 0, n_ichannels_setup, n_ichannels_exec, NULL, "/Method/BseSource/General/N Ichannels", { 0, }, },
  { &type_id_ichannel_name, "BseSource+ichannel-name", NULL, 0, ichannel_name_setup, ichannel_name_exec, NULL, "/Method/BseSource/General/Ichannel Name", { 0, }, },
  { &type_id_ichannel_cname, "BseSource+ichannel-cname", NULL, 0, ichannel_cname_setup, ichannel_cname_exec, NULL, "/Method/BseSource/General/Ichannel Cname", { 0, }, },
  { &type_id_ichannel_blurb, "BseSource+ichannel-blurb", NULL, 0, ichannel_blurb_setup, ichannel_blurb_exec, NULL, "/Method/BseSource/General/Ichannel Blurb", { 0, }, },
  { &type_id_is_joint_ichannel_by_id, "BseSource+is-joint-ichannel-by-id", NULL, 0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel By Id", { 0, }, },
  { &type_id_is_joint_ichannel, "BseSource+is-joint-ichannel", NULL, 0, is_joint_ichannel_setup, is_joint_ichannel_exec, NULL, "/Method/BseSource/General/Is Joint Ichannel", { 0, }, },
  { &type_id_ichannel_get_n_joints, "BseSource+ichannel-get-n-joints", NULL, 0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, NULL, "/Method/BseSource/General/Ichannel Get N Joints", { 0, }, },
  { &type_id_ichannel_get_osource, "BseSource+ichannel-get-osource", NULL, 0, ichannel_get_osource_setup, ichannel_get_osource_exec, NULL, "/Method/BseSource/General/Ichannel Get Osource", { 0, }, },
  { &type_id_ichannel_get_ochannel, "BseSource+ichannel-get-ochannel", NULL, 0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, NULL, "/Method/BseSource/General/Ichannel Get Ochannel", { 0, }, },
  { &type_id_n_ochannels, "BseSource+n-ochannels", NULL, 0, n_ochannels_setup, n_ochannels_exec, NULL, "/Method/BseSource/General/N Ochannels", { 0, }, },
  { &type_id_ochannel_name, "BseSource+ochannel-name", NULL, 0, ochannel_name_setup, ochannel_name_exec, NULL, "/Method/BseSource/General/Ochannel Name", { 0, }, },
  { &type_id_ochannel_cname, "BseSource+ochannel-cname", NULL, 0, ochannel_cname_setup, ochannel_cname_exec, NULL, "/Method/BseSource/General/Ochannel Cname", { 0, }, },
  { &type_id_ochannel_blurb, "BseSource+ochannel-blurb", NULL, 0, ochannel_blurb_setup, ochannel_blurb_exec, NULL, "/Method/BseSource/General/Ochannel Blurb", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
