
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsetrack.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsetrack.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 26 "bsetrack.proc"
CRIGHTS = "Copyright (C) 2003 Tim Janik";


/* --- insert-part --- */
static void
insert_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 29 "bsetrack.proc"
 {
#line 31 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_int ("id", "Link ID", NULL,
                         0, 0, SFI_MAXINT, 1, SFI_PARAM_DEFAULT);
}
#line 30 "bsetrack.proc"
  proc->help = "Insert a part into a track and retrieve the corresponding link id.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 40 "bsetrack.proc"
 }
static BseErrorType
#line 40 "bsetrack.proc"
insert_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 43 "bsetrack.proc"
{
#line 44 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BsePart  *part = bse_value_get_object (in_values++);
  guint id;

#line 50 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self) || !BSE_IS_PART (part) ||
      !BSE_ITEM (self)->parent ||
      BSE_ITEM (self)->parent != BSE_ITEM (part)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 56 "bsetrack.proc"
  
  id = bse_track_insert_part (self, tick, part);
  if (id)
    {
#line 60 "bsetrack.proc"
      
      bse_item_push_undo_proc (self, "remove-tick", tick);
    }

#line 64 "bsetrack.proc"
  
  g_value_set_int (out_values++, id);

  return BSE_ERROR_NONE;
}

/* --- remove-tick --- */
static void
remove_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 70 "bsetrack.proc"
 {
#line 72 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
}
#line 71 "bsetrack.proc"
  proc->help = "Remove a part at specified tick from a track.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 77 "bsetrack.proc"
 }
static BseErrorType
#line 77 "bsetrack.proc"
remove_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 80 "bsetrack.proc"
{
#line 81 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 86 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 90 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  if (entry)
    {
      bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
      bse_track_remove_tick (self, tick);
    }

  return BSE_ERROR_NONE;
}

/* --- remove-link --- */
static void
remove_link_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 101 "bsetrack.proc"
 {
#line 103 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("id", "Link ID", NULL,
			 0, 0, SFI_MAXINT, 384, SFI_PARAM_DEFAULT);
}
#line 102 "bsetrack.proc"
  proc->help = "Remove a specific part link by ID from a track.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 108 "bsetrack.proc"
 }
static BseErrorType
#line 108 "bsetrack.proc"
remove_link_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 111 "bsetrack.proc"
{
#line 112 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     id   = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;

#line 117 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  entry = bse_track_find_link (self, id);
  if (!entry)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 124 "bsetrack.proc"
  
  bse_item_push_undo_proc (self, "insert-part", entry->tick, entry->part);
  bse_track_remove_tick (self, entry->tick);
  
  return BSE_ERROR_NONE;
}

/* --- list-parts --- */
static void
list_parts_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 131 "bsetrack.proc"
 {
#line 133 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("part_list", "Part List", NULL,
				BSE_TYPE_TRACK_PART_SEQ, SFI_PARAM_DEFAULT);
}
#line 132 "bsetrack.proc"
  proc->help = "List parts scheduled in a track, sorted by tick.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 138 "bsetrack.proc"
 }
static BseErrorType
#line 138 "bsetrack.proc"
list_parts_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 141 "bsetrack.proc"
{
#line 142 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);

#line 145 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 149 "bsetrack.proc"
  
  bse_value_take_boxed (out_values++, bse_track_list_parts (self));

  return BSE_ERROR_NONE;
}

/* --- get-part --- */
static void
get_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 155 "bsetrack.proc"
 {
#line 157 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
}
#line 156 "bsetrack.proc"
  proc->help = "Get the part starting at a specific tick position.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 164 "bsetrack.proc"
 }
static BseErrorType
#line 164 "bsetrack.proc"
get_part_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 167 "bsetrack.proc"
{
#line 168 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  guint     tick = sfi_value_get_int (in_values++);
  BseTrackEntry *entry;
  
#line 173 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 177 "bsetrack.proc"
  
  entry = bse_track_lookup_tick (self, tick);
  bse_value_set_object (out_values++, entry ? entry->part : NULL);

  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 184 "bsetrack.proc"
 {
#line 186 "bsetrack.proc"
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL, BSE_TYPE_TRACK, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 185 "bsetrack.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 25 "bsetrack.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 189 "bsetrack.proc"
}  }
static BseErrorType
#line 189 "bsetrack.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 192 "bsetrack.proc"
{
#line 193 "bsetrack.proc"
  
  BseTrack *self = bse_value_get_object (in_values++);
  SfiInt    tick = sfi_value_get_int (in_values++);
  BseItem  *parent;
  BseSongTiming timing = { 0, };

#line 199 "bsetrack.proc"
  
  if (!BSE_IS_TRACK (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 203 "bsetrack.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 210 "bsetrack.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_insert_part = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseTrack+insert-part", "/Methods/BseTrack/General/Insert Part", NULL },
  0, insert_part_setup, insert_part_exec, 
};
static BseExportNodeProc __enode_remove_tick = {
  { (BseExportNode*) &__enode_insert_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-tick", "/Methods/BseTrack/General/Remove Tick", NULL },
  0, remove_tick_setup, remove_tick_exec, 
};
static BseExportNodeProc __enode_remove_link = {
  { (BseExportNode*) &__enode_remove_tick, BSE_EXPORT_NODE_PROC,
    "BseTrack+remove-link", "/Methods/BseTrack/General/Remove Link", NULL },
  0, remove_link_setup, remove_link_exec, 
};
static BseExportNodeProc __enode_list_parts = {
  { (BseExportNode*) &__enode_remove_link, BSE_EXPORT_NODE_PROC,
    "BseTrack+list-parts", "/Methods/BseTrack/General/List Parts", NULL },
  0, list_parts_setup, list_parts_exec, 
};
static BseExportNodeProc __enode_get_part = {
  { (BseExportNode*) &__enode_list_parts, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-part", "/Methods/BseTrack/General/Get Part", NULL },
  0, get_part_setup, get_part_exec, 
};
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_get_part, BSE_EXPORT_NODE_PROC,
    "BseTrack+get-timing", "/Methods/BseTrack/General/Get Timing", NULL },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsetrack_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/**
 ** Generated data ends here
 **/
