#include "bsecxxapi.h"


/*-------- begin ../sfi/sfidl generated code --------*/


namespace {
static const SfiConstants bse_midi_signal_type_vals[172] = {
  { "bse-midi-signal-control-0", 25, 45 },
  { "bse-midi-signal-continuous-0", 28, 6 },
  { "bse-midi-signal-control-100", 27, 145 },
  { "bse-midi-signal-control-10", 26, 55 },
  { "bse-midi-signal-continuous-10", 29, 16 },
  { "bse-midi-signal-control-110", 27, 155 },
  { "bse-midi-signal-control-20", 26, 65 },
  { "bse-midi-signal-continuous-20", 29, 26 },
  { "bse-midi-signal-control-120", 27, 165 },
  { "bse-midi-signal-control-30", 26, 75 },
  { "bse-midi-signal-continuous-30", 29, 36 },
  { "bse-midi-signal-control-40", 26, 85 },
  { "bse-midi-signal-control-50", 26, 95 },
  { "bse-midi-signal-control-60", 26, 105 },
  { "bse-midi-signal-control-70", 26, 115 },
  { "bse-midi-signal-control-80", 26, 125 },
  { "bse-midi-signal-control-90", 26, 135 },
  { "bse-midi-signal-control-1", 25, 46 },
  { "bse-midi-signal-continuous-1", 28, 7 },
  { "bse-midi-signal-control-101", 27, 146 },
  { "bse-midi-signal-control-11", 26, 56 },
  { "bse-midi-signal-continuous-11", 29, 17 },
  { "bse-midi-signal-control-111", 27, 156 },
  { "bse-midi-signal-control-21", 26, 66 },
  { "bse-midi-signal-continuous-21", 29, 27 },
  { "bse-midi-signal-control-121", 27, 166 },
  { "bse-midi-signal-control-31", 26, 76 },
  { "bse-midi-signal-continuous-31", 29, 37 },
  { "bse-midi-signal-control-41", 26, 86 },
  { "bse-midi-signal-control-51", 26, 96 },
  { "bse-midi-signal-control-61", 26, 106 },
  { "bse-midi-signal-control-71", 26, 116 },
  { "bse-midi-signal-control-81", 26, 126 },
  { "bse-midi-signal-control-91", 26, 136 },
  { "bse-midi-signal-control-2", 25, 47 },
  { "bse-midi-signal-continuous-2", 28, 8 },
  { "bse-midi-signal-control-102", 27, 147 },
  { "bse-midi-signal-control-12", 26, 57 },
  { "bse-midi-signal-continuous-12", 29, 18 },
  { "bse-midi-signal-control-112", 27, 157 },
  { "bse-midi-signal-control-22", 26, 67 },
  { "bse-midi-signal-continuous-22", 29, 28 },
  { "bse-midi-signal-control-122", 27, 167 },
  { "bse-midi-signal-control-32", 26, 77 },
  { "bse-midi-signal-control-42", 26, 87 },
  { "bse-midi-signal-control-52", 26, 97 },
  { "bse-midi-signal-control-62", 26, 107 },
  { "bse-midi-signal-control-72", 26, 117 },
  { "bse-midi-signal-control-82", 26, 127 },
  { "bse-midi-signal-control-92", 26, 137 },
  { "bse-midi-signal-control-3", 25, 48 },
  { "bse-midi-signal-continuous-3", 28, 9 },
  { "bse-midi-signal-control-103", 27, 148 },
  { "bse-midi-signal-control-13", 26, 58 },
  { "bse-midi-signal-continuous-13", 29, 19 },
  { "bse-midi-signal-control-113", 27, 158 },
  { "bse-midi-signal-control-23", 26, 68 },
  { "bse-midi-signal-continuous-23", 29, 29 },
  { "bse-midi-signal-control-123", 27, 168 },
  { "bse-midi-signal-control-33", 26, 78 },
  { "bse-midi-signal-control-43", 26, 88 },
  { "bse-midi-signal-control-53", 26, 98 },
  { "bse-midi-signal-control-63", 26, 108 },
  { "bse-midi-signal-control-73", 26, 118 },
  { "bse-midi-signal-control-83", 26, 128 },
  { "bse-midi-signal-control-93", 26, 138 },
  { "bse-midi-signal-control-4", 25, 49 },
  { "bse-midi-signal-continuous-4", 28, 10 },
  { "bse-midi-signal-control-104", 27, 149 },
  { "bse-midi-signal-control-14", 26, 59 },
  { "bse-midi-signal-continuous-14", 29, 20 },
  { "bse-midi-signal-control-114", 27, 159 },
  { "bse-midi-signal-control-24", 26, 69 },
  { "bse-midi-signal-continuous-24", 29, 30 },
  { "bse-midi-signal-control-124", 27, 169 },
  { "bse-midi-signal-control-34", 26, 79 },
  { "bse-midi-signal-control-44", 26, 89 },
  { "bse-midi-signal-control-54", 26, 99 },
  { "bse-midi-signal-control-64", 26, 109 },
  { "bse-midi-signal-control-74", 26, 119 },
  { "bse-midi-signal-control-84", 26, 129 },
  { "bse-midi-signal-control-94", 26, 139 },
  { "bse-midi-signal-control-5", 25, 50 },
  { "bse-midi-signal-continuous-5", 28, 11 },
  { "bse-midi-signal-control-105", 27, 150 },
  { "bse-midi-signal-control-15", 26, 60 },
  { "bse-midi-signal-continuous-15", 29, 21 },
  { "bse-midi-signal-control-115", 27, 160 },
  { "bse-midi-signal-control-25", 26, 70 },
  { "bse-midi-signal-continuous-25", 29, 31 },
  { "bse-midi-signal-control-125", 27, 170 },
  { "bse-midi-signal-control-35", 26, 80 },
  { "bse-midi-signal-control-45", 26, 90 },
  { "bse-midi-signal-control-55", 26, 100 },
  { "bse-midi-signal-control-65", 26, 110 },
  { "bse-midi-signal-control-75", 26, 120 },
  { "bse-midi-signal-control-85", 26, 130 },
  { "bse-midi-signal-control-95", 26, 140 },
  { "bse-midi-signal-control-6", 25, 51 },
  { "bse-midi-signal-continuous-6", 28, 12 },
  { "bse-midi-signal-control-106", 27, 151 },
  { "bse-midi-signal-control-16", 26, 61 },
  { "bse-midi-signal-continuous-16", 29, 22 },
  { "bse-midi-signal-control-116", 27, 161 },
  { "bse-midi-signal-control-26", 26, 71 },
  { "bse-midi-signal-continuous-26", 29, 32 },
  { "bse-midi-signal-control-126", 27, 171 },
  { "bse-midi-signal-control-36", 26, 81 },
  { "bse-midi-signal-control-46", 26, 91 },
  { "bse-midi-signal-control-56", 26, 101 },
  { "bse-midi-signal-control-66", 26, 111 },
  { "bse-midi-signal-control-76", 26, 121 },
  { "bse-midi-signal-control-86", 26, 131 },
  { "bse-midi-signal-control-96", 26, 141 },
  { "bse-midi-signal-control-7", 25, 52 },
  { "bse-midi-signal-continuous-7", 28, 13 },
  { "bse-midi-signal-control-107", 27, 152 },
  { "bse-midi-signal-control-17", 26, 62 },
  { "bse-midi-signal-continuous-17", 29, 23 },
  { "bse-midi-signal-control-117", 27, 162 },
  { "bse-midi-signal-control-27", 26, 72 },
  { "bse-midi-signal-continuous-27", 29, 33 },
  { "bse-midi-signal-control-127", 27, 172 },
  { "bse-midi-signal-control-37", 26, 82 },
  { "bse-midi-signal-control-47", 26, 92 },
  { "bse-midi-signal-control-57", 26, 102 },
  { "bse-midi-signal-control-67", 26, 112 },
  { "bse-midi-signal-control-77", 26, 122 },
  { "bse-midi-signal-control-87", 26, 132 },
  { "bse-midi-signal-control-97", 26, 142 },
  { "bse-midi-signal-control-8", 25, 53 },
  { "bse-midi-signal-continuous-8", 28, 14 },
  { "bse-midi-signal-control-108", 27, 153 },
  { "bse-midi-signal-control-18", 26, 63 },
  { "bse-midi-signal-continuous-18", 29, 24 },
  { "bse-midi-signal-control-118", 27, 163 },
  { "bse-midi-signal-control-28", 26, 73 },
  { "bse-midi-signal-continuous-28", 29, 34 },
  { "bse-midi-signal-control-38", 26, 83 },
  { "bse-midi-signal-control-48", 26, 93 },
  { "bse-midi-signal-control-58", 26, 103 },
  { "bse-midi-signal-control-68", 26, 113 },
  { "bse-midi-signal-control-78", 26, 123 },
  { "bse-midi-signal-control-88", 26, 133 },
  { "bse-midi-signal-control-98", 26, 143 },
  { "bse-midi-signal-control-9", 25, 54 },
  { "bse-midi-signal-continuous-9", 28, 15 },
  { "bse-midi-signal-control-109", 27, 154 },
  { "bse-midi-signal-control-19", 26, 64 },
  { "bse-midi-signal-continuous-19", 29, 25 },
  { "bse-midi-signal-control-119", 27, 164 },
  { "bse-midi-signal-control-29", 26, 74 },
  { "bse-midi-signal-continuous-29", 29, 35 },
  { "bse-midi-signal-control-39", 26, 84 },
  { "bse-midi-signal-control-49", 26, 94 },
  { "bse-midi-signal-control-59", 26, 104 },
  { "bse-midi-signal-control-69", 26, 114 },
  { "bse-midi-signal-control-79", 26, 124 },
  { "bse-midi-signal-control-89", 26, 134 },
  { "bse-midi-signal-control-99", 26, 144 },
  { "bse-midi-signal-pitch-bend", 26, 3 },
  { "bse-midi-signal-fine-tune", 25, 5 },
  { "bse-midi-signal-pressure", 24, 2 },
  { "bse-midi-signal-constant-negative-high", 38, 42 },
  { "bse-midi-signal-constant-high", 29, 38 },
  { "bse-midi-signal-program", 23, 1 },
  { "bse-midi-signal-parameter", 25, 43 },
  { "bse-midi-signal-non-parameter", 29, 44 },
  { "bse-midi-signal-constant-negative-center", 40, 41 },
  { "bse-midi-signal-constant-center", 31, 39 },
  { "bse-midi-signal-constant-low", 28, 40 },
  { "bse-midi-signal-velocity", 24, 4 },
};

const gchar*
bse_midi_signal_type_to_choice (Bse::MidiSignalType value)
{
  g_return_val_if_fail (value >= 1 && value <= 172, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, value);
}

Bse::MidiSignalType
bse_midi_signal_type_from_choice (const gchar *choice)
{
  return (Bse::MidiSignalType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_midi_signal_type_vals), bse_midi_signal_type_vals, choice) : 0);
}

static const SfiConstants bse_biquad_filter_type_vals[2] = {
  { "bse-biquad-filter-resonant-highpass", 35, 2 },
  { "bse-biquad-filter-resonant-lowpass", 34, 1 },
};

const gchar*
bse_biquad_filter_type_to_choice (Bse::BiquadFilterType value)
{
  g_return_val_if_fail (value >= 1 && value <= 2, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, value);
}

Bse::BiquadFilterType
bse_biquad_filter_type_from_choice (const gchar *choice)
{
  return (Bse::BiquadFilterType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_biquad_filter_type_vals), bse_biquad_filter_type_vals, choice) : 0);
}

static const SfiConstants bse_biquad_filter_norm_vals[3] = {
  { "bse-biquad-filter-norm-passband", 31, 1 },
  { "bse-biquad-filter-norm-resonance-gain", 37, 2 },
  { "bse-biquad-filter-norm-peak-gain", 32, 3 },
};

const gchar*
bse_biquad_filter_norm_to_choice (Bse::BiquadFilterNorm value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_biquad_filter_norm_vals), bse_biquad_filter_norm_vals, value);
}

Bse::BiquadFilterNorm
bse_biquad_filter_norm_from_choice (const gchar *choice)
{
  return (Bse::BiquadFilterNorm) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_biquad_filter_norm_vals), bse_biquad_filter_norm_vals, choice) : 0);
}

static const SfiConstants bse_registration_type_vals[3] = {
  { "bse-register-done", 17, 3 },
  { "bse-register-plugin", 19, 1 },
  { "bse-register-script", 19, 2 },
};

const gchar*
bse_registration_type_to_choice (Bse::RegistrationType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, value);
}

Bse::RegistrationType
bse_registration_type_from_choice (const gchar *choice)
{
  return (Bse::RegistrationType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_registration_type_vals), bse_registration_type_vals, choice) : 0);
}

static const SfiConstants bse_user_msg_type_vals[4] = {
  { "bse-user-msg-warning", 20, 3 },
  { "bse-user-msg-question", 21, 2 },
  { "bse-user-msg-info", 17, 1 },
  { "bse-user-msg-error", 18, 4 },
};

const gchar*
bse_user_msg_type_to_choice (Bse::UserMsgType value)
{
  g_return_val_if_fail (value >= 1 && value <= 4, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_user_msg_type_vals), bse_user_msg_type_vals, value);
}

Bse::UserMsgType
bse_user_msg_type_from_choice (const gchar *choice)
{
  return (Bse::UserMsgType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_user_msg_type_vals), bse_user_msg_type_vals, choice) : 0);
}

static const SfiConstants bse_error_type_vals[58] = {
  { "bse-error-no-data", 17, 20 },
  { "bse-error-device-async", 22, 29 },
  { "bse-error-file-read-failed", 26, 12 },
  { "bse-error-file-write-failed", 27, 13 },
  { "bse-error-file-seek-failed", 26, 11 },
  { "bse-error-file-open-failed", 26, 10 },
  { "bse-error-source-channels-connected", 35, 39 },
  { "bse-error-unimplemented", 23, 27 },
  { "bse-error-source-type-invalid", 29, 43 },
  { "bse-error-format-invalid", 24, 22 },
  { "bse-error-proc-not-found", 24, 44 },
  { "bse-error-file-not-found", 24, 8 },
  { "bse-error-wave-not-found", 24, 25 },
  { "bse-error-no-space", 18, 16 },
  { "bse-error-device-not-available", 30, 28 },
  { "bse-error-source-no-such-module", 31, 34 },
  { "bse-error-none", 14, 0 },
  { "bse-error-codec-failure", 23, 26 },
  { "bse-error-source-ichannel-in-use", 32, 38 },
  { "bse-error-file-eof", 18, 7 },
  { "bse-error-device-caps-mismatch", 30, 32 },
  { "bse-error-source-parent-mismatch", 32, 40 },
  { "bse-error-source-bad-loopback", 29, 41 },
  { "bse-error-internal", 18, 1 },
  { "bse-error-proc-param-inval", 26, 46 },
  { "bse-error-source-no-such-ichannel", 33, 35 },
  { "bse-error-source-no-such-ochannel", 33, 36 },
  { "bse-error-invalid-duration", 26, 56 },
  { "bse-error-source-no-such-connection", 35, 37 },
  { "bse-error-proc-execution", 24, 47 },
  { "bse-error-spawn", 15, 50 },
  { "bse-error-unknown", 17, 2 },
  { "bse-error-format-unknown", 24, 23 },
  { "bse-error-no-seek-info", 22, 19 },
  { "bse-error-file-io", 17, 3 },
  { "bse-error-invalid-overlap", 25, 57 },
  { "bse-error-temp", 14, 24 },
  { "bse-error-no-header", 19, 18 },
  { "bse-error-not-owner", 19, 54 },
  { "bse-error-file-is-dir", 21, 9 },
  { "bse-error-parse-error", 21, 49 },
  { "bse-error-no-files", 18, 15 },
  { "bse-error-many-files", 20, 14 },
  { "bse-error-file-perms", 20, 4 },
  { "bse-error-device-get-caps", 25, 31 },
  { "bse-error-device-set-caps", 25, 33 },
  { "bse-error-file-exists", 21, 6 },
  { "bse-error-no-target", 19, 53 },
  { "bse-error-invalid-offset", 24, 55 },
  { "bse-error-no-event", 18, 52 },
  { "bse-error-data-corrupt", 22, 21 },
  { "bse-error-proc-abort", 20, 48 },
  { "bse-error-no-memory", 19, 17 },
  { "bse-error-no-entry", 18, 51 },
  { "bse-error-proc-busy", 19, 45 },
  { "bse-error-device-busy", 21, 30 },
  { "bse-error-source-busy", 21, 42 },
  { "bse-error-file-busy", 19, 5 },
};

const gchar*
bse_error_type_to_choice (Bse::ErrorType value)
{
  g_return_val_if_fail (value >= 0 && value <= 57, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, value);
}

Bse::ErrorType
bse_error_type_from_choice (const gchar *choice)
{
  return (Bse::ErrorType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_error_type_vals), bse_error_type_vals, choice) : 0);
}

static const SfiConstants bse_project_state_vals[3] = {
  { "bse-project-active", 18, 2 },
  { "bse-project-inactive", 20, 1 },
  { "bse-project-playing", 19, 3 },
};

const gchar*
bse_project_state_to_choice (Bse::ProjectState value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, value);
}

Bse::ProjectState
bse_project_state_from_choice (const gchar *choice)
{
  return (Bse::ProjectState) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_project_state_vals), bse_project_state_vals, choice) : 0);
}

static const SfiConstants bse_standard_osc_wave_type_vals[9] = {
  { "bse-standard-osc-triangle", 25, 2 },
  { "bse-standard-osc-sine", 21, 1 },
  { "bse-standard-osc-square", 23, 8 },
  { "bse-standard-osc-peak-rise", 26, 5 },
  { "bse-standard-osc-saw-rise", 25, 3 },
  { "bse-standard-osc-pulse", 22, 9 },
  { "bse-standard-osc-peak-fall", 26, 6 },
  { "bse-standard-osc-saw-fall", 25, 4 },
  { "bse-standard-osc-moog-saw", 25, 7 },
};

const gchar*
bse_standard_osc_wave_type_to_choice (Bse::StandardOscWaveType value)
{
  g_return_val_if_fail (value >= 1 && value <= 9, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, value);
}

Bse::StandardOscWaveType
bse_standard_osc_wave_type_from_choice (const gchar *choice)
{
  return (Bse::StandardOscWaveType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (bse_standard_osc_wave_type_vals), bse_standard_osc_wave_type_vals, choice) : 0);
}

}

Bse::IntSeq
Bse::IntSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::IntSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (sfi_value_get_int (element));
  }
  return seq;
}

SfiSeq *
Bse::IntSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_int ((*this)[i]);
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::NoteSeq
Bse::NoteSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::NoteSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (sfi_value_get_int (element));
  }
  return seq;
}

SfiSeq *
Bse::NoteSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_int ((*this)[i]);
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::StringSeq
Bse::StringSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::StringSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (sfi_value_get_cxxstring (element));
  }
  return seq;
}

SfiSeq *
Bse::StringSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_string ((*this)[i].c_str());
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::ProxySeq
Bse::ProxySeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::ProxySeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (sfi_value_get_proxy (element));
  }
  return seq;
}

SfiSeq *
Bse::ProxySeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_proxy ((*this)[i]);
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::PartNoteSeq
Bse::PartNoteSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::PartNoteSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (Bse::PartNote::_from_rec (sfi_value_get_rec (element)));
  }
  return seq;
}

SfiSeq *
Bse::PartNoteSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_new_take_rec (Bse::PartNote::_to_rec ((*this)[i]));
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::PartControlSeq
Bse::PartControlSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::PartControlSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (Bse::PartControl::_from_rec (sfi_value_get_rec (element)));
  }
  return seq;
}

SfiSeq *
Bse::PartControlSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_new_take_rec (Bse::PartControl::_to_rec ((*this)[i]));
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::CategorySeq
Bse::CategorySeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::CategorySeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (Bse::Category::_from_rec (sfi_value_get_rec (element)));
  }
  return seq;
}

SfiSeq *
Bse::CategorySeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_new_take_rec (Bse::Category::_to_rec ((*this)[i]));
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::DotSeq
Bse::DotSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::DotSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (Bse::Dot::_from_rec (sfi_value_get_rec (element)));
  }
  return seq;
}

SfiSeq *
Bse::DotSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_new_take_rec (Bse::Dot::_to_rec ((*this)[i]));
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::TrackPartSeq
Bse::TrackPartSeq::_from_seq (SfiSeq *sfi_seq)
{
  Bse::TrackPartSeq seq;
  guint i, length;

  g_return_val_if_fail (sfi_seq != NULL, seq);

  length = sfi_seq_length (sfi_seq);
  seq.resize (length);
  for (i = 0; i < length; i++)
  {
    GValue *element = sfi_seq_get (sfi_seq, i);
    seq[i] = (Bse::TrackPart::_from_rec (sfi_value_get_rec (element)));
  }
  return seq;
}

SfiSeq *
Bse::TrackPartSeq::_to_seq ()
{
  SfiSeq *sfi_seq = sfi_seq_new ();
  for (guint i = 0; i < size(); i++)
  {
    GValue *element = sfi_value_new_take_rec (Bse::TrackPart::_to_rec ((*this)[i]));
    sfi_seq_append (sfi_seq, element);
    sfi_value_free (element);
  }
  return sfi_seq;
}

Bse::PartNotePtr
Bse::PartNote::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::PartNotePtr rec = new Bse::PartNote();
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "velocity");
  if (element)
    rec->velocity = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
Bse::PartNote::_to_rec (Bse::PartNotePtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->id);
  sfi_rec_set (sfi_rec, "id", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->duration);
  sfi_rec_set (sfi_rec, "duration", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->note);
  sfi_rec_set (sfi_rec, "note", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->fine_tune);
  sfi_rec_set (sfi_rec, "fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->velocity);
  sfi_rec_set (sfi_rec, "velocity", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->selected);
  sfi_rec_set (sfi_rec, "selected", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::PartControlPtr
Bse::PartControl::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::PartControlPtr rec = new Bse::PartControl();
  element = sfi_rec_get (sfi_rec, "id");
  if (element)
    rec->id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "control_type");
  if (element)
    rec->control_type = bse_midi_signal_type_from_choice (sfi_value_get_choice (element));
  element = sfi_rec_get (sfi_rec, "value");
  if (element)
    rec->value = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "selected");
  if (element)
    rec->selected = sfi_value_get_bool (element);
  return rec;
}

SfiRec *
Bse::PartControl::_to_rec (Bse::PartControlPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->id);
  sfi_rec_set (sfi_rec, "id", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_choice (bse_midi_signal_type_to_choice (rec->control_type));
  sfi_rec_set (sfi_rec, "control_type", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->value);
  sfi_rec_set (sfi_rec, "value", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->selected);
  sfi_rec_set (sfi_rec, "selected", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::NoteDescriptionPtr
Bse::NoteDescription::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::NoteDescriptionPtr rec = new Bse::NoteDescription();
  element = sfi_rec_get (sfi_rec, "note");
  if (element)
    rec->note = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "octave");
  if (element)
    rec->octave = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "freq");
  if (element)
    rec->freq = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "fine_tune");
  if (element)
    rec->fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "semitone");
  if (element)
    rec->semitone = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "upshift");
  if (element)
    rec->upshift = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "letter");
  if (element)
    rec->letter = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "name");
  if (element)
    rec->name = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "max_fine_tune");
  if (element)
    rec->max_fine_tune = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "kammer_note");
  if (element)
    rec->kammer_note = sfi_value_get_int (element);
  return rec;
}

SfiRec *
Bse::NoteDescription::_to_rec (Bse::NoteDescriptionPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->note);
  sfi_rec_set (sfi_rec, "note", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->octave);
  sfi_rec_set (sfi_rec, "octave", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->freq);
  sfi_rec_set (sfi_rec, "freq", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->fine_tune);
  sfi_rec_set (sfi_rec, "fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->semitone);
  sfi_rec_set (sfi_rec, "semitone", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->upshift);
  sfi_rec_set (sfi_rec, "upshift", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->letter);
  sfi_rec_set (sfi_rec, "letter", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->name.c_str());
  sfi_rec_set (sfi_rec, "name", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->max_fine_tune);
  sfi_rec_set (sfi_rec, "max_fine_tune", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->kammer_note);
  sfi_rec_set (sfi_rec, "kammer_note", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::NoteSequencePtr
Bse::NoteSequence::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::NoteSequencePtr rec = new Bse::NoteSequence();
  element = sfi_rec_get (sfi_rec, "offset");
  if (element)
    rec->offset = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "notes");
  if (element)
    rec->notes = Bse::NoteSeq::_from_seq (sfi_value_get_seq (element));
  return rec;
}

SfiRec *
Bse::NoteSequence::_to_rec (Bse::NoteSequencePtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->offset);
  sfi_rec_set (sfi_rec, "offset", element);
  sfi_value_free (element);
  element = sfi_value_new_take_seq (rec->notes._to_seq ());
  sfi_rec_set (sfi_rec, "notes", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::IconPtr
Bse::Icon::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::IconPtr rec = new Bse::Icon();
  element = sfi_rec_get (sfi_rec, "bytes_per_pixel");
  if (element)
    rec->bytes_per_pixel = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "width");
  if (element)
    rec->width = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "height");
  if (element)
    rec->height = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "pixels");
  if (element)
    rec->pixels = sfi_bblock_ref (sfi_value_get_bblock (element));
  return rec;
}

SfiRec *
Bse::Icon::_to_rec (Bse::IconPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->bytes_per_pixel);
  sfi_rec_set (sfi_rec, "bytes_per_pixel", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->width);
  sfi_rec_set (sfi_rec, "width", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->height);
  sfi_rec_set (sfi_rec, "height", element);
  sfi_value_free (element);
  element = sfi_value_bblock (rec->pixels);
  sfi_rec_set (sfi_rec, "pixels", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::CategoryPtr
Bse::Category::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::CategoryPtr rec = new Bse::Category();
  element = sfi_rec_get (sfi_rec, "category_id");
  if (element)
    rec->category_id = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "category");
  if (element)
    rec->category = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "mindex");
  if (element)
    rec->mindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "lindex");
  if (element)
    rec->lindex = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "type");
  if (element)
    rec->type = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "icon");
  if (element)
    rec->icon = Bse::Icon::_from_rec (sfi_value_get_rec (element));
  return rec;
}

SfiRec *
Bse::Category::_to_rec (Bse::CategoryPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->category_id);
  sfi_rec_set (sfi_rec, "category_id", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->category.c_str());
  sfi_rec_set (sfi_rec, "category", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->mindex);
  sfi_rec_set (sfi_rec, "mindex", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->lindex);
  sfi_rec_set (sfi_rec, "lindex", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->type.c_str());
  sfi_rec_set (sfi_rec, "type", element);
  sfi_value_free (element);
  element = sfi_value_new_take_rec (Bse::Icon::_to_rec (rec->icon));
  sfi_rec_set (sfi_rec, "icon", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::DotPtr
Bse::Dot::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::DotPtr rec = new Bse::Dot();
  element = sfi_rec_get (sfi_rec, "x");
  if (element)
    rec->x = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "y");
  if (element)
    rec->y = sfi_value_get_real (element);
  return rec;
}

SfiRec *
Bse::Dot::_to_rec (Bse::DotPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_real (rec->x);
  sfi_rec_set (sfi_rec, "x", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->y);
  sfi_rec_set (sfi_rec, "y", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::TrackPartPtr
Bse::TrackPart::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::TrackPartPtr rec = new Bse::TrackPart();
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "part");
  if (element)
    rec->part = sfi_value_get_proxy (element);
  element = sfi_rec_get (sfi_rec, "duration");
  if (element)
    rec->duration = sfi_value_get_int (element);
  return rec;
}

SfiRec *
Bse::TrackPart::_to_rec (Bse::TrackPartPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_proxy (rec->part);
  sfi_rec_set (sfi_rec, "part", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->duration);
  sfi_rec_set (sfi_rec, "duration", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::SongTimingPtr
Bse::SongTiming::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::SongTimingPtr rec = new Bse::SongTiming();
  element = sfi_rec_get (sfi_rec, "tick");
  if (element)
    rec->tick = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "bpm");
  if (element)
    rec->bpm = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "numerator");
  if (element)
    rec->numerator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "denominator");
  if (element)
    rec->denominator = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpqn");
  if (element)
    rec->tpqn = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "tpt");
  if (element)
    rec->tpt = sfi_value_get_int (element);
  return rec;
}

SfiRec *
Bse::SongTiming::_to_rec (Bse::SongTimingPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_int (rec->tick);
  sfi_rec_set (sfi_rec, "tick", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->bpm);
  sfi_rec_set (sfi_rec, "bpm", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->numerator);
  sfi_rec_set (sfi_rec, "numerator", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->denominator);
  sfi_rec_set (sfi_rec, "denominator", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tpqn);
  sfi_rec_set (sfi_rec, "tpqn", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->tpt);
  sfi_rec_set (sfi_rec, "tpt", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::SampleFileInfoPtr
Bse::SampleFileInfo::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::SampleFileInfoPtr rec = new Bse::SampleFileInfo();
  element = sfi_rec_get (sfi_rec, "file");
  if (element)
    rec->file = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "size");
  if (element)
    rec->size = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "mtime");
  if (element)
    rec->mtime = sfi_value_get_num (element);
  element = sfi_rec_get (sfi_rec, "loader");
  if (element)
    rec->loader = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "waves");
  if (element)
    rec->waves = Bse::StringSeq::_from_seq (sfi_value_get_seq (element));
  element = sfi_rec_get (sfi_rec, "error");
  if (element)
    rec->error = sfi_value_get_int (element);
  return rec;
}

SfiRec *
Bse::SampleFileInfo::_to_rec (Bse::SampleFileInfoPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_string (rec->file.c_str());
  sfi_rec_set (sfi_rec, "file", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->size);
  sfi_rec_set (sfi_rec, "size", element);
  sfi_value_free (element);
  element = sfi_value_num (rec->mtime);
  sfi_rec_set (sfi_rec, "mtime", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->loader.c_str());
  sfi_rec_set (sfi_rec, "loader", element);
  sfi_value_free (element);
  element = sfi_value_new_take_seq (rec->waves._to_seq ());
  sfi_rec_set (sfi_rec, "waves", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->error);
  sfi_rec_set (sfi_rec, "error", element);
  sfi_value_free (element);
  return sfi_rec;
}

Bse::GConfigPtr
Bse::GConfig::_from_rec (SfiRec *sfi_rec)
{
  GValue *element;

  if (!sfi_rec)
    return NULL;

  Bse::GConfigPtr rec = new Bse::GConfig();
  element = sfi_rec_get (sfi_rec, "sample_path");
  if (element)
    rec->sample_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "effect_path");
  if (element)
    rec->effect_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "instrument_path");
  if (element)
    rec->instrument_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "script_path");
  if (element)
    rec->script_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "plugin_path");
  if (element)
    rec->plugin_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "ladspa_path");
  if (element)
    rec->ladspa_path = sfi_value_get_cxxstring (element);
  element = sfi_rec_get (sfi_rec, "synth_block_size");
  if (element)
    rec->synth_block_size = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "synth_mixing_freq");
  if (element)
    rec->synth_mixing_freq = sfi_value_get_int (element);
  element = sfi_rec_get (sfi_rec, "invert_sustain");
  if (element)
    rec->invert_sustain = sfi_value_get_bool (element);
  element = sfi_rec_get (sfi_rec, "step_volume_dB");
  if (element)
    rec->step_volume_dB = sfi_value_get_real (element);
  element = sfi_rec_get (sfi_rec, "step_bpm");
  if (element)
    rec->step_bpm = sfi_value_get_int (element);
  return rec;
}

SfiRec *
Bse::GConfig::_to_rec (Bse::GConfigPtr rec)
{
  SfiRec *sfi_rec;
  GValue *element;

  g_return_val_if_fail (rec, NULL);

  sfi_rec = sfi_rec_new ();
  element = sfi_value_string (rec->sample_path.c_str());
  sfi_rec_set (sfi_rec, "sample_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->effect_path.c_str());
  sfi_rec_set (sfi_rec, "effect_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->instrument_path.c_str());
  sfi_rec_set (sfi_rec, "instrument_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->script_path.c_str());
  sfi_rec_set (sfi_rec, "script_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->plugin_path.c_str());
  sfi_rec_set (sfi_rec, "plugin_path", element);
  sfi_value_free (element);
  element = sfi_value_string (rec->ladspa_path.c_str());
  sfi_rec_set (sfi_rec, "ladspa_path", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->synth_block_size);
  sfi_rec_set (sfi_rec, "synth_block_size", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->synth_mixing_freq);
  sfi_rec_set (sfi_rec, "synth_mixing_freq", element);
  sfi_value_free (element);
  element = sfi_value_bool (rec->invert_sustain);
  sfi_rec_set (sfi_rec, "invert_sustain", element);
  sfi_value_free (element);
  element = sfi_value_real (rec->step_volume_dB);
  sfi_rec_set (sfi_rec, "step_volume_dB", element);
  sfi_value_free (element);
  element = sfi_value_int (rec->step_bpm);
  sfi_rec_set (sfi_rec, "step_bpm", element);
  sfi_value_free (element);
  return sfi_rec;
}

void
Bse::Item::add_parasite (const std::string& path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+add-parasite", 'p', _object_id, 's', path.c_str(), 'R', parasite, 0);
}

SfiBool
Bse::Item::check_is_a (const std::string& type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+check-is-a", 'p', _object_id, 's', type_name.c_str(), 0);
  return _retval;
}

void
Bse::Item::clear_undo (void) {
  sfi_glue_vcall_void ("BseItem+clear-undo", 'p', _object_id, 0);
}

Bse::Item
Bse::Item::common_ancestor (Bse::Item item2) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+common-ancestor", 'p', _object_id, 'p', item2._proxy(), 0);
  return _retval;
}

SfiFBlock*
Bse::Item::fixme_get_parasite (const std::string& name) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseItem+fixme-get-parasite", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

void
Bse::Item::fixme_set_parasite (const std::string& name, SfiFBlock* parasite) {
  sfi_glue_vcall_void ("BseItem+fixme-set-parasite", 'p', _object_id, 's', name.c_str(), 'F', parasite, 0);
}

Bse::IconPtr
Bse::Item::get_icon (void) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-icon", 'p', _object_id, 0);
  return Bse::Icon::_from_rec (_retval);
}

std::string
Bse::Item::get_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_name_or_type (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-name-or-type", 'p', _object_id, 0);
  return _retval;
}

SfiRec*
Bse::Item::get_parasite (const std::string& path) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseItem+get-parasite", 'p', _object_id, 's', path.c_str(), 0);
  return _retval;
}

Bse::Item
Bse::Item::get_parent (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-parent", 'p', _object_id, 0);
  return _retval;
}

Bse::Item
Bse::Item::get_project (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+get-project", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Item::get_seqid (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+get-seqid", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_type (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_type_authors (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-authors", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_type_blurb (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-blurb", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_type_license (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-license", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_type_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-type-name", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Item::get_uname_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseItem+get-uname-path", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::group_undo (const std::string& name) {
  sfi_glue_vcall_void ("BseItem+group-undo", 'p', _object_id, 's', name.c_str(), 0);
}

SfiBool
Bse::Item::internal (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseItem+internal", 'p', _object_id, 0);
  return _retval;
}

Bse::StringSeq
Bse::Item::list_parasites (const std::string& path) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseItem+list-parasites", 'p', _object_id, 's', path.c_str(), 0);
  return Bse::StringSeq::_from_seq (_retval);
}

Bse::ProxySeq
Bse::Item::list_proxies (const std::string& property_name) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseItem+list-proxies", 'p', _object_id, 's', property_name.c_str(), 0);
  return Bse::ProxySeq::_from_seq (_retval);
}

void
Bse::Item::redo (void) {
  sfi_glue_vcall_void ("BseItem+redo", 'p', _object_id, 0);
}

SfiInt
Bse::Item::redo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+redo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::set_name (const std::string& name) {
  sfi_glue_vcall_void ("BseItem+set-name", 'p', _object_id, 's', name.c_str(), 0);
}

void
Bse::Item::set_parasite (const std::string& path, SfiRec* parasite) {
  sfi_glue_vcall_void ("BseItem+set-parasite", 'p', _object_id, 's', path.c_str(), 'R', parasite, 0);
}

void
Bse::Item::undo (void) {
  sfi_glue_vcall_void ("BseItem+undo", 'p', _object_id, 0);
}

SfiInt
Bse::Item::undo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseItem+undo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Item::ungroup_undo (void) {
  sfi_glue_vcall_void ("BseItem+ungroup-undo", 'p', _object_id, 0);
}

void
Bse::Item::unuse (void) {
  sfi_glue_vcall_void ("BseItem+unuse", 'p', _object_id, 0);
}

Bse::Item
Bse::Item::use (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseItem+use", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Item::seqid ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "seqid");
  return sfi_value_get_int (val);
}

void
Bse::Item::set_seqid (SfiInt new_seqid)
{
  GValue *val = sfi_value_int (new_seqid);
  sfi_glue_proxy_set_property (_proxy(), "seqid", val);
  sfi_value_free (val);
}

void
Bse::Source::clear_inputs (void) {
  sfi_glue_vcall_void ("BseSource+clear-inputs", 'p', _object_id, 0);
}

void
Bse::Source::clear_outputs (void) {
  sfi_glue_vcall_void ("BseSource+clear-outputs", 'p', _object_id, 0);
}

SfiBool
Bse::Source::has_outputs (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+has-outputs", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Source::ichannel_blurb (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-blurb", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiInt
Bse::Source::ichannel_get_n_joints (SfiInt input_channel) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-n-joints", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiInt
Bse::Source::ichannel_get_ochannel (SfiInt input_channel, SfiInt input_joint) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+ichannel-get-ochannel", 'p', _object_id, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

Bse::Source
Bse::Source::ichannel_get_osource (SfiInt input_channel, SfiInt input_joint) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSource+ichannel-get-osource", 'p', _object_id, 'i', input_channel, 'i', input_joint, 0);
  return _retval;
}

std::string
Bse::Source::ichannel_ident (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-ident", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

std::string
Bse::Source::ichannel_name (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ichannel-name", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiBool
Bse::Source::is_joint_ichannel (const std::string& input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel", 'p', _object_id, 's', input_channel.c_str(), 0);
  return _retval;
}

SfiBool
Bse::Source::is_joint_ichannel_by_id (SfiInt input_channel) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSource+is-joint-ichannel-by-id", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

SfiInt
Bse::Source::n_ichannels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ichannels", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Source::n_ochannels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseSource+n-ochannels", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Source::ochannel_blurb (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-blurb", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

std::string
Bse::Source::ochannel_ident (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-ident", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

std::string
Bse::Source::ochannel_name (SfiInt input_channel) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseSource+ochannel-name", 'p', _object_id, 'i', input_channel, 0);
  return _retval;
}

Bse::ErrorType
Bse::Source::set_input (const std::string& input_channel, Bse::Source omodule, const std::string& output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input", 'p', _object_id, 's', input_channel.c_str(), 'p', omodule._proxy(), 's', output_channel.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Source::set_input_by_id (SfiInt input_channel, Bse::Source omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+set-input-by-id", 'p', _object_id, 'i', input_channel, 'p', omodule._proxy(), 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Source::set_pos (SfiReal x_pos, SfiReal y_pos) {
  sfi_glue_vcall_void ("BseSource+set-pos", 'p', _object_id, 'r', x_pos, 'r', y_pos, 0);
}

Bse::ErrorType
Bse::Source::unset_input (const std::string& input_channel, Bse::Source omodule, const std::string& output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input", 'p', _object_id, 's', input_channel.c_str(), 'p', omodule._proxy(), 's', output_channel.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Source::unset_input_by_id (SfiInt input_channel, Bse::Source omodule, SfiInt output_channel) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSource+unset-input-by-id", 'p', _object_id, 'i', input_channel, 'p', omodule._proxy(), 'i', output_channel, 0);
  return bse_error_type_from_choice (_retval);
}

SfiReal
Bse::Source::pos_x ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pos-x");
  return sfi_value_get_real (val);
}

void
Bse::Source::set_pos_x (SfiReal new_pos_x)
{
  GValue *val = sfi_value_real (new_pos_x);
  sfi_glue_proxy_set_property (_proxy(), "pos-x", val);
  sfi_value_free (val);
}

SfiReal
Bse::Source::pos_y ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pos-y");
  return sfi_value_get_real (val);
}

void
Bse::Source::set_pos_y (SfiReal new_pos_y)
{
  GValue *val = sfi_value_real (new_pos_y);
  sfi_glue_proxy_set_property (_proxy(), "pos-y", val);
  sfi_value_free (val);
}

SfiInt
Bse::Snooper::context_id ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "context-id");
  return sfi_value_get_int (val);
}

void
Bse::Snooper::set_context_id (SfiInt new_context_id)
{
  GValue *val = sfi_value_int (new_context_id);
  sfi_glue_proxy_set_property (_proxy(), "context-id", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-1");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_1 (SfiReal new_value_1)
{
  GValue *val = sfi_value_real (new_value_1);
  sfi_glue_proxy_set_property (_proxy(), "value-1", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-1");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_1 (SfiReal new_frequency_1)
{
  GValue *val = sfi_value_real (new_frequency_1);
  sfi_glue_proxy_set_property (_proxy(), "frequency-1", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-1");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_1 (SfiInt new_note_1)
{
  GValue *val = sfi_value_int (new_note_1);
  sfi_glue_proxy_set_property (_proxy(), "note-1", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-2");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_2 (SfiReal new_value_2)
{
  GValue *val = sfi_value_real (new_value_2);
  sfi_glue_proxy_set_property (_proxy(), "value-2", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-2");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_2 (SfiReal new_frequency_2)
{
  GValue *val = sfi_value_real (new_frequency_2);
  sfi_glue_proxy_set_property (_proxy(), "frequency-2", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-2");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_2 (SfiInt new_note_2)
{
  GValue *val = sfi_value_int (new_note_2);
  sfi_glue_proxy_set_property (_proxy(), "note-2", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-3");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_3 (SfiReal new_value_3)
{
  GValue *val = sfi_value_real (new_value_3);
  sfi_glue_proxy_set_property (_proxy(), "value-3", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-3");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_3 (SfiReal new_frequency_3)
{
  GValue *val = sfi_value_real (new_frequency_3);
  sfi_glue_proxy_set_property (_proxy(), "frequency-3", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-3");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_3 (SfiInt new_note_3)
{
  GValue *val = sfi_value_int (new_note_3);
  sfi_glue_proxy_set_property (_proxy(), "note-3", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-4");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_4 (SfiReal new_value_4)
{
  GValue *val = sfi_value_real (new_value_4);
  sfi_glue_proxy_set_property (_proxy(), "value-4", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-4");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_4 (SfiReal new_frequency_4)
{
  GValue *val = sfi_value_real (new_frequency_4);
  sfi_glue_proxy_set_property (_proxy(), "frequency-4", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-4");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_4 (SfiInt new_note_4)
{
  GValue *val = sfi_value_int (new_note_4);
  sfi_glue_proxy_set_property (_proxy(), "note-4", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-5");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_5 (SfiReal new_value_5)
{
  GValue *val = sfi_value_real (new_value_5);
  sfi_glue_proxy_set_property (_proxy(), "value-5", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-5");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_5 (SfiReal new_frequency_5)
{
  GValue *val = sfi_value_real (new_frequency_5);
  sfi_glue_proxy_set_property (_proxy(), "frequency-5", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-5");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_5 (SfiInt new_note_5)
{
  GValue *val = sfi_value_int (new_note_5);
  sfi_glue_proxy_set_property (_proxy(), "note-5", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-6");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_6 (SfiReal new_value_6)
{
  GValue *val = sfi_value_real (new_value_6);
  sfi_glue_proxy_set_property (_proxy(), "value-6", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-6");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_6 (SfiReal new_frequency_6)
{
  GValue *val = sfi_value_real (new_frequency_6);
  sfi_glue_proxy_set_property (_proxy(), "frequency-6", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-6");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_6 (SfiInt new_note_6)
{
  GValue *val = sfi_value_int (new_note_6);
  sfi_glue_proxy_set_property (_proxy(), "note-6", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-7");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_7 (SfiReal new_value_7)
{
  GValue *val = sfi_value_real (new_value_7);
  sfi_glue_proxy_set_property (_proxy(), "value-7", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-7");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_7 (SfiReal new_frequency_7)
{
  GValue *val = sfi_value_real (new_frequency_7);
  sfi_glue_proxy_set_property (_proxy(), "frequency-7", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-7");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_7 (SfiInt new_note_7)
{
  GValue *val = sfi_value_int (new_note_7);
  sfi_glue_proxy_set_property (_proxy(), "note-7", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::value_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "value-8");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_value_8 (SfiReal new_value_8)
{
  GValue *val = sfi_value_real (new_value_8);
  sfi_glue_proxy_set_property (_proxy(), "value-8", val);
  sfi_value_free (val);
}

SfiReal
Bse::Constant::frequency_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "frequency-8");
  return sfi_value_get_real (val);
}

void
Bse::Constant::set_frequency_8 (SfiReal new_frequency_8)
{
  GValue *val = sfi_value_real (new_frequency_8);
  sfi_glue_proxy_set_property (_proxy(), "frequency-8", val);
  sfi_value_free (val);
}

SfiInt
Bse::Constant::note_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note-8");
  return sfi_value_get_int (val);
}

void
Bse::Constant::set_note_8 (SfiInt new_note_8)
{
  GValue *val = sfi_value_int (new_note_8);
  sfi_glue_proxy_set_property (_proxy(), "note-8", val);
  sfi_value_free (val);
}

Bse::Item
Bse::Container::get_item (const std::string& item_type, SfiInt seq_id) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+get-item", 'p', _object_id, 's', item_type.c_str(), 'i', seq_id, 0);
  return _retval;
}

Bse::ProxySeq
Bse::Container::list_items (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseContainer+list-items", 'p', _object_id, 0);
  return Bse::ProxySeq::_from_seq (_retval);
}

Bse::Item
Bse::Container::lookup_item (const std::string& uname) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseContainer+lookup-item", 'p', _object_id, 's', uname.c_str(), 0);
  return _retval;
}

std::string
Bse::Super::author ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "author");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Super::set_author (const std::string& new_author)
{
  GValue *val = sfi_value_string (new_author.c_str());
  sfi_glue_proxy_set_property (_proxy(), "author", val);
  sfi_value_free (val);
}

std::string
Bse::Super::license ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "license");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Super::set_license (const std::string& new_license)
{
  GValue *val = sfi_value_string (new_license.c_str());
  sfi_glue_proxy_set_property (_proxy(), "license", val);
  sfi_value_free (val);
}

std::string
Bse::Super::copyright ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "copyright");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Super::set_copyright (const std::string& new_copyright)
{
  GValue *val = sfi_value_string (new_copyright.c_str());
  sfi_glue_proxy_set_property (_proxy(), "copyright", val);
  sfi_value_free (val);
}

SfiNum
Bse::Super::creation_time ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "creation-time");
  return sfi_value_get_num (val);
}

void
Bse::Super::set_creation_time (SfiNum new_creation_time)
{
  GValue *val = sfi_value_num (new_creation_time);
  sfi_glue_proxy_set_property (_proxy(), "creation-time", val);
  sfi_value_free (val);
}

SfiNum
Bse::Super::modification_time ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "modification-time");
  return sfi_value_get_num (val);
}

void
Bse::Super::set_modification_time (SfiNum new_modification_time)
{
  GValue *val = sfi_value_num (new_modification_time);
  sfi_glue_proxy_set_property (_proxy(), "modification-time", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::WaveRepo::load_file (const std::string& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWaveRepo+load-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::WaveRepo::remove_wave (Bse::Wave wave) {
  sfi_glue_vcall_void ("BseWaveRepo+remove-wave", 'p', _object_id, 'p', wave._proxy(), 0);
}

Bse::ErrorType
Bse::SNet::can_create_source (const std::string& module_type) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+can-create-source", 'p', _object_id, 's', module_type.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::Source
Bse::SNet::create_source (const std::string& module_type) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSNet+create-source", 'p', _object_id, 's', module_type.c_str(), 0);
  return _retval;
}

Bse::ErrorType
Bse::SNet::remove_source (Bse::Source module) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseSNet+remove-source", 'p', _object_id, 'p', module._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

SfiBool
Bse::SNet::supports_user_synths (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseSNet+supports-user-synths", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::SNet::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::SNet::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiSynth::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiSynth::n_voices ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "n-voices");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_n_voices (SfiInt new_n_voices)
{
  GValue *val = sfi_value_int (new_n_voices);
  sfi_glue_proxy_set_property (_proxy(), "n-voices", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::MidiSynth::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::MidiSynth::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::MidiSynth::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::MidiSynth::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

SfiReal
Bse::MidiSynth::volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-f");
  return sfi_value_get_real (val);
}

void
Bse::MidiSynth::set_volume_f (SfiReal new_volume_f)
{
  GValue *val = sfi_value_real (new_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::MidiSynth::volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::MidiSynth::set_volume_d_b (SfiReal new_volume_d_b)
{
  GValue *val = sfi_value_real (new_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiSynth::volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::MidiSynth::set_volume_perc (SfiInt new_volume_perc)
{
  GValue *val = sfi_value_int (new_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "volume-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::MidiSynth::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::MidiSynth::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

Bse::Part
Bse::Song::create_part (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-part", 'p', _object_id, 0);
  return _retval;
}

Bse::Track
Bse::Song::create_track (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+create-track", 'p', _object_id, 0);
  return _retval;
}

Bse::Track
Bse::Song::find_track_for_part (Bse::Part part) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseSong+find-track-for-part", 'p', _object_id, 'p', part._proxy(), 0);
  return _retval;
}

Bse::SongTimingPtr
Bse::Song::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseSong+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::_from_rec (_retval);
}

void
Bse::Song::remove_part (Bse::Part part) {
  sfi_glue_vcall_void ("BseSong+remove-part", 'p', _object_id, 'p', part._proxy(), 0);
}

void
Bse::Song::remove_track (Bse::Track track) {
  sfi_glue_vcall_void ("BseSong+remove-track", 'p', _object_id, 'p', track._proxy(), 0);
}

void
Bse::Song::synthesize_note (Bse::Track track, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  sfi_glue_vcall_void ("BseSong+synthesize-note", 'p', _object_id, 'p', track._proxy(), 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
}

SfiReal
Bse::Song::volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-f");
  return sfi_value_get_real (val);
}

void
Bse::Song::set_volume_f (SfiReal new_volume_f)
{
  GValue *val = sfi_value_real (new_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::Song::volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::Song::set_volume_d_b (SfiReal new_volume_d_b)
{
  GValue *val = sfi_value_real (new_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_volume_perc (SfiInt new_volume_perc)
{
  GValue *val = sfi_value_int (new_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "volume-perc", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::tpqn ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "tpqn");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_tpqn (SfiInt new_tpqn)
{
  GValue *val = sfi_value_int (new_tpqn);
  sfi_glue_proxy_set_property (_proxy(), "tpqn", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::numerator ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "numerator");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_numerator (SfiInt new_numerator)
{
  GValue *val = sfi_value_int (new_numerator);
  sfi_glue_proxy_set_property (_proxy(), "numerator", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::denominator ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "denominator");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_denominator (SfiInt new_denominator)
{
  GValue *val = sfi_value_int (new_denominator);
  sfi_glue_proxy_set_property (_proxy(), "denominator", val);
  sfi_value_free (val);
}

SfiReal
Bse::Song::bpm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "bpm");
  return sfi_value_get_real (val);
}

void
Bse::Song::set_bpm (SfiReal new_bpm)
{
  GValue *val = sfi_value_real (new_bpm);
  sfi_glue_proxy_set_property (_proxy(), "bpm", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Song::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::Song::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

SfiBool
Bse::Song::auto_activate ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "auto-activate");
  return sfi_value_get_bool (val);
}

void
Bse::Song::set_auto_activate (SfiBool new_auto_activate)
{
  GValue *val = sfi_value_bool (new_auto_activate);
  sfi_glue_proxy_set_property (_proxy(), "auto-activate", val);
  sfi_value_free (val);
}

SfiBool
Bse::Song::loop_enabled ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-enabled");
  return sfi_value_get_bool (val);
}

void
Bse::Song::set_loop_enabled (SfiBool new_loop_enabled)
{
  GValue *val = sfi_value_bool (new_loop_enabled);
  sfi_glue_proxy_set_property (_proxy(), "loop-enabled", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::loop_left ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-left");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_loop_left (SfiInt new_loop_left)
{
  GValue *val = sfi_value_int (new_loop_left);
  sfi_glue_proxy_set_property (_proxy(), "loop-left", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::loop_right ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "loop-right");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_loop_right (SfiInt new_loop_right)
{
  GValue *val = sfi_value_int (new_loop_right);
  sfi_glue_proxy_set_property (_proxy(), "loop-right", val);
  sfi_value_free (val);
}

SfiInt
Bse::Song::tick_pointer ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "tick-pointer");
  return sfi_value_get_int (val);
}

void
Bse::Song::set_tick_pointer (SfiInt new_tick_pointer)
{
  GValue *val = sfi_value_int (new_tick_pointer);
  sfi_glue_proxy_set_property (_proxy(), "tick-pointer", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::Project::import_midi_file (const std::string& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+import-midi-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::restore_from_file (const std::string& file_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+restore-from-file", 'p', _object_id, 's', file_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::store_bse (Bse::Super super, const std::string& file_name, SfiBool self_contained) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+store-bse", 'p', _object_id, 'p', super._proxy(), 's', file_name.c_str(), 'b', self_contained, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Project::activate (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+activate", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Project::auto_deactivate (SfiInt msec_delay) {
  sfi_glue_vcall_void ("BseProject+auto-deactivate", 'p', _object_id, 'i', msec_delay, 0);
}

SfiBool
Bse::Project::can_play (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+can-play", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Project::clear_undo (void) {
  sfi_glue_vcall_void ("BseProject+clear-undo", 'p', _object_id, 0);
}

Bse::CSynth
Bse::Project::create_csynth (const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-csynth", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::MidiSynth
Bse::Project::create_midi_synth (const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-midi-synth", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::Song
Bse::Project::create_song (const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+create-song", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

void
Bse::Project::deactivate (void) {
  sfi_glue_vcall_void ("BseProject+deactivate", 'p', _object_id, 0);
}

Bse::Item
Bse::Project::find_item (const std::string& uname_path) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+find-item", 'p', _object_id, 's', uname_path.c_str(), 0);
  return _retval;
}

Bse::DataPocket
Bse::Project::get_data_pocket (const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-data-pocket", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::ProjectState
Bse::Project::get_state (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+get-state", 'p', _object_id, 0);
  return bse_project_state_from_choice (_retval);
}

Bse::ProxySeq
Bse::Project::get_supers (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+get-supers", 'p', _object_id, 0);
  return Bse::ProxySeq::_from_seq (_retval);
}

Bse::WaveRepo
Bse::Project::get_wave_repo (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseProject+get-wave-repo", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::is_active (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-active", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::is_playing (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseProject+is-playing", 'p', _object_id, 0);
  return _retval;
}

Bse::StringSeq
Bse::Project::list_uname_paths (const std::string& item_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+list-uname-paths", 'p', _object_id, 's', item_type.c_str(), 0);
  return Bse::StringSeq::_from_seq (_retval);
}

Bse::ProxySeq
Bse::Project::match_items_by_uname (const std::string& item_type, const std::string& uname) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseProject+match-items-by-uname", 'p', _object_id, 's', item_type.c_str(), 's', uname.c_str(), 0);
  return Bse::ProxySeq::_from_seq (_retval);
}

Bse::ErrorType
Bse::Project::play (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseProject+play", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Project::redo (void) {
  sfi_glue_vcall_void ("BseProject+redo", 'p', _object_id, 0);
}

SfiInt
Bse::Project::redo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+redo-depth", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Project::remove_snet (Bse::SNet snet) {
  sfi_glue_vcall_void ("BseProject+remove-snet", 'p', _object_id, 'p', snet._proxy(), 0);
}

void
Bse::Project::start_playback (void) {
  sfi_glue_vcall_void ("BseProject+start-playback", 'p', _object_id, 0);
}

void
Bse::Project::stop (void) {
  sfi_glue_vcall_void ("BseProject+stop", 'p', _object_id, 0);
}

void
Bse::Project::stop_playback (void) {
  sfi_glue_vcall_void ("BseProject+stop-playback", 'p', _object_id, 0);
}

void
Bse::Project::undo (void) {
  sfi_glue_vcall_void ("BseProject+undo", 'p', _object_id, 0);
}

SfiInt
Bse::Project::undo_depth (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseProject+undo-depth", 'p', _object_id, 0);
  return _retval;
}

SfiBool
Bse::Project::dirty ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "dirty");
  return sfi_value_get_bool (val);
}

void
Bse::Project::set_dirty (SfiBool new_dirty)
{
  GValue *val = sfi_value_bool (new_dirty);
  sfi_glue_proxy_set_property (_proxy(), "dirty", val);
  sfi_value_free (val);
}

SfiBool
Bse::Server::can_load (const std::string& file_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+can-load", 'p', _object_id, 's', file_name.c_str(), 0);
  return _retval;
}

Bse::NoteDescriptionPtr
Bse::Server::construct_note (SfiInt semitone, SfiInt octave, SfiInt fine_tune) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseServer+construct-note", 'p', _object_id, 'i', semitone, 'i', octave, 'i', fine_tune, 0);
  return Bse::NoteDescription::_from_rec (_retval);
}

Bse::NoteDescriptionPtr
Bse::Server::describe_note (SfiInt note, SfiInt fine_tune) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseServer+describe-note", 'p', _object_id, 'i', note, 'i', fine_tune, 0);
  return Bse::NoteDescription::_from_rec (_retval);
}

std::string
Bse::Server::get_custom_effect_dir (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-effect-dir", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_custom_instrument_dir (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-custom-instrument-dir", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_demo_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-demo-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_effect_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-effect-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_instrument_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-instrument-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_ladspa_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-ladspa-path", 'p', _object_id, 0);
  return _retval;
}

Bse::MidiNotifier
Bse::Server::get_midi_notifier (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseServer+get-midi-notifier", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_mp3_version (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-mp3-version", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_plugin_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-plugin-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_sample_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-sample-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_script_path (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-script-path", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Server::get_version (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseServer+get-version", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Server::n_scripts (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseServer+n-scripts", 'p', _object_id, 0);
  return _retval;
}

Bse::NoteDescriptionPtr
Bse::Server::note_from_freq (SfiReal freq) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseServer+note-from-freq", 'p', _object_id, 'r', freq, 0);
  return Bse::NoteDescription::_from_rec (_retval);
}

Bse::NoteDescriptionPtr
Bse::Server::note_from_string (const std::string& name) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseServer+note-from-string", 'p', _object_id, 's', name.c_str(), 0);
  return Bse::NoteDescription::_from_rec (_retval);
}

SfiBool
Bse::Server::preferences_locked (void) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BseServer+preferences-locked", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Server::register_core_plugins (void) {
  sfi_glue_vcall_void ("BseServer+register-core-plugins", 'p', _object_id, 0);
}

void
Bse::Server::register_ladspa_plugins (void) {
  sfi_glue_vcall_void ("BseServer+register-ladspa-plugins", 'p', _object_id, 0);
}

void
Bse::Server::register_scripts (void) {
  sfi_glue_vcall_void ("BseServer+register-scripts", 'p', _object_id, 0);
}

void
Bse::Server::save_preferences (void) {
  sfi_glue_vcall_void ("BseServer+save-preferences", 'p', _object_id, 0);
}

Bse::Project
Bse::Server::use_new_project (const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseServer+use-new-project", 'p', _object_id, 's', name.c_str(), 0);
  return _retval;
}

SfiRec*
Bse::Server::bse_preferences ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "bse-preferences");
  return sfi_rec_ref (sfi_value_get_rec (val));
}

void
Bse::Server::set_bse_preferences (SfiRec* new_bse_preferences)
{
  GValue *val = sfi_value_rec (new_bse_preferences);
  sfi_glue_proxy_set_property (_proxy(), "bse-preferences", val);
  sfi_value_free (val);
}

SfiInt
Bse::Server::latency ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "latency");
  return sfi_value_get_int (val);
}

void
Bse::Server::set_latency (SfiInt new_latency)
{
  GValue *val = sfi_value_int (new_latency);
  sfi_glue_proxy_set_property (_proxy(), "latency", val);
  sfi_value_free (val);
}

std::string
Bse::Server::wave_file ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-file");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Server::set_wave_file (const std::string& new_wave_file)
{
  GValue *val = sfi_value_string (new_wave_file.c_str());
  sfi_glue_proxy_set_property (_proxy(), "wave-file", val);
  sfi_value_free (val);
}

std::string
Bse::SubIPort::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubIPort::set_in_port_1 (const std::string& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::SubIPort::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubIPort::set_in_port_2 (const std::string& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::SubIPort::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubIPort::set_in_port_3 (const std::string& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::SubIPort::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubIPort::set_in_port_4 (const std::string& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentInput::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentInput::set_in_port_1 (const std::string& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentInput::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentInput::set_in_port_2 (const std::string& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentInput::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentInput::set_in_port_3 (const std::string& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentInput::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentInput::set_in_port_4 (const std::string& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

void
Bse::WaveOsc::pcm_seek_perc (SfiReal pos_perc) {
  sfi_glue_vcall_void ("BseWaveOsc+pcm-seek-perc", 'p', _object_id, 'r', pos_perc, 0);
}

void
Bse::WaveOsc::request_pcm_position (void) {
  sfi_glue_vcall_void ("BseWaveOsc+request-pcm-position", 'p', _object_id, 0);
}

void
Bse::WaveOsc::set_from_editable_sample (Bse::EditableSample esample) {
  sfi_glue_vcall_void ("BseWaveOsc+set-from-editable-sample", 'p', _object_id, 'p', esample._proxy(), 0);
}

Bse::Wave
Bse::WaveOsc::wave ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave");
  return sfi_value_get_proxy (val);
}

void
Bse::WaveOsc::set_wave (Bse::Wave new_wave)
{
  GValue *val = sfi_value_proxy (new_wave);
  sfi_glue_proxy_set_property (_proxy(), "wave", val);
  sfi_value_free (val);
}

SfiReal
Bse::WaveOsc::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::WaveOsc::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::WaveOsc::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::WaveOsc::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::WaveOsc::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::WaveOsc::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiController::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiController::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-1");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_1 (Bse::MidiSignalType new_control_1)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_1));
  sfi_glue_proxy_set_property (_proxy(), "control-1", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-2");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_2 (Bse::MidiSignalType new_control_2)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_2));
  sfi_glue_proxy_set_property (_proxy(), "control-2", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-3");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_3 (Bse::MidiSignalType new_control_3)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_3));
  sfi_glue_proxy_set_property (_proxy(), "control-3", val);
  sfi_value_free (val);
}

Bse::MidiSignalType
Bse::MidiController::control_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "control-4");
  return bse_midi_signal_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::MidiController::set_control_4 (Bse::MidiSignalType new_control_4)
{
  GValue *val = sfi_value_choice (bse_midi_signal_type_to_choice (new_control_4));
  sfi_glue_proxy_set_property (_proxy(), "control-4", val);
  sfi_value_free (val);
}

Bse::BiquadFilterType
Bse::BiquadFilter::filter_type ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "filter-type");
  return bse_biquad_filter_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::BiquadFilter::set_filter_type (Bse::BiquadFilterType new_filter_type)
{
  GValue *val = sfi_value_choice (bse_biquad_filter_type_to_choice (new_filter_type));
  sfi_glue_proxy_set_property (_proxy(), "filter-type", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::freq ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "freq");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_freq (SfiReal new_freq)
{
  GValue *val = sfi_value_real (new_freq);
  sfi_glue_proxy_set_property (_proxy(), "freq", val);
  sfi_value_free (val);
}

SfiInt
Bse::BiquadFilter::note ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "note");
  return sfi_value_get_int (val);
}

void
Bse::BiquadFilter::set_note (SfiInt new_note)
{
  GValue *val = sfi_value_int (new_note);
  sfi_glue_proxy_set_property (_proxy(), "note", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::gain ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_gain (SfiReal new_gain)
{
  GValue *val = sfi_value_real (new_gain);
  sfi_glue_proxy_set_property (_proxy(), "gain", val);
  sfi_value_free (val);
}

Bse::BiquadFilterNorm
Bse::BiquadFilter::norm_type ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "norm-type");
  return bse_biquad_filter_norm_from_choice (sfi_value_get_choice (val));
}

void
Bse::BiquadFilter::set_norm_type (Bse::BiquadFilterNorm new_norm_type)
{
  GValue *val = sfi_value_choice (bse_biquad_filter_norm_to_choice (new_norm_type));
  sfi_glue_proxy_set_property (_proxy(), "norm-type", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::BiquadFilter::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::BiquadFilter::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

SfiReal
Bse::BiquadFilter::gain_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-perc");
  return sfi_value_get_real (val);
}

void
Bse::BiquadFilter::set_gain_perc (SfiReal new_gain_perc)
{
  GValue *val = sfi_value_real (new_gain_perc);
  sfi_glue_proxy_set_property (_proxy(), "gain-perc", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::SubSynth::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::SubSynth::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_1 (const std::string& new_in_port_1)
{
  GValue *val = sfi_value_string (new_in_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_1 (const std::string& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_2 (const std::string& new_in_port_2)
{
  GValue *val = sfi_value_string (new_in_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_2 (const std::string& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_3 (const std::string& new_in_port_3)
{
  GValue *val = sfi_value_string (new_in_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_3 (const std::string& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_4 (const std::string& new_in_port_4)
{
  GValue *val = sfi_value_string (new_in_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-4", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_4 (const std::string& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-5");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_5 (const std::string& new_in_port_5)
{
  GValue *val = sfi_value_string (new_in_port_5.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-5", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_5 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-5");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_5 (const std::string& new_out_port_5)
{
  GValue *val = sfi_value_string (new_out_port_5.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-5", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-6");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_6 (const std::string& new_in_port_6)
{
  GValue *val = sfi_value_string (new_in_port_6.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-6", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_6 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-6");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_6 (const std::string& new_out_port_6)
{
  GValue *val = sfi_value_string (new_out_port_6.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-6", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-7");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_7 (const std::string& new_in_port_7)
{
  GValue *val = sfi_value_string (new_in_port_7.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-7", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_7 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-7");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_7 (const std::string& new_out_port_7)
{
  GValue *val = sfi_value_string (new_out_port_7.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-7", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::in_port_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "in-port-8");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_in_port_8 (const std::string& new_in_port_8)
{
  GValue *val = sfi_value_string (new_in_port_8.c_str());
  sfi_glue_proxy_set_property (_proxy(), "in-port-8", val);
  sfi_value_free (val);
}

std::string
Bse::SubSynth::out_port_8 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-8");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubSynth::set_out_port_8 (const std::string& new_out_port_8)
{
  GValue *val = sfi_value_string (new_out_port_8.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-8", val);
  sfi_value_free (val);
}

Bse::StandardOscWaveType
Bse::StandardOsc::wave_form ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-form");
  return bse_standard_osc_wave_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::StandardOsc::set_wave_form (Bse::StandardOscWaveType new_wave_form)
{
  GValue *val = sfi_value_choice (bse_standard_osc_wave_type_to_choice (new_wave_form));
  sfi_glue_proxy_set_property (_proxy(), "wave-form", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::phase ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "phase");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_phase (SfiReal new_phase)
{
  GValue *val = sfi_value_real (new_phase);
  sfi_glue_proxy_set_property (_proxy(), "phase", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::base_freq ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "base-freq");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_base_freq (SfiReal new_base_freq)
{
  GValue *val = sfi_value_real (new_base_freq);
  sfi_glue_proxy_set_property (_proxy(), "base-freq", val);
  sfi_value_free (val);
}

SfiInt
Bse::StandardOsc::base_note ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "base-note");
  return sfi_value_get_int (val);
}

void
Bse::StandardOsc::set_base_note (SfiInt new_base_note)
{
  GValue *val = sfi_value_int (new_base_note);
  sfi_glue_proxy_set_property (_proxy(), "base-note", val);
  sfi_value_free (val);
}

SfiInt
Bse::StandardOsc::fine_tune ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fine-tune");
  return sfi_value_get_int (val);
}

void
Bse::StandardOsc::set_fine_tune (SfiInt new_fine_tune)
{
  GValue *val = sfi_value_int (new_fine_tune);
  sfi_glue_proxy_set_property (_proxy(), "fine-tune", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::fm_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_fm_perc (SfiReal new_fm_perc)
{
  GValue *val = sfi_value_real (new_fm_perc);
  sfi_glue_proxy_set_property (_proxy(), "fm-perc", val);
  sfi_value_free (val);
}

SfiBool
Bse::StandardOsc::exponential_fm ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "exponential-fm");
  return sfi_value_get_bool (val);
}

void
Bse::StandardOsc::set_exponential_fm (SfiBool new_exponential_fm)
{
  GValue *val = sfi_value_bool (new_exponential_fm);
  sfi_glue_proxy_set_property (_proxy(), "exponential-fm", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::fm_n_octaves ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fm-n-octaves");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_fm_n_octaves (SfiReal new_fm_n_octaves)
{
  GValue *val = sfi_value_real (new_fm_n_octaves);
  sfi_glue_proxy_set_property (_proxy(), "fm-n-octaves", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::self_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "self-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_self_perc (SfiReal new_self_perc)
{
  GValue *val = sfi_value_real (new_self_perc);
  sfi_glue_proxy_set_property (_proxy(), "self-perc", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::pulse_width ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pulse-width");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_pulse_width (SfiReal new_pulse_width)
{
  GValue *val = sfi_value_real (new_pulse_width);
  sfi_glue_proxy_set_property (_proxy(), "pulse-width", val);
  sfi_value_free (val);
}

SfiReal
Bse::StandardOsc::pulse_mod_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pulse-mod-perc");
  return sfi_value_get_real (val);
}

void
Bse::StandardOsc::set_pulse_mod_perc (SfiReal new_pulse_mod_perc)
{
  GValue *val = sfi_value_real (new_pulse_mod_perc);
  sfi_glue_proxy_set_property (_proxy(), "pulse-mod-perc", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiInput::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::MidiInput::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmOutput::master_volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-f");
  return sfi_value_get_real (val);
}

void
Bse::PcmOutput::set_master_volume_f (SfiReal new_master_volume_f)
{
  GValue *val = sfi_value_real (new_master_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmOutput::master_volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::PcmOutput::set_master_volume_d_b (SfiReal new_master_volume_d_b)
{
  GValue *val = sfi_value_real (new_master_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::PcmOutput::master_volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "master-volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::PcmOutput::set_master_volume_perc (SfiInt new_master_volume_perc)
{
  GValue *val = sfi_value_int (new_master_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "master-volume-perc", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmInput::gain_volume_f ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-f");
  return sfi_value_get_real (val);
}

void
Bse::PcmInput::set_gain_volume_f (SfiReal new_gain_volume_f)
{
  GValue *val = sfi_value_real (new_gain_volume_f);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-f", val);
  sfi_value_free (val);
}

SfiReal
Bse::PcmInput::gain_volume_d_b ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-d-b");
  return sfi_value_get_real (val);
}

void
Bse::PcmInput::set_gain_volume_d_b (SfiReal new_gain_volume_d_b)
{
  GValue *val = sfi_value_real (new_gain_volume_d_b);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-d-b", val);
  sfi_value_free (val);
}

SfiInt
Bse::PcmInput::gain_volume_perc ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "gain-volume-perc");
  return sfi_value_get_int (val);
}

void
Bse::PcmInput::set_gain_volume_perc (SfiInt new_gain_volume_perc)
{
  GValue *val = sfi_value_int (new_gain_volume_perc);
  sfi_glue_proxy_set_property (_proxy(), "gain-volume-perc", val);
  sfi_value_free (val);
}

std::string
Bse::SubOPort::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubOPort::set_out_port_1 (const std::string& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::SubOPort::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubOPort::set_out_port_2 (const std::string& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::SubOPort::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubOPort::set_out_port_3 (const std::string& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::SubOPort::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::SubOPort::set_out_port_4 (const std::string& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentOutput::out_port_1 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-1");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentOutput::set_out_port_1 (const std::string& new_out_port_1)
{
  GValue *val = sfi_value_string (new_out_port_1.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-1", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentOutput::out_port_2 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-2");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentOutput::set_out_port_2 (const std::string& new_out_port_2)
{
  GValue *val = sfi_value_string (new_out_port_2.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-2", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentOutput::out_port_3 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-3");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentOutput::set_out_port_3 (const std::string& new_out_port_3)
{
  GValue *val = sfi_value_string (new_out_port_3.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-3", val);
  sfi_value_free (val);
}

std::string
Bse::InstrumentOutput::out_port_4 ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "out-port-4");
  return sfi_value_get_cxxstring (val);
}

void
Bse::InstrumentOutput::set_out_port_4 (const std::string& new_out_port_4)
{
  GValue *val = sfi_value_string (new_out_port_4.c_str());
  sfi_glue_proxy_set_property (_proxy(), "out-port-4", val);
  sfi_value_free (val);
}

SfiReal
Bse::Wave::chunk_get_mix_freq (SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-mix-freq", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

SfiReal
Bse::Wave::chunk_get_osc_freq (SfiInt chunk_index) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseWave+chunk-get-osc-freq", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

Bse::ErrorType
Bse::Wave::load_wave (const std::string& file_name, const std::string& wave_name) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseWave+load-wave", 'p', _object_id, 's', file_name.c_str(), 's', wave_name.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

SfiInt
Bse::Wave::n_wave_chunks (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseWave+n-wave-chunks", 'p', _object_id, 0);
  return _retval;
}

Bse::EditableSample
Bse::Wave::use_editable (SfiInt chunk_index) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseWave+use-editable", 'p', _object_id, 'i', chunk_index, 0);
  return _retval;
}

SfiBool
Bse::Wave::locator_set ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "locator-set");
  return sfi_value_get_bool (val);
}

void
Bse::Wave::set_locator_set (SfiBool new_locator_set)
{
  GValue *val = sfi_value_bool (new_locator_set);
  sfi_glue_proxy_set_property (_proxy(), "locator-set", val);
  sfi_value_free (val);
}

std::string
Bse::Wave::file_name ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "file-name");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Wave::set_file_name (const std::string& new_file_name)
{
  GValue *val = sfi_value_string (new_file_name.c_str());
  sfi_glue_proxy_set_property (_proxy(), "file-name", val);
  sfi_value_free (val);
}

std::string
Bse::Wave::wave_name ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave-name");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Wave::set_wave_name (const std::string& new_wave_name)
{
  GValue *val = sfi_value_string (new_wave_name.c_str());
  sfi_glue_proxy_set_property (_proxy(), "wave-name", val);
  sfi_value_free (val);
}

SfiInt
Bse::MidiNotifier::current_time (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseMidiNotifier+current-time", 'p', _object_id, 0);
  return _retval;
}

Bse::Part
Bse::Track::get_part (SfiInt tick) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseTrack+get-part", 'p', _object_id, 'i', tick, 0);
  return _retval;
}

Bse::SongTimingPtr
Bse::Track::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BseTrack+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::_from_rec (_retval);
}

SfiInt
Bse::Track::insert_part (SfiInt tick, Bse::Part part) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseTrack+insert-part", 'p', _object_id, 'i', tick, 'p', part._proxy(), 0);
  return _retval;
}

Bse::TrackPartSeq
Bse::Track::list_parts (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BseTrack+list-parts", 'p', _object_id, 0);
  return Bse::TrackPartSeq::_from_seq (_retval);
}

void
Bse::Track::remove_link (SfiInt id) {
  sfi_glue_vcall_void ("BseTrack+remove-link", 'p', _object_id, 'i', id, 0);
}

void
Bse::Track::remove_tick (SfiInt tick) {
  sfi_glue_vcall_void ("BseTrack+remove-tick", 'p', _object_id, 'i', tick, 0);
}

SfiBool
Bse::Track::muted ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "muted");
  return sfi_value_get_bool (val);
}

void
Bse::Track::set_muted (SfiBool new_muted)
{
  GValue *val = sfi_value_bool (new_muted);
  sfi_glue_proxy_set_property (_proxy(), "muted", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Track::snet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "snet");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_snet (Bse::CSynth new_snet)
{
  GValue *val = sfi_value_proxy (new_snet);
  sfi_glue_proxy_set_property (_proxy(), "snet", val);
  sfi_value_free (val);
}

Bse::Wave
Bse::Track::wave ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "wave");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_wave (Bse::Wave new_wave)
{
  GValue *val = sfi_value_proxy (new_wave);
  sfi_glue_proxy_set_property (_proxy(), "wave", val);
  sfi_value_free (val);
}

SfiInt
Bse::Track::midi_channel ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "midi-channel");
  return sfi_value_get_int (val);
}

void
Bse::Track::set_midi_channel (SfiInt new_midi_channel)
{
  GValue *val = sfi_value_int (new_midi_channel);
  sfi_glue_proxy_set_property (_proxy(), "midi-channel", val);
  sfi_value_free (val);
}

SfiInt
Bse::Track::n_voices ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "n-voices");
  return sfi_value_get_int (val);
}

void
Bse::Track::set_n_voices (SfiInt new_n_voices)
{
  GValue *val = sfi_value_int (new_n_voices);
  sfi_glue_proxy_set_property (_proxy(), "n-voices", val);
  sfi_value_free (val);
}

Bse::CSynth
Bse::Track::pnet ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "pnet");
  return sfi_value_get_proxy (val);
}

void
Bse::Track::set_pnet (Bse::CSynth new_pnet)
{
  GValue *val = sfi_value_proxy (new_pnet);
  sfi_glue_proxy_set_property (_proxy(), "pnet", val);
  sfi_value_free (val);
}

Bse::ErrorType
Bse::Part::change_control (SfiInt id, SfiInt tick, Bse::MidiSignalType control_type, SfiReal value) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-control", 'p', _object_id, 'i', id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::Part::change_note (SfiInt id, SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+change-note", 'p', _object_id, 'i', id, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::PartNoteSeq
Bse::Part::check_overlap (SfiInt tick, SfiInt duration, SfiInt note) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+check-overlap", 'p', _object_id, 'i', tick, 'i', duration, 'i', note, 0);
  return Bse::PartNoteSeq::_from_seq (_retval);
}

Bse::ErrorType
Bse::Part::delete_event (SfiInt id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BsePart+delete-event", 'p', _object_id, 'i', id, 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Part::deselect_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+deselect-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
Bse::Part::deselect_event (SfiInt id) {
  sfi_glue_vcall_void ("BsePart+deselect-event", 'p', _object_id, 'i', id, 0);
}

void
Bse::Part::deselect_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+deselect-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

Bse::PartControlSeq
Bse::Part::get_controls (SfiInt tick, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-controls", 'p', _object_id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::_from_seq (_retval);
}

SfiInt
Bse::Part::get_max_note (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-max-note", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Part::get_max_tick (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-max-tick", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::Part::get_min_note (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+get-min-note", 'p', _object_id, 0);
  return _retval;
}

Bse::PartNoteSeq
Bse::Part::get_notes (SfiInt tick, SfiInt note) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-notes", 'p', _object_id, 'i', tick, 'i', note, 0);
  return Bse::PartNoteSeq::_from_seq (_retval);
}

Bse::PartControlSeq
Bse::Part::get_range_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+get-range-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::_from_seq (_retval);
}

Bse::SongTimingPtr
Bse::Part::get_timing (SfiInt tick) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("BsePart+get-timing", 'p', _object_id, 'i', tick, 0);
  return Bse::SongTiming::_from_rec (_retval);
}

SfiInt
Bse::Part::insert_control (SfiInt tick, Bse::MidiSignalType control_type, SfiReal value) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-control", 'p', _object_id, 'i', tick, 'C', bse_midi_signal_type_to_choice (control_type), 'r', value, 0);
  return _retval;
}

SfiInt
Bse::Part::insert_note (SfiInt tick, SfiInt duration, SfiInt note, SfiInt fine_tune, SfiReal velocity) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BsePart+insert-note", 'p', _object_id, 'i', tick, 'i', duration, 'i', note, 'i', fine_tune, 'r', velocity, 0);
  return _retval;
}

SfiBool
Bse::Part::is_selected_event (SfiInt id) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("BsePart+is-selected-event", 'p', _object_id, 'i', id, 0);
  return _retval;
}

Bse::PartControlSeq
Bse::Part::list_controls (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-controls", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::_from_seq (_retval);
}

Bse::PartNoteSeq
Bse::Part::list_notes_crossing (SfiInt tick, SfiInt duration) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-notes-crossing", 'p', _object_id, 'i', tick, 'i', duration, 0);
  return Bse::PartNoteSeq::_from_seq (_retval);
}

Bse::PartControlSeq
Bse::Part::list_selected_controls (Bse::MidiSignalType control_type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-controls", 'p', _object_id, 'C', bse_midi_signal_type_to_choice (control_type), 0);
  return Bse::PartControlSeq::_from_seq (_retval);
}

Bse::PartNoteSeq
Bse::Part::list_selected_notes (void) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("BsePart+list-selected-notes", 'p', _object_id, 0);
  return Bse::PartNoteSeq::_from_seq (_retval);
}

void
Bse::Part::queue_controls (SfiInt tick, SfiInt duration) {
  sfi_glue_vcall_void ("BsePart+queue-controls", 'p', _object_id, 'i', tick, 'i', duration, 0);
}

void
Bse::Part::queue_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+queue-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
Bse::Part::select_controls_exclusive (SfiInt tick, SfiInt duration, Bse::MidiSignalType control_type) {
  sfi_glue_vcall_void ("BsePart+select-controls-exclusive", 'p', _object_id, 'i', tick, 'i', duration, 'C', bse_midi_signal_type_to_choice (control_type), 0);
}

void
Bse::Part::select_event (SfiInt id) {
  sfi_glue_vcall_void ("BsePart+select-event", 'p', _object_id, 'i', id, 0);
}

void
Bse::Part::select_notes (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

void
Bse::Part::select_notes_exclusive (SfiInt tick, SfiInt duration, SfiInt min_note, SfiInt max_note) {
  sfi_glue_vcall_void ("BsePart+select-notes-exclusive", 'p', _object_id, 'i', tick, 'i', duration, 'i', min_note, 'i', max_note, 0);
}

SfiInt
Bse::Part::last_tick ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "last-tick");
  return sfi_value_get_int (val);
}

void
Bse::Part::set_last_tick (SfiInt new_last_tick)
{
  GValue *val = sfi_value_int (new_last_tick);
  sfi_glue_proxy_set_property (_proxy(), "last-tick", val);
  sfi_value_free (val);
}

SfiInt
Bse::DataPocket::create_entry (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+create-entry", 'p', _object_id, 0);
  return _retval;
}

Bse::ErrorType
Bse::DataPocket::delete_entry (SfiInt entry_id) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+delete-entry", 'p', _object_id, 'i', entry_id, 0);
  return bse_error_type_from_choice (_retval);
}

SfiReal
Bse::DataPocket::get_float (SfiInt entry_id, const std::string& name) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseDataPocket+get-float", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_int (SfiInt entry_id, const std::string& name) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-int", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_n_entries (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-n-entries", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::DataPocket::get_nth_entry_id (SfiInt entry_index) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseDataPocket+get-nth-entry-id", 'p', _object_id, 'i', entry_index, 0);
  return _retval;
}

Bse::Item
Bse::DataPocket::get_object (SfiInt entry_id, const std::string& name) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("BseDataPocket+get-object", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

std::string
Bse::DataPocket::get_string (SfiInt entry_id, const std::string& name) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseDataPocket+get-string", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 0);
  return _retval;
}

Bse::ErrorType
Bse::DataPocket::set_float (SfiInt entry_id, const std::string& name, SfiReal number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-float", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'r', number, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_int (SfiInt entry_id, const std::string& name, SfiInt number) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-int", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'i', number, 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_object (SfiInt entry_id, const std::string& name, Bse::Item item) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-object", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 'p', item._proxy(), 0);
  return bse_error_type_from_choice (_retval);
}

Bse::ErrorType
Bse::DataPocket::set_string (SfiInt entry_id, const std::string& name, const std::string& string) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseDataPocket+set-string", 'p', _object_id, 'i', entry_id, 's', name.c_str(), 's', string.c_str(), 0);
  return bse_error_type_from_choice (_retval);
}

void
Bse::Janitor::add_action (const std::string& action, const std::string& name, const std::string& blurb) {
  sfi_glue_vcall_void ("BseJanitor+add-action", 'p', _object_id, 's', action.c_str(), 's', name.c_str(), 's', blurb.c_str(), 0);
}

void
Bse::Janitor::exit (Bse::UserMsgType msg_type, const std::string& message) {
  sfi_glue_vcall_void ("BseJanitor+exit", 'p', _object_id, 'C', bse_user_msg_type_to_choice (msg_type), 's', message.c_str(), 0);
}

std::string
Bse::Janitor::get_action (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

std::string
Bse::Janitor::get_action_blurb (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-blurb", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

std::string
Bse::Janitor::get_action_name (SfiInt nth_action) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-action-name", 'p', _object_id, 'i', nth_action, 0);
  return _retval;
}

std::string
Bse::Janitor::get_proc_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-proc-name", 'p', _object_id, 0);
  return _retval;
}

std::string
Bse::Janitor::get_script_name (void) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("BseJanitor+get-script-name", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Janitor::kill (void) {
  sfi_glue_vcall_void ("BseJanitor+kill", 'p', _object_id, 0);
}

SfiInt
Bse::Janitor::n_actions (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseJanitor+n-actions", 'p', _object_id, 0);
  return _retval;
}

void
Bse::Janitor::progress (SfiReal progress) {
  sfi_glue_vcall_void ("BseJanitor+progress", 'p', _object_id, 'r', progress, 0);
}

void
Bse::Janitor::remove_action (const std::string& action) {
  sfi_glue_vcall_void ("BseJanitor+remove-action", 'p', _object_id, 's', action.c_str(), 0);
}

void
Bse::Janitor::set_msg (Bse::UserMsgType msg_type, const std::string& message) {
  sfi_glue_vcall_void ("BseJanitor+set-msg", 'p', _object_id, 'C', bse_user_msg_type_to_choice (msg_type), 's', message.c_str(), 0);
}

void
Bse::Janitor::trigger_action (const std::string& action) {
  sfi_glue_vcall_void ("BseJanitor+trigger-action", 'p', _object_id, 's', action.c_str(), 0);
}

Bse::UserMsgType
Bse::Janitor::user_msg_type ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "user-msg-type");
  return bse_user_msg_type_from_choice (sfi_value_get_choice (val));
}

void
Bse::Janitor::set_user_msg_type (Bse::UserMsgType new_user_msg_type)
{
  GValue *val = sfi_value_choice (bse_user_msg_type_to_choice (new_user_msg_type));
  sfi_glue_proxy_set_property (_proxy(), "user-msg-type", val);
  sfi_value_free (val);
}

std::string
Bse::Janitor::user_msg ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "user-msg");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Janitor::set_user_msg (const std::string& new_user_msg)
{
  GValue *val = sfi_value_string (new_user_msg.c_str());
  sfi_glue_proxy_set_property (_proxy(), "user-msg", val);
  sfi_value_free (val);
}

SfiBool
Bse::Janitor::connected ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "connected");
  return sfi_value_get_bool (val);
}

void
Bse::Janitor::set_connected (SfiBool new_connected)
{
  GValue *val = sfi_value_bool (new_connected);
  sfi_glue_proxy_set_property (_proxy(), "connected", val);
  sfi_value_free (val);
}

std::string
Bse::Janitor::ident ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "ident");
  return sfi_value_get_cxxstring (val);
}

void
Bse::Janitor::set_ident (const std::string& new_ident)
{
  GValue *val = sfi_value_string (new_ident.c_str());
  sfi_glue_proxy_set_property (_proxy(), "ident", val);
  sfi_value_free (val);
}

void
Bse::EditableSample::close (void) {
  sfi_glue_vcall_void ("BseEditableSample+close", 'p', _object_id, 0);
}

SfiFBlock*
Bse::EditableSample::collect_stats (SfiInt voffset, SfiReal offset_scale, SfiInt block_size, SfiInt stepping, SfiInt max_pairs) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseEditableSample+collect-stats", 'p', _object_id, 'i', voffset, 'r', offset_scale, 'i', block_size, 'i', stepping, 'i', max_pairs, 0);
  return _retval;
}

SfiInt
Bse::EditableSample::get_length (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-length", 'p', _object_id, 0);
  return _retval;
}

SfiInt
Bse::EditableSample::get_n_channels (void) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("BseEditableSample+get-n-channels", 'p', _object_id, 0);
  return _retval;
}

SfiReal
Bse::EditableSample::get_osc_freq (void) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("BseEditableSample+get-osc-freq", 'p', _object_id, 0);
  return _retval;
}

Bse::ErrorType
Bse::EditableSample::open (void) {
  const gchar * _retval;
  _retval = sfi_glue_vcall_choice ("BseEditableSample+open", 'p', _object_id, 0);
  return bse_error_type_from_choice (_retval);
}

SfiFBlock*
Bse::EditableSample::read_samples (SfiInt voffset) {
  SfiFBlock* _retval;
  _retval = sfi_glue_vcall_fblock ("BseEditableSample+read-samples", 'p', _object_id, 'i', voffset, 0);
  return _retval;
}


Bse::CategoryPtr
Bse::category_from_id (SfiInt category_id) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-category-from-id", 'i', category_id, 0);
  return Bse::Category::_from_rec (_retval);
}

Bse::CategorySeq
Bse::categories_match (const std::string& pattern) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match", 's', pattern.c_str(), 0);
  return Bse::CategorySeq::_from_seq (_retval);
}

Bse::CategorySeq
Bse::categories_match_method (const std::string& pattern, const std::string& type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-method", 's', pattern.c_str(), 's', type.c_str(), 0);
  return Bse::CategorySeq::_from_seq (_retval);
}

Bse::CategorySeq
Bse::categories_match_typed (const std::string& pattern, const std::string& type) {
  SfiSeq* _retval;
  _retval = sfi_glue_vcall_seq ("bse-categories-match-typed", 's', pattern.c_str(), 's', type.c_str(), 0);
  return Bse::CategorySeq::_from_seq (_retval);
}

std::string
Bse::error_blurb (Bse::ErrorType error) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-error-blurb", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

std::string
Bse::error_name (Bse::ErrorType error) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-error-name", 'C', bse_error_type_to_choice (error), 0);
  return _retval;
}

Bse::Janitor
Bse::janitor_get_specific (void) {
  SfiProxy _retval;
  _retval = sfi_glue_vcall_proxy ("bse-janitor-get-specific", 0);
  return _retval;
}

SfiInt
Bse::note_from_freq (SfiReal frequency) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("bse-note-from-freq", 'r', frequency, 0);
  return _retval;
}

SfiReal
Bse::note_to_freq (SfiInt note, SfiInt fine_tune) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-note-to-freq", 'i', note, 'i', fine_tune, 0);
  return _retval;
}

SfiBool
Bse::proxy_check (Bse::Item item, const std::string& type_name) {
  SfiBool _retval;
  _retval = sfi_glue_vcall_bool ("bse-proxy-check", 'p', item._proxy(), 's', type_name.c_str(), 0);
  return _retval;
}

Bse::SampleFileInfoPtr
Bse::sample_file_info (const std::string& file_name) {
  SfiRec* _retval;
  _retval = sfi_glue_vcall_rec ("bse-sample-file-info", 's', file_name.c_str(), 0);
  return Bse::SampleFileInfo::_from_rec (_retval);
}

SfiReal
Bse::string_extract_number (const std::string& string, const std::string& format, SfiReal aux_base, SfiReal dflt) {
  SfiReal _retval;
  _retval = sfi_glue_vcall_real ("bse-string-extract-number", 's', string.c_str(), 's', format.c_str(), 'r', aux_base, 'r', dflt, 0);
  return _retval;
}

std::string
Bse::type_blurb (const std::string& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-blurb", 's', type.c_str(), 0);
  return _retval;
}

std::string
Bse::type_options (const std::string& type) {
  std::string _retval;
  _retval = sfi_glue_vcall_string ("bse-type-options", 's', type.c_str(), 0);
  return _retval;
}




/*-------- end ../sfi/sfidl generated code --------*/



/*-------- begin ../sfi/sfidl generated code --------*/


namespace {
static const SfiConstants namespace_funkyness_type_vals[3] = {
  { "namespace-non-funky", 19, 3 },
  { "namespace-moderately-funky", 26, 2 },
  { "namespace-really-funky", 22, 1 },
};

const gchar*
namespace_funkyness_type_to_choice (Namespace::FunkynessType value)
{
  g_return_val_if_fail (value >= 1 && value <= 3, NULL);
  return sfi_constants_get_name (G_N_ELEMENTS (namespace_funkyness_type_vals), namespace_funkyness_type_vals, value);
}

Namespace::FunkynessType
namespace_funkyness_type_from_choice (const gchar *choice)
{
  return (Namespace::FunkynessType) (choice ? sfi_constants_get_index (G_N_ELEMENTS (namespace_funkyness_type_vals), namespace_funkyness_type_vals, choice) : 0);
}

}

SfiInt
Namespace::TestObject::fixme ()
{
  const GValue *val;
  val = sfi_glue_proxy_get_property (_proxy(), "fixme");
  return sfi_value_get_int (val);
}

void
Namespace::TestObject::set_fixme (SfiInt new_fixme)
{
  GValue *val = sfi_value_int (new_fixme);
  sfi_glue_proxy_set_property (_proxy(), "fixme", val);
  sfi_value_free (val);
}


SfiInt
Namespace::test_exception (SfiInt i, Namespace::TestObject o, SfiInt bar, Namespace::FunkynessType ft) {
  SfiInt _retval;
  _retval = sfi_glue_vcall_int ("namespace-test-exception", 'i', i, 'p', o._proxy(), 'i', bar, 'C', namespace_funkyness_type_to_choice (ft), 0);
  return _retval;
}




/*-------- end ../sfi/sfidl generated code --------*/


