/* CSL - Common Sound Layer
 * Copyright (C) 1997, 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __ARTS_SOCKET_H__
#define __ARTS_SOCKET_H__

#include <csl/csldefs.h>
#include <csl/cslutils.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ARTS_IPV4_FIELD_MASK(uint)     (((guint32) (uint)) & 0xff)
#define ARTS_IPV4_ADDR(f1, f2, f3, f4) ((ARTS_IPV4_FIELD_MASK (f1) << 24) | \
                                       (ARTS_IPV4_FIELD_MASK (f2) << 16) | \
                                       (ARTS_IPV4_FIELD_MASK (f3) << 8) | \
                                       (ARTS_IPV4_FIELD_MASK (f4) << 0))
#define ARTS_IPV4_FIELD(field,addr)    ((((CslUInt) (addr)) >> (32 - (field) * 8)) & 0xff)


/* --- structures --- */
typedef struct
{
  int          fd;
  unsigned int will_block : 1;
  int	       msg_length_offset;
  unsigned int rbuffer_size;
  char        *rbuffer;
  unsigned int n_bytes_read;
} ArtsSocket;


/* --- prototypes --- */
ArtsSocket*	_arts_socket_new_tcp	(const char	*host_spec);
ArtsSocket*	_arts_socket_new_unix	(const char	*path);
void		_arts_socket_may_block	(ArtsSocket	*csock,
					 int		 may_block);
unsigned int	_arts_socket_read	(ArtsSocket	*csock,
					 unsigned int	 n_bytes,
					 void		*bytes);
void		_arts_socket_write	(ArtsSocket	*csock,
					 unsigned int	 n_bytes,
					 void		*bytes);
void*		_arts_socket_peek_msg	(ArtsSocket	*csock,
					 unsigned int	*n_bytes);
void		_arts_socket_skip_msg	(ArtsSocket	*csock,
					 unsigned int	 n_bytes);
CslBool		_arts_socket_wait_for_msg(ArtsSocket	*csock,
					 int		*milliseconds);
void		_arts_socket_free	(ArtsSocket	*csock);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __ARTS_SOCKET_H__ */
