#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

static const char *g_log_domain_gthread = "GThread";
static gboolean thread_system_already_initialized = FALSE;
extern gboolean g_forbid_thread_initilization;

#include G_THREAD_SOURCE

extern void gmutex_c_thread_init();
extern void gmessages_c_thread_init();

gboolean
g_thread_try_init(GMutexFunctions* init)
{
  if(thread_system_already_initialized)
    {
      return FALSE;
    }

  if(g_forbid_thread_initilization)
    {
      g_error( "you have to call g_thread[_try]_init earlier in the program.");
    }

  thread_system_already_initialized = TRUE;

  g_mutex_use_default_impl = ( init == NULL );

  if( g_mutex_use_default_impl ) 
    {
      init = &g_mutex_functions_for_glib_use_default;
    }
  g_mutex_functions_for_glib_use = *init;

  g_mutex_supported = init->mutex_new && init->mutex_lock && 
    init->mutex_try_lock && init->mutex_unlock && init->mutex_free;

  g_cond_supported = init->cond_new && init->cond_signal && 
    init->cond_broadcast && init->cond_wait && init->cond_timed_wait &&
    init->cond_free;

  g_private_supported = init->private_new && init->private_get &&
    init->private_set;

  /* if somebody is calling g_thread_init(), it means that he at least wants
     to have mutex support, so check this */

  if( !g_mutex_supported )
    {
      g_error( "there is no mutex implementation available for glib." );
    }

  /* now call the thread initialization functions of the different glib
     modules */
  
  gmutex_c_thread_init();
  gmessages_c_thread_init();

  return TRUE;
}

void
g_thread_init(GMutexFunctions* init)
{  
  /* Make sure, this function is only called once. */
  if( !g_thread_try_init( init ) )
    {
      g_error( "the glib thread system might only be initialized once." );
    }
}

