/* translation of file(s)
	"petrinet-patterns-basic.k"
	"petrinet-patterns-structured.k"
	"petrinet-patterns-scopes.k"
	"petrinet-patterns-handlers.k"
	"petrinet-patterns-links.k"
	"petrinet-patterns-shortcuts.k"
	"ast-grammar.k"
	"ast-config.k"
	"ast-to-petrinet.k"
	"ast-to-xml.k"
	"ast-to-cfg.k"
	"ast-postprocess.k"
	"ast-rewrite.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.10 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_TYPES

#include "ast-system-k.h"
#include <stdio.h>
#include <ctype.h>
#include <string>
#include <sys/types.h>
#include <stdlib.h>

#ifdef _MSC_VER
#pragma warning( disable : 4786 )
#endif
#include <new>
#include <set>
#include <list>
#include <algorithm>

#if !defined(USE_HASHSET) && (defined(__GNUC__) || defined(__ICC) || defined(__ECC)) \
&& !defined(DONT_USE_HASHSET)
#  define USE_HASHSET
#endif
#ifdef USE_HASHSET
#  if defined(__GNUC__) && __GNUC__>2
#    include <ext/hash_set>
#  else
#    include <hash_set>
#  endif
#endif

using namespace std;

namespace kc {

inline bool
ht_less(casestring p1, casestring p2){
    return kc_strcmp(p1->name, p2->name)<0;
}

inline bool
ht_less(nocasestring p1, nocasestring p2){
    return kc_strcasecmp(p1->name, p2->name)<0;
}

inline bool
ht_less(real p1, real p2){
    return p1->value < p2->value;
}

inline bool
ht_less(integer p1, integer p2){
    return p1->value < p2->value;
}

inline bool
ht_less(voidptr p1, voidptr p2){
    return p1->pointer < p2->pointer;
}

bool
ht_less(abstract_phylum p1, abstract_phylum p2)
{
    enum_operators prod_sel=p1->prod_sel();
    enum_operators prod_sel2=p2->prod_sel();
    if(prod_sel<prod_sel2)
	return true;
    if(prod_sel>prod_sel2)
	return false;
    switch(prod_sel) {
	case sel_NoCaseStr:
	    return ht_less(static_cast<nocasestring>(p1),static_cast<nocasestring>(p2));
	case sel__Str:
	    return ht_less(static_cast<casestring>(p1),static_cast<casestring>(p2));
	case sel__Real:
	    return ht_less(static_cast<real>(p1),static_cast<real>(p2));
	case sel__Int:
	    return ht_less(static_cast<integer>(p1),static_cast<integer>(p2));
	case sel__VoidPtr:
	    return ht_less(static_cast<voidptr>(p1),static_cast<voidptr>(p2));
	default: {
	    int i=0;
	    bool still_unique = kc_storageclass_still_uniq[phylum_info[p1->phylum()].uniq_stored];
	    abstract_phylum sub1=0;
	    do {
		sub1=p1->subphylum(i);
		abstract_phylum sub2=p2->subphylum(i);
		if(still_unique) {
		    if(sub1<sub2)
			return true;
		    if(sub2<sub1)
			return false;
		}
		else {
		    if(ht_less(sub1, sub2))
			return true;
		    if(ht_less(sub2, sub1))
			return false;
		}
		++i;
	    } while(sub1);
	}
    }
    return false;
}

template<typename T>
class phylum_less : std::binary_function<T, T, bool>
{
    public:
    bool operator()(const T& X, const T& Y) const
	{ return ht_less(X,Y); }
};

inline void deletefun(c_abstract_phylum t){
    delete const_cast<abstract_phylum>(t);
}


#ifdef USE_HASHSET
struct hashitem {
    size_t hashvalue;
    casestring contents;
    hashitem(casestring cs): contents(cs) {
	unsigned long h = 0;
	kc_char_t const *s = cs->name;
	for ( ; *s; ++s)
	    h = 5*h + *s;
	hashvalue=(size_t)h;
    }
};

inline void deletefunhashitem(hashitem t) {
    delete t.contents;
}

#  ifdef __GNUC__
struct eq_hashitem { bool operator()(hashitem hi1, hashitem hi2) const {
	return kc_strcmp(hi1.contents->name, hi2.contents->name) == 0; } };

struct hash_hashitem { size_t operator()(hashitem hi) const {
	return hi.hashvalue; } };

#  else
struct comp_hashitem {
    enum { bucket_size = 4, min_buckets = 8 };
    // bucket_size and min_buckets are just guesses
    size_t operator()(const hashitem hi) const {
	return hi.hashvalue; }
    bool operator()(const hashitem hi1, const hashitem hi2) const {
	return kc_strcmp(hi1.contents->name, hi2.contents->name) < 0; }
};
#  endif // Whether gcc or icc
#endif // Whether hash or not

struct hashtable_level
{
    hashtable_level(bool cod = true): clean_on_destruction(cod) { }
    void clear(bool free_entries=true) {
	if(free_entries)
	    clear_entries();
	_casestring.clear();
	_nocasestring.clear();
	_integer.clear();
	_real.clear();
	_voidptr.clear();
	_abstract_phylum.clear();
    }
    void clear_entries() {
#ifdef USE_HASHSET
	std::for_each(_casestring.begin(),_casestring.end(),deletefunhashitem);
#else
	std::for_each(_casestring.begin(),_casestring.end(),deletefun);
#endif
	std::for_each(_nocasestring.begin(),_nocasestring.end(),deletefun);
	std::for_each(_integer.begin(),_integer.end(),deletefun);
	std::for_each(_real.begin(),_real.end(),deletefun);
	std::for_each(_voidptr.begin(),_voidptr.end(),deletefun);
	std::for_each(_abstract_phylum.begin(),_abstract_phylum.end(),deletefun);
    }
    ~hashtable_level() {
	clear(clean_on_destruction);
    }
    abstract_phylum check_insert(abstract_phylum t) {
	return *_abstract_phylum.insert(t).first;
    }
    casestring check_insert(casestring t) {
#ifdef USE_HASHSET
	return (*_casestring.insert(hashitem(t)).first).contents;
#else
	return *_casestring.insert(t).first;
#endif
    }
    nocasestring check_insert(nocasestring t) {
	return *_nocasestring.insert(t).first;
    }
    integer check_insert(integer t) {
	return *_integer.insert(t).first;
    }
    real check_insert(real t) {
	return *_real.insert(t).first;
    }
    voidptr check_insert(voidptr t) {
	return *_voidptr.insert(t).first;
    }
private:
    bool clean_on_destruction;
#ifdef USE_HASHSET
#  ifdef __GNUC__
#    if __GNUC__==2 || (__GNUC__==3 && __GNUC_MINOR__==0)
    std::hash_set<hashitem, hash_hashitem, eq_hashitem> _casestring;
#    else
    __gnu_cxx::hash_set<hashitem, hash_hashitem, eq_hashitem> _casestring;
#    endif
#  else
    std::hash_set<hashitem, comp_hashitem> _casestring;
#  endif
#else
    std::set<casestring, phylum_less<casestring> > _casestring;
#endif
    std::set<nocasestring, phylum_less<nocasestring> > _nocasestring;
    std::set<integer, phylum_less<integer> > _integer;
    std::set<real, phylum_less<real> > _real;
    std::set<voidptr, phylum_less<voidptr> > _voidptr;
    std::set<abstract_phylum, phylum_less<abstract_phylum> > _abstract_phylum;
};

class hashtable_stack: public std::list<hashtable_level> {
public:
    hashtable_stack(): _pos(begin()) { }

    void inc_level() { _pos=insert(_pos, hashtable_level()); }
    void dec_level() { if(valid() && _pos!=end()) ++_pos; }
    void free_level() { if(_pos!=begin()) { erase(begin(),_pos);_pos=begin(); } }

    bool valid() const { return !empty(); }
    hashtable_level& get_level() { return *_pos; }

    template<typename T>
    T check_insert(T t) {
	return dynamic_cast<T>((*_pos).check_insert(t));
    }
private:
    iterator _pos;
};

class hashtable_struct_t {
public:
    // don't clean _static_level on destruction (program ends)
    hashtable_struct_t(): _static_level(false), _to_be_freed(false),  _dynamic(false) { }

    template <typename T>
    T ht_check_insert(T t) {
	if(_dynamic && _dynamic_level.valid())
	    return _dynamic_level.check_insert(t);
	else
	    return dynamic_cast<T>(_static_level.check_insert(t));
    }
    void ht_static() {_dynamic=false; }
    void ht_dynamic() {
	_dynamic=true;
	if(!_dynamic_level.valid())
	    _dynamic_level.inc_level();
    }
    void ht_inc_level() { _dynamic_level.inc_level(); }
    void ht_dec_level() { _dynamic_level.dec_level(); }
    void ht_free_level() { _dynamic_level.free_level(); }
    void ht_clear() { _static_level.clear(); _dynamic_level.clear(); _dynamic=false; }

    bool to_be_freed() { return _to_be_freed; }
    void set_to_be_freed(bool b=true) { _to_be_freed=b; }
private:
    hashtable_level _static_level;
    hashtable_stack _dynamic_level;
    bool _to_be_freed; /* should be true for dynamic, false for statically allocated structures */
    bool _dynamic;
};

impl_nocasestring_NoCaseStr::impl_nocasestring_NoCaseStr(const kc_char_t* _name) : name(_name) { }
void impl_nocasestring_NoCaseStr::make_own(int length) {
    kc_char_t *newname=new kc_char_t[length+1];
    for (int i=0; i < length && name[i]; ++i)
    newname[i] = kc_tolower(name[i]);
    newname[length]=0;
    name=newname;
}

impl_casestring__Str::impl_casestring__Str(const kc_char_t* _name) : name(_name) { }
void impl_casestring__Str::make_own(int length) {
    kc_char_t *newname=kc_strncpy(new kc_char_t[length+1],name,length);
    newname[length]=0;
    name=newname;
}
abstract_phylum impl_expression_Disjunction::subphylum(int no) const
{
    switch(no){
	case 0: return expression_1;
	case 1: return expression_2;
    }
    return 0;
}
abstract_phylum impl_expression_Conjunction::subphylum(int no) const
{
    switch(no){
	case 0: return expression_1;
	case 1: return expression_2;
    }
    return 0;
}
abstract_phylum impl_expression_Term::subphylum(int no) const
{
    switch(no){
	case 0: return casestring_1;
    }
    return 0;
}
abstract_phylum impl_joinCondition_userDefinedJoinCondition::subphylum(int no) const
{
    switch(no){
	case 0: return expression_1;
    }
    return 0;
}
abstract_phylum impl_tSource_Source::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tSource_list::subphylum(int no) const
{
    switch(no){
	case 0: return tSource_1;
	case 1: return tSource_list_1;
    }
    return 0;
}
abstract_phylum impl_tTarget_Target::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tTarget_list::subphylum(int no) const
{
    switch(no){
	case 0: return tTarget_1;
	case 1: return tTarget_list_1;
    }
    return 0;
}
abstract_phylum impl_standardElements_StandardElements::subphylum(int no) const
{
    switch(no){
	case 0: return tTarget_list_1;
	case 1: return tSource_list_1;
	case 2: return joinCondition_1;
    }
    return 0;
}
abstract_phylum impl_tScope_Scope::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tVariable_list_1;
	case 2: return tFaultHandlers_1;
	case 3: return tCompensationHandler_1;
	case 4: return tTerminationHandler_1;
	case 5: return tEventHandlers_1;
	case 6: return tCorrelationSet_list_1;
	case 7: return activity_1;
	case 8: return tPartnerLink_list_1;
	case 9: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tLink_Link::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tLink_list::subphylum(int no) const
{
    switch(no){
	case 0: return tLink_1;
	case 1: return tLink_list_1;
    }
    return 0;
}
abstract_phylum impl_tFlow_Flow::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tLink_list_1;
	case 2: return activity_list_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tPick_Pick::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tOnMessage_list_1;
	case 2: return tOnAlarm_list_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tForEach_ForEach::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return casestring_1;
	case 2: return casestring_2;
	case 3: return casestring_3;
	case 4: return tScope_1;
	case 5: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tRepeatUntil_RepeatUntil::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return activity_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tWhile_While::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return activity_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tElse_NoElse::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tElse_Else::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tElseIf_ElseIf::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tElseIf_list::subphylum(int no) const
{
    switch(no){
	case 0: return tElseIf_1;
	case 1: return tElseIf_list_1;
    }
    return 0;
}
abstract_phylum impl_tIf_If::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tElseIf_list_1;
	case 2: return tElse_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tSequence_Sequence::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return activity_list_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCompensate_CompensateScope::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return casestring_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCompensate_Compensate::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tRethrow_Rethrow::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tThrow_Throw::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tExit_Exit::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tWait_Wait::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tEmpty_Empty::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tValidate_Validate::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tTo_To::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tFrom_From::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCopy_Copy::subphylum(int no) const
{
    switch(no){
	case 0: return tFrom_1;
	case 1: return tTo_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCopy_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCopy_1;
	case 1: return tCopy_list_1;
    }
    return 0;
}
abstract_phylum impl_tAssign_Assign::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCopy_list_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tInvoke_volatile_annotatedInvoke::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tCatch_list_1;
	case 3: return tCatchAll_1;
	case 4: return tCompensationHandler_1;
	case 5: return tToPart_list_1;
	case 6: return tFromPart_list_1;
	case 7: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tInvoke_AsynchronousInvoke::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tToPart_list_1;
	case 3: return tFromPart_list_1;
	case 4: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tInvoke_SynchronousInvoke::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tToPart_list_1;
	case 3: return tFromPart_list_1;
	case 4: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tInvoke_volatile_Invoke::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tToPart_list_1;
	case 3: return tFromPart_list_1;
	case 4: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tReply_Reply::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tToPart_list_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tReceive_Receive::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
	case 2: return tFromPart_list_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tFromPart_FromPart::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tFromPart_list::subphylum(int no) const
{
    switch(no){
	case 0: return tFromPart_1;
	case 1: return tFromPart_list_1;
    }
    return 0;
}
abstract_phylum impl_tToPart_ToPart::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tToPart_list::subphylum(int no) const
{
    switch(no){
	case 0: return tToPart_1;
	case 1: return tToPart_list_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelation_Correlation::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelation_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCorrelation_1;
	case 1: return tCorrelation_list_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelationSet_CorrelationSet::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelationSet_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCorrelationSet_1;
	case 1: return tCorrelationSet_list_1;
    }
    return 0;
}
abstract_phylum impl_tVariable_Variable::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tVariable_list::subphylum(int no) const
{
    switch(no){
	case 0: return tVariable_1;
	case 1: return tVariable_list_1;
    }
    return 0;
}
abstract_phylum impl_tRepeatEvery_RepeatEvery::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tRepeatEvery_emptyRepeatEvery::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tOnAlarm_OnAlarm::subphylum(int no) const
{
    switch(no){
	case 0: return tRepeatEvery_1;
	case 1: return activity_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tOnAlarm_list::subphylum(int no) const
{
    switch(no){
	case 0: return tOnAlarm_1;
	case 1: return tOnAlarm_list_1;
    }
    return 0;
}
abstract_phylum impl_tOnMessage_OnMessage::subphylum(int no) const
{
    switch(no){
	case 0: return tCorrelation_list_1;
	case 1: return tFromPart_list_1;
	case 2: return activity_1;
	case 3: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tOnMessage_list::subphylum(int no) const
{
    switch(no){
	case 0: return tOnMessage_1;
	case 1: return tOnMessage_list_1;
    }
    return 0;
}
abstract_phylum impl_tEventHandlers_EventHandlers::subphylum(int no) const
{
    switch(no){
	case 0: return tOnMessage_list_1;
	case 1: return tOnAlarm_list_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tEventHandlers_emptyEventHandlers::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCompensationHandler_CompensationHandler::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCompensationHandler_volatile_standardCompensationHandler::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tTerminationHandler_TerminationHandler::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tTerminationHandler_volatile_standardTerminationHandler::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCatchAll_CatchAll::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCatch_Catch::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tCatch_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCatch_1;
	case 1: return tCatch_list_1;
    }
    return 0;
}
abstract_phylum impl_tFaultHandlers_FaultHandlers::subphylum(int no) const
{
    switch(no){
	case 0: return tCatch_list_1;
	case 1: return tCatchAll_1;
	case 2: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tFaultHandlers_volatile_standardFaultHandlers::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tPartner_Partner::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_list_1;
	case 1: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tPartner_list::subphylum(int no) const
{
    switch(no){
	case 0: return tPartner_1;
	case 1: return tPartner_list_1;
    }
    return 0;
}
abstract_phylum impl_tPartnerLink_PartnerLink::subphylum(int no) const
{
    switch(no){
	case 0: return integer_1;
    }
    return 0;
}
abstract_phylum impl_tPartnerLink_list::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_1;
	case 1: return tPartnerLink_list_1;
    }
    return 0;
}
abstract_phylum impl_activity_list::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return activity_list_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityScope::subphylum(int no) const
{
    switch(no){
	case 0: return tScope_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityFlow::subphylum(int no) const
{
    switch(no){
	case 0: return tFlow_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityPick::subphylum(int no) const
{
    switch(no){
	case 0: return tPick_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityForEach::subphylum(int no) const
{
    switch(no){
	case 0: return tForEach_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityRepeatUntil::subphylum(int no) const
{
    switch(no){
	case 0: return tRepeatUntil_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityWhile::subphylum(int no) const
{
    switch(no){
	case 0: return tWhile_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityIf::subphylum(int no) const
{
    switch(no){
	case 0: return tIf_1;
    }
    return 0;
}
abstract_phylum impl_activity_activitySequence::subphylum(int no) const
{
    switch(no){
	case 0: return tSequence_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityCompensate::subphylum(int no) const
{
    switch(no){
	case 0: return tCompensate_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityRethrow::subphylum(int no) const
{
    switch(no){
	case 0: return tRethrow_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityThrow::subphylum(int no) const
{
    switch(no){
	case 0: return tThrow_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityExit::subphylum(int no) const
{
    switch(no){
	case 0: return tExit_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityWait::subphylum(int no) const
{
    switch(no){
	case 0: return tWait_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityEmpty::subphylum(int no) const
{
    switch(no){
	case 0: return tEmpty_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityValidate::subphylum(int no) const
{
    switch(no){
	case 0: return tValidate_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityAssign::subphylum(int no) const
{
    switch(no){
	case 0: return tAssign_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityInvoke::subphylum(int no) const
{
    switch(no){
	case 0: return tInvoke_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityReply::subphylum(int no) const
{
    switch(no){
	case 0: return tReply_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityReceive::subphylum(int no) const
{
    switch(no){
	case 0: return tReceive_1;
    }
    return 0;
}
abstract_phylum impl_tProcess_Process::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_list_1;
	case 1: return tPartner_list_1;
	case 2: return tVariable_list_1;
	case 3: return tCorrelationSet_list_1;
	case 4: return tFaultHandlers_1;
	case 5: return tEventHandlers_1;
	case 6: return activity_1;
	case 7: return integer_1;
    }
    return 0;
}
void impl_expression_Disjunction::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = expression_1 = dynamic_cast<expression>(val);break;
	case 1: newval = expression_2 = dynamic_cast<expression>(val);break;
    }
    assertNonNull(newval);
}
void impl_expression_Conjunction::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = expression_1 = dynamic_cast<expression>(val);break;
	case 1: newval = expression_2 = dynamic_cast<expression>(val);break;
    }
    assertNonNull(newval);
}
void impl_expression_Term::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = casestring_1 = dynamic_cast<casestring>(val);break;
    }
    assertNonNull(newval);
}
void impl_joinCondition_userDefinedJoinCondition::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = expression_1 = dynamic_cast<expression>(val);break;
    }
    assertNonNull(newval);
}
void impl_tSource_Source::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tSource_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tSource_1 = dynamic_cast<tSource>(val);break;
	case 1: newval = tSource_list_1 = dynamic_cast<tSource_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTarget_Target::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTarget_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tTarget_1 = dynamic_cast<tTarget>(val);break;
	case 1: newval = tTarget_list_1 = dynamic_cast<tTarget_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_standardElements_StandardElements::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tTarget_list_1 = dynamic_cast<tTarget_list>(val);break;
	case 1: newval = tSource_list_1 = dynamic_cast<tSource_list>(val);break;
	case 2: newval = joinCondition_1 = dynamic_cast<joinCondition>(val);break;
    }
    assertNonNull(newval);
}
void impl_tScope_Scope::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
	case 2: newval = tFaultHandlers_1 = dynamic_cast<tFaultHandlers>(val);break;
	case 3: newval = tCompensationHandler_1 = dynamic_cast<tCompensationHandler>(val);break;
	case 4: newval = tTerminationHandler_1 = dynamic_cast<tTerminationHandler>(val);break;
	case 5: newval = tEventHandlers_1 = dynamic_cast<tEventHandlers>(val);break;
	case 6: newval = tCorrelationSet_list_1 = dynamic_cast<tCorrelationSet_list>(val);break;
	case 7: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 8: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
	case 9: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tLink_Link::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tLink_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tLink_1 = dynamic_cast<tLink>(val);break;
	case 1: newval = tLink_list_1 = dynamic_cast<tLink_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFlow_Flow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tLink_list_1 = dynamic_cast<tLink_list>(val);break;
	case 2: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPick_Pick::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
	case 2: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tForEach_ForEach::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 2: newval = casestring_2 = dynamic_cast<casestring>(val);break;
	case 3: newval = casestring_3 = dynamic_cast<casestring>(val);break;
	case 4: newval = tScope_1 = dynamic_cast<tScope>(val);break;
	case 5: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tRepeatUntil_RepeatUntil::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tWhile_While::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tElse_NoElse::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tElse_Else::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tElseIf_ElseIf::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tElseIf_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tElseIf_1 = dynamic_cast<tElseIf>(val);break;
	case 1: newval = tElseIf_list_1 = dynamic_cast<tElseIf_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tIf_If::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tElseIf_list_1 = dynamic_cast<tElseIf_list>(val);break;
	case 2: newval = tElse_1 = dynamic_cast<tElse>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tSequence_Sequence::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensate_CompensateScope::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = casestring_1 = dynamic_cast<casestring>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensate_Compensate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tRethrow_Rethrow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tThrow_Throw::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tExit_Exit::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tWait_Wait::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tEmpty_Empty::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tValidate_Validate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTo_To::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFrom_From::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCopy_Copy::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tFrom_1 = dynamic_cast<tFrom>(val);break;
	case 1: newval = tTo_1 = dynamic_cast<tTo>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCopy_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCopy_1 = dynamic_cast<tCopy>(val);break;
	case 1: newval = tCopy_list_1 = dynamic_cast<tCopy_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tAssign_Assign::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCopy_list_1 = dynamic_cast<tCopy_list>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tInvoke_volatile_annotatedInvoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tCatch_list_1 = dynamic_cast<tCatch_list>(val);break;
	case 3: newval = tCatchAll_1 = dynamic_cast<tCatchAll>(val);break;
	case 4: newval = tCompensationHandler_1 = dynamic_cast<tCompensationHandler>(val);break;
	case 5: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
	case 6: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 7: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tInvoke_AsynchronousInvoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
	case 3: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 4: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tInvoke_SynchronousInvoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
	case 3: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 4: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tInvoke_volatile_Invoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
	case 3: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 4: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tReply_Reply::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tReceive_Receive::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 2: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFromPart_FromPart::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFromPart_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tFromPart_1 = dynamic_cast<tFromPart>(val);break;
	case 1: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tToPart_ToPart::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tToPart_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tToPart_1 = dynamic_cast<tToPart>(val);break;
	case 1: newval = tToPart_list_1 = dynamic_cast<tToPart_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelation_Correlation::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelation_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCorrelation_1 = dynamic_cast<tCorrelation>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelationSet_CorrelationSet::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelationSet_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCorrelationSet_1 = dynamic_cast<tCorrelationSet>(val);break;
	case 1: newval = tCorrelationSet_list_1 = dynamic_cast<tCorrelationSet_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tVariable_Variable::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tVariable_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tVariable_1 = dynamic_cast<tVariable>(val);break;
	case 1: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tRepeatEvery_RepeatEvery::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tRepeatEvery_emptyRepeatEvery::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnAlarm_OnAlarm::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tRepeatEvery_1 = dynamic_cast<tRepeatEvery>(val);break;
	case 1: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnAlarm_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnAlarm_1 = dynamic_cast<tOnAlarm>(val);break;
	case 1: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnMessage_OnMessage::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
	case 1: newval = tFromPart_list_1 = dynamic_cast<tFromPart_list>(val);break;
	case 2: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 3: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnMessage_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnMessage_1 = dynamic_cast<tOnMessage>(val);break;
	case 1: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tEventHandlers_EventHandlers::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
	case 1: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tEventHandlers_emptyEventHandlers::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensationHandler_CompensationHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensationHandler_volatile_standardCompensationHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTerminationHandler_TerminationHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTerminationHandler_volatile_standardTerminationHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatchAll_CatchAll::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatch_Catch::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatch_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCatch_1 = dynamic_cast<tCatch>(val);break;
	case 1: newval = tCatch_list_1 = dynamic_cast<tCatch_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFaultHandlers_FaultHandlers::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCatch_list_1 = dynamic_cast<tCatch_list>(val);break;
	case 1: newval = tCatchAll_1 = dynamic_cast<tCatchAll>(val);break;
	case 2: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFaultHandlers_volatile_standardFaultHandlers::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartner_Partner::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
	case 1: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartner_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartner_1 = dynamic_cast<tPartner>(val);break;
	case 1: newval = tPartner_list_1 = dynamic_cast<tPartner_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartnerLink_PartnerLink::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartnerLink_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_1 = dynamic_cast<tPartnerLink>(val);break;
	case 1: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityScope::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tScope_1 = dynamic_cast<tScope>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityFlow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tFlow_1 = dynamic_cast<tFlow>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityPick::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPick_1 = dynamic_cast<tPick>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityForEach::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tForEach_1 = dynamic_cast<tForEach>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityRepeatUntil::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tRepeatUntil_1 = dynamic_cast<tRepeatUntil>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityWhile::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tWhile_1 = dynamic_cast<tWhile>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityIf::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tIf_1 = dynamic_cast<tIf>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activitySequence::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tSequence_1 = dynamic_cast<tSequence>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityCompensate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCompensate_1 = dynamic_cast<tCompensate>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityRethrow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tRethrow_1 = dynamic_cast<tRethrow>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityThrow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tThrow_1 = dynamic_cast<tThrow>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityExit::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tExit_1 = dynamic_cast<tExit>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityWait::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tWait_1 = dynamic_cast<tWait>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityEmpty::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tEmpty_1 = dynamic_cast<tEmpty>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityValidate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tValidate_1 = dynamic_cast<tValidate>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityAssign::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tAssign_1 = dynamic_cast<tAssign>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityInvoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tInvoke_1 = dynamic_cast<tInvoke>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityReply::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tReply_1 = dynamic_cast<tReply>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityReceive::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tReceive_1 = dynamic_cast<tReceive>(val);break;
    }
    assertNonNull(newval);
}
void impl_tProcess_Process::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
	case 1: newval = tPartner_list_1 = dynamic_cast<tPartner_list>(val);break;
	case 2: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
	case 3: newval = tCorrelationSet_list_1 = dynamic_cast<tCorrelationSet_list>(val);break;
	case 4: newval = tFaultHandlers_1 = dynamic_cast<tFaultHandlers>(val);break;
	case 5: newval = tEventHandlers_1 = dynamic_cast<tEventHandlers>(val);break;
	case 6: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 7: newval = integer_1 = dynamic_cast<integer>(val);break;
    }
    assertNonNull(newval);
}

void
copy_attributes(enum_phyla copyPhy, c_abstract_phylum kc_p1, abstract_phylum kc_p2)
{
    switch(copyPhy) {
    case phylum_standardElements: {
	c_standardElements p1 = dynamic_cast<c_standardElements>(kc_p1);
	standardElements p2 = dynamic_cast<standardElements>(kc_p2);
	p2->suppressJF = p1->suppressJF;
	p2->parentId = p1->parentId;
	break;
    }
    case phylum_joinCondition:
	dynamic_cast<joinCondition>(kc_p2)->parentId = dynamic_cast<c_joinCondition>(kc_p1)->parentId;
	break;
    case phylum_expression: {
	c_expression p1 = dynamic_cast<c_expression>(kc_p1);
	expression p2 = dynamic_cast<expression>(kc_p2);
	p2->parentId = p1->parentId;
	p2->value = p1->value;
	break;
    }
    case one_before_first_phylum: // just to avoid a warning about missing case if empty
    default:
	break; // it's alright, no attributes to copy
    }
    enum_operators copyOp=kc_p1->prod_sel();
    for (int i=operator_info[copyOp].no_attrs-1; i>=0; --i)
	attributeOf(kc_p2, i)=attributeOf(const_cast<abstract_phylum>(kc_p1), i);
}

KC_PHYLUM_INFO phylum_info[] = {
    { "", one_before_first_operator, one_before_first_operator, (kc_storageclass_t)0 }, /* dummy element */
    { "nocasestring", sel_NoCaseStr, sel_NoCaseStr, uniq },
    { "casestring", sel__Str, sel__Str, uniq },
    { "real", sel__Real, sel__Real, uniq },
    { "integer", sel__Int, sel__Int, uniq },
    { "voidptr", sel__VoidPtr, sel__VoidPtr, uniq },
    { "tProcess", sel_Process, sel_Process, kc_not_uniq },
    { "activity", sel_activityReceive, sel_activityScope, kc_not_uniq },
    { "activity_list", sel_Nilactivity_list, sel_Consactivity_list, kc_not_uniq },
    { "tPartnerLink_list", sel_NiltPartnerLink_list, sel_ConstPartnerLink_list, kc_not_uniq },
    { "tPartnerLink", sel_PartnerLink, sel_PartnerLink, kc_not_uniq },
    { "tPartner_list", sel_NiltPartner_list, sel_ConstPartner_list, kc_not_uniq },
    { "tPartner", sel_Partner, sel_Partner, kc_not_uniq },
    { "tFaultHandlers", sel_volatile_standardFaultHandlers, sel_FaultHandlers, kc_not_uniq },
    { "tCatch_list", sel_NiltCatch_list, sel_ConstCatch_list, kc_not_uniq },
    { "tCatch", sel_Catch, sel_Catch, kc_not_uniq },
    { "tCatchAll", sel_CatchAll, sel_NoCatchAll, kc_not_uniq },
    { "tTerminationHandler", sel_volatile_standardTerminationHandler, sel_TerminationHandler, kc_not_uniq },
    { "tCompensationHandler", sel_volatile_standardCompensationHandler, sel_CompensationHandler, kc_not_uniq },
    { "tEventHandlers", sel_emptyEventHandlers, sel_EventHandlers, kc_not_uniq },
    { "tOnMessage_list", sel_NiltOnMessage_list, sel_ConstOnMessage_list, kc_not_uniq },
    { "tOnMessage", sel_OnMessage, sel_OnMessage, kc_not_uniq },
    { "tOnAlarm_list", sel_NiltOnAlarm_list, sel_ConstOnAlarm_list, kc_not_uniq },
    { "tOnAlarm", sel_OnAlarm, sel_OnAlarm, kc_not_uniq },
    { "tRepeatEvery", sel_emptyRepeatEvery, sel_RepeatEvery, kc_not_uniq },
    { "tVariable_list", sel_NiltVariable_list, sel_ConstVariable_list, kc_not_uniq },
    { "tVariable", sel_Variable, sel_Variable, kc_not_uniq },
    { "tCorrelationSet_list", sel_NiltCorrelationSet_list, sel_ConstCorrelationSet_list, kc_not_uniq },
    { "tCorrelationSet", sel_CorrelationSet, sel_CorrelationSet, kc_not_uniq },
    { "tCorrelation_list", sel_NiltCorrelation_list, sel_ConstCorrelation_list, kc_not_uniq },
    { "tCorrelation", sel_Correlation, sel_Correlation, kc_not_uniq },
    { "tToPart_list", sel_NiltToPart_list, sel_ConstToPart_list, kc_not_uniq },
    { "tToPart", sel_ToPart, sel_ToPart, kc_not_uniq },
    { "tFromPart_list", sel_NiltFromPart_list, sel_ConstFromPart_list, kc_not_uniq },
    { "tFromPart", sel_FromPart, sel_FromPart, kc_not_uniq },
    { "tReceive", sel_Receive, sel_Receive, kc_not_uniq },
    { "tReply", sel_Reply, sel_Reply, kc_not_uniq },
    { "tInvoke", sel_volatile_Invoke, sel_volatile_annotatedInvoke, kc_not_uniq },
    { "tAssign", sel_Assign, sel_Assign, kc_not_uniq },
    { "tCopy_list", sel_NiltCopy_list, sel_ConstCopy_list, kc_not_uniq },
    { "tCopy", sel_Copy, sel_Copy, kc_not_uniq },
    { "tFrom", sel_From, sel_From, kc_not_uniq },
    { "tTo", sel_To, sel_To, kc_not_uniq },
    { "tValidate", sel_Validate, sel_Validate, kc_not_uniq },
    { "tEmpty", sel_Empty, sel_Empty, kc_not_uniq },
    { "tWait", sel_Wait, sel_Wait, kc_not_uniq },
    { "tExit", sel_Exit, sel_Exit, kc_not_uniq },
    { "tThrow", sel_Throw, sel_Throw, kc_not_uniq },
    { "tRethrow", sel_Rethrow, sel_Rethrow, kc_not_uniq },
    { "tCompensate", sel_Compensate, sel_CompensateScope, kc_not_uniq },
    { "tSequence", sel_Sequence, sel_Sequence, kc_not_uniq },
    { "tIf", sel_If, sel_If, kc_not_uniq },
    { "tElseIf_list", sel_NiltElseIf_list, sel_ConstElseIf_list, kc_not_uniq },
    { "tElseIf", sel_ElseIf, sel_ElseIf, kc_not_uniq },
    { "tElse", sel_Else, sel_NoElse, kc_not_uniq },
    { "tWhile", sel_While, sel_While, kc_not_uniq },
    { "tRepeatUntil", sel_RepeatUntil, sel_RepeatUntil, kc_not_uniq },
    { "tForEach", sel_ForEach, sel_ForEach, kc_not_uniq },
    { "tPick", sel_Pick, sel_Pick, kc_not_uniq },
    { "tFlow", sel_Flow, sel_Flow, kc_not_uniq },
    { "tLink_list", sel_NiltLink_list, sel_ConstLink_list, kc_not_uniq },
    { "tLink", sel_Link, sel_Link, kc_not_uniq },
    { "tScope", sel_Scope, sel_Scope, kc_not_uniq },
    { "standardElements", sel_StandardElements, sel_NoStandardElements, kc_not_uniq },
    { "tTarget_list", sel_NiltTarget_list, sel_ConstTarget_list, kc_not_uniq },
    { "tTarget", sel_Target, sel_Target, kc_not_uniq },
    { "tSource_list", sel_NiltSource_list, sel_ConstSource_list, kc_not_uniq },
    { "tSource", sel_Source, sel_Source, kc_not_uniq },
    { "joinCondition", sel_standardJoinCondition, sel_userDefinedJoinCondition, kc_not_uniq },
    { "expression", sel_Term, sel_Disjunction, kc_not_uniq },
    { "", one_before_first_operator, one_before_first_operator, (kc_storageclass_t)0 } /* last element */
};

static enum_phyla kc_subphyla_Process[] = { phylum_tPartnerLink_list, phylum_tPartner_list, phylum_tVariable_list, phylum_tCorrelationSet_list, phylum_tFaultHandlers, phylum_tEventHandlers, phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_activityReceive[] = { phylum_tReceive };
static enum_phyla kc_subphyla_activityReply[] = { phylum_tReply };
static enum_phyla kc_subphyla_activityInvoke[] = { phylum_tInvoke };
static enum_phyla kc_subphyla_activityAssign[] = { phylum_tAssign };
static enum_phyla kc_subphyla_activityValidate[] = { phylum_tValidate };
static enum_phyla kc_subphyla_activityEmpty[] = { phylum_tEmpty };
static enum_phyla kc_subphyla_activityWait[] = { phylum_tWait };
static enum_phyla kc_subphyla_activityExit[] = { phylum_tExit };
static enum_phyla kc_subphyla_activityThrow[] = { phylum_tThrow };
static enum_phyla kc_subphyla_activityRethrow[] = { phylum_tRethrow };
static enum_phyla kc_subphyla_activityCompensate[] = { phylum_tCompensate };
static enum_phyla kc_subphyla_activitySequence[] = { phylum_tSequence };
static enum_phyla kc_subphyla_activityIf[] = { phylum_tIf };
static enum_phyla kc_subphyla_activityWhile[] = { phylum_tWhile };
static enum_phyla kc_subphyla_activityRepeatUntil[] = { phylum_tRepeatUntil };
static enum_phyla kc_subphyla_activityForEach[] = { phylum_tForEach };
static enum_phyla kc_subphyla_activityPick[] = { phylum_tPick };
static enum_phyla kc_subphyla_activityFlow[] = { phylum_tFlow };
static enum_phyla kc_subphyla_activityScope[] = { phylum_tScope };
static enum_phyla kc_subphyla_Consactivity_list[] = { phylum_activity, phylum_activity_list };
static enum_phyla kc_subphyla_ConstPartnerLink_list[] = { phylum_tPartnerLink, phylum_tPartnerLink_list };
static enum_phyla kc_subphyla_PartnerLink[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstPartner_list[] = { phylum_tPartner, phylum_tPartner_list };
static enum_phyla kc_subphyla_Partner[] = { phylum_tPartnerLink_list, phylum_integer };
static enum_phyla kc_subphyla_volatile_standardFaultHandlers[] = { phylum_integer };
static enum_phyla kc_subphyla_FaultHandlers[] = { phylum_tCatch_list, phylum_tCatchAll, phylum_integer };
static enum_phyla kc_subphyla_ConstCatch_list[] = { phylum_tCatch, phylum_tCatch_list };
static enum_phyla kc_subphyla_Catch[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_CatchAll[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_volatile_standardTerminationHandler[] = { phylum_integer };
static enum_phyla kc_subphyla_TerminationHandler[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_volatile_standardCompensationHandler[] = { phylum_integer };
static enum_phyla kc_subphyla_CompensationHandler[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_emptyEventHandlers[] = { phylum_integer };
static enum_phyla kc_subphyla_EventHandlers[] = { phylum_tOnMessage_list, phylum_tOnAlarm_list, phylum_integer };
static enum_phyla kc_subphyla_ConstOnMessage_list[] = { phylum_tOnMessage, phylum_tOnMessage_list };
static enum_phyla kc_subphyla_OnMessage[] = { phylum_tCorrelation_list, phylum_tFromPart_list, phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_ConstOnAlarm_list[] = { phylum_tOnAlarm, phylum_tOnAlarm_list };
static enum_phyla kc_subphyla_OnAlarm[] = { phylum_tRepeatEvery, phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_emptyRepeatEvery[] = { phylum_integer };
static enum_phyla kc_subphyla_RepeatEvery[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstVariable_list[] = { phylum_tVariable, phylum_tVariable_list };
static enum_phyla kc_subphyla_Variable[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstCorrelationSet_list[] = { phylum_tCorrelationSet, phylum_tCorrelationSet_list };
static enum_phyla kc_subphyla_CorrelationSet[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstCorrelation_list[] = { phylum_tCorrelation, phylum_tCorrelation_list };
static enum_phyla kc_subphyla_Correlation[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstToPart_list[] = { phylum_tToPart, phylum_tToPart_list };
static enum_phyla kc_subphyla_ToPart[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstFromPart_list[] = { phylum_tFromPart, phylum_tFromPart_list };
static enum_phyla kc_subphyla_FromPart[] = { phylum_integer };
static enum_phyla kc_subphyla_Receive[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tFromPart_list, phylum_integer };
static enum_phyla kc_subphyla_Reply[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tToPart_list, phylum_integer };
static enum_phyla kc_subphyla_volatile_Invoke[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tToPart_list, phylum_tFromPart_list, phylum_integer };
static enum_phyla kc_subphyla_SynchronousInvoke[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tToPart_list, phylum_tFromPart_list, phylum_integer };
static enum_phyla kc_subphyla_AsynchronousInvoke[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tToPart_list, phylum_tFromPart_list, phylum_integer };
static enum_phyla kc_subphyla_volatile_annotatedInvoke[] = { phylum_standardElements, phylum_tCorrelation_list, phylum_tCatch_list, phylum_tCatchAll, phylum_tCompensationHandler, phylum_tToPart_list, phylum_tFromPart_list, phylum_integer };
static enum_phyla kc_subphyla_Assign[] = { phylum_standardElements, phylum_tCopy_list, phylum_integer };
static enum_phyla kc_subphyla_ConstCopy_list[] = { phylum_tCopy, phylum_tCopy_list };
static enum_phyla kc_subphyla_Copy[] = { phylum_tFrom, phylum_tTo, phylum_integer };
static enum_phyla kc_subphyla_From[] = { phylum_integer };
static enum_phyla kc_subphyla_To[] = { phylum_integer };
static enum_phyla kc_subphyla_Validate[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Empty[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Wait[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Exit[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Throw[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Rethrow[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_Compensate[] = { phylum_standardElements, phylum_integer };
static enum_phyla kc_subphyla_CompensateScope[] = { phylum_standardElements, phylum_casestring, phylum_integer };
static enum_phyla kc_subphyla_Sequence[] = { phylum_standardElements, phylum_activity_list, phylum_integer };
static enum_phyla kc_subphyla_If[] = { phylum_standardElements, phylum_tElseIf_list, phylum_tElse, phylum_integer };
static enum_phyla kc_subphyla_ConstElseIf_list[] = { phylum_tElseIf, phylum_tElseIf_list };
static enum_phyla kc_subphyla_ElseIf[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_Else[] = { phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_NoElse[] = { phylum_integer };
static enum_phyla kc_subphyla_While[] = { phylum_standardElements, phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_RepeatUntil[] = { phylum_standardElements, phylum_activity, phylum_integer };
static enum_phyla kc_subphyla_ForEach[] = { phylum_standardElements, phylum_casestring, phylum_casestring, phylum_casestring, phylum_tScope, phylum_integer };
static enum_phyla kc_subphyla_Pick[] = { phylum_standardElements, phylum_tOnMessage_list, phylum_tOnAlarm_list, phylum_integer };
static enum_phyla kc_subphyla_Flow[] = { phylum_standardElements, phylum_tLink_list, phylum_activity_list, phylum_integer };
static enum_phyla kc_subphyla_ConstLink_list[] = { phylum_tLink, phylum_tLink_list };
static enum_phyla kc_subphyla_Link[] = { phylum_integer };
static enum_phyla kc_subphyla_Scope[] = { phylum_standardElements, phylum_tVariable_list, phylum_tFaultHandlers, phylum_tCompensationHandler, phylum_tTerminationHandler, phylum_tEventHandlers, phylum_tCorrelationSet_list, phylum_activity, phylum_tPartnerLink_list, phylum_integer };
static enum_phyla kc_subphyla_StandardElements[] = { phylum_tTarget_list, phylum_tSource_list, phylum_joinCondition };
static enum_phyla kc_subphyla_ConstTarget_list[] = { phylum_tTarget, phylum_tTarget_list };
static enum_phyla kc_subphyla_Target[] = { phylum_integer };
static enum_phyla kc_subphyla_ConstSource_list[] = { phylum_tSource, phylum_tSource_list };
static enum_phyla kc_subphyla_Source[] = { phylum_integer };
static enum_phyla kc_subphyla_userDefinedJoinCondition[] = { phylum_expression };
static enum_phyla kc_subphyla_Term[] = { phylum_casestring };
static enum_phyla kc_subphyla_Conjunction[] = { phylum_expression, phylum_expression };
static enum_phyla kc_subphyla_Disjunction[] = { phylum_expression, phylum_expression };


KC_OPERATOR_INFO operator_info[] = {
    { "", 0, 0, one_before_first_phylum, 0, 0, 0, 0 }, /* dummy element */
    { "NoCaseStr", 0, true, phylum_nocasestring, 0, 0, 0, sizeof(impl_nocasestring_NoCaseStr) },
    { "_Str", 0, true, phylum_casestring, 0, 0, 0, sizeof(impl_casestring__Str) },
    { "_Real", 0, true, phylum_real, 0, 0, 0, sizeof(impl_real__Real) },
    { "_Int", 0, true, phylum_integer, 0, 0, 0, sizeof(impl_integer__Int) },
    { "_VoidPtr", 0, true, phylum_voidptr, 0, 0, 0, sizeof(impl_voidptr__VoidPtr) },
    { "Process", 8, false, phylum_tProcess, kc_subphyla_Process, 0, 0, sizeof(impl_tProcess_Process) },
    { "activityReceive", 1, false, phylum_activity, kc_subphyla_activityReceive, 0, 0, sizeof(impl_activity_activityReceive) },
    { "activityReply", 1, false, phylum_activity, kc_subphyla_activityReply, 0, 0, sizeof(impl_activity_activityReply) },
    { "activityInvoke", 1, false, phylum_activity, kc_subphyla_activityInvoke, 0, 0, sizeof(impl_activity_activityInvoke) },
    { "activityAssign", 1, false, phylum_activity, kc_subphyla_activityAssign, 0, 0, sizeof(impl_activity_activityAssign) },
    { "activityValidate", 1, false, phylum_activity, kc_subphyla_activityValidate, 0, 0, sizeof(impl_activity_activityValidate) },
    { "activityEmpty", 1, false, phylum_activity, kc_subphyla_activityEmpty, 0, 0, sizeof(impl_activity_activityEmpty) },
    { "activityWait", 1, false, phylum_activity, kc_subphyla_activityWait, 0, 0, sizeof(impl_activity_activityWait) },
    { "activityExit", 1, false, phylum_activity, kc_subphyla_activityExit, 0, 0, sizeof(impl_activity_activityExit) },
    { "activityThrow", 1, false, phylum_activity, kc_subphyla_activityThrow, 0, 0, sizeof(impl_activity_activityThrow) },
    { "activityRethrow", 1, false, phylum_activity, kc_subphyla_activityRethrow, 0, 0, sizeof(impl_activity_activityRethrow) },
    { "activityCompensate", 1, false, phylum_activity, kc_subphyla_activityCompensate, 0, 0, sizeof(impl_activity_activityCompensate) },
    { "activitySequence", 1, false, phylum_activity, kc_subphyla_activitySequence, 0, 0, sizeof(impl_activity_activitySequence) },
    { "activityIf", 1, false, phylum_activity, kc_subphyla_activityIf, 0, 0, sizeof(impl_activity_activityIf) },
    { "activityWhile", 1, false, phylum_activity, kc_subphyla_activityWhile, 0, 0, sizeof(impl_activity_activityWhile) },
    { "activityRepeatUntil", 1, false, phylum_activity, kc_subphyla_activityRepeatUntil, 0, 0, sizeof(impl_activity_activityRepeatUntil) },
    { "activityForEach", 1, false, phylum_activity, kc_subphyla_activityForEach, 0, 0, sizeof(impl_activity_activityForEach) },
    { "activityPick", 1, false, phylum_activity, kc_subphyla_activityPick, 0, 0, sizeof(impl_activity_activityPick) },
    { "activityFlow", 1, false, phylum_activity, kc_subphyla_activityFlow, 0, 0, sizeof(impl_activity_activityFlow) },
    { "activityScope", 1, false, phylum_activity, kc_subphyla_activityScope, 0, 0, sizeof(impl_activity_activityScope) },
    { "Nilactivity_list", 0, false, phylum_activity_list, 0, 0, 0, sizeof(impl_activity_list) },
    { "Consactivity_list", 2, false, phylum_activity_list, kc_subphyla_Consactivity_list, 0, 0, sizeof(impl_activity_list) },
    { "NiltPartnerLink_list", 0, false, phylum_tPartnerLink_list, 0, 0, 0, sizeof(impl_tPartnerLink_list) },
    { "ConstPartnerLink_list", 2, false, phylum_tPartnerLink_list, kc_subphyla_ConstPartnerLink_list, 0, 0, sizeof(impl_tPartnerLink_list) },
    { "PartnerLink", 1, false, phylum_tPartnerLink, kc_subphyla_PartnerLink, 0, 0, sizeof(impl_tPartnerLink_PartnerLink) },
    { "NiltPartner_list", 0, false, phylum_tPartner_list, 0, 0, 0, sizeof(impl_tPartner_list) },
    { "ConstPartner_list", 2, false, phylum_tPartner_list, kc_subphyla_ConstPartner_list, 0, 0, sizeof(impl_tPartner_list) },
    { "Partner", 2, false, phylum_tPartner, kc_subphyla_Partner, 0, 0, sizeof(impl_tPartner_Partner) },
    { "volatile_standardFaultHandlers", 1, false, phylum_tFaultHandlers, kc_subphyla_volatile_standardFaultHandlers, 0, 0, sizeof(impl_tFaultHandlers_volatile_standardFaultHandlers) },
    { "FaultHandlers", 3, false, phylum_tFaultHandlers, kc_subphyla_FaultHandlers, 0, 0, sizeof(impl_tFaultHandlers_FaultHandlers) },
    { "NiltCatch_list", 0, false, phylum_tCatch_list, 0, 0, 0, sizeof(impl_tCatch_list) },
    { "ConstCatch_list", 2, false, phylum_tCatch_list, kc_subphyla_ConstCatch_list, 0, 0, sizeof(impl_tCatch_list) },
    { "Catch", 2, false, phylum_tCatch, kc_subphyla_Catch, 0, 0, sizeof(impl_tCatch_Catch) },
    { "CatchAll", 2, false, phylum_tCatchAll, kc_subphyla_CatchAll, 0, 0, sizeof(impl_tCatchAll_CatchAll) },
    { "NoCatchAll", 0, false, phylum_tCatchAll, 0, 0, 0, sizeof(impl_tCatchAll_NoCatchAll) },
    { "volatile_standardTerminationHandler", 1, false, phylum_tTerminationHandler, kc_subphyla_volatile_standardTerminationHandler, 0, 0, sizeof(impl_tTerminationHandler_volatile_standardTerminationHandler) },
    { "TerminationHandler", 2, false, phylum_tTerminationHandler, kc_subphyla_TerminationHandler, 0, 0, sizeof(impl_tTerminationHandler_TerminationHandler) },
    { "volatile_standardCompensationHandler", 1, false, phylum_tCompensationHandler, kc_subphyla_volatile_standardCompensationHandler, 0, 0, sizeof(impl_tCompensationHandler_volatile_standardCompensationHandler) },
    { "CompensationHandler", 2, false, phylum_tCompensationHandler, kc_subphyla_CompensationHandler, 0, 0, sizeof(impl_tCompensationHandler_CompensationHandler) },
    { "emptyEventHandlers", 1, false, phylum_tEventHandlers, kc_subphyla_emptyEventHandlers, 0, 0, sizeof(impl_tEventHandlers_emptyEventHandlers) },
    { "EventHandlers", 3, false, phylum_tEventHandlers, kc_subphyla_EventHandlers, 0, 0, sizeof(impl_tEventHandlers_EventHandlers) },
    { "NiltOnMessage_list", 0, false, phylum_tOnMessage_list, 0, 0, 0, sizeof(impl_tOnMessage_list) },
    { "ConstOnMessage_list", 2, false, phylum_tOnMessage_list, kc_subphyla_ConstOnMessage_list, 0, 0, sizeof(impl_tOnMessage_list) },
    { "OnMessage", 4, false, phylum_tOnMessage, kc_subphyla_OnMessage, 0, 0, sizeof(impl_tOnMessage_OnMessage) },
    { "NiltOnAlarm_list", 0, false, phylum_tOnAlarm_list, 0, 0, 0, sizeof(impl_tOnAlarm_list) },
    { "ConstOnAlarm_list", 2, false, phylum_tOnAlarm_list, kc_subphyla_ConstOnAlarm_list, 0, 0, sizeof(impl_tOnAlarm_list) },
    { "OnAlarm", 3, false, phylum_tOnAlarm, kc_subphyla_OnAlarm, 0, 0, sizeof(impl_tOnAlarm_OnAlarm) },
    { "emptyRepeatEvery", 1, false, phylum_tRepeatEvery, kc_subphyla_emptyRepeatEvery, 0, 0, sizeof(impl_tRepeatEvery_emptyRepeatEvery) },
    { "RepeatEvery", 1, false, phylum_tRepeatEvery, kc_subphyla_RepeatEvery, 0, 0, sizeof(impl_tRepeatEvery_RepeatEvery) },
    { "NiltVariable_list", 0, false, phylum_tVariable_list, 0, 0, 0, sizeof(impl_tVariable_list) },
    { "ConstVariable_list", 2, false, phylum_tVariable_list, kc_subphyla_ConstVariable_list, 0, 0, sizeof(impl_tVariable_list) },
    { "Variable", 1, false, phylum_tVariable, kc_subphyla_Variable, 0, 0, sizeof(impl_tVariable_Variable) },
    { "NiltCorrelationSet_list", 0, false, phylum_tCorrelationSet_list, 0, 0, 0, sizeof(impl_tCorrelationSet_list) },
    { "ConstCorrelationSet_list", 2, false, phylum_tCorrelationSet_list, kc_subphyla_ConstCorrelationSet_list, 0, 0, sizeof(impl_tCorrelationSet_list) },
    { "CorrelationSet", 1, false, phylum_tCorrelationSet, kc_subphyla_CorrelationSet, 0, 0, sizeof(impl_tCorrelationSet_CorrelationSet) },
    { "NiltCorrelation_list", 0, false, phylum_tCorrelation_list, 0, 0, 0, sizeof(impl_tCorrelation_list) },
    { "ConstCorrelation_list", 2, false, phylum_tCorrelation_list, kc_subphyla_ConstCorrelation_list, 0, 0, sizeof(impl_tCorrelation_list) },
    { "Correlation", 1, false, phylum_tCorrelation, kc_subphyla_Correlation, 0, 0, sizeof(impl_tCorrelation_Correlation) },
    { "NiltToPart_list", 0, false, phylum_tToPart_list, 0, 0, 0, sizeof(impl_tToPart_list) },
    { "ConstToPart_list", 2, false, phylum_tToPart_list, kc_subphyla_ConstToPart_list, 0, 0, sizeof(impl_tToPart_list) },
    { "ToPart", 1, false, phylum_tToPart, kc_subphyla_ToPart, 0, 0, sizeof(impl_tToPart_ToPart) },
    { "NiltFromPart_list", 0, false, phylum_tFromPart_list, 0, 0, 0, sizeof(impl_tFromPart_list) },
    { "ConstFromPart_list", 2, false, phylum_tFromPart_list, kc_subphyla_ConstFromPart_list, 0, 0, sizeof(impl_tFromPart_list) },
    { "FromPart", 1, false, phylum_tFromPart, kc_subphyla_FromPart, 0, 0, sizeof(impl_tFromPart_FromPart) },
    { "Receive", 4, false, phylum_tReceive, kc_subphyla_Receive, 0, 0, sizeof(impl_tReceive_Receive) },
    { "Reply", 4, false, phylum_tReply, kc_subphyla_Reply, 0, 0, sizeof(impl_tReply_Reply) },
    { "volatile_Invoke", 5, false, phylum_tInvoke, kc_subphyla_volatile_Invoke, 0, 0, sizeof(impl_tInvoke_volatile_Invoke) },
    { "SynchronousInvoke", 5, false, phylum_tInvoke, kc_subphyla_SynchronousInvoke, 0, 0, sizeof(impl_tInvoke_SynchronousInvoke) },
    { "AsynchronousInvoke", 5, false, phylum_tInvoke, kc_subphyla_AsynchronousInvoke, 0, 0, sizeof(impl_tInvoke_AsynchronousInvoke) },
    { "volatile_annotatedInvoke", 8, false, phylum_tInvoke, kc_subphyla_volatile_annotatedInvoke, 0, 0, sizeof(impl_tInvoke_volatile_annotatedInvoke) },
    { "Assign", 3, false, phylum_tAssign, kc_subphyla_Assign, 0, 0, sizeof(impl_tAssign_Assign) },
    { "NiltCopy_list", 0, false, phylum_tCopy_list, 0, 0, 0, sizeof(impl_tCopy_list) },
    { "ConstCopy_list", 2, false, phylum_tCopy_list, kc_subphyla_ConstCopy_list, 0, 0, sizeof(impl_tCopy_list) },
    { "Copy", 3, false, phylum_tCopy, kc_subphyla_Copy, 0, 0, sizeof(impl_tCopy_Copy) },
    { "From", 1, false, phylum_tFrom, kc_subphyla_From, 0, 0, sizeof(impl_tFrom_From) },
    { "To", 1, false, phylum_tTo, kc_subphyla_To, 0, 0, sizeof(impl_tTo_To) },
    { "Validate", 2, false, phylum_tValidate, kc_subphyla_Validate, 0, 0, sizeof(impl_tValidate_Validate) },
    { "Empty", 2, false, phylum_tEmpty, kc_subphyla_Empty, 0, 0, sizeof(impl_tEmpty_Empty) },
    { "Wait", 2, false, phylum_tWait, kc_subphyla_Wait, 0, 0, sizeof(impl_tWait_Wait) },
    { "Exit", 2, false, phylum_tExit, kc_subphyla_Exit, 0, 0, sizeof(impl_tExit_Exit) },
    { "Throw", 2, false, phylum_tThrow, kc_subphyla_Throw, 0, 0, sizeof(impl_tThrow_Throw) },
    { "Rethrow", 2, false, phylum_tRethrow, kc_subphyla_Rethrow, 0, 0, sizeof(impl_tRethrow_Rethrow) },
    { "Compensate", 2, false, phylum_tCompensate, kc_subphyla_Compensate, 0, 0, sizeof(impl_tCompensate_Compensate) },
    { "CompensateScope", 3, false, phylum_tCompensate, kc_subphyla_CompensateScope, 0, 0, sizeof(impl_tCompensate_CompensateScope) },
    { "Sequence", 3, false, phylum_tSequence, kc_subphyla_Sequence, 0, 0, sizeof(impl_tSequence_Sequence) },
    { "If", 4, false, phylum_tIf, kc_subphyla_If, 0, 0, sizeof(impl_tIf_If) },
    { "NiltElseIf_list", 0, false, phylum_tElseIf_list, 0, 0, 0, sizeof(impl_tElseIf_list) },
    { "ConstElseIf_list", 2, false, phylum_tElseIf_list, kc_subphyla_ConstElseIf_list, 0, 0, sizeof(impl_tElseIf_list) },
    { "ElseIf", 2, false, phylum_tElseIf, kc_subphyla_ElseIf, 0, 0, sizeof(impl_tElseIf_ElseIf) },
    { "Else", 2, false, phylum_tElse, kc_subphyla_Else, 0, 0, sizeof(impl_tElse_Else) },
    { "NoElse", 1, false, phylum_tElse, kc_subphyla_NoElse, 0, 0, sizeof(impl_tElse_NoElse) },
    { "While", 3, false, phylum_tWhile, kc_subphyla_While, 0, 0, sizeof(impl_tWhile_While) },
    { "RepeatUntil", 3, false, phylum_tRepeatUntil, kc_subphyla_RepeatUntil, 0, 0, sizeof(impl_tRepeatUntil_RepeatUntil) },
    { "ForEach", 6, false, phylum_tForEach, kc_subphyla_ForEach, 0, 0, sizeof(impl_tForEach_ForEach) },
    { "Pick", 4, false, phylum_tPick, kc_subphyla_Pick, 0, 0, sizeof(impl_tPick_Pick) },
    { "Flow", 4, false, phylum_tFlow, kc_subphyla_Flow, 0, 0, sizeof(impl_tFlow_Flow) },
    { "NiltLink_list", 0, false, phylum_tLink_list, 0, 0, 0, sizeof(impl_tLink_list) },
    { "ConstLink_list", 2, false, phylum_tLink_list, kc_subphyla_ConstLink_list, 0, 0, sizeof(impl_tLink_list) },
    { "Link", 1, false, phylum_tLink, kc_subphyla_Link, 0, 0, sizeof(impl_tLink_Link) },
    { "Scope", 10, false, phylum_tScope, kc_subphyla_Scope, 0, 0, sizeof(impl_tScope_Scope) },
    { "StandardElements", 3, false, phylum_standardElements, kc_subphyla_StandardElements, 0, 0, sizeof(impl_standardElements_StandardElements) },
    { "NoStandardElements", 0, false, phylum_standardElements, 0, 0, 0, sizeof(impl_standardElements_NoStandardElements) },
    { "NiltTarget_list", 0, false, phylum_tTarget_list, 0, 0, 0, sizeof(impl_tTarget_list) },
    { "ConstTarget_list", 2, false, phylum_tTarget_list, kc_subphyla_ConstTarget_list, 0, 0, sizeof(impl_tTarget_list) },
    { "Target", 1, false, phylum_tTarget, kc_subphyla_Target, 0, 0, sizeof(impl_tTarget_Target) },
    { "NiltSource_list", 0, false, phylum_tSource_list, 0, 0, 0, sizeof(impl_tSource_list) },
    { "ConstSource_list", 2, false, phylum_tSource_list, kc_subphyla_ConstSource_list, 0, 0, sizeof(impl_tSource_list) },
    { "Source", 1, false, phylum_tSource, kc_subphyla_Source, 0, 0, sizeof(impl_tSource_Source) },
    { "standardJoinCondition", 0, false, phylum_joinCondition, 0, 0, 0, sizeof(impl_joinCondition_standardJoinCondition) },
    { "userDefinedJoinCondition", 1, false, phylum_joinCondition, kc_subphyla_userDefinedJoinCondition, 0, 0, sizeof(impl_joinCondition_userDefinedJoinCondition) },
    { "Term", 1, false, phylum_expression, kc_subphyla_Term, 0, 0, sizeof(impl_expression_Term) },
    { "Conjunction", 2, false, phylum_expression, kc_subphyla_Conjunction, 0, 0, sizeof(impl_expression_Conjunction) },
    { "Disjunction", 2, false, phylum_expression, kc_subphyla_Disjunction, 0, 0, sizeof(impl_expression_Disjunction) },
    { "", 0, 0, one_before_first_phylum, 0, 0, 0, 0 } /* last element */
};

static enum_phyla phylumstorageclass_uniq[] = { one_before_first_phylum, phylum_nocasestring, phylum_casestring, phylum_real, phylum_integer, phylum_voidptr, last_phylum };

KC_UNIQ_INFO kc_UniqInfo[] = {
    (KC_UNIQ_INFO)0,
    phylumstorageclass_uniq
};

} // namespace kc

namespace kc {

void
kc_no_default_in_with( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=A2CT(KC_NO_DEFAULT_IN_WITH);
    const _TCHAR* tkc_func=A2CT(kc_func);
    const _TCHAR* tkc_file=A2CT(kc_file);
    TRACE( format, tkc_func, tkc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, KC_NO_DEFAULT_IN_WITH, kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_returnless_function( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: function %s does not return a value, at %s:%d");
    const _TCHAR* tkc_func=A2CT(kc_func);
    const _TCHAR* tkc_file=A2CT(kc_file);
    TRACE( format, tkc_func, tkc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: function %s does not return a value, at %s:%d", kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionFailed(const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    TRACE( format, tkc_func, kc_l );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d\n", kc_fn, kc_l );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionReasonFailed(const char *kc_fn, int kc_l, const char *kc_s)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at file %s:%d: %s\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s=A2CT(kc_s);
    TRACE( format, tkc_func, kc_l, tkc_s );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at file %s:%d: %s\n", kc_fn, kc_l, kc_s );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionNonNullFailed(const char *kc_fn, int kc_l, const char *kc_str)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s=A2CT(kc_str);
    TRACE( format , tkc_func, kc_l, tkc_s);
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n", kc_fn, kc_l, kc_str );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionOperatorInPhylumFailed(int kc_op, const char *kc_str1, const char *kc_str2, const char *kc_phy, const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s1=A2CT(kc_str1);
    const _TCHAR* tkc_s2=A2CT(kc_str2);
    const _TCHAR* tname=A2CT(kc_phy);
    if ((kc_op <= one_before_first_operator) || (kc_op >= last_operator)) {
	TRACE (format, tkc_func, kc_l, tname, tkc_s1, tkc_s2, kc_op );
    } else {
	format=_T("Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n");
	const _TCHAR* tname2=A2CT(operator_info[kc_op].name);
	const _TCHAR* tname3=A2CT(phylum_info[operator_info[kc_op].phylum].name);
	TRACE(format,tkc_func, kc_l, tname, tkc_s1, tkc_s2, tname2, kc_op, tname3 );
    }
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    if ((kc_op <= one_before_first_operator) || (kc_op >= last_operator)) {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_op );
    } else {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, operator_info[kc_op].name, kc_op, phylum_info[operator_info[kc_op].phylum].name );
    }
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void kc_invalid_operator( const char *kc_func_prefix, enum_phyla kc_phy, int kc_line, const char *kc_file, enum_operators kc_oper )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: invalid operator code in %s%s at %s:%d: %s\n");
    const _TCHAR* tkc_func=A2CT(kc_func_prefix);
    const _TCHAR* tkc_file=A2CT(kc_file);
    const _TCHAR* ts1=A2CT(phylumname_or_error( kc_phy ));
    const _TCHAR* ts2=A2CT(kc_operatorname_or_error( kc_oper ));
    TRACE( format, tkc_func, ts1, tkc_file, kc_line, ts2);
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: invalid operator code in %s%s at %s:%d: %s\n", kc_func_prefix, phylumname_or_error( kc_phy ), kc_file, kc_line, kc_operatorname_or_error( kc_oper ));
#ifndef KC_INVALID_OPERATOR_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}
const enum_phyla impl_nocasestring::phylum_sel_ = phylum_nocasestring;
const enum_phyla impl_casestring::phylum_sel_ = phylum_casestring;
const enum_phyla impl_real::phylum_sel_ = phylum_real;
impl_real__Real::impl_real__Real(REAL _value)
    : value(_value) { }
const enum_phyla impl_integer::phylum_sel_ = phylum_integer;
impl_integer__Int::impl_integer__Int(INTEGER _value)
    : value(_value) { }
const enum_phyla impl_voidptr::phylum_sel_ = phylum_voidptr;
impl_voidptr__VoidPtr::impl_voidptr__VoidPtr(void* _pointer)
    : pointer(_pointer) { }
const enum_phyla impl_tProcess::phylum_sel_ = phylum_tProcess;
const enum_phyla impl_activity::phylum_sel_ = phylum_activity;
const enum_phyla impl_activity_list::phylum_sel_ = phylum_activity_list;
impl_activity_list::impl_activity_list(activity p1 , activity_list p2)
    : activity_1(p1), activity_list_1(p2) { }
const enum_phyla impl_tPartnerLink_list::phylum_sel_ = phylum_tPartnerLink_list;
impl_tPartnerLink_list::impl_tPartnerLink_list(tPartnerLink p1 , tPartnerLink_list p2)
    : tPartnerLink_1(p1), tPartnerLink_list_1(p2) { }
const enum_phyla impl_tPartnerLink::phylum_sel_ = phylum_tPartnerLink;
const enum_phyla impl_tPartner_list::phylum_sel_ = phylum_tPartner_list;
impl_tPartner_list::impl_tPartner_list(tPartner p1 , tPartner_list p2)
    : tPartner_1(p1), tPartner_list_1(p2) { }
const enum_phyla impl_tPartner::phylum_sel_ = phylum_tPartner;
const enum_phyla impl_tFaultHandlers::phylum_sel_ = phylum_tFaultHandlers;
const enum_phyla impl_tCatch_list::phylum_sel_ = phylum_tCatch_list;
impl_tCatch_list::impl_tCatch_list(tCatch p1 , tCatch_list p2)
    : tCatch_1(p1), tCatch_list_1(p2) { }
const enum_phyla impl_tCatch::phylum_sel_ = phylum_tCatch;
const enum_phyla impl_tCatchAll::phylum_sel_ = phylum_tCatchAll;
impl_tCatchAll_NoCatchAll::impl_tCatchAll_NoCatchAll()
    { }
const enum_phyla impl_tTerminationHandler::phylum_sel_ = phylum_tTerminationHandler;
const enum_phyla impl_tCompensationHandler::phylum_sel_ = phylum_tCompensationHandler;
const enum_phyla impl_tEventHandlers::phylum_sel_ = phylum_tEventHandlers;
const enum_phyla impl_tOnMessage_list::phylum_sel_ = phylum_tOnMessage_list;
impl_tOnMessage_list::impl_tOnMessage_list(tOnMessage p1 , tOnMessage_list p2)
    : tOnMessage_1(p1), tOnMessage_list_1(p2) { }
const enum_phyla impl_tOnMessage::phylum_sel_ = phylum_tOnMessage;
const enum_phyla impl_tOnAlarm_list::phylum_sel_ = phylum_tOnAlarm_list;
impl_tOnAlarm_list::impl_tOnAlarm_list(tOnAlarm p1 , tOnAlarm_list p2)
    : tOnAlarm_1(p1), tOnAlarm_list_1(p2) { }
const enum_phyla impl_tOnAlarm::phylum_sel_ = phylum_tOnAlarm;
const enum_phyla impl_tRepeatEvery::phylum_sel_ = phylum_tRepeatEvery;
impl_tRepeatEvery_RepeatEvery::impl_tRepeatEvery_RepeatEvery(integer _integer_1)
    : integer_1(_integer_1) { }
impl_tRepeatEvery_emptyRepeatEvery::impl_tRepeatEvery_emptyRepeatEvery(integer _integer_1)
    : integer_1(_integer_1) { }
const enum_phyla impl_tVariable_list::phylum_sel_ = phylum_tVariable_list;
impl_tVariable_list::impl_tVariable_list(tVariable p1 , tVariable_list p2)
    : tVariable_1(p1), tVariable_list_1(p2) { }
const enum_phyla impl_tVariable::phylum_sel_ = phylum_tVariable;
const enum_phyla impl_tCorrelationSet_list::phylum_sel_ = phylum_tCorrelationSet_list;
impl_tCorrelationSet_list::impl_tCorrelationSet_list(tCorrelationSet p1 , tCorrelationSet_list p2)
    : tCorrelationSet_1(p1), tCorrelationSet_list_1(p2) { }
const enum_phyla impl_tCorrelationSet::phylum_sel_ = phylum_tCorrelationSet;
const enum_phyla impl_tCorrelation_list::phylum_sel_ = phylum_tCorrelation_list;
impl_tCorrelation_list::impl_tCorrelation_list(tCorrelation p1 , tCorrelation_list p2)
    : tCorrelation_1(p1), tCorrelation_list_1(p2) { }
const enum_phyla impl_tCorrelation::phylum_sel_ = phylum_tCorrelation;
const enum_phyla impl_tToPart_list::phylum_sel_ = phylum_tToPart_list;
impl_tToPart_list::impl_tToPart_list(tToPart p1 , tToPart_list p2)
    : tToPart_1(p1), tToPart_list_1(p2) { }
const enum_phyla impl_tToPart::phylum_sel_ = phylum_tToPart;
const enum_phyla impl_tFromPart_list::phylum_sel_ = phylum_tFromPart_list;
impl_tFromPart_list::impl_tFromPart_list(tFromPart p1 , tFromPart_list p2)
    : tFromPart_1(p1), tFromPart_list_1(p2) { }
const enum_phyla impl_tFromPart::phylum_sel_ = phylum_tFromPart;
const enum_phyla impl_tReceive::phylum_sel_ = phylum_tReceive;
const enum_phyla impl_tReply::phylum_sel_ = phylum_tReply;
const enum_phyla impl_tInvoke::phylum_sel_ = phylum_tInvoke;
const enum_phyla impl_tAssign::phylum_sel_ = phylum_tAssign;
const enum_phyla impl_tCopy_list::phylum_sel_ = phylum_tCopy_list;
impl_tCopy_list::impl_tCopy_list(tCopy p1 , tCopy_list p2)
    : tCopy_1(p1), tCopy_list_1(p2) { }
const enum_phyla impl_tCopy::phylum_sel_ = phylum_tCopy;
const enum_phyla impl_tFrom::phylum_sel_ = phylum_tFrom;
const enum_phyla impl_tTo::phylum_sel_ = phylum_tTo;
const enum_phyla impl_tValidate::phylum_sel_ = phylum_tValidate;
const enum_phyla impl_tEmpty::phylum_sel_ = phylum_tEmpty;
const enum_phyla impl_tWait::phylum_sel_ = phylum_tWait;
const enum_phyla impl_tExit::phylum_sel_ = phylum_tExit;
const enum_phyla impl_tThrow::phylum_sel_ = phylum_tThrow;
const enum_phyla impl_tRethrow::phylum_sel_ = phylum_tRethrow;
const enum_phyla impl_tCompensate::phylum_sel_ = phylum_tCompensate;
const enum_phyla impl_tSequence::phylum_sel_ = phylum_tSequence;
const enum_phyla impl_tIf::phylum_sel_ = phylum_tIf;
const enum_phyla impl_tElseIf_list::phylum_sel_ = phylum_tElseIf_list;
impl_tElseIf_list::impl_tElseIf_list(tElseIf p1 , tElseIf_list p2)
    : tElseIf_1(p1), tElseIf_list_1(p2) { }
const enum_phyla impl_tElseIf::phylum_sel_ = phylum_tElseIf;
const enum_phyla impl_tElse::phylum_sel_ = phylum_tElse;
const enum_phyla impl_tWhile::phylum_sel_ = phylum_tWhile;
const enum_phyla impl_tRepeatUntil::phylum_sel_ = phylum_tRepeatUntil;
const enum_phyla impl_tForEach::phylum_sel_ = phylum_tForEach;
const enum_phyla impl_tPick::phylum_sel_ = phylum_tPick;
const enum_phyla impl_tFlow::phylum_sel_ = phylum_tFlow;
const enum_phyla impl_tLink_list::phylum_sel_ = phylum_tLink_list;
impl_tLink_list::impl_tLink_list(tLink p1 , tLink_list p2)
    : tLink_1(p1), tLink_list_1(p2) { }
const enum_phyla impl_tLink::phylum_sel_ = phylum_tLink;
const enum_phyla impl_tScope::phylum_sel_ = phylum_tScope;
const enum_phyla impl_standardElements::phylum_sel_ = phylum_standardElements;
impl_standardElements_NoStandardElements::impl_standardElements_NoStandardElements()
    { }
impl_standardElements_StandardElements::impl_standardElements_StandardElements(tTarget_list _tTarget_list_1, tSource_list _tSource_list_1, joinCondition _joinCondition_1)
    : tTarget_list_1(_tTarget_list_1), tSource_list_1(_tSource_list_1), joinCondition_1(_joinCondition_1) { }
const enum_phyla impl_tTarget_list::phylum_sel_ = phylum_tTarget_list;
impl_tTarget_list::impl_tTarget_list(tTarget p1 , tTarget_list p2)
    : tTarget_1(p1), tTarget_list_1(p2) { }
const enum_phyla impl_tTarget::phylum_sel_ = phylum_tTarget;
const enum_phyla impl_tSource_list::phylum_sel_ = phylum_tSource_list;
impl_tSource_list::impl_tSource_list(tSource p1 , tSource_list p2)
    : tSource_1(p1), tSource_list_1(p2) { }
const enum_phyla impl_tSource::phylum_sel_ = phylum_tSource;
const enum_phyla impl_joinCondition::phylum_sel_ = phylum_joinCondition;
impl_joinCondition_userDefinedJoinCondition::impl_joinCondition_userDefinedJoinCondition(expression _expression_1)
    : expression_1(_expression_1) { }
impl_joinCondition_standardJoinCondition::impl_joinCondition_standardJoinCondition()
    { }
const enum_phyla impl_expression::phylum_sel_ = phylum_expression;
impl_expression_Disjunction::impl_expression_Disjunction(expression _expression_1, expression _expression_2)
    : expression_1(_expression_1), expression_2(_expression_2) { }
impl_expression_Conjunction::impl_expression_Conjunction(expression _expression_1, expression _expression_2)
    : expression_1(_expression_1), expression_2(_expression_2) { }
impl_expression_Term::impl_expression_Term(casestring _casestring_1)
    : casestring_1(_casestring_1) { }

#ifdef KC_STATISTICS
KC_OPERATOR_STATISTICS operator_statistics[KC_NO_OF_OPERATORS];
static int kc_casestring_strlen =0;
static int kc_nocasestring_strlen =0;
#  define KC_COLLECT_STATS0(v) v
#else
#  define KC_COLLECT_STATS0(v)
#endif

#ifndef KC_CREATE_STATS
#  define KC_CREATE_STATS(oper) operator_statistics[oper].created++;
#endif
#ifndef KC_EXISTINGNOTFOUND_STATS
#  define KC_EXISTINGNOTFOUND_STATS(oper) operator_statistics[oper].existing_not_found++;
#endif

#ifndef KC_FREE_CALLED_STATS
#  define KC_FREE_CALLED_STATS(oper,rec) operator_statistics[oper].free_called[(rec?true:false)]++;
#endif

#ifndef KC_FREED_STATS
#  define KC_FREED_STATS(oper,rec) operator_statistics[oper].freed[(rec?true:false)]++;
#endif
static hashtable_struct_t kc_not_uniq_static_hashtable;
static hashtable_struct_t uniq_static_hashtable;

bool kc_storageclass_still_uniq[] = {
    true, true };

hashtable_t hashtables[] = {
    &kc_not_uniq_static_hashtable,
    &uniq_static_hashtable,
};

const char* kc_storageclassnames[] = { "kc_not_uniq", "uniq" };

namespace { // all local to k.cc

standardElements kc_initialize_standardElements(standardElements kc_x)
{
#line 491 "ast-grammar.k"
    kc_x->suppressJF =  false;

#line  2629 "ast-system-k.cc"
    return kc_x;
}

expression kc_initialize_expression(expression kc_x)
{
#line 525 "ast-grammar.k"
    kc_x->value =  false;

#line  2638 "ast-system-k.cc"
    return kc_x;
}


} // namespace

enum_phyla
impl_abstract_phylum::phylum() const {
    return operator_info[prod_sel()].phylum;
}

const char*
impl_abstract_phylum::phylum_name() const {
    return phylum_info[phylum()].name;
}

const char*
impl_abstract_phylum::op_name() const {
    return operator_info[prod_sel()].name;
}

casestring
mkcasestring(const kc_char_t *kc_s, int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Str));

    casestring kc_x=new impl_casestring__Str(kc_s);
    if(length>=0) 
	kc_x->make_own(length);

    casestring unique_kc_x=hashtables[uniq]->ht_check_insert((casestring)kc_x);
    if(unique_kc_x!=kc_x) {
	if(length<0) 
	    kc_x->name=0;

	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Str));
	if(length<0) 
	    kc_x->make_own(static_cast<int>(kc_strlen(kc_s)));

	kc_x->post_create();
    }
    return kc_x;
}

nocasestring
mknocasestring(const kc_char_t *kc_s, int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCaseStr));

    nocasestring kc_x=new impl_nocasestring_NoCaseStr(kc_s);
    if(length>=0)
	kc_x->make_own(length);
    nocasestring unique_kc_x=hashtables[uniq]->ht_check_insert((nocasestring)kc_x);
    if(unique_kc_x!=kc_x) {
	if(length<0)
	    kc_x->name=0;
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCaseStr));
	if(length<0)
	    kc_x->make_own(static_cast<int>(kc_strlen(kc_s)));
	kc_x->post_create();
    }

    return kc_x;
}

integer
mkinteger(const INTEGER kc_i)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Int));

    integer kc_x =new impl_integer__Int(kc_i);
    integer unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Int));
	kc_x->post_create();
    }

    return kc_x;
}

real
mkreal(const REAL kc_r)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Real));

    real kc_x=new impl_real__Real(kc_r);
    real unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Real));
	kc_x->post_create();
    }

    return kc_x;
}

voidptr
mkvoidptr(void *kc_p)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__VoidPtr));
    voidptr kc_x=new impl_voidptr__VoidPtr(kc_p);
    voidptr unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__VoidPtr));
	kc_x->post_create();
    }
    return kc_x;
}

impl_tProcess_Process*
Process(tPartnerLink_list _tPartnerLink_list_1, tPartner_list _tPartner_list_1, tVariable_list _tVariable_list_1, tCorrelationSet_list _tCorrelationSet_list_1, tFaultHandlers _tFaultHandlers_1, tEventHandlers _tEventHandlers_1, activity _activity_1, integer _integer_1) {
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    assertPhylum(_tPartner_list_1, phylum_tPartner_list);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    assertPhylum(_tCorrelationSet_list_1, phylum_tCorrelationSet_list);
    assertPhylum(_tFaultHandlers_1, phylum_tFaultHandlers);
    assertPhylum(_tEventHandlers_1, phylum_tEventHandlers);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tProcess kc_x = new impl_tProcess_Process(_tPartnerLink_list_1, _tPartner_list_1, _tVariable_list_1, _tCorrelationSet_list_1, _tFaultHandlers_1, _tEventHandlers_1, _activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Process));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Process));
    kc_x->post_create();
    return static_cast<impl_tProcess_Process*>(kc_x);
}

impl_activity_activityReceive*
activityReceive(tReceive _tReceive_1) {
    assertPhylum(_tReceive_1, phylum_tReceive);
    activity kc_x = new impl_activity_activityReceive(_tReceive_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityReceive));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityReceive));
    kc_x->post_create();
    return static_cast<impl_activity_activityReceive*>(kc_x);
}

impl_activity_activityReply*
activityReply(tReply _tReply_1) {
    assertPhylum(_tReply_1, phylum_tReply);
    activity kc_x = new impl_activity_activityReply(_tReply_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityReply));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityReply));
    kc_x->post_create();
    return static_cast<impl_activity_activityReply*>(kc_x);
}

impl_activity_activityInvoke*
activityInvoke(tInvoke _tInvoke_1) {
    assertPhylum(_tInvoke_1, phylum_tInvoke);
    activity kc_x = new impl_activity_activityInvoke(_tInvoke_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityInvoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityInvoke));
    kc_x->post_create();
    return static_cast<impl_activity_activityInvoke*>(kc_x);
}

impl_activity_activityAssign*
activityAssign(tAssign _tAssign_1) {
    assertPhylum(_tAssign_1, phylum_tAssign);
    activity kc_x = new impl_activity_activityAssign(_tAssign_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityAssign));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityAssign));
    kc_x->post_create();
    return static_cast<impl_activity_activityAssign*>(kc_x);
}

impl_activity_activityValidate*
activityValidate(tValidate _tValidate_1) {
    assertPhylum(_tValidate_1, phylum_tValidate);
    activity kc_x = new impl_activity_activityValidate(_tValidate_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityValidate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityValidate));
    kc_x->post_create();
    return static_cast<impl_activity_activityValidate*>(kc_x);
}

impl_activity_activityEmpty*
activityEmpty(tEmpty _tEmpty_1) {
    assertPhylum(_tEmpty_1, phylum_tEmpty);
    activity kc_x = new impl_activity_activityEmpty(_tEmpty_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityEmpty));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityEmpty));
    kc_x->post_create();
    return static_cast<impl_activity_activityEmpty*>(kc_x);
}

impl_activity_activityWait*
activityWait(tWait _tWait_1) {
    assertPhylum(_tWait_1, phylum_tWait);
    activity kc_x = new impl_activity_activityWait(_tWait_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityWait));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityWait));
    kc_x->post_create();
    return static_cast<impl_activity_activityWait*>(kc_x);
}

impl_activity_activityExit*
activityExit(tExit _tExit_1) {
    assertPhylum(_tExit_1, phylum_tExit);
    activity kc_x = new impl_activity_activityExit(_tExit_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityExit));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityExit));
    kc_x->post_create();
    return static_cast<impl_activity_activityExit*>(kc_x);
}

impl_activity_activityThrow*
activityThrow(tThrow _tThrow_1) {
    assertPhylum(_tThrow_1, phylum_tThrow);
    activity kc_x = new impl_activity_activityThrow(_tThrow_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityThrow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityThrow));
    kc_x->post_create();
    return static_cast<impl_activity_activityThrow*>(kc_x);
}

impl_activity_activityRethrow*
activityRethrow(tRethrow _tRethrow_1) {
    assertPhylum(_tRethrow_1, phylum_tRethrow);
    activity kc_x = new impl_activity_activityRethrow(_tRethrow_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityRethrow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityRethrow));
    kc_x->post_create();
    return static_cast<impl_activity_activityRethrow*>(kc_x);
}

impl_activity_activityCompensate*
activityCompensate(tCompensate _tCompensate_1) {
    assertPhylum(_tCompensate_1, phylum_tCompensate);
    activity kc_x = new impl_activity_activityCompensate(_tCompensate_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityCompensate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityCompensate));
    kc_x->post_create();
    return static_cast<impl_activity_activityCompensate*>(kc_x);
}

impl_activity_activitySequence*
activitySequence(tSequence _tSequence_1) {
    assertPhylum(_tSequence_1, phylum_tSequence);
    activity kc_x = new impl_activity_activitySequence(_tSequence_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activitySequence));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activitySequence));
    kc_x->post_create();
    return static_cast<impl_activity_activitySequence*>(kc_x);
}

impl_activity_activityIf*
activityIf(tIf _tIf_1) {
    assertPhylum(_tIf_1, phylum_tIf);
    activity kc_x = new impl_activity_activityIf(_tIf_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityIf));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityIf));
    kc_x->post_create();
    return static_cast<impl_activity_activityIf*>(kc_x);
}

impl_activity_activityWhile*
activityWhile(tWhile _tWhile_1) {
    assertPhylum(_tWhile_1, phylum_tWhile);
    activity kc_x = new impl_activity_activityWhile(_tWhile_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityWhile));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityWhile));
    kc_x->post_create();
    return static_cast<impl_activity_activityWhile*>(kc_x);
}

impl_activity_activityRepeatUntil*
activityRepeatUntil(tRepeatUntil _tRepeatUntil_1) {
    assertPhylum(_tRepeatUntil_1, phylum_tRepeatUntil);
    activity kc_x = new impl_activity_activityRepeatUntil(_tRepeatUntil_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityRepeatUntil));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityRepeatUntil));
    kc_x->post_create();
    return static_cast<impl_activity_activityRepeatUntil*>(kc_x);
}

impl_activity_activityForEach*
activityForEach(tForEach _tForEach_1) {
    assertPhylum(_tForEach_1, phylum_tForEach);
    activity kc_x = new impl_activity_activityForEach(_tForEach_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityForEach));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityForEach));
    kc_x->post_create();
    return static_cast<impl_activity_activityForEach*>(kc_x);
}

impl_activity_activityPick*
activityPick(tPick _tPick_1) {
    assertPhylum(_tPick_1, phylum_tPick);
    activity kc_x = new impl_activity_activityPick(_tPick_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityPick));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityPick));
    kc_x->post_create();
    return static_cast<impl_activity_activityPick*>(kc_x);
}

impl_activity_activityFlow*
activityFlow(tFlow _tFlow_1) {
    assertPhylum(_tFlow_1, phylum_tFlow);
    activity kc_x = new impl_activity_activityFlow(_tFlow_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityFlow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityFlow));
    kc_x->post_create();
    return static_cast<impl_activity_activityFlow*>(kc_x);
}

impl_activity_activityScope*
activityScope(tScope _tScope_1) {
    assertPhylum(_tScope_1, phylum_tScope);
    activity kc_x = new impl_activity_activityScope(_tScope_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityScope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityScope));
    kc_x->post_create();
    return static_cast<impl_activity_activityScope*>(kc_x);
}

impl_activity_list*
Nilactivity_list() {
    activity_list kc_x = new impl_activity_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilactivity_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilactivity_list));
    kc_x->post_create();
    return static_cast<impl_activity_list*>(kc_x);
}

impl_activity_list*
Consactivity_list(activity _activity_1, activity_list _activity_list_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_activity_list_1, phylum_activity_list);
    activity_list kc_x = new impl_activity_list(_activity_1, _activity_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consactivity_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consactivity_list));
    kc_x->post_create();
    return static_cast<impl_activity_list*>(kc_x);
}

impl_tPartnerLink_list*
NiltPartnerLink_list() {
    tPartnerLink_list kc_x = new impl_tPartnerLink_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltPartnerLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltPartnerLink_list));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_list*>(kc_x);
}

impl_tPartnerLink_list*
ConstPartnerLink_list(tPartnerLink _tPartnerLink_1, tPartnerLink_list _tPartnerLink_list_1) {
    assertPhylum(_tPartnerLink_1, phylum_tPartnerLink);
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    tPartnerLink_list kc_x = new impl_tPartnerLink_list(_tPartnerLink_1, _tPartnerLink_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstPartnerLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstPartnerLink_list));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_list*>(kc_x);
}

impl_tPartnerLink_PartnerLink*
PartnerLink(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tPartnerLink kc_x = new impl_tPartnerLink_PartnerLink(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PartnerLink));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PartnerLink));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_PartnerLink*>(kc_x);
}

impl_tPartner_list*
NiltPartner_list() {
    tPartner_list kc_x = new impl_tPartner_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltPartner_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltPartner_list));
    kc_x->post_create();
    return static_cast<impl_tPartner_list*>(kc_x);
}

impl_tPartner_list*
ConstPartner_list(tPartner _tPartner_1, tPartner_list _tPartner_list_1) {
    assertPhylum(_tPartner_1, phylum_tPartner);
    assertPhylum(_tPartner_list_1, phylum_tPartner_list);
    tPartner_list kc_x = new impl_tPartner_list(_tPartner_1, _tPartner_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstPartner_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstPartner_list));
    kc_x->post_create();
    return static_cast<impl_tPartner_list*>(kc_x);
}

impl_tPartner_Partner*
Partner(tPartnerLink_list _tPartnerLink_list_1, integer _integer_1) {
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    assertPhylum(_integer_1, phylum_integer);
    tPartner kc_x = new impl_tPartner_Partner(_tPartnerLink_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Partner));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Partner));
    kc_x->post_create();
    return static_cast<impl_tPartner_Partner*>(kc_x);
}

impl_tFaultHandlers_volatile_standardFaultHandlers*
volatile_standardFaultHandlers(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tFaultHandlers kc_x = new impl_tFaultHandlers_volatile_standardFaultHandlers(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_volatile_standardFaultHandlers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_volatile_standardFaultHandlers));
    kc_x->post_create();
    return static_cast<impl_tFaultHandlers_volatile_standardFaultHandlers*>(kc_x);
}

impl_tFaultHandlers_FaultHandlers*
FaultHandlers(tCatch_list _tCatch_list_1, tCatchAll _tCatchAll_1, integer _integer_1) {
    assertPhylum(_tCatch_list_1, phylum_tCatch_list);
    assertPhylum(_tCatchAll_1, phylum_tCatchAll);
    assertPhylum(_integer_1, phylum_integer);
    tFaultHandlers kc_x = new impl_tFaultHandlers_FaultHandlers(_tCatch_list_1, _tCatchAll_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_FaultHandlers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_FaultHandlers));
    kc_x->post_create();
    return static_cast<impl_tFaultHandlers_FaultHandlers*>(kc_x);
}

impl_tCatch_list*
NiltCatch_list() {
    tCatch_list kc_x = new impl_tCatch_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCatch_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCatch_list));
    kc_x->post_create();
    return static_cast<impl_tCatch_list*>(kc_x);
}

impl_tCatch_list*
ConstCatch_list(tCatch _tCatch_1, tCatch_list _tCatch_list_1) {
    assertPhylum(_tCatch_1, phylum_tCatch);
    assertPhylum(_tCatch_list_1, phylum_tCatch_list);
    tCatch_list kc_x = new impl_tCatch_list(_tCatch_1, _tCatch_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCatch_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCatch_list));
    kc_x->post_create();
    return static_cast<impl_tCatch_list*>(kc_x);
}

impl_tCatch_Catch*
Catch(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tCatch kc_x = new impl_tCatch_Catch(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Catch));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Catch));
    kc_x->post_create();
    return static_cast<impl_tCatch_Catch*>(kc_x);
}

impl_tCatchAll_CatchAll*
CatchAll(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tCatchAll kc_x = new impl_tCatchAll_CatchAll(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CatchAll));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CatchAll));
    kc_x->post_create();
    return static_cast<impl_tCatchAll_CatchAll*>(kc_x);
}

impl_tCatchAll_NoCatchAll*
NoCatchAll() {
    tCatchAll kc_x = new impl_tCatchAll_NoCatchAll();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCatchAll));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCatchAll));
    kc_x->post_create();
    return static_cast<impl_tCatchAll_NoCatchAll*>(kc_x);
}

impl_tTerminationHandler_volatile_standardTerminationHandler*
volatile_standardTerminationHandler(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tTerminationHandler kc_x = new impl_tTerminationHandler_volatile_standardTerminationHandler(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_volatile_standardTerminationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_volatile_standardTerminationHandler));
    kc_x->post_create();
    return static_cast<impl_tTerminationHandler_volatile_standardTerminationHandler*>(kc_x);
}

impl_tTerminationHandler_TerminationHandler*
TerminationHandler(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tTerminationHandler kc_x = new impl_tTerminationHandler_TerminationHandler(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_TerminationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_TerminationHandler));
    kc_x->post_create();
    return static_cast<impl_tTerminationHandler_TerminationHandler*>(kc_x);
}

impl_tCompensationHandler_volatile_standardCompensationHandler*
volatile_standardCompensationHandler(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tCompensationHandler kc_x = new impl_tCompensationHandler_volatile_standardCompensationHandler(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_volatile_standardCompensationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_volatile_standardCompensationHandler));
    kc_x->post_create();
    return static_cast<impl_tCompensationHandler_volatile_standardCompensationHandler*>(kc_x);
}

impl_tCompensationHandler_CompensationHandler*
CompensationHandler(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tCompensationHandler kc_x = new impl_tCompensationHandler_CompensationHandler(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CompensationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CompensationHandler));
    kc_x->post_create();
    return static_cast<impl_tCompensationHandler_CompensationHandler*>(kc_x);
}

impl_tEventHandlers_emptyEventHandlers*
emptyEventHandlers(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tEventHandlers kc_x = new impl_tEventHandlers_emptyEventHandlers(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_emptyEventHandlers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_emptyEventHandlers));
    kc_x->post_create();
    return static_cast<impl_tEventHandlers_emptyEventHandlers*>(kc_x);
}

impl_tEventHandlers_EventHandlers*
EventHandlers(tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1, integer _integer_1) {
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    assertPhylum(_integer_1, phylum_integer);
    tEventHandlers kc_x = new impl_tEventHandlers_EventHandlers(_tOnMessage_list_1, _tOnAlarm_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_EventHandlers));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_EventHandlers));
    kc_x->post_create();
    return static_cast<impl_tEventHandlers_EventHandlers*>(kc_x);
}

impl_tOnMessage_list*
NiltOnMessage_list() {
    tOnMessage_list kc_x = new impl_tOnMessage_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltOnMessage_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltOnMessage_list));
    kc_x->post_create();
    return static_cast<impl_tOnMessage_list*>(kc_x);
}

impl_tOnMessage_list*
ConstOnMessage_list(tOnMessage _tOnMessage_1, tOnMessage_list _tOnMessage_list_1) {
    assertPhylum(_tOnMessage_1, phylum_tOnMessage);
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    tOnMessage_list kc_x = new impl_tOnMessage_list(_tOnMessage_1, _tOnMessage_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstOnMessage_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstOnMessage_list));
    kc_x->post_create();
    return static_cast<impl_tOnMessage_list*>(kc_x);
}

impl_tOnMessage_OnMessage*
OnMessage(tCorrelation_list _tCorrelation_list_1, tFromPart_list _tFromPart_list_1, activity _activity_1, integer _integer_1) {
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tOnMessage kc_x = new impl_tOnMessage_OnMessage(_tCorrelation_list_1, _tFromPart_list_1, _activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OnMessage));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OnMessage));
    kc_x->post_create();
    return static_cast<impl_tOnMessage_OnMessage*>(kc_x);
}

impl_tOnAlarm_list*
NiltOnAlarm_list() {
    tOnAlarm_list kc_x = new impl_tOnAlarm_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltOnAlarm_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltOnAlarm_list));
    kc_x->post_create();
    return static_cast<impl_tOnAlarm_list*>(kc_x);
}

impl_tOnAlarm_list*
ConstOnAlarm_list(tOnAlarm _tOnAlarm_1, tOnAlarm_list _tOnAlarm_list_1) {
    assertPhylum(_tOnAlarm_1, phylum_tOnAlarm);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    tOnAlarm_list kc_x = new impl_tOnAlarm_list(_tOnAlarm_1, _tOnAlarm_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstOnAlarm_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstOnAlarm_list));
    kc_x->post_create();
    return static_cast<impl_tOnAlarm_list*>(kc_x);
}

impl_tOnAlarm_OnAlarm*
OnAlarm(tRepeatEvery _tRepeatEvery_1, activity _activity_1, integer _integer_1) {
    assertPhylum(_tRepeatEvery_1, phylum_tRepeatEvery);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tOnAlarm kc_x = new impl_tOnAlarm_OnAlarm(_tRepeatEvery_1, _activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OnAlarm));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OnAlarm));
    kc_x->post_create();
    return static_cast<impl_tOnAlarm_OnAlarm*>(kc_x);
}

impl_tRepeatEvery_emptyRepeatEvery*
emptyRepeatEvery(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tRepeatEvery kc_x = new impl_tRepeatEvery_emptyRepeatEvery(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_emptyRepeatEvery));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_emptyRepeatEvery));
    kc_x->post_create();
    return static_cast<impl_tRepeatEvery_emptyRepeatEvery*>(kc_x);
}

impl_tRepeatEvery_RepeatEvery*
RepeatEvery(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tRepeatEvery kc_x = new impl_tRepeatEvery_RepeatEvery(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_RepeatEvery));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_RepeatEvery));
    kc_x->post_create();
    return static_cast<impl_tRepeatEvery_RepeatEvery*>(kc_x);
}

impl_tVariable_list*
NiltVariable_list() {
    tVariable_list kc_x = new impl_tVariable_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltVariable_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltVariable_list));
    kc_x->post_create();
    return static_cast<impl_tVariable_list*>(kc_x);
}

impl_tVariable_list*
ConstVariable_list(tVariable _tVariable_1, tVariable_list _tVariable_list_1) {
    assertPhylum(_tVariable_1, phylum_tVariable);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    tVariable_list kc_x = new impl_tVariable_list(_tVariable_1, _tVariable_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstVariable_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstVariable_list));
    kc_x->post_create();
    return static_cast<impl_tVariable_list*>(kc_x);
}

impl_tVariable_Variable*
Variable(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tVariable kc_x = new impl_tVariable_Variable(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Variable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Variable));
    kc_x->post_create();
    return static_cast<impl_tVariable_Variable*>(kc_x);
}

impl_tCorrelationSet_list*
NiltCorrelationSet_list() {
    tCorrelationSet_list kc_x = new impl_tCorrelationSet_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCorrelationSet_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCorrelationSet_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_list*>(kc_x);
}

impl_tCorrelationSet_list*
ConstCorrelationSet_list(tCorrelationSet _tCorrelationSet_1, tCorrelationSet_list _tCorrelationSet_list_1) {
    assertPhylum(_tCorrelationSet_1, phylum_tCorrelationSet);
    assertPhylum(_tCorrelationSet_list_1, phylum_tCorrelationSet_list);
    tCorrelationSet_list kc_x = new impl_tCorrelationSet_list(_tCorrelationSet_1, _tCorrelationSet_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCorrelationSet_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCorrelationSet_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_list*>(kc_x);
}

impl_tCorrelationSet_CorrelationSet*
CorrelationSet(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tCorrelationSet kc_x = new impl_tCorrelationSet_CorrelationSet(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CorrelationSet));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CorrelationSet));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_CorrelationSet*>(kc_x);
}

impl_tCorrelation_list*
NiltCorrelation_list() {
    tCorrelation_list kc_x = new impl_tCorrelation_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCorrelation_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCorrelation_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_list*>(kc_x);
}

impl_tCorrelation_list*
ConstCorrelation_list(tCorrelation _tCorrelation_1, tCorrelation_list _tCorrelation_list_1) {
    assertPhylum(_tCorrelation_1, phylum_tCorrelation);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    tCorrelation_list kc_x = new impl_tCorrelation_list(_tCorrelation_1, _tCorrelation_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCorrelation_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCorrelation_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_list*>(kc_x);
}

impl_tCorrelation_Correlation*
Correlation(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tCorrelation kc_x = new impl_tCorrelation_Correlation(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Correlation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Correlation));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_Correlation*>(kc_x);
}

impl_tToPart_list*
NiltToPart_list() {
    tToPart_list kc_x = new impl_tToPart_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltToPart_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltToPart_list));
    kc_x->post_create();
    return static_cast<impl_tToPart_list*>(kc_x);
}

impl_tToPart_list*
ConstToPart_list(tToPart _tToPart_1, tToPart_list _tToPart_list_1) {
    assertPhylum(_tToPart_1, phylum_tToPart);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    tToPart_list kc_x = new impl_tToPart_list(_tToPart_1, _tToPart_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstToPart_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstToPart_list));
    kc_x->post_create();
    return static_cast<impl_tToPart_list*>(kc_x);
}

impl_tToPart_ToPart*
ToPart(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tToPart kc_x = new impl_tToPart_ToPart(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ToPart));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ToPart));
    kc_x->post_create();
    return static_cast<impl_tToPart_ToPart*>(kc_x);
}

impl_tFromPart_list*
NiltFromPart_list() {
    tFromPart_list kc_x = new impl_tFromPart_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltFromPart_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltFromPart_list));
    kc_x->post_create();
    return static_cast<impl_tFromPart_list*>(kc_x);
}

impl_tFromPart_list*
ConstFromPart_list(tFromPart _tFromPart_1, tFromPart_list _tFromPart_list_1) {
    assertPhylum(_tFromPart_1, phylum_tFromPart);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    tFromPart_list kc_x = new impl_tFromPart_list(_tFromPart_1, _tFromPart_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstFromPart_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstFromPart_list));
    kc_x->post_create();
    return static_cast<impl_tFromPart_list*>(kc_x);
}

impl_tFromPart_FromPart*
FromPart(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tFromPart kc_x = new impl_tFromPart_FromPart(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_FromPart));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_FromPart));
    kc_x->post_create();
    return static_cast<impl_tFromPart_FromPart*>(kc_x);
}

impl_tReceive_Receive*
Receive(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tFromPart_list _tFromPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tReceive kc_x = new impl_tReceive_Receive(_standardElements_1, _tCorrelation_list_1, _tFromPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Receive));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Receive));
    kc_x->post_create();
    return static_cast<impl_tReceive_Receive*>(kc_x);
}

impl_tReply_Reply*
Reply(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tToPart_list _tToPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tReply kc_x = new impl_tReply_Reply(_standardElements_1, _tCorrelation_list_1, _tToPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Reply));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Reply));
    kc_x->post_create();
    return static_cast<impl_tReply_Reply*>(kc_x);
}

impl_tInvoke_volatile_Invoke*
volatile_Invoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tToPart_list _tToPart_list_1, tFromPart_list _tFromPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tInvoke kc_x = new impl_tInvoke_volatile_Invoke(_standardElements_1, _tCorrelation_list_1, _tToPart_list_1, _tFromPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_volatile_Invoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_volatile_Invoke));
    kc_x->post_create();
    return static_cast<impl_tInvoke_volatile_Invoke*>(kc_x);
}

impl_tInvoke_SynchronousInvoke*
SynchronousInvoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tToPart_list _tToPart_list_1, tFromPart_list _tFromPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tInvoke kc_x = new impl_tInvoke_SynchronousInvoke(_standardElements_1, _tCorrelation_list_1, _tToPart_list_1, _tFromPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_SynchronousInvoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_SynchronousInvoke));
    kc_x->post_create();
    return static_cast<impl_tInvoke_SynchronousInvoke*>(kc_x);
}

impl_tInvoke_AsynchronousInvoke*
AsynchronousInvoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tToPart_list _tToPart_list_1, tFromPart_list _tFromPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tInvoke kc_x = new impl_tInvoke_AsynchronousInvoke(_standardElements_1, _tCorrelation_list_1, _tToPart_list_1, _tFromPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_AsynchronousInvoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_AsynchronousInvoke));
    kc_x->post_create();
    return static_cast<impl_tInvoke_AsynchronousInvoke*>(kc_x);
}

impl_tInvoke_volatile_annotatedInvoke*
volatile_annotatedInvoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1, tCatch_list _tCatch_list_1, tCatchAll _tCatchAll_1, tCompensationHandler _tCompensationHandler_1, tToPart_list _tToPart_list_1, tFromPart_list _tFromPart_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    assertPhylum(_tCatch_list_1, phylum_tCatch_list);
    assertPhylum(_tCatchAll_1, phylum_tCatchAll);
    assertPhylum(_tCompensationHandler_1, phylum_tCompensationHandler);
    assertPhylum(_tToPart_list_1, phylum_tToPart_list);
    assertPhylum(_tFromPart_list_1, phylum_tFromPart_list);
    assertPhylum(_integer_1, phylum_integer);
    tInvoke kc_x = new impl_tInvoke_volatile_annotatedInvoke(_standardElements_1, _tCorrelation_list_1, _tCatch_list_1, _tCatchAll_1, _tCompensationHandler_1, _tToPart_list_1, _tFromPart_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_volatile_annotatedInvoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_volatile_annotatedInvoke));
    kc_x->post_create();
    return static_cast<impl_tInvoke_volatile_annotatedInvoke*>(kc_x);
}

impl_tAssign_Assign*
Assign(standardElements _standardElements_1, tCopy_list _tCopy_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCopy_list_1, phylum_tCopy_list);
    assertPhylum(_integer_1, phylum_integer);
    tAssign kc_x = new impl_tAssign_Assign(_standardElements_1, _tCopy_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Assign));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Assign));
    kc_x->post_create();
    return static_cast<impl_tAssign_Assign*>(kc_x);
}

impl_tCopy_list*
NiltCopy_list() {
    tCopy_list kc_x = new impl_tCopy_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCopy_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCopy_list));
    kc_x->post_create();
    return static_cast<impl_tCopy_list*>(kc_x);
}

impl_tCopy_list*
ConstCopy_list(tCopy _tCopy_1, tCopy_list _tCopy_list_1) {
    assertPhylum(_tCopy_1, phylum_tCopy);
    assertPhylum(_tCopy_list_1, phylum_tCopy_list);
    tCopy_list kc_x = new impl_tCopy_list(_tCopy_1, _tCopy_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCopy_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCopy_list));
    kc_x->post_create();
    return static_cast<impl_tCopy_list*>(kc_x);
}

impl_tCopy_Copy*
Copy(tFrom _tFrom_1, tTo _tTo_1, integer _integer_1) {
    assertPhylum(_tFrom_1, phylum_tFrom);
    assertPhylum(_tTo_1, phylum_tTo);
    assertPhylum(_integer_1, phylum_integer);
    tCopy kc_x = new impl_tCopy_Copy(_tFrom_1, _tTo_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Copy));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Copy));
    kc_x->post_create();
    return static_cast<impl_tCopy_Copy*>(kc_x);
}

impl_tFrom_From*
From(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tFrom kc_x = new impl_tFrom_From(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_From));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_From));
    kc_x->post_create();
    return static_cast<impl_tFrom_From*>(kc_x);
}

impl_tTo_To*
To(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tTo kc_x = new impl_tTo_To(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_To));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_To));
    kc_x->post_create();
    return static_cast<impl_tTo_To*>(kc_x);
}

impl_tValidate_Validate*
Validate(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tValidate kc_x = new impl_tValidate_Validate(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Validate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Validate));
    kc_x->post_create();
    return static_cast<impl_tValidate_Validate*>(kc_x);
}

impl_tEmpty_Empty*
Empty(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tEmpty kc_x = new impl_tEmpty_Empty(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Empty));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Empty));
    kc_x->post_create();
    return static_cast<impl_tEmpty_Empty*>(kc_x);
}

impl_tWait_Wait*
Wait(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tWait kc_x = new impl_tWait_Wait(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Wait));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Wait));
    kc_x->post_create();
    return static_cast<impl_tWait_Wait*>(kc_x);
}

impl_tExit_Exit*
Exit(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tExit kc_x = new impl_tExit_Exit(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Exit));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Exit));
    kc_x->post_create();
    return static_cast<impl_tExit_Exit*>(kc_x);
}

impl_tThrow_Throw*
Throw(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tThrow kc_x = new impl_tThrow_Throw(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Throw));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Throw));
    kc_x->post_create();
    return static_cast<impl_tThrow_Throw*>(kc_x);
}

impl_tRethrow_Rethrow*
Rethrow(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tRethrow kc_x = new impl_tRethrow_Rethrow(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Rethrow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Rethrow));
    kc_x->post_create();
    return static_cast<impl_tRethrow_Rethrow*>(kc_x);
}

impl_tCompensate_Compensate*
Compensate(standardElements _standardElements_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_integer_1, phylum_integer);
    tCompensate kc_x = new impl_tCompensate_Compensate(_standardElements_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Compensate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Compensate));
    kc_x->post_create();
    return static_cast<impl_tCompensate_Compensate*>(kc_x);
}

impl_tCompensate_CompensateScope*
CompensateScope(standardElements _standardElements_1, casestring _casestring_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_casestring_1, phylum_casestring);
    assertPhylum(_integer_1, phylum_integer);
    tCompensate kc_x = new impl_tCompensate_CompensateScope(_standardElements_1, _casestring_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CompensateScope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CompensateScope));
    kc_x->post_create();
    return static_cast<impl_tCompensate_CompensateScope*>(kc_x);
}

impl_tSequence_Sequence*
Sequence(standardElements _standardElements_1, activity_list _activity_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_activity_list_1, phylum_activity_list);
    assertPhylum(_integer_1, phylum_integer);
    tSequence kc_x = new impl_tSequence_Sequence(_standardElements_1, _activity_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Sequence));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Sequence));
    kc_x->post_create();
    return static_cast<impl_tSequence_Sequence*>(kc_x);
}

impl_tIf_If*
If(standardElements _standardElements_1, tElseIf_list _tElseIf_list_1, tElse _tElse_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tElseIf_list_1, phylum_tElseIf_list);
    assertPhylum(_tElse_1, phylum_tElse);
    assertPhylum(_integer_1, phylum_integer);
    tIf kc_x = new impl_tIf_If(_standardElements_1, _tElseIf_list_1, _tElse_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_If));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_If));
    kc_x->post_create();
    return static_cast<impl_tIf_If*>(kc_x);
}

impl_tElseIf_list*
NiltElseIf_list() {
    tElseIf_list kc_x = new impl_tElseIf_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltElseIf_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltElseIf_list));
    kc_x->post_create();
    return static_cast<impl_tElseIf_list*>(kc_x);
}

impl_tElseIf_list*
ConstElseIf_list(tElseIf _tElseIf_1, tElseIf_list _tElseIf_list_1) {
    assertPhylum(_tElseIf_1, phylum_tElseIf);
    assertPhylum(_tElseIf_list_1, phylum_tElseIf_list);
    tElseIf_list kc_x = new impl_tElseIf_list(_tElseIf_1, _tElseIf_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstElseIf_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstElseIf_list));
    kc_x->post_create();
    return static_cast<impl_tElseIf_list*>(kc_x);
}

impl_tElseIf_ElseIf*
ElseIf(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tElseIf kc_x = new impl_tElseIf_ElseIf(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ElseIf));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ElseIf));
    kc_x->post_create();
    return static_cast<impl_tElseIf_ElseIf*>(kc_x);
}

impl_tElse_Else*
Else(activity _activity_1, integer _integer_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tElse kc_x = new impl_tElse_Else(_activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Else));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Else));
    kc_x->post_create();
    return static_cast<impl_tElse_Else*>(kc_x);
}

impl_tElse_NoElse*
NoElse(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tElse kc_x = new impl_tElse_NoElse(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoElse));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoElse));
    kc_x->post_create();
    return static_cast<impl_tElse_NoElse*>(kc_x);
}

impl_tWhile_While*
While(standardElements _standardElements_1, activity _activity_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tWhile kc_x = new impl_tWhile_While(_standardElements_1, _activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_While));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_While));
    kc_x->post_create();
    return static_cast<impl_tWhile_While*>(kc_x);
}

impl_tRepeatUntil_RepeatUntil*
RepeatUntil(standardElements _standardElements_1, activity _activity_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_integer_1, phylum_integer);
    tRepeatUntil kc_x = new impl_tRepeatUntil_RepeatUntil(_standardElements_1, _activity_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_RepeatUntil));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_RepeatUntil));
    kc_x->post_create();
    return static_cast<impl_tRepeatUntil_RepeatUntil*>(kc_x);
}

impl_tForEach_ForEach*
ForEach(standardElements _standardElements_1, casestring _casestring_1, casestring _casestring_2, casestring _casestring_3, tScope _tScope_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_casestring_1, phylum_casestring);
    assertPhylum(_casestring_2, phylum_casestring);
    assertPhylum(_casestring_3, phylum_casestring);
    assertPhylum(_tScope_1, phylum_tScope);
    assertPhylum(_integer_1, phylum_integer);
    tForEach kc_x = new impl_tForEach_ForEach(_standardElements_1, _casestring_1, _casestring_2, _casestring_3, _tScope_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ForEach));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ForEach));
    kc_x->post_create();
    return static_cast<impl_tForEach_ForEach*>(kc_x);
}

impl_tPick_Pick*
Pick(standardElements _standardElements_1, tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    assertPhylum(_integer_1, phylum_integer);
    tPick kc_x = new impl_tPick_Pick(_standardElements_1, _tOnMessage_list_1, _tOnAlarm_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Pick));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Pick));
    kc_x->post_create();
    return static_cast<impl_tPick_Pick*>(kc_x);
}

impl_tFlow_Flow*
Flow(standardElements _standardElements_1, tLink_list _tLink_list_1, activity_list _activity_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tLink_list_1, phylum_tLink_list);
    assertPhylum(_activity_list_1, phylum_activity_list);
    assertPhylum(_integer_1, phylum_integer);
    tFlow kc_x = new impl_tFlow_Flow(_standardElements_1, _tLink_list_1, _activity_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Flow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Flow));
    kc_x->post_create();
    return static_cast<impl_tFlow_Flow*>(kc_x);
}

impl_tLink_list*
NiltLink_list() {
    tLink_list kc_x = new impl_tLink_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltLink_list));
    kc_x->post_create();
    return static_cast<impl_tLink_list*>(kc_x);
}

impl_tLink_list*
ConstLink_list(tLink _tLink_1, tLink_list _tLink_list_1) {
    assertPhylum(_tLink_1, phylum_tLink);
    assertPhylum(_tLink_list_1, phylum_tLink_list);
    tLink_list kc_x = new impl_tLink_list(_tLink_1, _tLink_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstLink_list));
    kc_x->post_create();
    return static_cast<impl_tLink_list*>(kc_x);
}

impl_tLink_Link*
Link(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tLink kc_x = new impl_tLink_Link(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Link));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Link));
    kc_x->post_create();
    return static_cast<impl_tLink_Link*>(kc_x);
}

impl_tScope_Scope*
Scope(standardElements _standardElements_1, tVariable_list _tVariable_list_1, tFaultHandlers _tFaultHandlers_1, tCompensationHandler _tCompensationHandler_1, tTerminationHandler _tTerminationHandler_1, tEventHandlers _tEventHandlers_1, tCorrelationSet_list _tCorrelationSet_list_1, activity _activity_1, tPartnerLink_list _tPartnerLink_list_1, integer _integer_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    assertPhylum(_tFaultHandlers_1, phylum_tFaultHandlers);
    assertPhylum(_tCompensationHandler_1, phylum_tCompensationHandler);
    assertPhylum(_tTerminationHandler_1, phylum_tTerminationHandler);
    assertPhylum(_tEventHandlers_1, phylum_tEventHandlers);
    assertPhylum(_tCorrelationSet_list_1, phylum_tCorrelationSet_list);
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    assertPhylum(_integer_1, phylum_integer);
    tScope kc_x = new impl_tScope_Scope(_standardElements_1, _tVariable_list_1, _tFaultHandlers_1, _tCompensationHandler_1, _tTerminationHandler_1, _tEventHandlers_1, _tCorrelationSet_list_1, _activity_1, _tPartnerLink_list_1, _integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Scope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Scope));
    kc_x->post_create();
    return static_cast<impl_tScope_Scope*>(kc_x);
}

impl_standardElements_StandardElements*
StandardElements(tTarget_list _tTarget_list_1, tSource_list _tSource_list_1, joinCondition _joinCondition_1) {
    assertPhylum(_tTarget_list_1, phylum_tTarget_list);
    assertPhylum(_tSource_list_1, phylum_tSource_list);
    assertPhylum(_joinCondition_1, phylum_joinCondition);
    standardElements kc_x = new impl_standardElements_StandardElements(_tTarget_list_1, _tSource_list_1, _joinCondition_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_StandardElements));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_StandardElements));
    kc_x->post_create();
    kc_x = kc_initialize_standardElements(kc_x);
    return static_cast<impl_standardElements_StandardElements*>(kc_x);
}

impl_standardElements_NoStandardElements*
NoStandardElements() {
    standardElements kc_x = new impl_standardElements_NoStandardElements();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoStandardElements));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoStandardElements));
    kc_x->post_create();
    kc_x = kc_initialize_standardElements(kc_x);
    return static_cast<impl_standardElements_NoStandardElements*>(kc_x);
}

impl_tTarget_list*
NiltTarget_list() {
    tTarget_list kc_x = new impl_tTarget_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltTarget_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltTarget_list));
    kc_x->post_create();
    return static_cast<impl_tTarget_list*>(kc_x);
}

impl_tTarget_list*
ConstTarget_list(tTarget _tTarget_1, tTarget_list _tTarget_list_1) {
    assertPhylum(_tTarget_1, phylum_tTarget);
    assertPhylum(_tTarget_list_1, phylum_tTarget_list);
    tTarget_list kc_x = new impl_tTarget_list(_tTarget_1, _tTarget_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstTarget_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstTarget_list));
    kc_x->post_create();
    return static_cast<impl_tTarget_list*>(kc_x);
}

impl_tTarget_Target*
Target(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tTarget kc_x = new impl_tTarget_Target(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Target));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Target));
    kc_x->post_create();
    return static_cast<impl_tTarget_Target*>(kc_x);
}

impl_tSource_list*
NiltSource_list() {
    tSource_list kc_x = new impl_tSource_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltSource_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltSource_list));
    kc_x->post_create();
    return static_cast<impl_tSource_list*>(kc_x);
}

impl_tSource_list*
ConstSource_list(tSource _tSource_1, tSource_list _tSource_list_1) {
    assertPhylum(_tSource_1, phylum_tSource);
    assertPhylum(_tSource_list_1, phylum_tSource_list);
    tSource_list kc_x = new impl_tSource_list(_tSource_1, _tSource_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstSource_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstSource_list));
    kc_x->post_create();
    return static_cast<impl_tSource_list*>(kc_x);
}

impl_tSource_Source*
Source(integer _integer_1) {
    assertPhylum(_integer_1, phylum_integer);
    tSource kc_x = new impl_tSource_Source(_integer_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Source));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Source));
    kc_x->post_create();
    return static_cast<impl_tSource_Source*>(kc_x);
}

impl_joinCondition_standardJoinCondition*
standardJoinCondition() {
    joinCondition kc_x = new impl_joinCondition_standardJoinCondition();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_standardJoinCondition));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_standardJoinCondition));
    kc_x->post_create();
    return static_cast<impl_joinCondition_standardJoinCondition*>(kc_x);
}

impl_joinCondition_userDefinedJoinCondition*
userDefinedJoinCondition(expression _expression_1) {
    assertPhylum(_expression_1, phylum_expression);
    joinCondition kc_x = new impl_joinCondition_userDefinedJoinCondition(_expression_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_userDefinedJoinCondition));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_userDefinedJoinCondition));
    kc_x->post_create();
    return static_cast<impl_joinCondition_userDefinedJoinCondition*>(kc_x);
}

impl_expression_Term*
Term(casestring _casestring_1) {
    assertPhylum(_casestring_1, phylum_casestring);
    expression kc_x = new impl_expression_Term(_casestring_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Term));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Term));
    kc_x->post_create();
    kc_x = kc_initialize_expression(kc_x);
    return static_cast<impl_expression_Term*>(kc_x);
}

impl_expression_Conjunction*
Conjunction(expression _expression_1, expression _expression_2) {
    assertPhylum(_expression_1, phylum_expression);
    assertPhylum(_expression_2, phylum_expression);
    expression kc_x = new impl_expression_Conjunction(_expression_1, _expression_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Conjunction));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Conjunction));
    kc_x->post_create();
    kc_x = kc_initialize_expression(kc_x);
    return static_cast<impl_expression_Conjunction*>(kc_x);
}

impl_expression_Disjunction*
Disjunction(expression _expression_1, expression _expression_2) {
    assertPhylum(_expression_1, phylum_expression);
    assertPhylum(_expression_2, phylum_expression);
    expression kc_x = new impl_expression_Disjunction(_expression_1, _expression_2);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Disjunction));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Disjunction));
    kc_x->post_create();
    kc_x = kc_initialize_expression(kc_x);
    return static_cast<impl_expression_Disjunction*>(kc_x);
}


abstract_phylum
kc_create(enum_operators createOp, abstract_phylum kc_p1, abstract_phylum kc_p2, abstract_phylum kc_p3, abstract_phylum kc_p4, abstract_phylum kc_p5, abstract_phylum kc_p6, abstract_phylum kc_p7, abstract_phylum kc_p8, abstract_phylum kc_p9, abstract_phylum kc_p10)
{
    switch(createOp) {
    case sel__VoidPtr:
    case sel__Int:
    case sel__Real:
    case sel__Str:
    case sel_NoCaseStr:
	assertionFailed("Cannot create this kind of phylum - predefined phyla must be handled seperately");break;
    case sel_Disjunction:
	return Disjunction(phylum_cast<expression>(kc_p1), phylum_cast<expression>(kc_p2));
    case sel_Conjunction:
	return Conjunction(phylum_cast<expression>(kc_p1), phylum_cast<expression>(kc_p2));
    case sel_Term:
	return Term(phylum_cast<casestring>(kc_p1));
    case sel_userDefinedJoinCondition:
	return userDefinedJoinCondition(phylum_cast<expression>(kc_p1));
    case sel_standardJoinCondition:
	return standardJoinCondition();
    case sel_Source:
	return Source(phylum_cast<integer>(kc_p1));
    case sel_ConstSource_list:
	return ConstSource_list(phylum_cast<tSource>(kc_p1), phylum_cast<tSource_list>(kc_p2));
    case sel_NiltSource_list:
	return NiltSource_list();
    case sel_Target:
	return Target(phylum_cast<integer>(kc_p1));
    case sel_ConstTarget_list:
	return ConstTarget_list(phylum_cast<tTarget>(kc_p1), phylum_cast<tTarget_list>(kc_p2));
    case sel_NiltTarget_list:
	return NiltTarget_list();
    case sel_NoStandardElements:
	return NoStandardElements();
    case sel_StandardElements:
	return StandardElements(phylum_cast<tTarget_list>(kc_p1), phylum_cast<tSource_list>(kc_p2), phylum_cast<joinCondition>(kc_p3));
    case sel_Scope:
	return Scope(phylum_cast<standardElements>(kc_p1), phylum_cast<tVariable_list>(kc_p2), phylum_cast<tFaultHandlers>(kc_p3), phylum_cast<tCompensationHandler>(kc_p4), phylum_cast<tTerminationHandler>(kc_p5), phylum_cast<tEventHandlers>(kc_p6), phylum_cast<tCorrelationSet_list>(kc_p7), phylum_cast<activity>(kc_p8), phylum_cast<tPartnerLink_list>(kc_p9), phylum_cast<integer>(kc_p10));
    case sel_Link:
	return Link(phylum_cast<integer>(kc_p1));
    case sel_ConstLink_list:
	return ConstLink_list(phylum_cast<tLink>(kc_p1), phylum_cast<tLink_list>(kc_p2));
    case sel_NiltLink_list:
	return NiltLink_list();
    case sel_Flow:
	return Flow(phylum_cast<standardElements>(kc_p1), phylum_cast<tLink_list>(kc_p2), phylum_cast<activity_list>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_Pick:
	return Pick(phylum_cast<standardElements>(kc_p1), phylum_cast<tOnMessage_list>(kc_p2), phylum_cast<tOnAlarm_list>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_ForEach:
	return ForEach(phylum_cast<standardElements>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<casestring>(kc_p3), phylum_cast<casestring>(kc_p4), phylum_cast<tScope>(kc_p5), phylum_cast<integer>(kc_p6));
    case sel_RepeatUntil:
	return RepeatUntil(phylum_cast<standardElements>(kc_p1), phylum_cast<activity>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_While:
	return While(phylum_cast<standardElements>(kc_p1), phylum_cast<activity>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_NoElse:
	return NoElse(phylum_cast<integer>(kc_p1));
    case sel_Else:
	return Else(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_ElseIf:
	return ElseIf(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_ConstElseIf_list:
	return ConstElseIf_list(phylum_cast<tElseIf>(kc_p1), phylum_cast<tElseIf_list>(kc_p2));
    case sel_NiltElseIf_list:
	return NiltElseIf_list();
    case sel_If:
	return If(phylum_cast<standardElements>(kc_p1), phylum_cast<tElseIf_list>(kc_p2), phylum_cast<tElse>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_Sequence:
	return Sequence(phylum_cast<standardElements>(kc_p1), phylum_cast<activity_list>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_CompensateScope:
	return CompensateScope(phylum_cast<standardElements>(kc_p1), phylum_cast<casestring>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_Compensate:
	return Compensate(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Rethrow:
	return Rethrow(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Throw:
	return Throw(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Exit:
	return Exit(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Wait:
	return Wait(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Empty:
	return Empty(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Validate:
	return Validate(phylum_cast<standardElements>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_To:
	return To(phylum_cast<integer>(kc_p1));
    case sel_From:
	return From(phylum_cast<integer>(kc_p1));
    case sel_Copy:
	return Copy(phylum_cast<tFrom>(kc_p1), phylum_cast<tTo>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_ConstCopy_list:
	return ConstCopy_list(phylum_cast<tCopy>(kc_p1), phylum_cast<tCopy_list>(kc_p2));
    case sel_NiltCopy_list:
	return NiltCopy_list();
    case sel_Assign:
	return Assign(phylum_cast<standardElements>(kc_p1), phylum_cast<tCopy_list>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_volatile_annotatedInvoke:
	return volatile_annotatedInvoke(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tCatch_list>(kc_p3), phylum_cast<tCatchAll>(kc_p4), phylum_cast<tCompensationHandler>(kc_p5), phylum_cast<tToPart_list>(kc_p6), phylum_cast<tFromPart_list>(kc_p7), phylum_cast<integer>(kc_p8));
    case sel_AsynchronousInvoke:
	return AsynchronousInvoke(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tToPart_list>(kc_p3), phylum_cast<tFromPart_list>(kc_p4), phylum_cast<integer>(kc_p5));
    case sel_SynchronousInvoke:
	return SynchronousInvoke(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tToPart_list>(kc_p3), phylum_cast<tFromPart_list>(kc_p4), phylum_cast<integer>(kc_p5));
    case sel_volatile_Invoke:
	return volatile_Invoke(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tToPart_list>(kc_p3), phylum_cast<tFromPart_list>(kc_p4), phylum_cast<integer>(kc_p5));
    case sel_Reply:
	return Reply(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tToPart_list>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_Receive:
	return Receive(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2), phylum_cast<tFromPart_list>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_FromPart:
	return FromPart(phylum_cast<integer>(kc_p1));
    case sel_ConstFromPart_list:
	return ConstFromPart_list(phylum_cast<tFromPart>(kc_p1), phylum_cast<tFromPart_list>(kc_p2));
    case sel_NiltFromPart_list:
	return NiltFromPart_list();
    case sel_ToPart:
	return ToPart(phylum_cast<integer>(kc_p1));
    case sel_ConstToPart_list:
	return ConstToPart_list(phylum_cast<tToPart>(kc_p1), phylum_cast<tToPart_list>(kc_p2));
    case sel_NiltToPart_list:
	return NiltToPart_list();
    case sel_Correlation:
	return Correlation(phylum_cast<integer>(kc_p1));
    case sel_ConstCorrelation_list:
	return ConstCorrelation_list(phylum_cast<tCorrelation>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2));
    case sel_NiltCorrelation_list:
	return NiltCorrelation_list();
    case sel_CorrelationSet:
	return CorrelationSet(phylum_cast<integer>(kc_p1));
    case sel_ConstCorrelationSet_list:
	return ConstCorrelationSet_list(phylum_cast<tCorrelationSet>(kc_p1), phylum_cast<tCorrelationSet_list>(kc_p2));
    case sel_NiltCorrelationSet_list:
	return NiltCorrelationSet_list();
    case sel_Variable:
	return Variable(phylum_cast<integer>(kc_p1));
    case sel_ConstVariable_list:
	return ConstVariable_list(phylum_cast<tVariable>(kc_p1), phylum_cast<tVariable_list>(kc_p2));
    case sel_NiltVariable_list:
	return NiltVariable_list();
    case sel_RepeatEvery:
	return RepeatEvery(phylum_cast<integer>(kc_p1));
    case sel_emptyRepeatEvery:
	return emptyRepeatEvery(phylum_cast<integer>(kc_p1));
    case sel_OnAlarm:
	return OnAlarm(phylum_cast<tRepeatEvery>(kc_p1), phylum_cast<activity>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_ConstOnAlarm_list:
	return ConstOnAlarm_list(phylum_cast<tOnAlarm>(kc_p1), phylum_cast<tOnAlarm_list>(kc_p2));
    case sel_NiltOnAlarm_list:
	return NiltOnAlarm_list();
    case sel_OnMessage:
	return OnMessage(phylum_cast<tCorrelation_list>(kc_p1), phylum_cast<tFromPart_list>(kc_p2), phylum_cast<activity>(kc_p3), phylum_cast<integer>(kc_p4));
    case sel_ConstOnMessage_list:
	return ConstOnMessage_list(phylum_cast<tOnMessage>(kc_p1), phylum_cast<tOnMessage_list>(kc_p2));
    case sel_NiltOnMessage_list:
	return NiltOnMessage_list();
    case sel_EventHandlers:
	return EventHandlers(phylum_cast<tOnMessage_list>(kc_p1), phylum_cast<tOnAlarm_list>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_emptyEventHandlers:
	return emptyEventHandlers(phylum_cast<integer>(kc_p1));
    case sel_CompensationHandler:
	return CompensationHandler(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_volatile_standardCompensationHandler:
	return volatile_standardCompensationHandler(phylum_cast<integer>(kc_p1));
    case sel_TerminationHandler:
	return TerminationHandler(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_volatile_standardTerminationHandler:
	return volatile_standardTerminationHandler(phylum_cast<integer>(kc_p1));
    case sel_NoCatchAll:
	return NoCatchAll();
    case sel_CatchAll:
	return CatchAll(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_Catch:
	return Catch(phylum_cast<activity>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_ConstCatch_list:
	return ConstCatch_list(phylum_cast<tCatch>(kc_p1), phylum_cast<tCatch_list>(kc_p2));
    case sel_NiltCatch_list:
	return NiltCatch_list();
    case sel_FaultHandlers:
	return FaultHandlers(phylum_cast<tCatch_list>(kc_p1), phylum_cast<tCatchAll>(kc_p2), phylum_cast<integer>(kc_p3));
    case sel_volatile_standardFaultHandlers:
	return volatile_standardFaultHandlers(phylum_cast<integer>(kc_p1));
    case sel_Partner:
	return Partner(phylum_cast<tPartnerLink_list>(kc_p1), phylum_cast<integer>(kc_p2));
    case sel_ConstPartner_list:
	return ConstPartner_list(phylum_cast<tPartner>(kc_p1), phylum_cast<tPartner_list>(kc_p2));
    case sel_NiltPartner_list:
	return NiltPartner_list();
    case sel_PartnerLink:
	return PartnerLink(phylum_cast<integer>(kc_p1));
    case sel_ConstPartnerLink_list:
	return ConstPartnerLink_list(phylum_cast<tPartnerLink>(kc_p1), phylum_cast<tPartnerLink_list>(kc_p2));
    case sel_NiltPartnerLink_list:
	return NiltPartnerLink_list();
    case sel_Consactivity_list:
	return Consactivity_list(phylum_cast<activity>(kc_p1), phylum_cast<activity_list>(kc_p2));
    case sel_Nilactivity_list:
	return Nilactivity_list();
    case sel_activityScope:
	return activityScope(phylum_cast<tScope>(kc_p1));
    case sel_activityFlow:
	return activityFlow(phylum_cast<tFlow>(kc_p1));
    case sel_activityPick:
	return activityPick(phylum_cast<tPick>(kc_p1));
    case sel_activityForEach:
	return activityForEach(phylum_cast<tForEach>(kc_p1));
    case sel_activityRepeatUntil:
	return activityRepeatUntil(phylum_cast<tRepeatUntil>(kc_p1));
    case sel_activityWhile:
	return activityWhile(phylum_cast<tWhile>(kc_p1));
    case sel_activityIf:
	return activityIf(phylum_cast<tIf>(kc_p1));
    case sel_activitySequence:
	return activitySequence(phylum_cast<tSequence>(kc_p1));
    case sel_activityCompensate:
	return activityCompensate(phylum_cast<tCompensate>(kc_p1));
    case sel_activityRethrow:
	return activityRethrow(phylum_cast<tRethrow>(kc_p1));
    case sel_activityThrow:
	return activityThrow(phylum_cast<tThrow>(kc_p1));
    case sel_activityExit:
	return activityExit(phylum_cast<tExit>(kc_p1));
    case sel_activityWait:
	return activityWait(phylum_cast<tWait>(kc_p1));
    case sel_activityEmpty:
	return activityEmpty(phylum_cast<tEmpty>(kc_p1));
    case sel_activityValidate:
	return activityValidate(phylum_cast<tValidate>(kc_p1));
    case sel_activityAssign:
	return activityAssign(phylum_cast<tAssign>(kc_p1));
    case sel_activityInvoke:
	return activityInvoke(phylum_cast<tInvoke>(kc_p1));
    case sel_activityReply:
	return activityReply(phylum_cast<tReply>(kc_p1));
    case sel_activityReceive:
	return activityReceive(phylum_cast<tReceive>(kc_p1));
    case sel_Process:
	return Process(phylum_cast<tPartnerLink_list>(kc_p1), phylum_cast<tPartner_list>(kc_p2), phylum_cast<tVariable_list>(kc_p3), phylum_cast<tCorrelationSet_list>(kc_p4), phylum_cast<tFaultHandlers>(kc_p5), phylum_cast<tEventHandlers>(kc_p6), phylum_cast<activity>(kc_p7), phylum_cast<integer>(kc_p8));
    default:
	assertionFailed("Cannot create this kind of phylum - unkown operator id");
    }
    NORETURN
}

abstract_phylum
kc_create(enum_operators createOp, const std::vector<abstract_phylum>& kc_ps)
{
    if (kc_ps.size() < 10) {
	assertionFailed("Need vector of size of maximum subphylum count (which is 10)!");
    }
    return kc_create(createOp, kc_ps[0], kc_ps[1], kc_ps[2], kc_ps[3], kc_ps[4], kc_ps[5], kc_ps[6], kc_ps[7], kc_ps[8], kc_ps[9]);
}

abstract_phylum&
attributeOf(abstract_phylum kc_p, int no)
{
    assertionFailed("Cannot select attribute for this kind of phylum - has no attributes");
    NORETURN
}

abstract_phylum
impl_abstract_phylum::subphylum(int) const
{
    return 0;
}

void
impl_abstract_phylum::set_subphylum(int,abstract_phylum)
{
}

void
impl_abstract_phylum::free(bool kc_rec)
{
    KC_COLLECT_STATS0(KC_FREE_CALLED_STATS(prod_sel(), kc_rec));
    if (!phylum_info[phylum()].uniq_stored) {
	if (kc_rec) {
	    abstract_phylum son;
	    for (int kc_i=0; (son = subphylum(kc_i)); kc_i++)
	    {
		if (son!=0) son->free(kc_rec);
		son=0;
	    }
	}
	KC_COLLECT_STATS0(KC_FREED_STATS(prod_sel(), kc_rec));
	delete this;
    }
}

bool
impl_abstract_phylum::eq(c_abstract_phylum kc_p2) const
{
    if (this == kc_p2)
	return true;
    if (prod_sel() != kc_p2->prod_sel())
	return false;

    int kc_st = phylum_info[phylum()].uniq_stored;
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return false;

    c_abstract_phylum son1;
    for (int kc_i=0; (son1 = subphylum(kc_i)); kc_i++) {
	if (!son1->eq(kc_p2->subphylum(kc_i)))
	    return false;
    }

    return true;
}

static string kc_indentation = "";
static const char *kc_printformat_not_nullary_open = "%s%s(\n";
static const char *kc_printformat_list_open = "%s%s\n";

static const char *kc_printformat_not_nullary_close = "%s)\n";
static const char *kc_printformat_nullary = "%s%s()\n";

void
impl_abstract_phylum::fprint(FILE*kc_f)
{
    int kc_i;

    if (!kc_f) kc_f = stdout;
    abstract_list al = dynamic_cast<abstract_list>(this);
    if (al != 0 && !al->is_nil()) {
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	phylum_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
    } else // not list
	switch(phylum()) {
	case phylum_voidptr:
	    fprintf(kc_f, "%s%p\n", kc_indentation.c_str(), static_cast<voidptr>(this)->pointer);
	    break;
	case phylum_casestring:
	case phylum_nocasestring:
	    fprintf(kc_f, "%s%s\n", kc_indentation.c_str(), static_cast<casestring>(this)->name);
	    break;
	case phylum_integer:
	    fprintf(kc_f, "%s%i\n", kc_indentation.c_str(), static_cast<integer>(this)->value);
	    break;
	case phylum_real:
	    fprintf(kc_f, "%s%f\n", kc_indentation.c_str(), static_cast<real>(this)->value);
	    break;
	default:
	    if (!subphylum(0)) {
		fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
	    } else {
		fprintf(kc_f, kc_printformat_not_nullary_open, kc_indentation.c_str(), op_name());
		kc_indentation+="  ";
		abstract_phylum son;
		for (kc_i=0; (son = subphylum(kc_i)); kc_i++) {
		    son->fprint(kc_f);
		}
		kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
		fprintf(kc_f, kc_printformat_not_nullary_close, kc_indentation.c_str());
	    }
    }
}

void 
impl_abstract_phylum::print()
{
    fprint(stdout);
}

void 
impl_abstract_list::fprint_list(FILE*kc_f)
{
    if (!kc_f)
	kc_f = stdout;
    if (this->is_nil()) {
	kc_indentation+="`-";
	fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
    } else {
	kc_indentation+="|-";
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	phylum_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
    }
}

int
impl_abstract_list::length() const
{
    int kc_length = 0;
    c_abstract_phylum kc_p = this;
    while((kc_p = kc_p->subphylum(1)))
	kc_length++;
    return kc_length;
}
void impl_abstract_list::freelist()
{
    abstract_phylum kc_p = this, kc_tmp_p;
    do {
	kc_tmp_p=kc_p->subphylum(1);
	kc_p->free(false);
	kc_p=kc_tmp_p;
    } while(kc_p);
}
abstract_phylum
impl_abstract_list::do_concat(c_abstract_phylum kc_p2, enum_operators mk) const
{
    abstract_phylum next = subphylum(1);
    if(!next)
	return const_cast<abstract_phylum>(kc_p2);
    return kc_create(mk, subphylum(0), static_cast<abstract_list>(next)->do_concat(kc_p2, mk));
}

abstract_phylum
impl_abstract_list::do_reverse(c_abstract_phylum tail, enum_operators mk) const
{
    for (impl_abstract_list const* iterator_ = this; iterator_->subphylum(1) != 0;
	iterator_ = static_cast<impl_abstract_list const*>(iterator_->subphylum(1)) )
    tail = kc_create(mk, iterator_->subphylum(0), const_cast<abstract_phylum>(tail));
    return const_cast<abstract_phylum>(tail);
}

abstract_phylum
impl_abstract_list::last() const
{
    c_abstract_phylum kc_p = this, next = subphylum(1), nextnext;
#ifdef _AFX
    ASSERT(next);
    if(!next)
	return NULL;
#else
    if(!next){
	fflush(stdout);
	fprintf(stderr, "Internal Error: list::last was called with argument Nil%s\n", phylum_name());
	exit(1);
    }
#endif
    while ((nextnext = next->subphylum(1))) {
	kc_p = next;
	next = nextnext;
    }
    return const_cast<abstract_phylum>(kc_p->subphylum(0));/* XXX remove cast */
}

abstract_phylum
impl_abstract_list::do_map(abstract_phylum (*kc_fp)(abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_create(mk, kc_fp(el), next->do_map(kc_fp, mk));
}

abstract_phylum
impl_abstract_list::do_filter(bool (*kc_fp)(abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    if ((*kc_fp)(el)) {
	return kc_create(mk, el, next->do_filter(kc_fp, mk));
    } else {
	return next->do_filter(kc_fp, mk);
    }
}

abstract_list
impl_abstract_list::do_append(abstract_phylum new_last, abstract_list eol)
{
    abstract_list next = this;
    while (!next->is_nil())
	next = phylum_cast<abstract_list>(next->subphylum(1));
    next->set_subphylum(0, new_last);
    next->set_subphylum(1, eol);
    return next;
}

abstract_phylum
impl_abstract_list::do_merge(abstract_list second,abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_phylum el2 = second->subphylum(0);
    if (!el2)
	return el2;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    abstract_list next2 = static_cast<abstract_list>(second->subphylum(1));
    return kc_create(mk, kc_fp(el,el2), next->do_merge(next2, kc_fp, mk));
}

abstract_phylum
impl_abstract_list::do_reduce(abstract_phylum neutral, abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum)) {
    abstract_phylum el = subphylum(0);
    if (!el)
	return neutral;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_fp(el,next->do_reduce(neutral,kc_fp));
}


extern const char* kc_storageclassnames[];

#ifdef KC_STATISTICS
void do_print_operator_statistics(FILE * kc_f)
{
    unsigned int kc_i;
    assertNonNull( kc_f );
    fprintf(kc_f, "%-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s\n", 38 , "Operator", 3, "Sz", 8, "#oper", 8, "#new", 8, "#exist", 8, "#frnrec", 8, "#frrec", 8, "#freed", 8, "#rem", 9, "total (bytes)");
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case sensitive strings", 3, "-", 8, operator_statistics[sel__Str].created, 8, operator_statistics[sel__Str].existing_not_found, 8, operator_statistics[sel__Str].created-operator_statistics[sel__Str].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_casestring_strlen);
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case insensitive strings", 3, "-", 8, operator_statistics[sel_NoCaseStr].created, 8, operator_statistics[sel_NoCaseStr].existing_not_found, 8, operator_statistics[sel_NoCaseStr].created-operator_statistics[sel_NoCaseStr].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_nocasestring_strlen);
    for (kc_i = one_before_first_operator+1; kc_i < last_operator; kc_i++) {
	fprintf(kc_f, "%-*s|%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, operator_info[kc_i].name, 3, operator_info[kc_i].size, 8, operator_statistics[kc_i].created, 8, operator_statistics[kc_i].existing_not_found, 8, operator_statistics[kc_i].created-operator_statistics[kc_i].existing_not_found, 8, operator_statistics[kc_i].free_called[false], 8, operator_statistics[kc_i].free_called[true], 8, operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true], 8, operator_statistics[kc_i].existing_not_found-(operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true]), 9, operator_info[kc_i].size*(operator_statistics[kc_i].existing_not_found-(operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true])));
    }
}
#endif // KC_STATISTICS


void
ht_static(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_static();
}

void
ht_dynamic(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_dynamic();
}

void
ht_inc_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_inc_level();
}

void
ht_dec_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_dec_level();
}

void
ht_free_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_free_level();
}

hashtable_t
ht_create_simple()
{
    hashtable_t kc_ht=new hashtable_struct_t;
    kc_ht->set_to_be_freed();
    return kc_ht;
}

hashtable_t
ht_assign(hashtable_t kc_a_hashtable_t, kc_storageclass_t kc_a_storageclass_t, bool still_unique)
{
    hashtable_t kc_tmp = hashtables[kc_a_storageclass_t];
    hashtables[kc_a_storageclass_t] = kc_a_hashtable_t;
    kc_storageclass_still_uniq[kc_a_storageclass_t] = still_unique;
    return kc_tmp;
}

hashtable_t
ht_assigned(kc_storageclass_t kc_a_storageclass_t)
{
    return hashtables[kc_a_storageclass_t];
}

void
ht_clear(hashtable_t kc_a_hashtable_t)
{
    kc_a_hashtable_t->ht_clear();
}

void
ht_delete(hashtable_t kc_a_hashtable_t)
{
    if(kc_a_hashtable_t->to_be_freed())
	delete kc_a_hashtable_t;
}
const char*
phylumname_or_error(enum_phyla kc_phy)
{
    if ((kc_phy <= one_before_first_phylum) || (kc_phy >= last_phylum)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[69]), "Internal Error: unknown phylum number: %d", kc_phy);
	return kc_strof_error;
    } else {
	return phylum_info[kc_phy].name;
    }   }


const char*
kc_operatorname_or_error(enum_operators kc_operator)
{
    if ((kc_operator <= one_before_first_operator) || (kc_operator >= last_operator)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[71]), "Internal Error: unknown operator number: %d", kc_operator);
	return kc_strof_error;
    } else {
	return operator_info[kc_operator].name;
    }   }


#ifndef KC_PRINTDOT_LABELSIZE
# define KC_PRINTDOT_LABELSIZE 1023
#endif

class impl_kc_dotedgenode_t
{
    public:
    impl_kc_dotedgenode_t(c_abstract_phylum from,c_abstract_phylum to, int _son_nr):
    ptr_from(from), ptr_to(to), son_nr(_son_nr), label(0), lsize(0), next(0) { }
    c_abstract_phylum ptr_from;
    c_abstract_phylum ptr_to;
    int son_nr;
    char *label;
    int lsize;
    kc_dotedgenode_t next;
};

static kc_dotedgenode_t
kc_mkdotedgenode(struct kc_dotedge_ht*, c_abstract_phylum, c_abstract_phylum, int);
static void kc_do_printdot_do_add_edge (c_abstract_phylum, c_abstract_phylum, int, int*, kc_dotedgenode_t*, const char*);
static void kc_do_printdot_subgraph_prologue (FILE*, c_abstract_phylum, const char*, const char*, bool, bool);
static void kc_do_printdot_subgraph_epilogue (FILE*);
static void kc_do_printdot_genfields (FILE*, int, bool);
static void kc_do_printdot_edges (FILE*, kc_dotedgenode_t, const char*, bool);

static bool
kc_dotedge_less(kc_dotedgenode_t p1, kc_dotedgenode_t p2)
{
    if(p2==0)
	return false;
    if(p1==0)
	return true;
    if(p1->ptr_from<p2->ptr_from)
	return true;
    if(p1->ptr_from>p2->ptr_from)
	return false;
    if(p1->ptr_to<p2->ptr_to)
	return true;
    if(p1->ptr_to>p2->ptr_to)
	return false;
    if(p1->son_nr<p2->son_nr)
	return true;
    // OPERATORHASH((unsigned) kc_phy_from);
    // OPERATORHASH((unsigned) kc_phy_to);
    return false;
}

template<typename T>
struct dotedge_less : std::binary_function<T, T, bool> {
    bool operator()(const T& X, const T& Y) const { return kc_dotedge_less(X,Y); }
};

struct kc_dotedge_ht: public std::set<kc_dotedgenode_t, dotedge_less<kc_dotedgenode_t> > {
    ~kc_dotedge_ht() {
	for(iterator i=begin();i!=end();++i)
	delete const_cast<kc_dotedgenode_t>(*i);
	clear();
    }
    kc_dotedgenode_t check_insert(kc_dotedgenode_t t) {
	std::pair<iterator,bool> res=insert(t);
	return *res.first;
    }
};

static kc_dotedge_ht* fprintdot_hashtable;
void impl_nocasestring::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_casestring::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_real::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_integer::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_voidptr::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tProcess::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_activity::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_activity_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tPartnerLink_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tPartnerLink::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tPartner_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tPartner::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tFaultHandlers::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCatch_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCatch::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCatchAll::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tTerminationHandler::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCompensationHandler::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tEventHandlers::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tOnMessage_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tOnMessage::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tOnAlarm_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tOnAlarm::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tRepeatEvery::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tVariable_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tVariable::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCorrelationSet_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCorrelationSet::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCorrelation_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCorrelation::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tToPart_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tToPart::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tFromPart_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tFromPart::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tReceive::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tReply::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tInvoke::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tAssign::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCopy_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCopy::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tFrom::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tTo::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tValidate::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tEmpty::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tWait::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tExit::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tThrow::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tRethrow::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tCompensate::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tSequence::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tIf::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tElseIf_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tElseIf::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tElse::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tWhile::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tRepeatUntil::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tForEach::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tPick::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tFlow::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tLink_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tLink::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tScope::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_standardElements::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tTarget_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tTarget::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tSource_list::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_tSource::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_joinCondition::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}
void impl_expression::fprintdot(FILE *f, const char *root_label_prefix, const char *edge_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves, bool print_prologue_and_epilogue) const
{
    int kc_edge_nr = 1;
    kc_dotedgenode_t kc_edges = 0;
    if (print_prologue_and_epilogue) fprintdotprologue(f);
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_prologue(f, this, root_label_prefix, edge_attributes, print_node_labels, use_context_when_sharing_leaves);
    fprintdot_hashtable = new kc_dotedge_ht;
    do_printdot(f, true, &kc_edge_nr, &kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, 0, 0);
    kc_do_printdot_edges(f, kc_edges, edge_attributes, use_context_when_sharing_leaves);
    delete fprintdot_hashtable;
    fprintdot_hashtable=0;
    /*if (kc_outmost)*/ kc_do_printdot_subgraph_epilogue(f);
    if (print_prologue_and_epilogue) fprintdotepilogue(f);
}


kc_dotedgenode_t
kc_mkdotedgenode(kc_dotedge_ht* kc_a_ht, c_abstract_phylum kc_s_from, c_abstract_phylum kc_s_to, int kc_son_nr)
{
    kc_dotedgenode_t kc_x = new impl_kc_dotedgenode_t(kc_s_from,kc_s_to,kc_son_nr);
    kc_dotedgenode_t unique_kc_x=kc_a_ht->check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    }
    return kc_x;
}

void kc_do_printdot_subgraph_prologue(FILE *kc_f, c_abstract_phylum kc_p, const char *root_label_prefix, const char *edge_attributes, bool print_node_labels, bool use_context_when_sharing_leaves)
{
    if (!kc_f) kc_f = stdout;
    fprintf(kc_f, "/*subgraph*/ {\n");
    if (root_label_prefix) {
	fprintf(kc_f, "\"%s\" [shape=ellipse", root_label_prefix);
	if (edge_attributes && (strlen(edge_attributes) > 0)) {
	    fprintf(kc_f, ", %s", edge_attributes);
	}
	if (print_node_labels) {
	    fprintf(kc_f, ", label=\"%s\\n%s\"", root_label_prefix, phylum_info[kc_p->phylum()].name);
	}
	fprintf(kc_f, "];\n");
	fprintf(kc_f, "\"%s\" ->", root_label_prefix);
	kc_p->do_printdot_id(kc_f, use_context_when_sharing_leaves, 0, 0);
	if (edge_attributes && (strlen(edge_attributes) > 0)) {
	    fprintf(kc_f, "[%s]", edge_attributes);
	}
	fprintf(kc_f, ";\n");
    }
}

void kc_do_printdot_subgraph_epilogue(FILE *kc_f)
{
    if (!kc_f) kc_f = stdout;
    fprintf(kc_f, "}\n");
}

void fprintdotprologue(FILE *kc_f)
{
    if (!kc_f) kc_f = stdout;
    fprintf(kc_f, "digraph kc_output{\n");
    fprintf(kc_f, "node [shape=record, height=.1, fontname=Helvetica];\n");
}

void fprintdotepilogue(FILE *kc_f)
{
    if (!kc_f) kc_f = stdout;
    fprintf(kc_f, "}\n");
}

void kc_do_printdot_genfields(FILE *kc_f, int kc_prodsel, bool print_node_labels)
{
    int kc_i = 1;
    KC_OPERATOR_INFO *kc_op_info = &operator_info[kc_prodsel];
    if (kc_op_info->no_sons <= 0) return;
    if (!kc_f) kc_f = stdout;
    while(kc_i < kc_op_info->no_sons) {
	fprintf(kc_f, "<f%d>", kc_i);
	if (print_node_labels) {
	    fprintf(kc_f, "%s", phylum_info[kc_op_info->subphylum[kc_i-1]].name);
	}
	fprintf(kc_f, "|");
	kc_i++;
    }
    fprintf(kc_f, "<f%d>", kc_i);
    if (print_node_labels) {
	fprintf(kc_f, "%s", phylum_info[kc_op_info->subphylum[kc_i-1]].name);
    }
}

void impl_abstract_phylum::do_printdot_id(FILE *kc_f, bool use_context_when_sharing_leaves, c_abstract_phylum kc_ctxt, int kc_son_nr) const
{
    // The casts only make unique ids, so reinterpret_cast is alright
    if (!kc_f) kc_f = stdout;
    enum_phyla kc_phy = phylum();
    if (kc_phy == phylum_voidptr) {
	fprintf(kc_f, "kcidp%x", reinterpret_cast<int>(this));
	if (use_context_when_sharing_leaves) {
	    fprintf(kc_f, "_%x_%d", reinterpret_cast<int>(kc_ctxt), kc_son_nr);
	}
    } else if ((kc_phy == phylum_casestring) || (kc_phy == phylum_nocasestring)) {
	fprintf(kc_f, "kcids%x", reinterpret_cast<int>(this));
	if (use_context_when_sharing_leaves) {
	    fprintf(kc_f, "_%x_%d", reinterpret_cast<int>(kc_ctxt), kc_son_nr);
	}
    } else if (kc_phy == phylum_integer) {
	fprintf(kc_f, "kcidi%x", reinterpret_cast<int>(this));
	if (use_context_when_sharing_leaves) {
	    fprintf(kc_f, "_%x_%d", reinterpret_cast<int>(kc_ctxt), kc_son_nr);
	}
    } else if (kc_phy == phylum_real) {
	fprintf(kc_f, "kcidf%x", reinterpret_cast<int>(this));
	if (use_context_when_sharing_leaves) {
	    fprintf(kc_f, "_%x_%d", reinterpret_cast<int>(kc_ctxt), kc_son_nr);
	}
    } else {
	fprintf(kc_f, "kcidx%x", reinterpret_cast<int>(this));
    }   }

void kc_do_printdot_do_add_edge(c_abstract_phylum kc_p, c_abstract_phylum kc_sub_p, int kc_son_nr, int *kc_edge_nr, kc_dotedgenode_t *kc_edges, const char *edge_label_prefix)
{
    kc_dotedgenode_t kc_hn;
    char kc_buf[30];
    kc_hn = kc_mkdotedgenode(fprintdot_hashtable, kc_p, kc_sub_p, kc_son_nr);
    if (! kc_hn->label) {
	kc_hn->label = new char[(size_t)(KC_PRINTDOT_LABELSIZE+1)];
	kc_hn->lsize = KC_PRINTDOT_LABELSIZE;
	strcpy(kc_hn->label, "");
	kc_hn->next = *kc_edges;
	*kc_edges = kc_hn;
    } else {
	char kc_buf2[30];
	sprintf(kc_buf2, ", ");
	strncat(kc_hn->label, kc_buf2, kc_hn->lsize - strlen(kc_hn->label));
    }
    if (edge_label_prefix) {
	strncat(kc_hn->label, edge_label_prefix, kc_hn->lsize - strlen(kc_hn->label));
    }
    sprintf(kc_buf, "%d", *kc_edge_nr);
    strncat(kc_hn->label, kc_buf, kc_hn->lsize - strlen(kc_hn->label));
    (*kc_edge_nr)++;
}

void impl_abstract_phylum::printdot_add_edge(c_abstract_phylum kc_sub_p, int kc_son_nr, int *kc_edge_nr, kc_dotedgenode_t *kc_edges, const char *edge_label_prefix) const
{
    kc_do_printdot_do_add_edge(this, kc_sub_p, kc_son_nr, kc_edge_nr, kc_edges, edge_label_prefix);
}

void kc_do_printdot_edges(FILE *kc_f, kc_dotedgenode_t kc_edges, const char *edge_attributes, bool use_context_when_sharing_leaves)
{
    kc_dotedgenode_t kc_p = kc_edges;
    if (!kc_f) kc_f = stdout;
    while(kc_p) {
	kc_p->ptr_from->do_printdot_id(kc_f, use_context_when_sharing_leaves, 0, 0);
	fprintf(kc_f, ":f%d -> ", kc_p->son_nr);
	kc_p->ptr_to->do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_p->ptr_from, kc_p->son_nr);
	fprintf(kc_f, " [label=\"%s\"", kc_p->label);
	if (edge_attributes && (strlen(edge_attributes) > 0)) {
	    fprintf(kc_f, ", %s", edge_attributes);
	}
	fprintf(kc_f, "];\n");
	kc_p = kc_p->next;
    }   }

void impl_abstract_phylum::do_printdot(FILE *kc_f, bool kc_outmost, int *kc_edge_nr, kc_dotedgenode_t *kc_edges, const char *edge_label_prefix, bool print_node_labels, bool use_context_when_sharing_leaves, c_abstract_phylum kc_ctxt, int kc_son_nr) const
{
    int kc_i;

    if (!kc_f) kc_f = stdout;
    switch(phylum()) {
	case phylum_voidptr:
	do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
	fprintf(kc_f, " [label=\"%p\", shape=ellipse];\n", dynamic_cast<c_voidptr>(this)->pointer);
	break;
	case phylum_casestring:
	case phylum_nocasestring:
	do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
#ifdef KC_UNICODE
	fprintf(kc_f, " [label=\"%s\", shape=ellipse];\n", kc_to_cstring(static_cast<c_casestring>(this)->name).c_str());
#else
	fprintf(kc_f, " [label=\"%s\", shape=ellipse];\n", static_cast<c_casestring>(this)->name);
#endif
	break;
	case phylum_integer:
	do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
	fprintf(kc_f, " [label=\"%i\", shape=ellipse];\n", ((integer)this)->value);
	break;
	case phylum_real:
	do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
	fprintf(kc_f, " [label=\"%f\", shape=ellipse];\n", ((real)this)->value);
	break;
	default:
	if (!subphylum(0)) {
	    do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
	    fprintf(kc_f, " [label=\"<f0>%s\"];\n", op_name());
	} else {
	    do_printdot_id(kc_f, use_context_when_sharing_leaves, kc_ctxt, kc_son_nr);
	    fprintf(kc_f, " [label=\"{<f0>%s|{", op_name());
	    kc_do_printdot_genfields(kc_f, prod_sel(), print_node_labels);
	    fprintf(kc_f, "}}\"];\n");
	    abstract_phylum child;
	    for (kc_i=0; (child = subphylum(kc_i)); kc_i++) {
		printdot_add_edge(child, kc_i+1, kc_edge_nr, kc_edges, edge_label_prefix );
		child->do_printdot( kc_f, false, kc_edge_nr, kc_edges, edge_label_prefix, print_node_labels, use_context_when_sharing_leaves, this, kc_i+1 );
	    }
	}
    }
}
activity_list
concat(c_activity_list kc_p1, c_activity_list kc_p2)
{ return dynamic_cast<activity_list>(kc_p1->do_concat(kc_p2, sel_Consactivity_list)); }

activity_list
impl_activity_list::reverse() const
{ return dynamic_cast<activity_list>(do_reverse(Nilactivity_list(), sel_Consactivity_list)); }

activity
impl_activity_list::last() const
{ return dynamic_cast<activity>(impl_abstract_list::last()); }

bool
impl_activity_list::is_nil() const
{
    return activity_1==0 && activity_list_1==0;
}

activity_list
impl_activity_list::map(activity (*kc_fp)(activity))
{ return dynamic_cast<activity_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consactivity_list)); }
activity_list
impl_activity_list::filter(bool (*kc_fp)(activity))
{ return dynamic_cast<activity_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consactivity_list)); }

activity_list
impl_activity_list::append(activity new_last)
{
    return dynamic_cast<activity_list>(do_append(new_last, Nilactivity_list()));
}
activity_list
impl_activity_list::merge( activity_list second, activity (*kc_fp)(activity, activity))
{
    return dynamic_cast<activity_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consactivity_list));
}
activity
impl_activity_list::reduce( activity neutral, activity (*kc_fp)(activity, activity))
{
    return dynamic_cast<activity>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tPartnerLink_list
concat(c_tPartnerLink_list kc_p1, c_tPartnerLink_list kc_p2)
{ return dynamic_cast<tPartnerLink_list>(kc_p1->do_concat(kc_p2, sel_ConstPartnerLink_list)); }

tPartnerLink_list
impl_tPartnerLink_list::reverse() const
{ return dynamic_cast<tPartnerLink_list>(do_reverse(NiltPartnerLink_list(), sel_ConstPartnerLink_list)); }

tPartnerLink
impl_tPartnerLink_list::last() const
{ return dynamic_cast<tPartnerLink>(impl_abstract_list::last()); }

bool
impl_tPartnerLink_list::is_nil() const
{
    return tPartnerLink_1==0 && tPartnerLink_list_1==0;
}

tPartnerLink_list
impl_tPartnerLink_list::map(tPartnerLink (*kc_fp)(tPartnerLink))
{ return dynamic_cast<tPartnerLink_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstPartnerLink_list)); }
tPartnerLink_list
impl_tPartnerLink_list::filter(bool (*kc_fp)(tPartnerLink))
{ return dynamic_cast<tPartnerLink_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstPartnerLink_list)); }

tPartnerLink_list
impl_tPartnerLink_list::append(tPartnerLink new_last)
{
    return dynamic_cast<tPartnerLink_list>(do_append(new_last, NiltPartnerLink_list()));
}
tPartnerLink_list
impl_tPartnerLink_list::merge( tPartnerLink_list second, tPartnerLink (*kc_fp)(tPartnerLink, tPartnerLink))
{
    return dynamic_cast<tPartnerLink_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstPartnerLink_list));
}
tPartnerLink
impl_tPartnerLink_list::reduce( tPartnerLink neutral, tPartnerLink (*kc_fp)(tPartnerLink, tPartnerLink))
{
    return dynamic_cast<tPartnerLink>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tPartner_list
concat(c_tPartner_list kc_p1, c_tPartner_list kc_p2)
{ return dynamic_cast<tPartner_list>(kc_p1->do_concat(kc_p2, sel_ConstPartner_list)); }

tPartner_list
impl_tPartner_list::reverse() const
{ return dynamic_cast<tPartner_list>(do_reverse(NiltPartner_list(), sel_ConstPartner_list)); }

tPartner
impl_tPartner_list::last() const
{ return dynamic_cast<tPartner>(impl_abstract_list::last()); }

bool
impl_tPartner_list::is_nil() const
{
    return tPartner_1==0 && tPartner_list_1==0;
}

tPartner_list
impl_tPartner_list::map(tPartner (*kc_fp)(tPartner))
{ return dynamic_cast<tPartner_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstPartner_list)); }
tPartner_list
impl_tPartner_list::filter(bool (*kc_fp)(tPartner))
{ return dynamic_cast<tPartner_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstPartner_list)); }

tPartner_list
impl_tPartner_list::append(tPartner new_last)
{
    return dynamic_cast<tPartner_list>(do_append(new_last, NiltPartner_list()));
}
tPartner_list
impl_tPartner_list::merge( tPartner_list second, tPartner (*kc_fp)(tPartner, tPartner))
{
    return dynamic_cast<tPartner_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstPartner_list));
}
tPartner
impl_tPartner_list::reduce( tPartner neutral, tPartner (*kc_fp)(tPartner, tPartner))
{
    return dynamic_cast<tPartner>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCatch_list
concat(c_tCatch_list kc_p1, c_tCatch_list kc_p2)
{ return dynamic_cast<tCatch_list>(kc_p1->do_concat(kc_p2, sel_ConstCatch_list)); }

tCatch_list
impl_tCatch_list::reverse() const
{ return dynamic_cast<tCatch_list>(do_reverse(NiltCatch_list(), sel_ConstCatch_list)); }

tCatch
impl_tCatch_list::last() const
{ return dynamic_cast<tCatch>(impl_abstract_list::last()); }

bool
impl_tCatch_list::is_nil() const
{
    return tCatch_1==0 && tCatch_list_1==0;
}

tCatch_list
impl_tCatch_list::map(tCatch (*kc_fp)(tCatch))
{ return dynamic_cast<tCatch_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCatch_list)); }
tCatch_list
impl_tCatch_list::filter(bool (*kc_fp)(tCatch))
{ return dynamic_cast<tCatch_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCatch_list)); }

tCatch_list
impl_tCatch_list::append(tCatch new_last)
{
    return dynamic_cast<tCatch_list>(do_append(new_last, NiltCatch_list()));
}
tCatch_list
impl_tCatch_list::merge( tCatch_list second, tCatch (*kc_fp)(tCatch, tCatch))
{
    return dynamic_cast<tCatch_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCatch_list));
}
tCatch
impl_tCatch_list::reduce( tCatch neutral, tCatch (*kc_fp)(tCatch, tCatch))
{
    return dynamic_cast<tCatch>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tOnMessage_list
concat(c_tOnMessage_list kc_p1, c_tOnMessage_list kc_p2)
{ return dynamic_cast<tOnMessage_list>(kc_p1->do_concat(kc_p2, sel_ConstOnMessage_list)); }

tOnMessage_list
impl_tOnMessage_list::reverse() const
{ return dynamic_cast<tOnMessage_list>(do_reverse(NiltOnMessage_list(), sel_ConstOnMessage_list)); }

tOnMessage
impl_tOnMessage_list::last() const
{ return dynamic_cast<tOnMessage>(impl_abstract_list::last()); }

bool
impl_tOnMessage_list::is_nil() const
{
    return tOnMessage_1==0 && tOnMessage_list_1==0;
}

tOnMessage_list
impl_tOnMessage_list::map(tOnMessage (*kc_fp)(tOnMessage))
{ return dynamic_cast<tOnMessage_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstOnMessage_list)); }
tOnMessage_list
impl_tOnMessage_list::filter(bool (*kc_fp)(tOnMessage))
{ return dynamic_cast<tOnMessage_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstOnMessage_list)); }

tOnMessage_list
impl_tOnMessage_list::append(tOnMessage new_last)
{
    return dynamic_cast<tOnMessage_list>(do_append(new_last, NiltOnMessage_list()));
}
tOnMessage_list
impl_tOnMessage_list::merge( tOnMessage_list second, tOnMessage (*kc_fp)(tOnMessage, tOnMessage))
{
    return dynamic_cast<tOnMessage_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstOnMessage_list));
}
tOnMessage
impl_tOnMessage_list::reduce( tOnMessage neutral, tOnMessage (*kc_fp)(tOnMessage, tOnMessage))
{
    return dynamic_cast<tOnMessage>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tOnAlarm_list
concat(c_tOnAlarm_list kc_p1, c_tOnAlarm_list kc_p2)
{ return dynamic_cast<tOnAlarm_list>(kc_p1->do_concat(kc_p2, sel_ConstOnAlarm_list)); }

tOnAlarm_list
impl_tOnAlarm_list::reverse() const
{ return dynamic_cast<tOnAlarm_list>(do_reverse(NiltOnAlarm_list(), sel_ConstOnAlarm_list)); }

tOnAlarm
impl_tOnAlarm_list::last() const
{ return dynamic_cast<tOnAlarm>(impl_abstract_list::last()); }

bool
impl_tOnAlarm_list::is_nil() const
{
    return tOnAlarm_1==0 && tOnAlarm_list_1==0;
}

tOnAlarm_list
impl_tOnAlarm_list::map(tOnAlarm (*kc_fp)(tOnAlarm))
{ return dynamic_cast<tOnAlarm_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstOnAlarm_list)); }
tOnAlarm_list
impl_tOnAlarm_list::filter(bool (*kc_fp)(tOnAlarm))
{ return dynamic_cast<tOnAlarm_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstOnAlarm_list)); }

tOnAlarm_list
impl_tOnAlarm_list::append(tOnAlarm new_last)
{
    return dynamic_cast<tOnAlarm_list>(do_append(new_last, NiltOnAlarm_list()));
}
tOnAlarm_list
impl_tOnAlarm_list::merge( tOnAlarm_list second, tOnAlarm (*kc_fp)(tOnAlarm, tOnAlarm))
{
    return dynamic_cast<tOnAlarm_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstOnAlarm_list));
}
tOnAlarm
impl_tOnAlarm_list::reduce( tOnAlarm neutral, tOnAlarm (*kc_fp)(tOnAlarm, tOnAlarm))
{
    return dynamic_cast<tOnAlarm>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tVariable_list
concat(c_tVariable_list kc_p1, c_tVariable_list kc_p2)
{ return dynamic_cast<tVariable_list>(kc_p1->do_concat(kc_p2, sel_ConstVariable_list)); }

tVariable_list
impl_tVariable_list::reverse() const
{ return dynamic_cast<tVariable_list>(do_reverse(NiltVariable_list(), sel_ConstVariable_list)); }

tVariable
impl_tVariable_list::last() const
{ return dynamic_cast<tVariable>(impl_abstract_list::last()); }

bool
impl_tVariable_list::is_nil() const
{
    return tVariable_1==0 && tVariable_list_1==0;
}

tVariable_list
impl_tVariable_list::map(tVariable (*kc_fp)(tVariable))
{ return dynamic_cast<tVariable_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstVariable_list)); }
tVariable_list
impl_tVariable_list::filter(bool (*kc_fp)(tVariable))
{ return dynamic_cast<tVariable_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstVariable_list)); }

tVariable_list
impl_tVariable_list::append(tVariable new_last)
{
    return dynamic_cast<tVariable_list>(do_append(new_last, NiltVariable_list()));
}
tVariable_list
impl_tVariable_list::merge( tVariable_list second, tVariable (*kc_fp)(tVariable, tVariable))
{
    return dynamic_cast<tVariable_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstVariable_list));
}
tVariable
impl_tVariable_list::reduce( tVariable neutral, tVariable (*kc_fp)(tVariable, tVariable))
{
    return dynamic_cast<tVariable>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCorrelationSet_list
concat(c_tCorrelationSet_list kc_p1, c_tCorrelationSet_list kc_p2)
{ return dynamic_cast<tCorrelationSet_list>(kc_p1->do_concat(kc_p2, sel_ConstCorrelationSet_list)); }

tCorrelationSet_list
impl_tCorrelationSet_list::reverse() const
{ return dynamic_cast<tCorrelationSet_list>(do_reverse(NiltCorrelationSet_list(), sel_ConstCorrelationSet_list)); }

tCorrelationSet
impl_tCorrelationSet_list::last() const
{ return dynamic_cast<tCorrelationSet>(impl_abstract_list::last()); }

bool
impl_tCorrelationSet_list::is_nil() const
{
    return tCorrelationSet_1==0 && tCorrelationSet_list_1==0;
}

tCorrelationSet_list
impl_tCorrelationSet_list::map(tCorrelationSet (*kc_fp)(tCorrelationSet))
{ return dynamic_cast<tCorrelationSet_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCorrelationSet_list)); }
tCorrelationSet_list
impl_tCorrelationSet_list::filter(bool (*kc_fp)(tCorrelationSet))
{ return dynamic_cast<tCorrelationSet_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCorrelationSet_list)); }

tCorrelationSet_list
impl_tCorrelationSet_list::append(tCorrelationSet new_last)
{
    return dynamic_cast<tCorrelationSet_list>(do_append(new_last, NiltCorrelationSet_list()));
}
tCorrelationSet_list
impl_tCorrelationSet_list::merge( tCorrelationSet_list second, tCorrelationSet (*kc_fp)(tCorrelationSet, tCorrelationSet))
{
    return dynamic_cast<tCorrelationSet_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCorrelationSet_list));
}
tCorrelationSet
impl_tCorrelationSet_list::reduce( tCorrelationSet neutral, tCorrelationSet (*kc_fp)(tCorrelationSet, tCorrelationSet))
{
    return dynamic_cast<tCorrelationSet>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCorrelation_list
concat(c_tCorrelation_list kc_p1, c_tCorrelation_list kc_p2)
{ return dynamic_cast<tCorrelation_list>(kc_p1->do_concat(kc_p2, sel_ConstCorrelation_list)); }

tCorrelation_list
impl_tCorrelation_list::reverse() const
{ return dynamic_cast<tCorrelation_list>(do_reverse(NiltCorrelation_list(), sel_ConstCorrelation_list)); }

tCorrelation
impl_tCorrelation_list::last() const
{ return dynamic_cast<tCorrelation>(impl_abstract_list::last()); }

bool
impl_tCorrelation_list::is_nil() const
{
    return tCorrelation_1==0 && tCorrelation_list_1==0;
}

tCorrelation_list
impl_tCorrelation_list::map(tCorrelation (*kc_fp)(tCorrelation))
{ return dynamic_cast<tCorrelation_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCorrelation_list)); }
tCorrelation_list
impl_tCorrelation_list::filter(bool (*kc_fp)(tCorrelation))
{ return dynamic_cast<tCorrelation_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCorrelation_list)); }

tCorrelation_list
impl_tCorrelation_list::append(tCorrelation new_last)
{
    return dynamic_cast<tCorrelation_list>(do_append(new_last, NiltCorrelation_list()));
}
tCorrelation_list
impl_tCorrelation_list::merge( tCorrelation_list second, tCorrelation (*kc_fp)(tCorrelation, tCorrelation))
{
    return dynamic_cast<tCorrelation_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCorrelation_list));
}
tCorrelation
impl_tCorrelation_list::reduce( tCorrelation neutral, tCorrelation (*kc_fp)(tCorrelation, tCorrelation))
{
    return dynamic_cast<tCorrelation>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tToPart_list
concat(c_tToPart_list kc_p1, c_tToPart_list kc_p2)
{ return dynamic_cast<tToPart_list>(kc_p1->do_concat(kc_p2, sel_ConstToPart_list)); }

tToPart_list
impl_tToPart_list::reverse() const
{ return dynamic_cast<tToPart_list>(do_reverse(NiltToPart_list(), sel_ConstToPart_list)); }

tToPart
impl_tToPart_list::last() const
{ return dynamic_cast<tToPart>(impl_abstract_list::last()); }

bool
impl_tToPart_list::is_nil() const
{
    return tToPart_1==0 && tToPart_list_1==0;
}

tToPart_list
impl_tToPart_list::map(tToPart (*kc_fp)(tToPart))
{ return dynamic_cast<tToPart_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstToPart_list)); }
tToPart_list
impl_tToPart_list::filter(bool (*kc_fp)(tToPart))
{ return dynamic_cast<tToPart_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstToPart_list)); }

tToPart_list
impl_tToPart_list::append(tToPart new_last)
{
    return dynamic_cast<tToPart_list>(do_append(new_last, NiltToPart_list()));
}
tToPart_list
impl_tToPart_list::merge( tToPart_list second, tToPart (*kc_fp)(tToPart, tToPart))
{
    return dynamic_cast<tToPart_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstToPart_list));
}
tToPart
impl_tToPart_list::reduce( tToPart neutral, tToPart (*kc_fp)(tToPart, tToPart))
{
    return dynamic_cast<tToPart>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tFromPart_list
concat(c_tFromPart_list kc_p1, c_tFromPart_list kc_p2)
{ return dynamic_cast<tFromPart_list>(kc_p1->do_concat(kc_p2, sel_ConstFromPart_list)); }

tFromPart_list
impl_tFromPart_list::reverse() const
{ return dynamic_cast<tFromPart_list>(do_reverse(NiltFromPart_list(), sel_ConstFromPart_list)); }

tFromPart
impl_tFromPart_list::last() const
{ return dynamic_cast<tFromPart>(impl_abstract_list::last()); }

bool
impl_tFromPart_list::is_nil() const
{
    return tFromPart_1==0 && tFromPart_list_1==0;
}

tFromPart_list
impl_tFromPart_list::map(tFromPart (*kc_fp)(tFromPart))
{ return dynamic_cast<tFromPart_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstFromPart_list)); }
tFromPart_list
impl_tFromPart_list::filter(bool (*kc_fp)(tFromPart))
{ return dynamic_cast<tFromPart_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstFromPart_list)); }

tFromPart_list
impl_tFromPart_list::append(tFromPart new_last)
{
    return dynamic_cast<tFromPart_list>(do_append(new_last, NiltFromPart_list()));
}
tFromPart_list
impl_tFromPart_list::merge( tFromPart_list second, tFromPart (*kc_fp)(tFromPart, tFromPart))
{
    return dynamic_cast<tFromPart_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstFromPart_list));
}
tFromPart
impl_tFromPart_list::reduce( tFromPart neutral, tFromPart (*kc_fp)(tFromPart, tFromPart))
{
    return dynamic_cast<tFromPart>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCopy_list
concat(c_tCopy_list kc_p1, c_tCopy_list kc_p2)
{ return dynamic_cast<tCopy_list>(kc_p1->do_concat(kc_p2, sel_ConstCopy_list)); }

tCopy_list
impl_tCopy_list::reverse() const
{ return dynamic_cast<tCopy_list>(do_reverse(NiltCopy_list(), sel_ConstCopy_list)); }

tCopy
impl_tCopy_list::last() const
{ return dynamic_cast<tCopy>(impl_abstract_list::last()); }

bool
impl_tCopy_list::is_nil() const
{
    return tCopy_1==0 && tCopy_list_1==0;
}

tCopy_list
impl_tCopy_list::map(tCopy (*kc_fp)(tCopy))
{ return dynamic_cast<tCopy_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCopy_list)); }
tCopy_list
impl_tCopy_list::filter(bool (*kc_fp)(tCopy))
{ return dynamic_cast<tCopy_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCopy_list)); }

tCopy_list
impl_tCopy_list::append(tCopy new_last)
{
    return dynamic_cast<tCopy_list>(do_append(new_last, NiltCopy_list()));
}
tCopy_list
impl_tCopy_list::merge( tCopy_list second, tCopy (*kc_fp)(tCopy, tCopy))
{
    return dynamic_cast<tCopy_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCopy_list));
}
tCopy
impl_tCopy_list::reduce( tCopy neutral, tCopy (*kc_fp)(tCopy, tCopy))
{
    return dynamic_cast<tCopy>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tElseIf_list
concat(c_tElseIf_list kc_p1, c_tElseIf_list kc_p2)
{ return dynamic_cast<tElseIf_list>(kc_p1->do_concat(kc_p2, sel_ConstElseIf_list)); }

tElseIf_list
impl_tElseIf_list::reverse() const
{ return dynamic_cast<tElseIf_list>(do_reverse(NiltElseIf_list(), sel_ConstElseIf_list)); }

tElseIf
impl_tElseIf_list::last() const
{ return dynamic_cast<tElseIf>(impl_abstract_list::last()); }

bool
impl_tElseIf_list::is_nil() const
{
    return tElseIf_1==0 && tElseIf_list_1==0;
}

tElseIf_list
impl_tElseIf_list::map(tElseIf (*kc_fp)(tElseIf))
{ return dynamic_cast<tElseIf_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstElseIf_list)); }
tElseIf_list
impl_tElseIf_list::filter(bool (*kc_fp)(tElseIf))
{ return dynamic_cast<tElseIf_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstElseIf_list)); }

tElseIf_list
impl_tElseIf_list::append(tElseIf new_last)
{
    return dynamic_cast<tElseIf_list>(do_append(new_last, NiltElseIf_list()));
}
tElseIf_list
impl_tElseIf_list::merge( tElseIf_list second, tElseIf (*kc_fp)(tElseIf, tElseIf))
{
    return dynamic_cast<tElseIf_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstElseIf_list));
}
tElseIf
impl_tElseIf_list::reduce( tElseIf neutral, tElseIf (*kc_fp)(tElseIf, tElseIf))
{
    return dynamic_cast<tElseIf>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tLink_list
concat(c_tLink_list kc_p1, c_tLink_list kc_p2)
{ return dynamic_cast<tLink_list>(kc_p1->do_concat(kc_p2, sel_ConstLink_list)); }

tLink_list
impl_tLink_list::reverse() const
{ return dynamic_cast<tLink_list>(do_reverse(NiltLink_list(), sel_ConstLink_list)); }

tLink
impl_tLink_list::last() const
{ return dynamic_cast<tLink>(impl_abstract_list::last()); }

bool
impl_tLink_list::is_nil() const
{
    return tLink_1==0 && tLink_list_1==0;
}

tLink_list
impl_tLink_list::map(tLink (*kc_fp)(tLink))
{ return dynamic_cast<tLink_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstLink_list)); }
tLink_list
impl_tLink_list::filter(bool (*kc_fp)(tLink))
{ return dynamic_cast<tLink_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstLink_list)); }

tLink_list
impl_tLink_list::append(tLink new_last)
{
    return dynamic_cast<tLink_list>(do_append(new_last, NiltLink_list()));
}
tLink_list
impl_tLink_list::merge( tLink_list second, tLink (*kc_fp)(tLink, tLink))
{
    return dynamic_cast<tLink_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstLink_list));
}
tLink
impl_tLink_list::reduce( tLink neutral, tLink (*kc_fp)(tLink, tLink))
{
    return dynamic_cast<tLink>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tTarget_list
concat(c_tTarget_list kc_p1, c_tTarget_list kc_p2)
{ return dynamic_cast<tTarget_list>(kc_p1->do_concat(kc_p2, sel_ConstTarget_list)); }

tTarget_list
impl_tTarget_list::reverse() const
{ return dynamic_cast<tTarget_list>(do_reverse(NiltTarget_list(), sel_ConstTarget_list)); }

tTarget
impl_tTarget_list::last() const
{ return dynamic_cast<tTarget>(impl_abstract_list::last()); }

bool
impl_tTarget_list::is_nil() const
{
    return tTarget_1==0 && tTarget_list_1==0;
}

tTarget_list
impl_tTarget_list::map(tTarget (*kc_fp)(tTarget))
{ return dynamic_cast<tTarget_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstTarget_list)); }
tTarget_list
impl_tTarget_list::filter(bool (*kc_fp)(tTarget))
{ return dynamic_cast<tTarget_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstTarget_list)); }

tTarget_list
impl_tTarget_list::append(tTarget new_last)
{
    return dynamic_cast<tTarget_list>(do_append(new_last, NiltTarget_list()));
}
tTarget_list
impl_tTarget_list::merge( tTarget_list second, tTarget (*kc_fp)(tTarget, tTarget))
{
    return dynamic_cast<tTarget_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstTarget_list));
}
tTarget
impl_tTarget_list::reduce( tTarget neutral, tTarget (*kc_fp)(tTarget, tTarget))
{
    return dynamic_cast<tTarget>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tSource_list
concat(c_tSource_list kc_p1, c_tSource_list kc_p2)
{ return dynamic_cast<tSource_list>(kc_p1->do_concat(kc_p2, sel_ConstSource_list)); }

tSource_list
impl_tSource_list::reverse() const
{ return dynamic_cast<tSource_list>(do_reverse(NiltSource_list(), sel_ConstSource_list)); }

tSource
impl_tSource_list::last() const
{ return dynamic_cast<tSource>(impl_abstract_list::last()); }

bool
impl_tSource_list::is_nil() const
{
    return tSource_1==0 && tSource_list_1==0;
}

tSource_list
impl_tSource_list::map(tSource (*kc_fp)(tSource))
{ return dynamic_cast<tSource_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstSource_list)); }
tSource_list
impl_tSource_list::filter(bool (*kc_fp)(tSource))
{ return dynamic_cast<tSource_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstSource_list)); }

tSource_list
impl_tSource_list::append(tSource new_last)
{
    return dynamic_cast<tSource_list>(do_append(new_last, NiltSource_list()));
}
tSource_list
impl_tSource_list::merge( tSource_list second, tSource (*kc_fp)(tSource, tSource))
{
    return dynamic_cast<tSource_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstSource_list));
}
tSource
impl_tSource_list::reduce( tSource neutral, tSource (*kc_fp)(tSource, tSource))
{
    return dynamic_cast<tSource>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

abstract_phylum
impl_abstract_phylum::copy(bool kc_copy_attributes) const
{
    enum_phyla kc_phy = phylum(); // XXX - implement special cases in subclasses - MvL
    KC_OPERATOR_INFO *kc_op_info = &operator_info[prod_sel()];
    kc_storageclass_t kc_st = phylum_info[kc_op_info->phylum].uniq_stored;
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return const_cast<abstract_phylum>(this);
    abstract_phylum kc_answer=0;
    if (kc_phy == phylum_casestring) {
	kc_answer=mkcasestring((dynamic_cast<c_casestring>(this))->name);
    } else if (kc_phy == phylum_nocasestring) {
	kc_answer=mknocasestring((dynamic_cast<c_nocasestring>(this))->name);
    } else if (kc_phy == phylum_voidptr) {
	kc_answer=mkvoidptr((dynamic_cast<c_voidptr>(this))->pointer);
    } else if (kc_phy == phylum_integer) {
	kc_answer=mkinteger((dynamic_cast<c_integer>(this))->value);
    } else if (kc_phy == phylum_real) {
	kc_answer=mkreal((dynamic_cast<c_real>(this))->value);
    } else {
	abstract_phylum kc_subtmp[10], child;
	for (int kc_i = 0; (child = subphylum(kc_i)); kc_i++) {
	    kc_subtmp[kc_i] = child->copy(kc_copy_attributes);
	}
	switch(kc_op_info->no_sons) {
	    case 0: kc_answer = kc_create(prod_sel()); break;
	    case 1: kc_answer = kc_create(prod_sel(), kc_subtmp[0]); break;
	    case 2: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1]); break;
	    case 3: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2]); break;
	    case 4: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3]); break;
	    case 5: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4]); break;
	    case 6: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5]); break;
	    case 8: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7]); break;
	    case 10: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7], kc_subtmp[8], kc_subtmp[9]); break;
	    default: assertionFailed("unexpected number of sub-phyla");
	}
    }
    if (kc_copy_attributes)
	copy_attributes(kc_phy, this, kc_answer);
    return kc_answer;
}


} // namespace kc
