/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class HierarchyEnumerator {
    private Visitor visitor;
    private int cellCnt = 0;
    private int instCnt = 0;
    private Global.Set rootGlobals;
    private int[] globalToNetID;
    private List netIdToNetDesc = new ArrayList();
    private int largestGlobalNetID = -1;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private HierarchyEnumerator() {
    }

    private int nextNetID() {
        return this.netIdToNetDesc.size();
    }

    private int[] numberNets(Cell cell, Netlist netlist, int[][] portNdxToNetIDs, CellInfo info) {
        int i;
        int numNets = netlist.getNumNetworks();
        int[] netNdxToNetID = new int[numNets];
        Arrays.fill(netNdxToNetID, -1);
        Global.Set globals = netlist.getGlobals();
        for (i = 0; i < globals.size(); ++i) {
            Global global = globals.get(i);
            int netIndex = netlist.getNetIndex(global);
            int globalIndex = this.rootGlobals.indexOf(global);
            netNdxToNetID[netIndex] = this.globalToNetID[globalIndex];
        }
        for (i = 0; i < portNdxToNetIDs.length; ++i) {
            Export export = (Export)cell.getPort(i);
            int[] ids = portNdxToNetIDs[i];
            for (int j = 0; j < ids.length; ++j) {
                int netIndex = netlist.getNetIndex(export, j);
                netNdxToNetID[netIndex] = ids[j];
            }
        }
        for (i = 0; i < numNets; ++i) {
            JNetwork net = netlist.getNetwork(i);
            if (netNdxToNetID[i] >= 0) continue;
            int netID = this.nextNetID();
            this.netIdToNetDesc.add(new NetDescription(net, info));
            netNdxToNetID[i] = netID;
        }
        return netNdxToNetID;
    }

    private static int[] getPortNetIDs(Nodable no, PortProto pp, Netlist netlist, int[] netNdxToNetID) {
        int busWidth = pp.getNameKey().busWidth();
        int[] netIDs = new int[busWidth];
        for (int j = 0; j < busWidth; ++j) {
            int netIndex = netlist.getNetIndex(no, pp, j);
            int netID = netNdxToNetID[netIndex];
            HierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[j] = netID;
        }
        return netIDs;
    }

    private int[][] buildPortMap(Netlist netlist, Nodable ni, int[] netNdxToNetID) {
        Cell cell = (Cell)ni.getProto();
        int numPorts = cell.getNumPorts();
        int[][] portNdxToNetIDs = new int[numPorts][];
        for (int i = 0; i < numPorts; ++i) {
            PortProto pp = cell.getPort(i);
            portNdxToNetIDs[i] = HierarchyEnumerator.getPortNetIDs(ni, pp, netlist, netNdxToNetID);
        }
        return portNdxToNetIDs;
    }

    private void allocateGlobalNetIDs(CellInfo rootInfo, Netlist rootNetlist) {
        HierarchyEnumerator.error(this.globalToNetID != null, "already initialized?");
        this.globalToNetID = new int[this.rootGlobals.size()];
        for (int i = 0; i < this.rootGlobals.size(); ++i) {
            int netIndex;
            Global global = this.rootGlobals.get(i);
            HierarchyEnumerator.error(this.rootGlobals.indexOf(global) != i, "bad index?");
            this.globalToNetID[i] = netIndex = rootNetlist.getNetIndex(global);
            if (netIndex == this.nextNetID()) {
                JNetwork net = rootNetlist.getNetwork(netIndex);
                this.netIdToNetDesc.add(new NetDescription(net, rootInfo));
                continue;
            }
            HierarchyEnumerator.error(netIndex > this.nextNetID(), "HierarchyEnumerator: unexpected order of global signal " + global);
        }
        this.largestGlobalNetID = this.nextNetID() - 1;
    }

    private void enumerateCell(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[][] portNdxToNetIDs, AffineTransform xformToRoot, CellInfo parent) {
        CellInfo info = this.visitor.newCellInfo();
        if (parent == null) {
            this.allocateGlobalNetIDs(info, netlist);
        }
        int firstNetID = this.nextNetID();
        int[] netNdxToNetID = this.numberNets(cell, netlist, portNdxToNetIDs, info);
        int lastNetIDPlusOne = this.nextNetID();
        ++this.cellCnt;
        info.init(parentInst, cell, context, netlist, netNdxToNetID, portNdxToNetIDs, xformToRoot, this.netIdToNetDesc, this.largestGlobalNetID, parent);
        boolean enumInsts = this.visitor.enterCell(info);
        if (!enumInsts) {
            return;
        }
        Iterator it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable ni = (Nodable)it.next();
            ++this.instCnt;
            boolean descend = this.visitor.visitNodeInst(ni, info);
            NodeProto np = ni.getProto();
            if (!descend || !(np instanceof Cell) || np.isIcon()) continue;
            int[][] portNmToNetIDs2 = this.buildPortMap(netlist, ni, netNdxToNetID);
            AffineTransform xformToRoot2 = xformToRoot;
            if (ni instanceof NodeInst) {
                xformToRoot2 = new AffineTransform(xformToRoot);
                xformToRoot2.concatenate(((NodeInst)ni).rotateOut());
                xformToRoot2.concatenate(((NodeInst)ni).translateOut());
            }
            this.enumerateCell(ni, (Cell)np, context.push(ni), netlist.getNetlist(ni), portNmToNetIDs2, xformToRoot2, info);
        }
        this.visitor.exitCell(info);
        for (int i = firstNetID; i < lastNetIDPlusOne; ++i) {
            this.netIdToNetDesc.set(i, null);
        }
    }

    private void doIt(Cell root, VarContext context, Netlist netlist, Visitor visitor) {
        this.visitor = visitor;
        if (context == null) {
            context = VarContext.globalContext;
        }
        int[][] exportNdxToNetIDs = new int[][]{};
        this.rootGlobals = netlist.getGlobals();
        this.enumerateCell(null, root, context, netlist, exportNdxToNetIDs, new AffineTransform(), null);
    }

    public static void enumerateCell(Cell root, VarContext context, Netlist netlist, Visitor visitor) {
        if (netlist == null) {
            netlist = Network.getUserNetlist(root);
        }
        new HierarchyEnumerator().doIt(root, context, netlist, visitor);
    }

    public static int getNumUniqueChildCells(Cell cell) {
        HashMap uniqueChildCells = new HashMap();
        HierarchyEnumerator.hierCellsRecurse(cell, uniqueChildCells);
        return uniqueChildCells.size();
    }

    private static void hierCellsRecurse(Cell cell, HashMap uniqueCells) {
        Iterator uit = cell.getUsagesIn();
        while (uit.hasNext()) {
            NodeProto np;
            NodeUsage nu = (NodeUsage)uit.next();
            if (nu.isIcon() || !((np = nu.getProto()) instanceof Cell)) continue;
            uniqueCells.put((Cell)np, (Cell)np);
            HierarchyEnumerator.hierCellsRecurse((Cell)np, uniqueCells);
        }
    }

    public static class CellInfo {
        private Nodable parentInst;
        private Cell cell;
        private VarContext context;
        private Netlist netlist;
        private int[] netNdxToNetID;
        private int[][] exportNdxToNetIDs;
        private AffineTransform xformToRoot;
        private List netIdToNetDesc;
        private int largestGlobalNetID;
        private CellInfo parentInfo;

        void init(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[] netToNetID, int[][] exportNdxToNetIDs, AffineTransform xformToRoot, List netIdToNetDesc, int largestGlobalNetID, CellInfo parentInfo) {
            this.parentInst = parentInst;
            this.cell = cell;
            this.context = context;
            this.netlist = netlist;
            this.netNdxToNetID = netToNetID;
            this.exportNdxToNetIDs = exportNdxToNetIDs;
            this.xformToRoot = xformToRoot;
            this.netIdToNetDesc = netIdToNetDesc;
            this.largestGlobalNetID = largestGlobalNetID;
            this.parentInfo = parentInfo;
        }

        private double angleFromXY(double x, double y) {
            double ans = Math.atan2(y, x) * 180.0 / Math.PI;
            return ans;
        }

        private double angle0To360(double a) {
            while (a >= 360.0) {
                a -= 360.0;
            }
            while (a < 0.0) {
                a += 360.0;
            }
            return a;
        }

        private String makePath(VarContext context, String sep) {
            String path = context.getInstPath(sep);
            if (!path.equals("")) {
                path = path + sep;
            }
            return path;
        }

        public final Cell getCell() {
            return this.cell;
        }

        public final boolean isRootCell() {
            return this.parentInfo == null;
        }

        public final VarContext getContext() {
            return this.context;
        }

        public final Netlist getNetlist() {
            return this.netlist;
        }

        public final CellInfo getParentInfo() {
            return this.parentInfo;
        }

        public final Nodable getParentInst() {
            return this.parentInst;
        }

        public final CellInfo getRootInfo() {
            CellInfo i = this;
            while (i.getParentInfo() != null) {
                i = i.getParentInfo();
            }
            return i;
        }

        public final int[] getExportNetIDs(Export e) {
            if (this.isRootCell()) {
                int width = this.netlist.getBusWidth(e);
                int[] netIDs = new int[width];
                for (int i = 0; i < width; ++i) {
                    netIDs[i] = this.netlist.getNetIndex(e, i);
                }
                return netIDs;
            }
            return this.exportNdxToNetIDs[e.getPortIndex()];
        }

        public final int getNetID(JNetwork net) {
            return this.getNetID(net.getNetIndex());
        }

        public final int getNetID(int netIndex) {
            return this.netNdxToNetID[netIndex];
        }

        public final boolean isGlobalNet(int netID) {
            HierarchyEnumerator.error(netID < 0, "negative netIDs are illegal");
            return netID <= this.largestGlobalNetID;
        }

        public final int[] getPortNetIDs(Nodable no, PortProto pp) {
            return HierarchyEnumerator.getPortNetIDs(no, pp, this.netlist, this.netNdxToNetID);
        }

        public final String getUniqueNetName(JNetwork net, String sep) {
            return this.getUniqueNetName(net.getNetIndex(), sep);
        }

        public final String getUniqueNetName(int netID, String sep) {
            NetDescription ns = (NetDescription)this.netIdToNetDesc.get(netID);
            if (ns == null) {
                System.out.println("ns is null");
            }
            if (ns.getCellInfo() == null) {
                System.out.println("cell info is null");
            }
            VarContext netContext = ns.getCellInfo().getContext();
            String path = this.makePath(netContext, sep);
            Iterator it = ns.getNet().getNames();
            path = it.hasNext() ? path + (String)it.next() : path + "netID" + netID;
            return path;
        }

        public final String getUniqueNodableName(Nodable no, String sep) {
            return this.makePath(this.getContext(), sep) + no.getName();
        }

        public final NetDescription netIdToNetDescription(int netID) {
            return (NetDescription)this.netIdToNetDesc.get(netID);
        }

        public final AffineTransform getPositionInRoot(NodeInst ni) {
            AffineTransform x = new AffineTransform(this.xformToRoot);
            return x;
        }

        public AffineTransform getTransformToRoot() {
            return this.xformToRoot;
        }

        public final Point2D getPositionInRoot(Point2D p) {
            Point2D.Double ans = new Point2D.Double();
            this.xformToRoot.transform(p, ans);
            return ans;
        }

        public final Rectangle2D getBoundsInRoot(Rectangle2D r) {
            double[] coords = new double[]{r.getX(), r.getY(), r.getX(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY()};
            this.xformToRoot.transform(coords, 0, coords, 0, 8);
            double minY = Double.MAX_VALUE;
            double minX = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            double maxX = Double.MIN_VALUE;
            for (int i = 0; i < 8; i += 2) {
                minX = Math.min(minX, coords[i]);
                maxX = Math.max(maxX, coords[i]);
                minY = Math.min(minY, coords[i + 1]);
                maxY = Math.max(maxY, coords[i + 1]);
            }
            return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        }
    }

    public static class NetDescription {
        private JNetwork net;
        private CellInfo info;

        NetDescription(JNetwork net, CellInfo info) {
            this.net = net;
            this.info = info;
        }

        public JNetwork getNet() {
            return this.net;
        }

        public CellInfo getCellInfo() {
            return this.info;
        }
    }

    public static abstract class Visitor {
        public CellInfo newCellInfo() {
            return new CellInfo();
        }

        public abstract boolean enterCell(CellInfo var1);

        public abstract void exitCell(CellInfo var1);

        public abstract boolean visitNodeInst(Nodable var1, CellInfo var2);
    }
}

