/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class MessagesWindow
extends OutputStream
implements ActionListener,
KeyListener,
Runnable {
    private ArrayList history;
    private JTextField entry;
    private JTextArea info;
    private Container contentFrame;
    private int histidx = 0;
    private Thread ticker = null;
    private StringBuffer buffer = new StringBuffer();
    private Container jf;
    private PrintWriter printWriter = null;
    private static boolean newCommand = true;
    private static int commandNumber = 1;

    public MessagesWindow() {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension msgSize = new Dimension(scrnSize.width / 3 * 2, scrnSize.height / 100 * 15);
        if (TopLevel.isMDIMode()) {
            JInternalFrame jInternalFrame = new JInternalFrame("Electric Messages", true, false, true, true);
            this.jf = jInternalFrame;
            this.contentFrame = jInternalFrame.getContentPane();
            jInternalFrame.setFrameIcon(Resources.getResource(this.getClass(), "IconElectric.gif"));
        } else {
            JFrame jFrame = new JFrame("Electric Messages");
            this.jf = jFrame;
            jFrame.setDefaultCloseOperation(0);
            this.contentFrame = jFrame.getContentPane();
        }
        this.history = new ArrayList();
        this.entry = new JTextField();
        this.entry.addActionListener(this);
        this.entry.addKeyListener(this);
        this.info = new JTextArea(20, 110);
        this.info.setLineWrap(false);
        JScrollPane scrollPane = new JScrollPane(this.info, 22, 30);
        scrollPane.setPreferredSize(msgSize);
        JScrollBar vertscroll = scrollPane.getVerticalScrollBar();
        this.contentFrame.setLayout(new BorderLayout());
        this.contentFrame.add((Component)this.entry, "South");
        this.contentFrame.add((Component)scrollPane, "Center");
        this.jf.setLocation(150, scrnSize.height / 100 * 80);
        if (TopLevel.isMDIMode()) {
            ((JInternalFrame)this.jf).pack();
            ((JInternalFrame)this.jf).show();
            TopLevel.addToDesktop((JInternalFrame)this.jf);
        } else {
            ((JFrame)this.jf).pack();
            ((JFrame)this.jf).show();
        }
        System.setOut(new PrintStream(this));
    }

    public Rectangle getMessagesLocation() {
        return this.jf.getBounds();
    }

    public void flush() {
    }

    public void close() {
    }

    public void clear() {
        this.info.setText("");
    }

    public static void userCommandIssued() {
        newCommand = true;
    }

    public void save() {
        String filePath = OpenFile.chooseOutputFile(OpenFile.Type.TEXT, null, "emessages.txt");
        if (filePath == null) {
            return;
        }
        try {
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.out.println("Error creating " + filePath);
            return;
        }
        System.out.println("Messages will be saved to " + filePath);
    }

    public void write(byte[] b) {
        this.appendString(new String(b));
    }

    public void write(int b) {
        this.appendString(String.valueOf((char)b));
    }

    public void write(byte[] b, int off, int len) {
        this.appendString(new String(b, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendString(String str) {
        if (str.equals("")) {
            return;
        }
        if (newCommand) {
            newCommand = false;
            str = "=================================" + commandNumber++ + "=================================\n" + str;
        }
        StringBuffer stringBuffer = this.buffer;
        synchronized (stringBuffer) {
            if (this.printWriter != null) {
                this.printWriter.print(str);
                this.printWriter.flush();
            }
            this.buffer.append(str);
            if (this.ticker == null) {
                this.ticker = new Thread(this);
                this.ticker.start();
            }
        }
    }

    public void run() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.ticker = null;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                StringBuffer stringBuffer = MessagesWindow.this.buffer;
                synchronized (stringBuffer) {
                    MessagesWindow.this.dump(MessagesWindow.this.buffer.toString());
                    MessagesWindow.this.buffer.setLength(0);
                }
            }
        });
    }

    protected void dump(String str) {
        this.info.append(str);
        try {
            Rectangle r = this.info.modelToView(this.info.getDocument().getLength());
            this.info.scrollRectToVisible(r);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 38) {
            if (this.histidx > 0) {
                --this.histidx;
            }
            if (this.histidx < this.history.size()) {
                this.entry.setText((String)this.history.get(this.histidx));
            }
        } else if (code == 40 && this.histidx < this.history.size()) {
            ++this.histidx;
            if (this.histidx < this.history.size()) {
                this.entry.setText((String)this.history.get(this.histidx));
            } else {
                this.entry.setText("");
            }
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void actionPerformed(ActionEvent evt) {
        String msg = this.entry.getText();
        this.history.add(msg);
        this.histidx = this.history.size();
        this.entry.setText("");
        this.info.append("=================== " + msg + " =================\n");
        StringTokenizer st = new StringTokenizer(msg);
        String[] cmds = new String[st.countTokens()];
        if (cmds.length == 0) {
            return;
        }
        for (int i = 0; i < cmds.length; ++i) {
            cmds[i] = st.nextToken();
        }
        if (cmds[0].equals("mem")) {
            Runtime rt = Runtime.getRuntime();
            System.out.println("Total memory: " + rt.totalMemory());
            System.out.println("Free memory: " + rt.freeMemory());
        }
    }
}

