/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.Commit;
import com.sun.electric.tool.cvspm.Edit;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.GDSMap;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.project.AddCellJob;
import com.sun.electric.tool.project.AddLibraryJob;
import com.sun.electric.tool.project.CancelCheckOutJob;
import com.sun.electric.tool.project.CheckInJob;
import com.sun.electric.tool.project.CheckOutJob;
import com.sun.electric.tool.project.DeleteCellJob;
import com.sun.electric.tool.project.HistoryDialog;
import com.sun.electric.tool.project.LibraryDialog;
import com.sun.electric.tool.project.UpdateJob;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ChangeCurrentLib;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.projectSettings.ProjSettings;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class FileMenu {
    private static PageFormat pageFormat = null;

    static EMenu makeMenu() {
        return new EMenu("_File", new EMenuItem("_New Library..."){

            public void run() {
                FileMenu.newLibraryCommand();
            }
        }, ToolBar.openLibraryCommand, new EMenu("_Import", new EMenuItem("_CIF (Caltech Intermediate Format)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.CIF);
            }
        }, new EMenuItem("_GDS II (Stream)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.GDS);
            }
        }, new EMenuItem("GDS _Map File..."){

            public void run() {
                GDSMap.importMapFile();
            }
        }, new EMenuItem("_EDIF (Electronic Design Interchange Format)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.EDIF);
            }
        }, new EMenuItem("_LEF (Library Exchange Format)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.LEF);
            }
        }, new EMenuItem("_DEF (Design Exchange Format)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.DEF);
            }
        }, new EMenuItem("D_XF (AutoCAD)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.DXF);
            }
        }, new EMenuItem("S_UE (Schematic User Environment)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.SUE);
            }
        }, IOTool.hasDais() ? new EMenuItem("Dais (_Sun CAD)..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.DAIS);
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("ELI_B..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.ELIB);
            }
        }, new EMenuItem("_Readable Dump..."){

            public void run() {
                FileMenu.importLibraryCommand(FileType.READABLEDUMP);
            }
        }, new EMenuItem("_Text Cell Contents..."){

            public void run() {
                TextWindow.readTextCell();
            }
        }, new EMenuItem("_Preferences..."){

            public void run() {
                Job.getUserInterface().importPrefs();
            }
        }, new EMenuItem("Project Settings..."){

            public void run() {
                ProjSettings.importSettings();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("_Close Library"){

            public void run() {
                FileMenu.closeLibraryCommand(Library.getCurrent());
            }
        }, ToolBar.saveLibraryCommand, new EMenuItem("Save Library _As..."){

            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAsLibraryCommand(Library.getCurrent());
                }
            }
        }, new EMenuItem("_Save All Libraries", 'S'){

            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesCommand();
                }
            }
        }, new EMenuItem("Save All Libraries in _Format..."){

            public void run() {
                if (FileMenu.checkInvariants()) {
                    FileMenu.saveAllLibrariesInFormatCommand();
                }
            }
        }, new EMenu("_Export", new EMenuItem("_CIF (Caltech Intermediate Format)..."){

            public void run() {
                FileMenu.exportCommand(FileType.CIF, false);
            }
        }, new EMenuItem("_GDS II (Stream)..."){

            public void run() {
                FileMenu.exportCommand(FileType.GDS, false);
            }
        }, new EMenuItem("ED_IF (Electronic Design Interchange Format)..."){

            public void run() {
                FileMenu.exportCommand(FileType.EDIF, false);
            }
        }, new EMenuItem("LE_F (Library Exchange Format)..."){

            public void run() {
                FileMenu.exportCommand(FileType.LEF, false);
            }
        }, new EMenuItem("_L..."){

            public void run() {
                FileMenu.exportCommand(FileType.L, false);
            }
        }, IOTool.hasSkill() ? new EMenuItem("S_kill (Cadence Commands)..."){

            public void run() {
                FileMenu.exportCommand(FileType.SKILL, false);
            }
        } : null, IOTool.hasSkill() ? new EMenuItem("Skill Exports _Only (Cadence Commands)..."){

            public void run() {
                FileMenu.exportCommand(FileType.SKILLEXPORTSONLY, false);
            }
        } : null, EMenuItem.SEPARATOR, new EMenuItem("_Eagle..."){

            public void run() {
                FileMenu.exportCommand(FileType.EAGLE, false);
            }
        }, new EMenuItem("EC_AD..."){

            public void run() {
                FileMenu.exportCommand(FileType.ECAD, false);
            }
        }, new EMenuItem("Pad_s..."){

            public void run() {
                FileMenu.exportCommand(FileType.PADS, false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Text Cell Contents..."){

            public void run() {
                TextWindow.writeTextCell();
            }
        }, new EMenuItem("_PostScript..."){

            public void run() {
                FileMenu.exportCommand(FileType.POSTSCRIPT, false);
            }
        }, new EMenuItem("P_NG (Portable Network Graphics)..."){

            public void run() {
                FileMenu.exportCommand(FileType.PNG, false);
            }
        }, new EMenuItem("_HPGL..."){

            public void run() {
                FileMenu.exportCommand(FileType.HPGL, false);
            }
        }, new EMenuItem("D_XF (AutoCAD)..."){

            public void run() {
                FileMenu.exportCommand(FileType.DXF, false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("ELI_B (Version 6)..."){

            public void run() {
                FileMenu.saveLibraryCommand(Library.getCurrent(), FileType.ELIB, true, false, false);
            }
        }, new EMenuItem(Job.getDebug() ? "_JELIB (Version 8.04k)" : "_JELIB (Version 8.03)"){

            public void run() {
                FileMenu.saveOldJelib();
            }
        }, new EMenuItem("P_references..."){

            public void run() {
                Job.getUserInterface().exportPrefs();
            }
        }, new EMenuItem("Project Settings..."){

            public void run() {
                ProjSettings.exportSettings();
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("Change Current _Library..."){

            public void run() {
                ChangeCurrentLib.showDialog();
            }
        }, new EMenuItem("List Li_braries"){

            public void run() {
                CircuitChanges.listLibrariesCommand();
            }
        }, new EMenuItem("Rena_me Library..."){

            public void run() {
                CircuitChanges.renameLibrary(Library.getCurrent());
            }
        }, new EMenuItem("Mar_k All Libraries for Saving"){

            public void run() {
                CircuitChangeJobs.markAllLibrariesForSavingCommand();
            }
        }, new EMenu("C_heck Libraries", new EMenuItem("_Check"){

            public void run() {
                CircuitChanges.checkAndRepairCommand(false);
            }
        }, new EMenuItem("_Repair"){

            public void run() {
                CircuitChanges.checkAndRepairCommand(true);
            }
        }), EMenuItem.SEPARATOR, new EMenu("P_roject Management", new EMenuItem("_Update"){

            public void run() {
                UpdateJob.updateProject();
            }
        }, new EMenuItem("Check _Out This Cell"){

            public void run() {
                CheckOutJob.checkOutThisCell();
            }
        }, new EMenuItem("Check _In This Cell..."){

            public void run() {
                CheckInJob.checkInThisCell();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Roll_back and Release Check-Out"){

            public void run() {
                CancelCheckOutJob.cancelCheckOutThisCell();
            }
        }, new EMenuItem("_Add This Cell"){

            public void run() {
                AddCellJob.addThisCell();
            }
        }, new EMenuItem("_Remove This Cell"){

            public void run() {
                DeleteCellJob.removeThisCell();
            }
        }, new EMenuItem("Show _History of This Cell..."){

            public void run() {
                HistoryDialog.examineThisHistory();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Get Library From Repository..."){

            public void run() {
                LibraryDialog.getALibrary();
            }
        }, new EMenuItem("Add Current _Library To Repository"){

            public void run() {
                AddLibraryJob.addThisLibrary();
            }
        }, new EMenuItem("Ad_d All Libraries To Repository"){

            public void run() {
                AddLibraryJob.addAllLibraries();
            }
        }), new EMenu("C_VS", new EMenuItem[]{new EMenuItem("Commit All Open Libraries"){

            public void run() {
                Commit.commitAllLibraries();
            }
        }, new EMenuItem("Update Open Libraries"){

            public void run() {
                Update.updateOpenLibraries(0);
            }
        }, new EMenuItem("Get Status Open Libraries"){

            public void run() {
                Update.updateOpenLibraries(1);
            }
        }, new EMenuItem("List Editors Open Libraries"){

            public void run() {
                Edit.listEditorsOpenLibraries();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Update Project Libraries"){

            public void run() {
                Update.updateProject(0);
            }
        }, new EMenuItem("Get Status Project Libraries"){

            public void run() {
                Update.updateProject(1);
            }
        }, new EMenuItem("List Editors Project Libraries"){

            public void run() {
                Edit.listEditorsProject();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Checkout From Repository"){

            public void run() {
                CVS.checkoutFromRepository();
            }
        }}){

            public boolean isEnabled() {
                return CVS.isEnabled();
            }

            protected void registerItem() {
                super.registerItem();
                this.registerUpdatable();
            }
        }, EMenuItem.SEPARATOR, ToolBar.preferencesCommand, new EMenuItem("Pro_ject Settings..."){

            public void run() {
                ProjectSettingsFrame.projectSettingsCommand();
            }
        }, EMenuItem.SEPARATOR, !Client.isOSMac() ? new EMenuItem("_Quit", 'Q'){

            public void run() {
                FileMenu.quitCommand();
            }
        } : null, new EMenuItem("Force Q_uit (and Save)"){

            public void run() {
                FileMenu.forceQuit();
            }
        });
    }

    public static void newLibraryCommand() {
        String newLibName = JOptionPane.showInputDialog("New Library Name", (Object)"");
        if (newLibName == null) {
            return;
        }
        NewLibrary job = new NewLibrary(newLibName);
    }

    public static void openLibraryCommand() {
        String fileName = OpenFile.chooseInputFile(FileType.LIBRARYFORMATS, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            FileType type = FileMenu.getLibraryFormat(fileName, FileType.DEFAULTLIB);
            new ReadLibrary(fileURL, type, deleteLib, null);
        }
    }

    public static FileType getLibraryFormat(String fileName, FileType defaultType) {
        if (fileName != null) {
            if (fileName.endsWith(File.separator)) {
                fileName = fileName.substring(0, fileName.length() - File.separator.length());
            }
            for (int i = 0; i < FileType.libraryTypes.length; ++i) {
                FileType type = FileType.libraryTypes[i];
                if (!fileName.endsWith("." + type.getExtensions()[0])) continue;
                return type;
            }
        }
        return defaultType;
    }

    private static void doneOpeningLibrary(final Cell cell) {
        if (cell == null) {
            System.out.println("No current cell in this library");
        } else if (!Job.BATCHMODE) {
            CreateCellWindow creator = new CreateCellWindow(cell);
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(creator);
            } else {
                creator.run();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowFrame.wantToRedoLibraryTree();
                WindowFrame.wantToOpenCurrentLibrary(true, cell);
            }
        });
    }

    public static void importLibraryCommand(FileType type) {
        String fileName = null;
        fileName = type == FileType.DAIS ? OpenFile.chooseDirectory(type.getDescription()) : OpenFile.chooseInputFile(type, null);
        if (fileName != null) {
            URL fileURL = TextUtils.makeURLToFile(fileName);
            String libName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library deleteLib = Library.findLibrary(libName);
            if (deleteLib != null) {
                if (FileMenu.preventLoss(deleteLib, 2)) {
                    return;
                }
                WindowFrame.removeLibraryReferences(deleteLib);
            }
            new ImportLibrary(fileURL, type, deleteLib);
        }
    }

    public static void closeLibraryCommand(Library lib) {
        if (lib == null) {
            return;
        }
        Set<Cell> found = Library.findReferenceInCell(lib);
        boolean clearClipboard = false;
        boolean nonClipboard = false;
        for (Cell cell : found) {
            if (cell.getLibrary().isHidden()) {
                clearClipboard = true;
                continue;
            }
            nonClipboard = true;
        }
        if (nonClipboard) {
            System.out.println("Cannot close " + lib + ":");
            System.out.print("\t Cells ");
            for (Cell cell : found) {
                System.out.print("'" + cell.getName() + "'(" + cell.getLibrary().getName() + ") ");
            }
            System.out.println("refer to it.");
            return;
        }
        if (FileMenu.preventLoss(lib, 1)) {
            return;
        }
        WindowFrame.removeLibraryReferences(lib);
        CloseLibrary job = new CloseLibrary(lib, clearClipboard);
    }

    public static boolean saveLibraryCommand(Library lib) {
        return lib != null && FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, false);
    }

    public static boolean saveLibraryCommand(Library lib, FileType type, boolean compatibleWith6, boolean forceToType, boolean saveAs) {
        ArrayList<String> dummyCells = new ArrayList<String>();
        dummyCells.add("WARNING: " + lib + " contains the following Dummy cells:");
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell c = it.next();
            if (c.getVar(LibraryFiles.IO_DUMMY_OBJECT) == null) continue;
            dummyCells.add("   " + c.noLibDescribe());
        }
        if (dummyCells.size() > 1) {
            dummyCells.add("Do you really want to write this library?");
            String[] options = new String[]{"Continue Writing", "Cancel"};
            String message = ((Object)dummyCells).toString();
            int val = Job.getUserInterface().askForChoice(message, "Dummy Cells Found in " + lib, options, options[1]);
            if (val == 1) {
                return false;
            }
        }
        String[] extensions = type.getExtensions();
        String extension = extensions[0];
        String fileName = null;
        if (!saveAs && lib.isFromDisk()) {
            File file;
            if (type == FileType.JELIB || type == FileType.DELIB || type == FileType.ELIB && !compatibleWith6) {
                fileName = lib.getLibFile().getPath();
                if (forceToType) {
                    type = OpenFile.getOpenFileType(fileName, FileType.DEFAULTLIB);
                }
            }
            if (fileName != null && (file = new File(fileName)).exists() && !file.canWrite()) {
                fileName = null;
            }
        }
        if (fileName == null) {
            fileName = OpenFile.chooseOutputFile(FileType.libraryTypes, null, lib.getName() + "." + extension);
            if (fileName == null) {
                return false;
            }
            type = FileMenu.getLibraryFormat(fileName, type);
        }
        new SaveLibrary(lib, fileName, type, compatibleWith6);
        return true;
    }

    private static void saveOldJelib() {
        String currentDir = User.getWorkingDirectory();
        System.out.println("Saving libraries in oldJelib directory under " + currentDir);
        System.out.flush();
        File oldJelibDir = new File(currentDir, "oldJelib");
        if (!oldJelibDir.exists() && !oldJelibDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create oldJelib directory", oldJelibDir.getAbsolutePath()}, "Error creating oldJelib directory", 0);
            return;
        }
        Output.writePanicSnapshot(EDatabase.clientDatabase().backup(), oldJelibDir, true);
    }

    public static void saveAsLibraryCommand(Library lib) {
        FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, true);
        WindowFrame.wantToRedoTitleNames();
    }

    public static void saveAllLibrariesCommand() {
        FileMenu.saveAllLibrariesCommand(FileType.DEFAULTLIB, false, true);
    }

    public static void saveAllLibrariesCommand(FileType type, boolean compatibleWith6, boolean forceToType) {
        HashMap<Library, FileType> libsToSave = new HashMap<Library, FileType>();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            if (lib.getLibFile() != null) {
                type = FileMenu.getLibraryFormat(lib.getLibFile().getFile(), type);
            }
            libsToSave.put(lib, type);
        }
        boolean justSkip = false;
        Iterator it2 = libsToSave.keySet().iterator();
        while (it2.hasNext()) {
            Library lib = (Library)it2.next();
            if (FileMenu.saveLibraryCommand(lib, type = (FileType)libsToSave.get(lib), compatibleWith6, forceToType, false) || justSkip) continue;
            if (!it2.hasNext()) break;
            Object[] options = new String[]{"Cancel", "Skip this Library"};
            int ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cancel all library saving, or just skip saving this library?", "Save Cancelled", -1, 3, null, options, "Cancel");
            if (ret != 1) break;
            justSkip = true;
        }
    }

    public static void saveAllLibrariesInFormatCommand() {
        Object[] formats = new Object[]{FileType.JELIB, FileType.ELIB, FileType.READABLEDUMP, FileType.DELIB};
        Object format = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Output file format for all libraries:", "Save All Libraries In Format...", -1, null, formats, FileType.DEFAULTLIB);
        if (format == null) {
            return;
        }
        FileType outType = (FileType)format;
        SaveAllLibrariesInFormatJob job = new SaveAllLibrariesInFormatJob(outType);
    }

    private static boolean checkInvariants() {
        return true;
    }

    public static void exportCommand(FileType type, boolean isNetlist) {
        WindowContent wnd;
        if (type == FileType.POSTSCRIPT && PostScript.syncAll()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        WindowContent windowContent = wnd = wf != null ? wf.getContent() : null;
        if (wnd == null) {
            System.out.println("No current window");
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        VarContext context = wnd instanceof EditWindow ? ((EditWindow)wnd).getVarContext() : null;
        List<PolyBase> override = null;
        if (type == FileType.POSTSCRIPT) {
            if (cell.getView() == View.DOC) {
                System.out.println("Document cells can't be exported as postscript.");
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Document cells can't be exported as postscript.\nTry \"Export -> Text Cell Contents\"", "Exporting PS", 0);
                return;
            }
            if (IOTool.isPrintEncapsulated()) {
                type = FileType.EPS;
            }
            if (wnd instanceof WaveformWindow) {
                WaveformWindow ww = (WaveformWindow)wnd;
                override = ww.getPolysForPrinting();
            }
        }
        String[] extensions = type.getExtensions();
        String filePath = (cell != null ? cell.getName() : "") + "." + extensions[0];
        if (type == FileType.SPICE && !Simulation.getSpiceRunChoice().equals("Don't Run")) {
            filePath = Simulation.getSpiceUseRunDir() ? Simulation.getSpiceRunDir() + File.separator + filePath : User.getWorkingDirectory() + File.separator + filePath;
            if (User.isShowFileSelectionForNetlists() && !Simulation.getSpiceOutputOverwrite()) {
                String saveDir = User.getWorkingDirectory();
                filePath = OpenFile.chooseOutputFile(type, null, filePath);
                User.setWorkingDirectory(saveDir);
                if (filePath == null) {
                    return;
                }
            }
            Output.exportCellCommand(cell, context, filePath, type, override);
            return;
        }
        if (User.isShowFileSelectionForNetlists() || !isNetlist) {
            if ((filePath = OpenFile.chooseOutputFile(type, null, filePath)) == null) {
                return;
            }
        } else {
            filePath = User.getWorkingDirectory() + File.separator + filePath;
        }
        if (type == FileType.PNG) {
            String name = cell != null ? cell.toString() : filePath;
            ExportImage job = new ExportImage(name, wnd, filePath);
            return;
        }
        Output.exportCellCommand(cell, context, filePath, type, override);
    }

    private static ElectricPrinter getOutputPreferences(WindowContent context) {
        ElectricPrinter ep = new ElectricPrinter(context, pageFormat);
        return ep;
    }

    public static boolean quitCommand() {
        if (FileMenu.preventLoss(null, 0)) {
            return false;
        }
        try {
            new QuitJob();
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean preventLoss(Library desiredLib, int action) {
        boolean checkedInvariants = false;
        boolean saveCancelled = false;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (desiredLib != null && desiredLib != lib || lib.isHidden() || !lib.isChanged()) continue;
            if (!checkedInvariants) {
                if (!FileMenu.checkInvariants()) {
                    return true;
                }
                checkedInvariants = true;
            }
            String theAction = "Save before quitting?";
            if (action == 1) {
                theAction = "Save before closing?";
            } else if (action == 2) {
                theAction = "Save before replacing?";
            }
            Object[] options = new String[]{"Yes", "No", "Cancel", "No to All"};
            int ret = FileMenu.showFileMenuOptionDialog(TopLevel.getCurrentJFrame(), "Library '" + lib.getName() + "' has changed.  " + theAction, "Save Library?", -1, 2, null, options, options[0], null);
            if (ret == 0) {
                if (FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true, false)) continue;
                saveCancelled = true;
                continue;
            }
            if (ret == 1) continue;
            if (ret == 2 || ret == -1) {
                return true;
            }
            if (ret != 3) continue;
            break;
        }
        return saveCancelled;
    }

    public static int showFileMenuOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, String toolTipMessage) throws HeadlessException {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? JOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        pane.setMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        pane.setToolTipText(toolTipMessage);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void forceQuit() {
        int i;
        boolean dirty = false;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden() || !lib.isChanged()) continue;
            dirty = true;
            break;
        }
        if (dirty) {
            Object[] options = new String[]{"Force Save and Quit", "Cancel", "Quit without Saving"};
            int i2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning!  Libraries Changed!  Saving changes now may create bad libraries!"}, "Force Quit", -1, 2, null, options, options[1]);
            if (i2 == 0) {
                if (!FileMenu.forceSave(false)) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Error during forced library save, not quiting", "Saving Failed", 0);
                    return;
                }
                ActivityLogger.finished();
                System.exit(1);
            }
            if (i2 == 1) {
                return;
            }
            if (i2 == 2) {
                ActivityLogger.finished();
                System.exit(1);
            }
        }
        if ((i = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! You are about to kill Electric!", "Do you really want to force quit?"}, "Force Quit", 0, 2)) == 0) {
            ActivityLogger.finished();
            System.exit(1);
        }
    }

    public static boolean forceSave(boolean confirm) {
        boolean ok;
        if (confirm) {
            Object[] options = new String[]{"Cancel", "Force Save"};
            int i = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), new String[]{"Warning! Saving changes now may create bad libraries!", "Libraries will be saved to \"Panic\" directory in current directory", "Do you really want to force save?"}, "Force Save", -1, 2, null, options, options[0]);
            if (i == 0) {
                return false;
            }
        }
        String currentDir = User.getWorkingDirectory();
        System.out.println("Saving libraries in panic directory under " + currentDir);
        System.out.flush();
        File panicDir = new File(currentDir, "panic");
        if (!panicDir.exists() && !panicDir.mkdir()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Could not create panic directory", panicDir.getAbsolutePath()}, "Error creating panic directory", 0);
            return false;
        }
        Snapshot panicSnapshot = JobManager.findValidSnapshot();
        boolean bl = ok = !Output.writePanicSnapshot(panicSnapshot, panicDir, false);
        if (ok) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"Libraries are saved to panic directory", panicDir.getAbsolutePath()}, "Libraries are saved", 1);
        }
        return ok;
    }

    static class CellMouseMotionAdapter
    extends MouseMotionAdapter {
        JOptionPane pane;

        CellMouseMotionAdapter(JOptionPane p) {
            this.pane = p;
        }

        public void mouseMoved(MouseEvent e) {
            System.out.println(" Point " + this.pane.getToolTipLocation(e));
        }
    }

    public static class QuitJob
    extends Job {
        public QuitJob() {
            super("Quitting", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() throws JobException {
            return true;
        }

        public void terminateOK() {
            block2: {
                try {
                    Library.saveExpandStatus();
                }
                catch (BackingStoreException e) {
                    int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Cannot save cell expand status. Do you still want to quit?", "Cell Status Error", 0, 2);
                    if (response == 0) break block2;
                    return;
                }
            }
            Layer.preserveVisibility();
            WaveformWindow.preserveSignalOrder();
            ActivityLogger.finished();
            System.exit(0);
        }
    }

    public static class ClearCellDate
    extends Job {
        private String cellName;
        private Cell cell;

        public ClearCellDate(String cellName) {
            super("Clear Cell Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellName = cellName;
            this.startJob();
        }

        public ClearCellDate(Cell cell) {
            super("Clear Cell Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.cell == null && this.cellName != null) {
                this.cell = (Cell)Cell.findNodeProto(this.cellName);
            }
            if (this.cell != null) {
                this.cell.lowLevelSetRevisionDate(new Date(0L));
                this.cell.lowLevelSetCreationDate(new Date(0L));
            }
            return true;
        }
    }

    private static class ExportImage
    extends Job {
        private String filePath;
        private WindowContent wnd;

        public ExportImage(String description, WindowContent wnd, String filePath) {
            super("Export " + description + " (" + FileType.PNG + ")", User.getUserTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.wnd = wnd;
            this.filePath = filePath;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            ElectricPrinter ep = FileMenu.getOutputPreferences(this.wnd);
            this.wnd.writeImage(ep, this.filePath);
            return true;
        }
    }

    public static class SaveAllLibrariesInFormatJob
    extends Job {
        private FileType outType;

        public SaveAllLibrariesInFormatJob(FileType outType) {
            super("Save All Libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.outType = outType;
            this.startJob();
        }

        public boolean doIt() {
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                if (lib.isHidden() || !lib.isFromDisk()) continue;
                if (lib.getLibFile() != null) {
                    String fullName = lib.getLibFile().getFile();
                    fullName = fullName.replaceAll("\\.\\w*?$", "." + this.outType.getExtensions()[0]);
                    lib.setLibFile(TextUtils.makeURLToFile(fullName));
                }
                lib.setChanged();
            }
            FileMenu.saveAllLibrariesCommand(this.outType, false, false);
            return true;
        }
    }

    private static class SaveLibrary
    extends Job {
        private Library lib;
        private String newName;
        private FileType type;
        private boolean compatibleWith6;
        private IdMapper idMapper;

        public SaveLibrary(Library lib, String newName, FileType type, boolean compatibleWith6) {
            super("Write " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.type = type;
            this.compatibleWith6 = compatibleWith6;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            boolean success = false;
            try {
                if (this.newName != null) {
                    URL libURL = TextUtils.makeURLToFile(this.newName);
                    this.lib.setLibFile(libURL);
                    this.idMapper = this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
                    if (this.idMapper != null) {
                        this.lib = EDatabase.serverDatabase().getLib(this.idMapper.get(this.lib.getId()));
                    }
                }
                this.fieldVariableChanged("idMapper");
                success = !Output.writeLibrary(this.lib, this.type, this.compatibleWith6, false, false);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                throw new JobException("Exception caught when saving files: " + e.getMessage() + "Please check your disk libraries");
            }
            if (!success) {
                throw new JobException("Error saving files.  Please check your disk libraries");
            }
            return success;
        }

        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    private static class CloseLibrary
    extends Job {
        private Library lib;
        private boolean clearClipboard;

        public CloseLibrary(Library lib, boolean clearClipboard) {
            super("Close " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.clearClipboard = clearClipboard;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.clearClipboard) {
                Clipboard.clear();
            }
            if (this.lib.kill("delete")) {
                System.out.println("Library '" + this.lib.getName() + "' closed");
            }
            return true;
        }

        public void terminateOK() {
            WindowFrame.wantToRedoTitleNames();
            EditWindow.repaintAll();
            ToolBar.setSaveLibraryButton();
        }
    }

    public static class CreateCellWindow
    implements Runnable {
        private Cell cell;

        public CreateCellWindow(Cell cell) {
            this.cell = cell;
        }

        public void run() {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                WindowContent content = wf.getContent();
                if (content.getCell() != null) continue;
                wf.setCellWindow(this.cell, null);
                ToolBar.setSaveLibraryButton();
                return;
            }
            WindowFrame.createEditWindow(this.cell);
            ToolBar.setSaveLibraryButton();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReadInitialELIBs
    extends Job {
        private List<URL> fileURLs;

        public ReadInitialELIBs(List<URL> fileURLs) {
            super("Read Initial Libraries", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURLs = fileURLs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (URL file : this.fileURLs) {
                URL f;
                FileType defType = null;
                String fileName = file.getFile();
                defType = FileMenu.getLibraryFormat(fileName, defType);
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.JELIB.getExtensions()[0]), null)) {
                    defType = FileType.JELIB;
                    file = f;
                }
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.ELIB.getExtensions()[0]), null)) {
                    defType = FileType.ELIB;
                    file = f;
                }
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.DELIB.getExtensions()[0]), null)) {
                    defType = FileType.DELIB;
                    file = f;
                }
                if (defType == null && TextUtils.URLExists(f = TextUtils.makeURLToFile(fileName + "." + FileType.READABLEDUMP.getExtensions()[0]), null)) {
                    defType = FileType.READABLEDUMP;
                    file = f;
                }
                if (defType == null) {
                    defType = FileType.DEFAULTLIB;
                }
                new ReadLibrary(file, defType, null, null);
            }
            return true;
        }
    }

    public static class ImportLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Library createLib;
        private Library deleteLib;

        public ImportLibrary(URL fileURL, FileType type, Library deleteLib) {
            super("Import External Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.type = type;
            this.deleteLib = deleteLib;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.deleteLib != null) {
                if (!this.deleteLib.kill("replace")) {
                    return false;
                }
                this.deleteLib = null;
            }
            this.createLib = Input.importLibrary(this.fileURL, this.type);
            if (this.createLib == null) {
                return false;
            }
            Library noname = Library.findLibrary("noname");
            if (noname != null && !noname.getCells().hasNext()) {
                noname.kill("delete");
            }
            this.fieldVariableChanged("createLib");
            return true;
        }

        public void terminateOK() {
            this.createLib.setCurrent();
            Cell showThisCell = Job.getUserInterface().getCurrentCell(this.createLib);
            FileMenu.doneOpeningLibrary(showThisCell);
        }
    }

    public static class ReadLibrary
    extends Job {
        private URL fileURL;
        private FileType type;
        private Library deleteLib;
        private String cellName;
        private HashMap<Object, Map<String, Object>> meaningVariables;
        private Library lib;

        public ReadLibrary(URL fileURL, FileType type, Library deleteLib, String cellName) {
            super("Read External Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.type = type;
            this.deleteLib = deleteLib;
            this.cellName = cellName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.deleteLib != null) {
                if (!this.deleteLib.kill("replace")) {
                    return false;
                }
                this.deleteLib = null;
            }
            this.fieldVariableChanged("meaningVariables");
            this.meaningVariables = new HashMap();
            this.lib = LibraryFiles.readLibrary(this.fileURL, null, this.type, false, this.meaningVariables);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            Library noname = Library.findLibrary("noname");
            if (noname != null && !noname.getCells().hasNext()) {
                noname.kill("delete");
            }
            this.lib.setCurrent();
            return true;
        }

        public void terminateOK() {
            File projsettings = new File(User.getWorkingDirectory(), "projsettings.xml");
            if (projsettings.exists()) {
                ProjSettings.readSettings(projsettings, false);
            } else {
                Pref.reconcileMeaningVariables(this.lib.getName(), this.meaningVariables);
                this.meaningVariables = null;
            }
            Cell showThisCell = this.cellName != null ? this.lib.findNodeProto(this.cellName) : Job.getUserInterface().getCurrentCell(this.lib);
            FileMenu.doneOpeningLibrary(showThisCell);
            CircuitChanges.checkAndRepairCommand(true);
        }
    }

    private static class NewLibrary
    extends Job {
        private String newLibName;

        public NewLibrary(String newLibName) {
            super("New Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newLibName = newLibName;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Library lib = Library.newInstance(this.newLibName, null);
            if (lib == null) {
                return false;
            }
            lib.setCurrent();
            System.out.println("New " + lib + " created");
            return true;
        }

        public void terminateOK() {
            EditWindow.repaintAll();
            ToolBar.setSaveLibraryButton();
        }
    }
}

