/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.util.PropertiesUtils;
import com.sun.electric.util.config.Configuration;
import com.sun.electric.util.test.TestByReflection;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Launcher {
    private static final boolean enableAssertions = true;
    private static final Logger logger = Logger.getLogger(Launcher.class.getName());
    private static final String[] propertiesToCopy = new String[]{"user.home"};
    private static String additionalFolder = "additional";
    private static String configFile = "econfig.xml";
    private static ClassLoader pluginClassLoader;

    private Launcher() {
    }

    public static void main(String[] args) {
        int i;
        for (int i2 = 0; i2 < args.length; ++i2) {
            String str = args[i2];
            if (str.equals("-NOMINMEM")) {
                Launcher.loadAndRunMain(args, true);
                return;
            }
            if (!str.equals("-help") && !str.equals("-version") && !str.equals("-v")) continue;
            Launcher.loadAndRunMain(args, false);
            return;
        }
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        if (args.length >= 2 && args[0].equals("-regression") || args.length >= 3 && args[0].equals("-debug") && args[1].equals("-regression") || args.length >= 4 && args[0].equals("-threads") && args[2].equals("-regression") || args.length >= 4 && args[0].equals("-logging") && args[2].equals("-regression")) {
            Launcher.initClasspath(true);
            System.exit(Launcher.invokeRegression(args) ? 0 : 1);
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        int maxMem = (int)(runtime.maxMemory() / 1000000L);
        int maxPermWanted = Launcher.getUserInt("PermSize", 0);
        int maxMemWanted = Launcher.getUserInt("PermSize", 0);
        if (maxMemWanted <= maxMem && maxPermWanted == 0 || Arrays.asList(args).contains("-pipeserver")) {
            Launcher.loadAndRunMain(args, true);
            return;
        }
        ArrayList<String> procArgs = new ArrayList<String>();
        procArgs.add(program);
        procArgs.add("-cp");
        procArgs.add(Launcher.getJarLocation());
        procArgs.add("-ss2m");
        procArgs.add("-ea");
        procArgs.add("-mx" + maxMemWanted + "m");
        if (maxPermWanted > 0) {
            procArgs.add("-XX:MaxPermSize=" + maxPermWanted + "m");
        }
        for (i = 0; i < propertiesToCopy.length; ++i) {
            String propValue = System.getProperty(propertiesToCopy[i]);
            if (propValue == null || propValue.length() <= 0) continue;
            if (propValue.indexOf(32) >= 0) {
                propValue = "\"" + propValue + "\"";
            }
            procArgs.add("-D" + propertiesToCopy[i] + "=" + propValue);
        }
        procArgs.add("com.sun.electric.Launcher");
        procArgs.add("-NOMINMEM");
        for (i = 0; i < args.length; ++i) {
            procArgs.add(args[i]);
        }
        if (maxMemWanted > maxMem) {
            logger.log(Level.INFO, "Current Java memory limit of {0}MEG is too small, rerunning Electric with a memory limit of {1}MEG", new Object[]{maxMem, maxMemWanted});
        }
        if (maxPermWanted > 0) {
            logger.log(Level.INFO, "Setting maximum permanent space (2nd GC) to {0}MEG", new Object[]{maxPermWanted});
        }
        ProcessBuilder processBuilder = new ProcessBuilder(procArgs);
        try {
            processBuilder.start();
            System.exit(0);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error starting Electric subprocess", e);
            Launcher.loadAndRunMain(args, false);
        }
    }

    private static String[] getConfig(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-config=")) continue;
            configFile = arg.replaceAll("-config=", "");
            args = Launcher.removeArg(args, arg);
            return args;
        }
        return args;
    }

    private static String[] removeArg(String[] args, String option) {
        ArrayList tmp = new ArrayList();
        Collections.addAll(tmp, args);
        tmp.remove(option);
        return tmp.toArray(new String[tmp.size()]);
    }

    @TestByReflection(testMethodName="getAdditionalFolder")
    private static String[] getAdditionalFolder(String[] args) {
        for (String arg : args) {
            if (!arg.startsWith("-additionalfolder=")) continue;
            additionalFolder = arg.replaceAll("-additionalfolder=", "");
            args = Launcher.removeArg(args, arg);
            return args;
        }
        return args;
    }

    public static String getJarLocation() {
        String jarPath = System.getProperty("java.class.path", ".");
        if (jarPath.indexOf(32) >= 0) {
            jarPath = "\"" + jarPath + "\"";
        }
        return jarPath;
    }

    private static int getUserInt(String key, int def) {
        return Preferences.userNodeForPackage(Launcher.class).node("tool/user").getInt(key, def);
    }

    private static boolean invokeRegression(String[] args) {
        ArrayList<String> javaOptions = new ArrayList<String>();
        ArrayList<String> electricOptions = new ArrayList<String>();
        electricOptions.add("-debug");
        int regressionPos = 0;
        if (args[0].equals("-threads")) {
            regressionPos = 2;
            electricOptions.add("-threads");
            electricOptions.add(args[1]);
        } else if (args[0].equals("-logging")) {
            regressionPos = 2;
            electricOptions.add("-logging");
            electricOptions.add(args[1]);
        } else if (args[0].equals("-debug")) {
            regressionPos = 1;
        }
        String script = args[regressionPos + 1];
        for (int i = regressionPos + 2; i < args.length; ++i) {
            javaOptions.add(args[i]);
        }
        Process process = null;
        try {
            process = Launcher.invokePipeserver(javaOptions, electricOptions);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failure starting server subprocess", e);
            return false;
        }
        Launcher.initClasspath(true);
        boolean result2 = (Boolean)Launcher.callByReflection(ClassLoader.getSystemClassLoader(), "com.sun.electric.tool.Regression", "runScript", new Class[]{Process.class, String.class}, null, new Object[]{process, script});
        return result2;
    }

    public static Process invokePipeserver(List<String> javaOptions, List<String> electricOptions) throws IOException {
        ArrayList<String> procArgs = new ArrayList<String>();
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        procArgs.add(program);
        procArgs.add("-ea");
        procArgs.add("-Djava.util.prefs.PreferencesFactory=com.sun.electric.database.text.EmptyPreferencesFactory");
        procArgs.addAll(javaOptions);
        procArgs.add("-cp");
        procArgs.add(Launcher.getJarLocation());
        procArgs.add("com.sun.electric.Launcher");
        procArgs.addAll(electricOptions);
        procArgs.add("-pipeserver");
        String command = "";
        for (String arg : procArgs) {
            command = command + " " + arg;
        }
        logger.log(Level.INFO, "exec: {0}", new Object[]{command});
        return new ProcessBuilder(procArgs).start();
    }

    public static Class classFromPlugins(String className) throws ClassNotFoundException {
        return pluginClassLoader.loadClass(className);
    }

    private static void loadAndRunMain(String[] args, boolean loadDependencies) {
        args = Launcher.getAdditionalFolder(args);
        args = Launcher.getConfig(args);
        Configuration.setConfigName(configFile);
        Launcher.initClasspath(loadDependencies);
        Launcher.callByReflection(pluginClassLoader, "com.sun.electric.Main", "main", new Class[]{String[].class}, null, new Object[]{args});
    }

    private static void initClasspath(boolean loadDependencies) {
        ClassLoader launcherLoader;
        pluginClassLoader = launcherLoader = Launcher.class.getClassLoader();
        if (loadDependencies) {
            Launcher.initClasspath(Launcher.readAdditionalFolder(), launcherLoader);
            Launcher.initClasspath(Launcher.readMavenDependencies(), launcherLoader);
        }
        launcherLoader.setDefaultAssertionStatus(true);
        pluginClassLoader.setDefaultAssertionStatus(true);
    }

    private static void initClasspath(URL[] urls, ClassLoader launcherLoader) {
        for (URL url : urls) {
            Object result2 = Launcher.callByReflection(launcherLoader, "java.net.URLClassLoader", "addURL", new Class[]{URL.class}, launcherLoader, new Object[]{url});
        }
    }

    private static URL[] readAdditionalFolder() {
        ArrayList<URL> urls = new ArrayList<URL>();
        File additionalFolder = new File("additional");
        if (additionalFolder.exists() && additionalFolder.isDirectory()) {
            File[] files;
            for (File file : files = additionalFolder.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".jar");
                }
            })) {
                try {
                    urls.add(file.toURI().toURL());
                    logger.info("Add " + file.getAbsoluteFile() + " to classpath...");
                }
                catch (MalformedURLException e) {
                    logger.log(Level.SEVERE, "Add " + file.getAbsoluteFile() + " to classpath...", e);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL[] readMavenDependencies() {
        String path;
        String mavenDependenciesResourceName = "maven.dependencies";
        URL mavenDependencies = ClassLoader.getSystemResource(mavenDependenciesResourceName);
        if (mavenDependencies == null) {
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<File> repositories = new ArrayList<File>();
        String mavenRepository = ".m2" + File.separator + "repository";
        String homeDirProp = System.getProperty("user.home");
        if (homeDirProp != null) {
            File homeDir = new File(homeDirProp);
            File file = new File(homeDir, mavenRepository);
            if (file.canRead()) {
                repositories.add(file);
                logger.log(Level.FINE, "Found repository {0}", file);
            } else if (file.exists()) {
                logger.log(Level.FINE, "Can't read repository {0}", file);
            } else {
                logger.log(Level.FINE, "Not found repository {0}", file);
            }
        }
        if (mavenDependencies.getProtocol().equals("jar") && (path = mavenDependencies.getPath()).startsWith("file:") && path.endsWith("!/" + mavenDependenciesResourceName)) {
            String jarPath = path.substring("file:".length(), path.length() - "!/".length() - mavenDependenciesResourceName.length());
            File jarDir = new File(jarPath).getParentFile();
            File file = new File(jarDir, mavenRepository);
            if (file.canRead()) {
                repositories.add(file);
                logger.log(Level.FINE, "Found repository {0}", file);
            } else if (file.exists()) {
                logger.log(Level.FINE, "Can't read repository {0}", file);
            } else {
                logger.log(Level.FINE, "Not found repository {0}", file);
            }
        }
        try {
            Properties properties = PropertiesUtils.load(mavenDependenciesResourceName);
            block2: for (Object dependency : properties.keySet()) {
                for (File repository : repositories) {
                    File file = new File(repository, dependency.toString());
                    if (file.canRead()) {
                        URL url = file.toURI().toURL();
                        urls.add(url);
                        logger.log(Level.FINE, "Add {0} to class path", url);
                        continue block2;
                    }
                    if (file.exists()) {
                        logger.log(Level.FINE, "Can't read {0}", file);
                        continue;
                    }
                    logger.log(Level.FINEST, "Not found {0}", file);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error reading maven dependencies", e);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static Object callByReflection(ClassLoader classLoader, String className, String methodName, Class[] argTypes, Object obj, Object[] argValues) {
        try {
            Class<?> mainClass = classLoader.loadClass(className);
            Method method = mainClass.getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return method.invoke(obj, argValues);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Can't invoke Electric", e);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Can't invoke Electric", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.SEVERE, "Can't invoke Electric", e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, "Error in Electric invocation", e.getTargetException());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EClassLoader
    extends URLClassLoader {
        private EClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("com.sun.electric.plugins.") || name.startsWith("com.sun.electric.scala.")) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    String path = name.replace('.', '/').concat(".class");
                    URL url = this.getResource(path);
                    if (url != null) {
                        try {
                            DataInputStream in = new DataInputStream(url.openStream());
                            int len = in.available();
                            byte[] ba = new byte[len];
                            in.readFully(ba);
                            in.close();
                            c = this.defineClass(name, ba, 0, len);
                        }
                        catch (IOException e) {
                            throw new ClassNotFoundException(name);
                        }
                    } else {
                        throw new ClassNotFoundException(name);
                    }
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

