/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2015 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
      value = 24;	/* --> subs.  */
      break;
    case 141:	/* mov */
      value = 140;	/* --> umov.  */
      break;
    case 143:	/* mov */
      value = 142;	/* --> ins.  */
      break;
    case 145:	/* mov */
      value = 144;	/* --> ins.  */
      break;
    case 206:	/* mvn */
      value = 205;	/* --> not.  */
      break;
    case 261:	/* mov */
      value = 260;	/* --> orr.  */
      break;
    case 318:	/* sxtl */
      value = 317;	/* --> sshll.  */
      break;
    case 320:	/* sxtl2 */
      value = 319;	/* --> sshll2.  */
      break;
    case 340:	/* uxtl */
      value = 339;	/* --> ushll.  */
      break;
    case 342:	/* uxtl2 */
      value = 341;	/* --> ushll2.  */
      break;
    case 437:	/* mov */
      value = 436;	/* --> dup.  */
      break;
    case 506:	/* sxtw */
    case 505:	/* sxth */
    case 504:	/* sxtb */
    case 507:	/* asr */
    case 503:	/* sbfx */
    case 502:	/* sbfiz */
      value = 501;	/* --> sbfm.  */
      break;
    case 510:	/* bfxil */
    case 509:	/* bfi */
      value = 508;	/* --> bfm.  */
      break;
    case 515:	/* uxth */
    case 514:	/* uxtb */
    case 517:	/* lsr */
    case 516:	/* lsl */
    case 513:	/* ubfx */
    case 512:	/* ubfiz */
      value = 511;	/* --> ubfm.  */
      break;
    case 535:	/* cset */
    case 534:	/* cinc */
      value = 533;	/* --> csinc.  */
      break;
    case 538:	/* csetm */
    case 537:	/* cinv */
      value = 536;	/* --> csinv.  */
      break;
    case 540:	/* cneg */
      value = 539;	/* --> csneg.  */
      break;
    case 565:	/* lsl */
      value = 564;	/* --> lslv.  */
      break;
    case 567:	/* lsr */
      value = 566;	/* --> lsrv.  */
      break;
    case 569:	/* asr */
      value = 568;	/* --> asrv.  */
      break;
    case 571:	/* ror */
      value = 570;	/* --> rorv.  */
      break;
    case 581:	/* mul */
      value = 580;	/* --> madd.  */
      break;
    case 583:	/* mneg */
      value = 582;	/* --> msub.  */
      break;
    case 585:	/* smull */
      value = 584;	/* --> smaddl.  */
      break;
    case 587:	/* smnegl */
      value = 586;	/* --> smsubl.  */
      break;
    case 590:	/* umull */
      value = 589;	/* --> umaddl.  */
      break;
    case 592:	/* umnegl */
      value = 591;	/* --> umsubl.  */
      break;
    case 603:	/* ror */
      value = 602;	/* --> extr.  */
      break;
    case 760:	/* bic */
      value = 759;	/* --> and.  */
      break;
    case 762:	/* mov */
      value = 761;	/* --> orr.  */
      break;
    case 765:	/* tst */
      value = 764;	/* --> ands.  */
      break;
    case 770:	/* uxtw */
    case 769:	/* mov */
      value = 768;	/* --> orr.  */
      break;
    case 772:	/* mvn */
      value = 771;	/* --> orn.  */
      break;
    case 776:	/* tst */
      value = 775;	/* --> ands.  */
      break;
    case 902:	/* staddb */
      value = 806;	/* --> ldaddb.  */
      break;
    case 903:	/* staddh */
      value = 807;	/* --> ldaddh.  */
      break;
    case 904:	/* stadd */
      value = 808;	/* --> ldadd.  */
      break;
    case 905:	/* staddlb */
      value = 810;	/* --> ldaddlb.  */
      break;
    case 906:	/* staddlh */
      value = 813;	/* --> ldaddlh.  */
      break;
    case 907:	/* staddl */
      value = 816;	/* --> ldaddl.  */
      break;
    case 908:	/* stclrb */
      value = 818;	/* --> ldclrb.  */
      break;
    case 909:	/* stclrh */
      value = 819;	/* --> ldclrh.  */
      break;
    case 910:	/* stclr */
      value = 820;	/* --> ldclr.  */
      break;
    case 911:	/* stclrlb */
      value = 822;	/* --> ldclrlb.  */
      break;
    case 912:	/* stclrlh */
      value = 825;	/* --> ldclrlh.  */
      break;
    case 913:	/* stclrl */
      value = 828;	/* --> ldclrl.  */
      break;
    case 914:	/* steorb */
      value = 830;	/* --> ldeorb.  */
      break;
    case 915:	/* steorh */
      value = 831;	/* --> ldeorh.  */
      break;
    case 916:	/* steor */
      value = 832;	/* --> ldeor.  */
      break;
    case 917:	/* steorlb */
      value = 834;	/* --> ldeorlb.  */
      break;
    case 918:	/* steorlh */
      value = 837;	/* --> ldeorlh.  */
      break;
    case 919:	/* steorl */
      value = 840;	/* --> ldeorl.  */
      break;
    case 920:	/* stsetb */
      value = 842;	/* --> ldsetb.  */
      break;
    case 921:	/* stseth */
      value = 843;	/* --> ldseth.  */
      break;
    case 922:	/* stset */
      value = 844;	/* --> ldset.  */
      break;
    case 923:	/* stsetlb */
      value = 846;	/* --> ldsetlb.  */
      break;
    case 924:	/* stsetlh */
      value = 849;	/* --> ldsetlh.  */
      break;
    case 925:	/* stsetl */
      value = 852;	/* --> ldsetl.  */
      break;
    case 926:	/* stsmaxb */
      value = 854;	/* --> ldsmaxb.  */
      break;
    case 927:	/* stsmaxh */
      value = 855;	/* --> ldsmaxh.  */
      break;
    case 928:	/* stsmax */
      value = 856;	/* --> ldsmax.  */
      break;
    case 929:	/* stsmaxlb */
      value = 858;	/* --> ldsmaxlb.  */
      break;
    case 930:	/* stsmaxlh */
      value = 861;	/* --> ldsmaxlh.  */
      break;
    case 931:	/* stsmaxl */
      value = 864;	/* --> ldsmaxl.  */
      break;
    case 932:	/* stsminb */
      value = 866;	/* --> ldsminb.  */
      break;
    case 933:	/* stsminh */
      value = 867;	/* --> ldsminh.  */
      break;
    case 934:	/* stsmin */
      value = 868;	/* --> ldsmin.  */
      break;
    case 935:	/* stsminlb */
      value = 870;	/* --> ldsminlb.  */
      break;
    case 936:	/* stsminlh */
      value = 873;	/* --> ldsminlh.  */
      break;
    case 937:	/* stsminl */
      value = 876;	/* --> ldsminl.  */
      break;
    case 938:	/* stumaxb */
      value = 878;	/* --> ldumaxb.  */
      break;
    case 939:	/* stumaxh */
      value = 879;	/* --> ldumaxh.  */
      break;
    case 940:	/* stumax */
      value = 880;	/* --> ldumax.  */
      break;
    case 941:	/* stumaxlb */
      value = 882;	/* --> ldumaxlb.  */
      break;
    case 942:	/* stumaxlh */
      value = 885;	/* --> ldumaxlh.  */
      break;
    case 943:	/* stumaxl */
      value = 888;	/* --> ldumaxl.  */
      break;
    case 944:	/* stuminb */
      value = 890;	/* --> lduminb.  */
      break;
    case 945:	/* stuminh */
      value = 891;	/* --> lduminh.  */
      break;
    case 946:	/* stumin */
      value = 892;	/* --> ldumin.  */
      break;
    case 947:	/* stuminlb */
      value = 894;	/* --> lduminlb.  */
      break;
    case 948:	/* stuminlh */
      value = 897;	/* --> lduminlh.  */
      break;
    case 949:	/* stuminl */
      value = 900;	/* --> lduminl.  */
      break;
    case 951:	/* mov */
      value = 950;	/* --> movn.  */
      break;
    case 953:	/* mov */
      value = 952;	/* --> movz.  */
      break;
    case 964:	/* sevl */
    case 963:	/* sev */
    case 962:	/* wfi */
    case 961:	/* wfe */
    case 960:	/* yield */
    case 959:	/* nop */
      value = 958;	/* --> hint.  */
      break;
    case 973:	/* tlbi */
    case 972:	/* ic */
    case 971:	/* dc */
    case 970:	/* at */
      value = 969;	/* --> sys.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
      return aarch64_ins_regno (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ins_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ins_reglane (self, info, code, inst);
    case 31:
      return aarch64_ins_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 37:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 67:
    case 68:
    case 69:
    case 70:
      return aarch64_ins_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 59:
      return aarch64_ins_limm (self, info, code, inst);
    case 60:
      return aarch64_ins_aimm (self, info, code, inst);
    case 61:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 62:
      return aarch64_ins_fbits (self, info, code, inst);
    case 64:
    case 65:
      return aarch64_ins_cond (self, info, code, inst);
    case 71:
    case 77:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 72:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 73:
    case 74:
    case 75:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 76:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 78:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 79:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 80:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 81:
    case 82:
    case 83:
    case 84:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 85:
    case 86:
      return aarch64_ins_barrier (self, info, code, inst);
    case 87:
      return aarch64_ins_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
