/* Pentium 4-64 gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 1991, 1993, 1994, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
2008, 2009 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the GNU MP Library.  If not, see http://www.gnu.org/licenses/.  */

#define BITS_PER_MP_LIMB 64
#define BYTES_PER_MP_LIMB 8

/* These routines exists for all x86_64 chips, but they are slower on Pentium4
   than separate add/sub and shift.  Make sure they are not really used.  */
#undef HAVE_NATIVE_mpn_addlsh1_n
#undef HAVE_NATIVE_mpn_sublsh1_n
#undef HAVE_NATIVE_mpn_rsh1add_n
#undef HAVE_NATIVE_mpn_rsh1sub_n

/* 3200 MHz Pentium / 2048 Kibyte cache / socket 775 */

/* Generated by tuneup.c, 2009-01-15, gcc 3.4 */

#define MUL_KARATSUBA_THRESHOLD          12
#define MUL_TOOM3_THRESHOLD              91
#define MUL_TOOM44_THRESHOLD            136

#define SQR_BASECASE_THRESHOLD            0  /* always (native) */
#define SQR_KARATSUBA_THRESHOLD          28
#define SQR_TOOM3_THRESHOLD              97
#define SQR_TOOM4_THRESHOLD             218

#define MULLOW_BASECASE_THRESHOLD         0  /* always */
#define MULLOW_DC_THRESHOLD              28
#define MULLOW_MUL_N_THRESHOLD          246

#define DIV_SB_PREINV_THRESHOLD           0  /* always */
#define DIV_DC_THRESHOLD                 35
#define POWM_THRESHOLD                   59

#define MATRIX22_STRASSEN_THRESHOLD      25
#define HGCD_THRESHOLD                  112
#define GCD_DC_THRESHOLD                258
#define GCDEXT_DC_THRESHOLD             311
#define JACOBI_BASE_METHOD                1

#define MOD_1_NORM_THRESHOLD              0  /* always */
#define MOD_1_UNNORM_THRESHOLD            0  /* always */
#define MOD_1_1_THRESHOLD                 5
#define MOD_1_2_THRESHOLD                 7
#define MOD_1_4_THRESHOLD                28
#define USE_PREINV_DIVREM_1               1  /* native */
#define USE_PREINV_MOD_1                  1
#define DIVEXACT_1_THRESHOLD              0  /* always (native) */
#define MODEXACT_1_ODD_THRESHOLD          0  /* always (native) */

#define GET_STR_DC_THRESHOLD             15
#define GET_STR_PRECOMPUTE_THRESHOLD     24
#define SET_STR_DC_THRESHOLD            866
#define SET_STR_PRECOMPUTE_THRESHOLD   1646

#define MUL_FFT_TABLE  { 240, 416, 1216, 2304, 7168, 20480, 49152, 196608, 786432, 0 }
#define MUL_FFT_MODF_THRESHOLD          256
#define MUL_FFT_THRESHOLD              2944

#define SQR_FFT_TABLE  { 208, 480, 1600, 2304, 7168, 20480, 49152, 196608, 786432, 0 }
#define SQR_FFT_MODF_THRESHOLD          224
#define SQR_FFT_THRESHOLD              2688
