/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.TryExp;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InlineCalls
extends ExpWalker {
    private static Class[] inlinerMethodArgTypes;

    public static void inlineCalls(Expression exp, Compilation comp) {
        InlineCalls walker = new InlineCalls(comp);
        walker.walk(exp);
    }

    public InlineCalls(Compilation comp) {
        this.setContext(comp);
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        Expression func = exp.func;
        if (func instanceof LambdaExp) {
            LambdaExp lexp = (LambdaExp)func;
            Expression inlined = InlineCalls.inlineCall((LambdaExp)func, exp.args, false);
            if (inlined != null) {
                return this.walk(inlined);
            }
        }
        exp.func = func = this.walk(func);
        return func.inline(exp, this, null, false);
    }

    public final Expression walkApplyOnly(ApplyExp exp) {
        return exp.func.inline(exp, this, null, true);
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration decl = exp.getBinding();
        if (decl != null && decl.field == null && !decl.getCanWrite()) {
            Expression dval = decl.getValue();
            if (dval instanceof QuoteExp && dval != QuoteExp.undefined_exp) {
                return this.walkQuoteExp((QuoteExp)dval);
            }
            if (dval instanceof ReferenceExp && !decl.isAlias()) {
                ReferenceExp rval = (ReferenceExp)dval;
                Declaration rdecl = rval.getBinding();
                Type dtype = decl.getType();
                if (!(rdecl == null || rdecl.getCanWrite() || dtype != null && dtype != Type.pointer_type && dtype != rdecl.getType() || rval.getDontDereference())) {
                    return this.walkReferenceExp(rval);
                }
            }
            if (!exp.isProcedureName() && (decl.flags & 0x100080L) == 0x100080L) {
                this.comp.error('e', "unimplemented: reference to method " + decl.getName() + " as variable");
                this.comp.error('e', decl, "here is the definition of ", "");
            }
        }
        return super.walkReferenceExp(exp);
    }

    protected Expression walkIfExp(IfExp exp) {
        Expression value;
        Declaration decl;
        Expression test2 = exp.test.walk(this);
        if (test2 instanceof ReferenceExp && (decl = ((ReferenceExp)test2).getBinding()) != null && (value = decl.getValue()) instanceof QuoteExp && value != QuoteExp.undefined_exp) {
            test2 = value;
        }
        exp.test = test2;
        if (this.exitValue == null) {
            exp.then_clause = this.walk(exp.then_clause);
        }
        if (this.exitValue == null && exp.else_clause != null) {
            exp.else_clause = this.walk(exp.else_clause);
        }
        if (test2 instanceof QuoteExp) {
            boolean truth = this.comp.getLanguage().isTrue(((QuoteExp)test2).getValue());
            return exp.select(truth);
        }
        if (test2.getType().isVoid()) {
            boolean truth = this.comp.getLanguage().isTrue(Values.empty);
            this.comp.error('w', "void-valued condition is always " + truth);
            return new BeginExp(test2, exp.select(truth));
        }
        return exp;
    }

    protected Expression walkScopeExp(ScopeExp exp) {
        exp.walkChildren(this);
        this.walkDeclarationTypes(exp);
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.type != null) continue;
            Expression val = decl.getValue();
            decl.type = Type.objectType;
            decl.setType(val != null && val != QuoteExp.undefined_exp ? val.getType() : Type.objectType);
        }
        return exp;
    }

    protected Expression walkLetExp(LetExp exp) {
        ReferenceExp ref;
        Declaration d;
        Expression init;
        Declaration decl = exp.firstDecl();
        int n = exp.inits.length;
        int i = 0;
        while (i < n) {
            Expression init0 = exp.inits[i];
            exp.inits[i] = init = this.walk(init0);
            Expression dvalue = decl.value;
            if (dvalue == init0) {
                decl.value = dvalue = init;
                if (!decl.getFlag(8192L)) {
                    decl.setType(dvalue.getType());
                }
            }
            ++i;
            decl = decl.nextDecl();
        }
        if (this.exitValue == null) {
            exp.body = this.walk(exp.body);
        }
        if (exp.body instanceof ReferenceExp && (d = (ref = (ReferenceExp)exp.body).getBinding()) != null && d.context == exp && !ref.getDontDereference() && n == 1) {
            init = exp.inits[0];
            Expression texp = d.getTypeExp();
            if (texp != QuoteExp.classObjectExp) {
                init = this.walkApplyOnly(Compilation.makeCoercion(init, texp));
            }
            return init;
        }
        return exp;
    }

    protected Expression walkLambdaExp(LambdaExp exp) {
        Declaration firstDecl = exp.firstDecl();
        if (firstDecl != null && firstDecl.isThisParameter() && !exp.isClassMethod() && firstDecl.type == null) {
            firstDecl.setType(this.comp.mainClass);
        }
        return this.walkScopeExp(exp);
    }

    protected Expression walkTryExp(TryExp exp) {
        if (exp.getCatchClauses() == null && exp.getFinallyClause() == null) {
            return this.walk(exp.try_clause);
        }
        return super.walkTryExp(exp);
    }

    protected Expression walkSetExp(SetExp exp) {
        super.walkSetExp(exp);
        Declaration decl = exp.getBinding();
        if (!exp.isDefining() && decl != null && (decl.flags & 0x100080L) == 0x100080L) {
            this.comp.error('e', "can't assign to method " + decl.getName(), exp);
        }
        if (decl != null && decl.getFlag(8192L) && Invoke.checkKnownClass(decl.getType(), this.comp) < 0) {
            decl.setType(Type.errorType);
        }
        return exp;
    }

    private static synchronized Class[] getInlinerMethodArgTypes() throws Exception {
        Class[] t = inlinerMethodArgTypes;
        if (t == null) {
            t = new Class[]{Class.forName("gnu.expr.ApplyExp"), Class.forName("gnu.expr.InlineCalls"), Boolean.TYPE, Class.forName("gnu.mapping.Procedure")};
            inlinerMethodArgTypes = t;
        }
        return t;
    }

    public Expression maybeInline(ApplyExp exp, boolean argsInlined, Procedure proc) {
        try {
            Object inliner = Procedure.inlineCallsKey.get(proc);
            if (inliner != null) {
                return ((CanInline)inliner).inline(exp, this, argsInlined);
            }
            inliner = proc.getProperty(Procedure.inlinerKey, null);
            if (inliner != null) {
                Boolean argsInlinedBoxed = argsInlined;
                if (inliner instanceof Procedure) {
                    return (Expression)((Procedure)inliner).apply4(exp, this, argsInlinedBoxed, proc);
                }
                if (inliner instanceof String) {
                    String inliners = (String)inliner;
                    int colon = inliners.indexOf(58);
                    Method method = null;
                    if (colon > 0) {
                        String cname = inliners.substring(0, colon);
                        String mname = inliners.substring(colon + 1);
                        Class<?> clas = Class.forName(cname, true, proc.getClass().getClassLoader());
                        method = clas.getDeclaredMethod(mname, InlineCalls.getInlinerMethodArgTypes());
                    }
                    if (method == null) {
                        this.error('e', "inliner property string for " + proc + " is not of the form CLASS:METHOD");
                        return null;
                    }
                    inliner = method;
                    proc.setProperty(Procedure.inlinerKey, method);
                }
                return (Expression)((Method)inliner).invoke(null, exp, this, argsInlinedBoxed, proc);
            }
            if (proc instanceof CanInline) {
                return ((CanInline)((Object)proc)).inline(exp, this, argsInlined);
            }
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            this.messages.error('e', "caught exception in inliner for " + proc + " - " + ex, ex);
        }
        return null;
    }

    public static Expression inlineCall(LambdaExp lexp, Expression[] args, boolean makeCopy) {
        boolean varArgs;
        if (lexp.keywords != null || lexp.nameDecl != null && !makeCopy) {
            return null;
        }
        boolean bl = varArgs = lexp.max_args < 0;
        if (lexp.min_args == lexp.max_args && lexp.min_args == args.length || varArgs && lexp.min_args == 0) {
            Expression[] cargs;
            IdentityHashTable<Declaration, Declaration> mapper;
            Declaration prev = null;
            int i = 0;
            if (makeCopy) {
                mapper = new IdentityHashTable<Declaration, Declaration>();
                cargs = Expression.deepCopy(args, mapper);
                if (cargs == null && args != null) {
                    return null;
                }
            } else {
                mapper = null;
                cargs = args;
            }
            if (varArgs) {
                Expression[] xargs = new Expression[args.length + 1];
                xargs[0] = QuoteExp.getInstance(lexp.firstDecl().type);
                System.arraycopy(args, 0, xargs, 1, args.length);
                cargs = new Expression[]{new ApplyExp(Invoke.make, xargs)};
            }
            LetExp let2 = new LetExp(cargs);
            Declaration param = lexp.firstDecl();
            while (param != null) {
                Declaration next = param.nextDecl();
                if (makeCopy) {
                    Declaration ldecl = let2.addDeclaration(param.symbol, param.type);
                    if (param.typeExp != null) {
                        ldecl.typeExp = Expression.deepCopy(param.typeExp);
                        if (ldecl.typeExp == null) {
                            return null;
                        }
                    }
                    mapper.put(param, ldecl);
                } else {
                    lexp.remove(prev, param);
                    let2.add(prev, param);
                }
                if (!varArgs && !param.getCanWrite()) {
                    param.setValue(cargs[i]);
                }
                prev = param;
                param = next;
                ++i;
            }
            Expression body = lexp.body;
            if (makeCopy && (body = Expression.deepCopy(body, mapper)) == null && lexp.body != null) {
                return null;
            }
            let2.body = body;
            return let2;
        }
        return null;
    }
}

