/* paramfuncs.c: -*- C -*-  Functions for handling parameters in PowerStrip. */

/* Copyright (c) 1997 Brian J. Fox
   Author: Brian J. Fox (bfox@ai.mit.edu) Mon May 12 13:35:44 1997.

   This file is part of <Meta-HTML>(tm), a system for the rapid deployment
   of Internet and Intranet applications via the use of the Meta-HTML
   language.

   Copyright (c) 1995, 1996, Brian J. Fox (bfox@ai.mit.edu).
   Copyright (c) 1996, Universal Access Inc. (http://www.ua.com).

   Meta-HTML is free software; you can redistribute it and/or modify
   it under the terms of the UAI Free Software License as published
   by Universal Access Inc.; either version 1, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   UAI Free Software License for more details.

   You should have received a copy of the UAI Free Software License
   along with this program; if you have not, you may obtain one by
   writing to:

   Universal Access Inc.
   129 El Paseo Court
   Santa Barbara, CA
   93101  */

#include "language.h"

static void pf_defparam (PFunArgs);

static PFunDesc functab[] = {
  /*   tag	     complex? debug_level	   code    */
  { "DEFPARAM",		0,	0,		pf_defparam },
  { (char *)NULL,	0,	0,		(PFunHandler *)NULL }
};

PACKAGE_INITIALIZER(initialize_param_funcs)

void
initialize_param_funcs (Package *pack)
{
  register int i;
  Symbol *sym;

  /* Install the names and pointers. */
  for (i = 0; functab[i].tag != (char *)NULL; i++)
    {
      sym = symbol_intern_in_package (mhtml_function_package, functab[i].tag);
      sym->type = symtype_FUNCTION;
      sym->values = (char **)(&functab[i]);
    }
}

#define DEFVAR(name, value) \
    if (empty_string_p (name)) { xfree (name); name = strdup (value); }

static void
pf_defparam (PFunArgs)
{
  char *name = mhtml_evaluate_string (get_positional_arg (vars, 0));
  char *docs = get_positional_arg (vars, 1);
  char *type = mhtml_evaluate_string (get_value (vars, "type"));
  char *value = get_value (vars, "value");
  Package *package = symbol_get_package ((char *)NULL);
  Package *params = symbol_get_package ("ibis-parameters");

  DEFVAR (type, "string");
  DEFVAR (value, "");
  DEFVAR (docs, "Undocumented Parameter");

  
  
