# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gnome.xmhtml
import string, re, os
import pyscript
import configureoutput
import cfg

class _HtmlWidgetCommon:
    def on_key_press_event(self, *argv):
        """
        Will be used to implement scrolling when GtkHTML is available
        """
        pass
    def read_docfile(self, filename, locale=None):
        import gettext
        filefound = None
        if locale:
            languages = [locale]
        else:
            languages = gettext.lang
        for lang in languages:
            if os.path.isfile(os.path.join('online-docs', lang, filename)):
                os.chdir(os.path.join("online-docs", lang))
                self.source(open(filename, 'r').read())
                filefound = 1
                os.chdir("../..")
                break
        if not filefound:
            for lang in languages:
                fn = os.path.join('online-docs', lang, 'missing-helpfile.html')
                if os.path.isfile(fn):
                    self.source(open(fn, 'r').read())

class GtkHTML(gtk.GtkScrolledWindow, _HtmlWidgetCommon):
    def __init__(self, activate_cb, anchor_track_cb):
        gtk.GtkScrolledWindow.__init__(self)
        self.__html = gtkhtml.GtkHTML()
        self.__html.show()
        self.add(self.__html)
        self.m_pyscript = pyscript.PyScript()
        self.__html.connect('link_clicked', lambda _o, url, f=activate_cb: f(url))
        self.__html.connect('url_requested', self.on_url_requested)
        if anchor_track_cb:
            self.__html.connect('on_url', lambda _o, url, f=anchor_track_cb:
                                f(url))
        self.__html.connect('load_done', self.on_load_done)
    def on_load_done(self, html, *v):
        #print "on_load_done", html, v
        pass
    def on_url_requested(self, html, fn, handle):
        """This is called when the widget need to load images
        """
        print "Sorry, images don't work with gtkhtml:", fn
        #return
        s = open(fn, 'r').read()
        self.__html.write(handle, s)
        #self.__html.end(handle, gtkhtml.HTML_STREAM_OK)
    def source(self, txt):
        txt = self.m_pyscript.evaluate(txt)
        self.m_handle = self.__html.begin()
        self.__html.write(self.m_handle, txt)
        self.__html.end(self.m_handle, gtkhtml.HTML_STREAM_OK)

class XmHTML(gtk.GtkEventBox, _HtmlWidgetCommon):
    """
    I had to make SolfegeXmHTML a GtkVBox containing a SolfegeXmHTML because
    otherwise there are problems with redrawing.
    """
    def __init__(self, activate_cb, anchor_track_cb):
        gtk.GtkEventBox.__init__(self)
        self.__html = gnome.xmhtml.GtkXmHTML()
        self.__html.show()
        self.m_pyscript = pyscript.PyScript()
        self.activate_cb = activate_cb
        self.anchor_track_cb = anchor_track_cb
        # for the win32 port
        if configureoutput.WITH_GNOME:
            self.__html.connect('activate',
                lambda _o, cbstruct, f=activate_cb: f(cbstruct.href))
            if anchor_track_cb:
                self.__html.connect('anchor_track',
                  lambda _o, cbstruct, F=anchor_track_cb: F(cbstruct.href))
        else:
            self.__html.activate_cb = self.activate_cb
        self.add(self.__html)
    def source(self, txt):
        txt = self.m_pyscript.evaluate(txt)
        self.__html.source(txt)


if not configureoutput.WITH_GNOME:
   cfg.set_string("gui/htmlwidget", "xmhtml")

if cfg.get_string("gui/htmlwidget") == 'gtkhtml':
    import gtkhtml
    HtmlWidget = GtkHTML
else:
    HtmlWidget = XmHTML
