/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Iterator;

class IvanFlater
extends HierarchyEnumerator.Visitor {
    private static final boolean debug = false;
    private Writer of;
    private int depth = 0;
    private int nameNumber = 0;

    private void spaces() {
        for (int i = 0; i < this.depth; ++i) {
            System.out.print(" ");
        }
    }

    private static void error(boolean pred, String msg) {
        if (pred) {
            throw new RuntimeException(msg);
        }
    }

    IvanFlater(String fileNm) {
        try {
            this.of = new BufferedWriter(new FileWriter(fileNm));
        }
        catch (Exception e) {
            IvanFlater.error(true, "can't open output file: " + e.toString());
        }
    }

    public void close() {
        try {
            this.of.close();
        }
        catch (Exception e) {
            IvanFlater.error(true, "close failed: " + e.toString());
        }
    }

    void writeExports(HierarchyEnumerator.CellInfo info) {
        Cell rootCell = info.getCell();
        Iterator it = rootCell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            Network net = info.getNetlist().getNetwork(e, 0);
            int netId = info.getNetID(net);
            String netNm = this.generateNetName(netId, info);
            this.writeln("EXPORT " + e.getName() + " " + netNm);
        }
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        if (info.isRootCell()) {
            this.writeExports(info);
        }
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    private String generateNetName(int id, HierarchyEnumerator.CellInfo info) {
        return null;
    }

    private String getNetNm(NodeInst ni, String portNm, HierarchyEnumerator.CellInfo info) {
        PortInst port = ni.findPortInst(portNm);
        IvanFlater.error(port == null, "can't find port: " + portNm);
        Network net = info.getNetlist().getNetwork(port);
        IvanFlater.error(net == null, "missing Network for port: " + portNm);
        int id = info.getNetID(net);
        IvanFlater.error(id < 0, "missing net ID for port: " + portNm);
        return this.generateNetName(id, info);
    }

    private void dumpVariables(NodeInst ni) {
        Iterator it = ni.getVariables();
        while (it.hasNext()) {
            Variable v = (Variable)it.next();
            System.out.println("    " + v.getKey() + " = " + v.getObject());
        }
    }

    private String getMosWidthLength(NodeInst ni) {
        SizeOffset so = ni.getSizeOffset();
        double w = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        double l = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
        return w + " " + l;
    }

    private void writeln(String msg) {
        try {
            this.of.write(msg);
            this.of.write("\n");
        }
        catch (Exception e) {
            IvanFlater.error(true, "writeln failed: " + this.of.toString());
        }
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        NodeProto np = no.getProto();
        String msg = null;
        if (np instanceof PrimitiveNode) {
            NodeInst ni = (NodeInst)no;
            String protNm = np.getName();
            if (protNm.equals("N-Transistor")) {
                msg = "NMOS " + this.getMosWidthLength(ni) + " " + this.getNetNm(ni, "n-trans-diff-top", info) + " " + this.getNetNm(ni, "n-trans-poly-right", info) + " " + this.getNetNm(ni, "n-trans-diff-bottom", info);
            } else if (protNm.equals("P-Transistor")) {
                msg = "PMOS " + this.getMosWidthLength(ni) + " " + this.getNetNm(ni, "p-trans-diff-top", info) + " " + this.getNetNm(ni, "p-trans-poly-right", info) + " " + this.getNetNm(ni, "p-trans-diff-bottom", info);
            } else if (protNm.equals("Transistor")) {
                msg = "MOS " + this.getMosWidthLength(ni) + " " + this.getNetNm(ni, "d", info) + " " + this.getNetNm(ni, "g", info) + " " + this.getNetNm(ni, "s", info);
            }
        }
        if (msg != null) {
            this.writeln(msg);
        }
        return true;
    }
}

