/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2PH {
    private static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double pGatesY = 4.0;
    private static final double nGatesY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double weakRatio = 10.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "nand2PH";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 6.0 * 2.0, 2);
        Nand2PH.error(fwP == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2PH.error(fwN == null, "can't make " + nm + " this small: " + sz);
        totWid = Math.max(3.0, totWid / 10.0);
        FoldsAndWidth fwW = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2PH.error(fwW == null, "can't make " + nm + " this small: " + sz);
        Cell gate = stdCell.findPart(nm, sz);
        if (gate != null) {
            return gate;
        }
        gate = stdCell.newPart(nm, sz);
        double resetNX = 3.5;
        double inbX = resetNX + 7.0;
        double resetNJogX = inbX + 7.0;
        double mosX = resetNJogX + 7.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, gate, stdCell);
        double nmosWeakY = -9.0 - fwW.physWid / 2.0;
        FoldedNmos nmosB = new FoldedNmos(mosX, nmosWeakY, fwW.nbFolds, 1, fwW.gateWid, gate, stdCell);
        double nmosBRightX = StdCellParams.getRightDiffX(nmosB);
        double nmosX = nmosBRightX + 11.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmosR = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, gate, stdCell);
        double rstNmosRightX = StdCellParams.getRightDiffX(nmosR);
        double pmosRightX = StdCellParams.getRightDiffX(pmos);
        double nmosAX = Math.max(rstNmosRightX + 11.0, pmosRightX - (double)(fwW.nbFolds * 8));
        FoldedNmos nmosA = new FoldedNmos(nmosAX, nmosWeakY, fwW.nbFolds, 1, fwW.gateWid, gate, stdCell);
        FoldedMos[] nmoss = new FoldedMos[]{nmosB, nmosR, nmosA};
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, gate);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, gate);
        TrackRouterH bGates = new TrackRouterH(Tech.m1, 3.0, 4.0, gate);
        TrackRouterH aGatesHi = new TrackRouterH(Tech.m1, 4.0, 4.0, gate);
        int nbGates = pmos.nbGates() / 2;
        for (int i2 = 0; i2 < nbGates; ++i2) {
            bGates.connect(pmos.getGate(i2, 'B'));
            aGatesHi.connect(pmos.getGate(i2 + nbGates, 'B'));
        }
        TrackRouterH aGatesLo = new TrackRouterH(Tech.m1, 3.0, -4.0, gate);
        nbGates = nmosA.nbGates();
        for (int i3 = 0; i3 < nbGates; ++i3) {
            bGates.connect(nmosB.getGate(i3, 'T'));
            aGatesLo.connect(nmosA.getGate(i3, 'T'));
        }
        TrackRouterH resetHi = new TrackRouterH(Tech.m1, 3.0, -4.0, gate);
        for (int i4 = 0; i4 < nmosR.nbGates(); ++i4) {
            resetHi.connect(nmosR.getGate(i4, 'T'));
        }
        PortInst resetNjog = LayoutLib.newNodeInst(Tech.m1pin, resetNJogX, -4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, gate).getOnlyPortInst();
        resetHi.connect(resetNjog);
        TrackRouterH resetLo = new TrackRouterH(Tech.m2, 3.0, -11.0, gate);
        resetLo.connect(resetNjog);
        LayoutLib.newExport(gate, "resetN", PortCharacteristic.IN, Tech.m1, 4.0, resetNX, -11.0);
        resetLo.connect(gate.findExport("resetN"));
        PortInst jogA = LayoutLib.newNodeInst(Tech.m1pin, LayoutLib.roundCenterX(nmosA.getGate(0, 'T')), 4.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, gate).getOnlyPortInst();
        aGatesLo.connect(jogA);
        aGatesHi.connect(jogA);
        LayoutLib.newExport(gate, "inb", PortCharacteristic.IN, Tech.m1, 4.0, inbX, 4.0);
        bGates.connect(gate.findExport("inb"));
        double rightDiffX = StdCellParams.getRightDiffX(pmos, nmosA);
        double inaX = rightDiffX + 7.0;
        LayoutLib.newExport(gate, "ina", PortCharacteristic.IN, Tech.m1, 4.0, inaX, -4.0);
        aGatesLo.connect(gate.findExport("ina"));
        double outX = inaX + 7.0;
        LayoutLib.newExport(gate, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 0.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, gate);
        outHi.connect(gate.findExport("out"));
        for (int i5 = 1; i5 < pmos.nbSrcDrns(); i5 += 2) {
            outHi.connect(pmos.getSrcDrn(i5));
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, gate);
        outLo.connect(gate.findExport("out"));
        for (i = 1; i < nmosB.nbSrcDrns(); i += 2) {
            outLo.connect(nmosB.getSrcDrn(i));
            outLo.connect(nmosA.getSrcDrn(i));
        }
        for (i = 1; i < nmosR.nbSrcDrns(); i += 2) {
            outLo.connect(nmosR.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 3.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, gate);
        stdCell.addPmosWell(wellMinX, wellMaxX, gate);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, gate);
        stdCell.doNCC(gate, nm + "{sch}");
        return gate;
    }
}

