/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class MultiTaskJob<TaskKey, TaskResult, Result>
extends Job {
    private transient LinkedHashMap<TaskKey, Task> tasks;
    private transient ArrayList<Task> allTasks;
    private transient int tasksStarted;
    private transient int tasksDone;
    private transient Environment env;
    private transient EditingPreferences editingPreferences;
    private transient EThread ownerThread;
    private transient int numberOfRunningThreads;
    private transient int numberOfFinishedThreads;
    private Consumer<Result> consumer;
    private transient ThreadMXBean threadMX;
    private transient long accumulatedCpuTime;
    private transient long accumulatedUserTime;
    private static final double MILLIS_IN_SEC = 1000.0;
    private static final double NANOS_IN_SEC = 1.0E9;

    public MultiTaskJob(String jobName, Tool t, Consumer<Result> c) {
        super(jobName, t, Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
        this.consumer = c;
    }

    public abstract void prepareTasks() throws JobException;

    public abstract TaskResult runTask(TaskKey var1) throws JobException;

    public abstract Result mergeTaskResults(Map<TaskKey, TaskResult> var1) throws JobException;

    @Override
    public final boolean doIt() throws JobException {
        this.threadMX = ManagementFactory.getThreadMXBean();
        long startClockTime = System.currentTimeMillis();
        long startCpuTime = this.threadMX.getCurrentThreadCpuTime();
        long startUserTime = this.threadMX.getCurrentThreadUserTime();
        this.env = Environment.getThreadEnvironment();
        this.editingPreferences = this.getEditingPreferences();
        this.ownerThread = (EThread)Thread.currentThread();
        this.numberOfRunningThreads = ServerJobManager.getMaxNumberOfThreads();
        this.tasks = new LinkedHashMap();
        this.allTasks = new ArrayList();
        this.prepareTasks();
        this.tasksDone = -this.numberOfRunningThreads;
        for (int id = 0; id < this.numberOfRunningThreads; ++id) {
            new MultiTaskWorkingThread(id).start();
        }
        this.waitTasks();
        LinkedHashMap taskResults = new LinkedHashMap();
        for (Task task : this.tasks.values()) {
            if (task.taskResult == null) continue;
            taskResults.put(task.taskKey, task.taskResult);
        }
        this.tasks.clear();
        Result result = this.mergeTaskResults(taskResults);
        taskResults.clear();
        long endClockTime = System.currentTimeMillis();
        this.accumulatedCpuTime += this.threadMX.getCurrentThreadCpuTime() - startCpuTime;
        this.accumulatedUserTime += this.threadMX.getCurrentThreadCpuTime() - startUserTime;
        System.out.println(this + " took " + (double)(endClockTime - startClockTime) / 1000.0 + " sec, cpu=" + (double)this.accumulatedCpuTime / 1.0E9 + " user=" + (double)this.accumulatedUserTime / 1.0E9);
        if (this.consumer != null) {
            this.consumer.consume(result);
        }
        return true;
    }

    public synchronized void startTask(String taskName, TaskKey taskKey) {
        Task task = new Task(taskName, taskKey);
        if (this.tasks.containsKey(taskKey)) {
            throw new IllegalArgumentException();
        }
        this.tasks.put(taskKey, task);
        this.allTasks.add(task);
        this.notifyAll();
    }

    private synchronized Task getTask() {
        ++this.tasksDone;
        assert (this.tasksDone <= this.tasksStarted);
        try {
            while (this.tasksDone < this.allTasks.size() && this.tasksStarted == this.allTasks.size()) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.tasksDone == this.allTasks.size()) {
            assert (this.tasksStarted == this.tasksDone);
            return null;
        }
        return this.allTasks.get(this.tasksStarted++);
    }

    private synchronized void waitTasks() {
        try {
            while (this.numberOfFinishedThreads < this.numberOfRunningThreads) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void finishWorkingThread(long cpuTime, long userTime) {
        this.accumulatedCpuTime += cpuTime;
        this.accumulatedUserTime += userTime;
        ++this.numberOfFinishedThreads;
        this.notifyAll();
    }

    class MultiTaskWorkingThread
    extends EThread {
        private MultiTaskWorkingThread(int id) {
            super("WorkingThread-" + id);
            this.userInterface = new ServerJobManager.UserInterfaceRedirect(MultiTaskJob.this.ownerThread.ejob.jobKey);
            this.ejob = MultiTaskJob.this.ownerThread.ejob;
            this.isServerThread = MultiTaskJob.this.ownerThread.isServerThread;
            this.database = MultiTaskJob.this.ownerThread.database;
        }

        @Override
        public void run() {
            Task t;
            long accumulatedTime = 0L;
            Environment.setThreadEnvironment(MultiTaskJob.this.env);
            EditingPreferences.lowLevelSetThreadLocalEditingPreferences(MultiTaskJob.this.editingPreferences);
            while ((t = MultiTaskJob.this.getTask()) != null) {
                try {
                    long startTime = System.currentTimeMillis();
                    t.taskResult = MultiTaskJob.this.runTask(t.taskKey);
                    long endTime = System.currentTimeMillis();
                    accumulatedTime += endTime - startTime;
                }
                catch (Throwable e) {
                    e.getStackTrace();
                    e.printStackTrace(System.out);
                    e.printStackTrace();
                }
            }
            long cpuTime = MultiTaskJob.this.threadMX.getCurrentThreadCpuTime();
            long userTime = MultiTaskJob.this.threadMX.getCurrentThreadUserTime();
            System.out.println(this.getName() + " clock=" + (double)accumulatedTime / 1000.0 + " cpu=" + (double)cpuTime / 1.0E9 + " user=" + (double)userTime / 1.0E9);
            MultiTaskJob.this.finishWorkingThread(cpuTime, userTime);
        }
    }

    private class Task {
        private final TaskKey taskKey;
        private TaskResult taskResult;

        private Task(String taskName, TaskKey taskKey) {
            this.taskKey = taskKey;
        }
    }
}

