// java-insns.h - Instruction encodings. This is -*- c++ -*-

/* Copyright (C) 1999, 2001, 2002  Free Software Foundation

   This file is part of libgcj.

This software is copyrighted work licensed under the terms of the
Libgcj License.  Please consult the file "LIBGCJ_LICENSE" for
details.  */

#ifndef __JAVA_INSNS_H__
#define __JAVA_INSNS_H__

enum java_opcode
{
  op_nop = 0x00,
  op_aconst_null = 0x01,
  op_iconst_m1 = 0x02,
  op_iconst_0 = 0x03,
  op_iconst_1 = 0x04,
  op_iconst_2 = 0x05,
  op_iconst_3 = 0x06,
  op_iconst_4 = 0x07,
  op_iconst_5 = 0x08,
  op_lconst_0 = 0x09,
  op_lconst_1 = 0x0a,
  op_fconst_0 = 0x0b,
  op_fconst_1 = 0x0c,
  op_fconst_2 = 0x0d,
  op_dconst_0 = 0x0e,
  op_dconst_1 = 0x0f,
  op_bipush = 0x10,
  op_sipush = 0x11,
  op_ldc = 0x12,
  op_ldc_w = 0x13,
  op_ldc2_w = 0x14,
  op_iload = 0x15,
  op_lload = 0x16,
  op_fload = 0x17,
  op_dload = 0x18,
  op_aload = 0x19,
  op_iload_0 = 0x1a,
  op_iload_1 = 0x1b,
  op_iload_2 = 0x1c,
  op_iload_3 = 0x1d,
  op_lload_0 = 0x1e,
  op_lload_1 = 0x1f,
  op_lload_2 = 0x20,
  op_lload_3 = 0x21,
  op_fload_0 = 0x22,
  op_fload_1 = 0x23,
  op_fload_2 = 0x24,
  op_fload_3 = 0x25,
  op_dload_0 = 0x26,
  op_dload_1 = 0x27,
  op_dload_2 = 0x28,
  op_dload_3 = 0x29,
  op_aload_0 = 0x2a,
  op_aload_1 = 0x2b,
  op_aload_2 = 0x2c,
  op_aload_3 = 0x2d,
  op_iaload = 0x2e,
  op_laload = 0x2f,
  op_faload = 0x30,
  op_daload = 0x31,
  op_aaload = 0x32,
  op_baload = 0x33,
  op_caload = 0x34,
  op_saload = 0x35,
  op_istore = 0x36,
  op_lstore = 0x37,
  op_fstore = 0x38,
  op_dstore = 0x39,
  op_astore = 0x3a,
  op_istore_0 = 0x3b,
  op_istore_1 = 0x3c,
  op_istore_2 = 0x3d,
  op_istore_3 = 0x3e,
  op_lstore_0 = 0x3f,
  op_lstore_1 = 0x40,
  op_lstore_2 = 0x41,
  op_lstore_3 = 0x42,
  op_fstore_0 = 0x43,
  op_fstore_1 = 0x44,
  op_fstore_2 = 0x45,
  op_fstore_3 = 0x46,
  op_dstore_0 = 0x47,
  op_dstore_1 = 0x48,
  op_dstore_2 = 0x49,
  op_dstore_3 = 0x4a,
  op_astore_0 = 0x4b,
  op_astore_1 = 0x4c,
  op_astore_2 = 0x4d,
  op_astore_3 = 0x4e,
  op_iastore = 0x4f,
  op_lastore = 0x50,
  op_fastore = 0x51,
  op_dastore = 0x52,
  op_aastore = 0x53,
  op_bastore = 0x54,
  op_castore = 0x55,
  op_sastore = 0x56,
  op_pop = 0x57,
  op_pop2 = 0x58,
  op_dup = 0x59,
  op_dup_x1 = 0x5a,
  op_dup_x2 = 0x5b,
  op_dup2 = 0x5c,
  op_dup2_x1 = 0x5d,
  op_dup2_x2 = 0x5e,
  op_swap = 0x5f,
  op_iadd = 0x60,
  op_ladd = 0x61,
  op_fadd = 0x62,
  op_dadd = 0x63,
  op_isub = 0x64,
  op_lsub = 0x65,
  op_fsub = 0x66,
  op_dsub = 0x67,
  op_imul = 0x68,
  op_lmul = 0x69,
  op_fmul = 0x6a,
  op_dmul = 0x6b,
  op_idiv = 0x6c,
  op_ldiv = 0x6d,
  op_fdiv = 0x6e,
  op_ddiv = 0x6f,
  op_irem = 0x70,
  op_lrem = 0x71,
  op_frem = 0x72,
  op_drem = 0x73,
  op_ineg = 0x74,
  op_lneg = 0x75,
  op_fneg = 0x76,
  op_dneg = 0x77,
  op_ishl = 0x78,
  op_lshl = 0x79,
  op_ishr = 0x7a,
  op_lshr = 0x7b,
  op_iushr = 0x7c,
  op_lushr = 0x7d,
  op_iand = 0x7e,
  op_land = 0x7f,
  op_ior = 0x80,
  op_lor = 0x81,
  op_ixor = 0x82,
  op_lxor = 0x83,
  op_iinc = 0x84,
  op_i2l = 0x85,
  op_i2f = 0x86,
  op_i2d = 0x87,
  op_l2i = 0x88,
  op_l2f = 0x89,
  op_l2d = 0x8a,
  op_f2i = 0x8b,
  op_f2l = 0x8c,
  op_f2d = 0x8d,
  op_d2i = 0x8e,
  op_d2l = 0x8f,
  op_d2f = 0x90,
  op_i2b = 0x91,
  op_i2c = 0x92,
  op_i2s = 0x93,
  op_lcmp = 0x94,
  op_fcmpl = 0x95,
  op_fcmpg = 0x96,
  op_dcmpl = 0x97,
  op_dcmpg = 0x98,
  op_ifeq = 0x99,
  op_ifne = 0x9a,
  op_iflt = 0x9b,
  op_ifge = 0x9c,
  op_ifgt = 0x9d,
  op_ifle = 0x9e,
  op_if_icmpeq = 0x9f,
  op_if_icmpne = 0xa0,
  op_if_icmplt = 0xa1,
  op_if_icmpge = 0xa2,
  op_if_icmpgt = 0xa3,
  op_if_icmple = 0xa4,
  op_if_acmpeq = 0xa5,
  op_if_acmpne = 0xa6,
  op_goto = 0xa7,
  op_jsr = 0xa8,
  op_ret = 0xa9,
  op_tableswitch = 0xaa,
  op_lookupswitch = 0xab,
  op_ireturn = 0xac,
  op_lreturn = 0xad,
  op_freturn = 0xae,
  op_dreturn = 0xaf,
  op_areturn = 0xb0,
  op_return = 0xb1,
  op_getstatic = 0xb2,
  op_putstatic = 0xb3,
  op_getfield = 0xb4,
  op_putfield = 0xb5,
  op_invokevirtual = 0xb6,
  op_invokespecial = 0xb7,
  op_invokestatic = 0xb8,
  op_invokeinterface = 0xb9,

  // 0xba is unused.

  op_new = 0xbb,
  op_newarray = 0xbc,
  op_anewarray = 0xbd,
  op_arraylength = 0xbe,
  op_athrow = 0xbf,
  op_checkcast = 0xc0,
  op_instanceof = 0xc1,
  op_monitorenter = 0xc2,
  op_monitorexit = 0xc3,
  op_wide = 0xc4,
  op_multianewarray = 0xc5,
  op_ifnull = 0xc6,
  op_ifnonnull = 0xc7,
  op_goto_w = 0xc8,
  op_jsr_w = 0xc9,

  // new opcodes

  op_putfield_1 = 0xca,
  op_putfield_2 = 0xcb,
  op_putfield_4 = 0xcc,
  op_putfield_8 = 0xcd,
  op_putfield_a = 0xce,

  op_putstatic_1 = 0xcf,
  op_putstatic_2 = 0xd0,
  op_putstatic_4 = 0xd1,
  op_putstatic_8 = 0xd2,
  op_putstatic_a = 0xd3,

  op_getfield_1 = 0xd4,
  op_getfield_2s = 0xd5,
  op_getfield_2u = 0xd6,
  op_getfield_4 = 0xd7,
  op_getfield_8 = 0xd8,
  op_getfield_a = 0xd9,

  op_getstatic_1 = 0xda,
  op_getstatic_2s = 0xdb,
  op_getstatic_2u = 0xdc,
  op_getstatic_4 = 0xdd,
  op_getstatic_8 = 0xde,
  op_getstatic_a = 0xdf
};

#endif /* __JAVA_INSNS_H__ */
