/* btuser.h -- user permissions

   Copyright 2009 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#define SMAXUID 30000           /*  Above that we do special things  */

#define UGO_USER        0
#define UGO_GROUP       1
#define UGO_OTHER       2

typedef struct  {
        unsigned  char  btd_version;    /* Major GNUbatch version number */
        unsigned  char  btd_minp,       /* Minimum priority  */
                        btd_maxp,       /* Maximum priority  */
                        btd_defp;       /* Default priority  */

        time_t          btd_lastp;      /* Last read password file */

        ULONG           btd_priv;       /* Privileges */
        USHORT          btd_maxll;      /* Max load level */
        USHORT          btd_totll;      /* Max total load level */
        USHORT          btd_spec_ll;    /* Non-std jobs load level */
        USHORT          btd_jflags[3];  /* Flags for jobs */
        USHORT          btd_vflags[3];  /* Flags for variables */
}  Btdef, *BtdefRef;

typedef const   Btdef   *CBtdefRef;

typedef struct  {
        unsigned  char  btu_isvalid,    /* Valid user id */
                        btu_minp,       /* Minimum priority  */
                        btu_maxp,       /* Maximum priority  */
                        btu_defp;       /* Default priority  */
        int_ugid_t      btu_user;       /* User id */

        ULONG           btu_priv;       /* Privileges */

        USHORT          btu_maxll;      /* Max load level */
        USHORT          btu_totll;      /* Max total load level */
        USHORT          btu_spec_ll;    /* Non-std jobs load level */
        USHORT          btu_jflags[3];  /* Flags for jobs */
        USHORT          btu_vflags[3];  /* Flags for variables */
}  Btuser, *BtuserRef;

typedef const   Btuser  *CBtuserRef;

/* Initial minimum, maximum and default priorities */

#define U_DF_MINP       100
#define U_DF_MAXP       200
#define U_DF_DEFP       150

#define U_DF_MAXLL      1000
#define U_DF_TOTLL      10000
#define U_DF_SPECLL     1000

/* Default privileges */

#define U_DF_UJ         (BTM_READ|BTM_WRITE|BTM_SHOW|BTM_RDMODE|BTM_WRMODE|BTM_UGIVE|BTM_GGIVE|BTM_DELETE|BTM_KILL)
#define U_DF_GJ         (BTM_READ|BTM_SHOW|BTM_RDMODE|BTM_GGIVE)

#define U_DF_UV         (BTM_READ|BTM_WRITE|BTM_SHOW|BTM_RDMODE|BTM_WRMODE|BTM_UGIVE|BTM_GGIVE|BTM_DELETE)
#define U_DF_GV         (BTM_READ|BTM_SHOW|BTM_RDMODE|BTM_GGIVE)

#define U_DF_OJ         (BTM_SHOW|BTM_RDMODE)
#define U_DF_OV         (BTM_SHOW|BTM_RDMODE)

#define U_DF_PRIV       (BTM_UMASK|BTM_CREATE)

/* Charge record generated by scheduler */

struct  btcharge        {
        time_t          btch_when;      /* When it happened */
        netid_t         btch_host;      /* Host responsible */
        int_ugid_t      btch_user;      /* Uid charged for */
        unsigned  char  btch_pri;       /* Priority */
        unsigned  char  btch_what;      /* Type of charge */
#define BTCH_RECORD     0               /* Record left by btsched */
#define BTCH_FEE        1               /* Impose fee */
#define BTCH_FEEALL     2               /* Impose fee everywhere */
#define BTCH_CONSOL     3               /* Consolidation of previous charges */
#define BTCH_ZERO       4               /* Zero record for given user */
#define BTCH_ZEROALL    5               /* Zero record for all users */
        USHORT          btch_ll;        /* Load level */
        double          btch_runtime;   /* Secs run */
};

extern  Btdef   Btuhdr;
extern  BtuserRef       mypriv;

extern BtuserRef  getbtuser(const uid_t);
extern BtuserRef  getbtuentry(const uid_t);
extern BtuserRef  getbtulist();

extern void  putbtuhdr();
extern void  putbtuentry(BtuserRef);
extern void  putbtulist(BtuserRef);
