/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import {
  Codec,
  buildCodecForObject,
  codecForBoolean,
} from "@gnu-taler/taler-util";
import { buildStorageKey, useLocalStorage } from "@gnu-taler/web-util/browser";
import { Settings, defaultSettings } from "../platform/api.js";

export const codecForSettings = (): Codec<Settings> =>
  buildCodecForObject<Settings>()
    .property("walletAllowHttp", codecForBoolean())
    .property("injectTalerSupport", codecForBoolean())
    .property("autoOpen", codecForBoolean())
    .property("advancedMode", codecForBoolean())
    .property("backup", codecForBoolean())
    .property("langSelector", codecForBoolean())
    .property("showJsonOnError", codecForBoolean())
    .property("extendedAccountTypes", codecForBoolean())
    .property("suspendIndividualTransaction", codecForBoolean())
    .property("showRefeshTransactions", codecForBoolean())
    .property("showExchangeManagement", codecForBoolean())
    .property("selectTosFormat", codecForBoolean())
    .property("showWalletActivity", codecForBoolean())
    .property("walletEnableV1Contracts", codecForBoolean())
    .build("Settings");

const SETTINGS_KEY = buildStorageKey("wallet-settings", codecForSettings());

export function useSettings(): [
  Readonly<Settings>,
  <T extends keyof Settings>(key: T, value: Settings[T]) => void,
] {
  const { value, update } = useLocalStorage(SETTINGS_KEY, defaultSettings);

  function updateField<T extends keyof Settings>(k: T, v: Settings[T]) {
    update({ ...value, [k]: v });
  }

  return [value, updateField];
}
