/*
 * arch/sh/boards/landisk/irq.c
 *
 * I-O DATA Device, Inc. LANDISK Support
 *
 * Copyright (C) 2005-2007 kogiidena
 *
 * Copyright (C) 2001  Ian da Silva, Jeremy Siegel
 * Based largely on io_se.c.
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#include <linux/init.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/io.h>
#include <mach-landisk/mach/iodata_landisk.h>

static void disable_landisk_irq(struct irq_data *data)
{
	unsigned char mask = 0xff ^ (0x01 << (data->irq - 5));

	__raw_writeb(__raw_readb(PA_IMASK) & mask, PA_IMASK);
}

static void enable_landisk_irq(struct irq_data *data)
{
	unsigned char value = (0x01 << (data->irq - 5));

	__raw_writeb(__raw_readb(PA_IMASK) | value, PA_IMASK);
}

static struct irq_chip landisk_irq_chip __read_mostly = {
	.name		= "LANDISK",
	.irq_mask	= disable_landisk_irq,
	.irq_unmask	= enable_landisk_irq,
};

/*
 * Initialize IRQ setting
 */
void __init init_landisk_IRQ(void)
{
	int i;

	for (i = 5; i < 14; i++) {
		disable_irq_nosync(i);
		set_irq_chip_and_handler_name(i, &landisk_irq_chip,
					      handle_level_irq, "level");
		enable_landisk_irq(irq_get_irq_data(i));
	}
	__raw_writeb(0x00, PA_PWRINT_CLR);
}
