# probe libc's inet_pton & backtrace it with ping

# Installs a probe on libc's inet_pton function, that will use uprobes,
# then use 'perf trace' on a ping to localhost asking for just one packet
# with the a backtrace 3 levels deep, check that it is what we expect.
# This needs no debuginfo package, all is done using the libc ELF symtab
# and the CFI info in the binaries.

# Arnaldo Carvalho de Melo <acme@kernel.org>, 2017

. $(dirname $0)/lib/probe.sh

ld=$(realpath /lib64/ld*.so.* | uniq)
libc=$(echo $ld | sed 's/ld/libc/g')

trace_libc_inet_pton_backtrace() {
	idx=0
	expected[0]="PING.*bytes"
	expected[1]="64 bytes from ::1.*"
	expected[2]=".*ping statistics.*"
	expected[3]=".*packets transmitted.*"
	expected[4]="rtt min.*"
	expected[5]="[0-9]+\.[0-9]+[[:space:]]+probe_libc:inet_pton:\([[:xdigit:]]+\)"
	expected[6]=".*inet_pton[[:space:]]\($libc\)$"
	expected[7]="getaddrinfo[[:space:]]\($libc\)$"
	expected[8]=".*\(.*/bin/ping.*\)$"

	perf trace --no-syscalls -e probe_libc:inet_pton/max-stack=3/ ping -6 -c 1 ::1 2>&1 | grep -v ^$ | while read line ; do
		echo $line
		echo "$line" | egrep -q "${expected[$idx]}"
		if [ $? -ne 0 ] ; then
			printf "FAIL: expected backtrace entry %d \"%s\" got \"%s\"\n" $idx "${expected[$idx]}" "$line"
			exit 1
		fi
		let idx+=1
		[ $idx -eq 9 ] && break
	done
}

skip_if_no_perf_probe && \
perf probe -q $libc inet_pton && \
trace_libc_inet_pton_backtrace
err=$?
rm -f ${file}
perf probe -q -d probe_libc:inet_pton
exit $err
