/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019-2022 MediaTek Inc.
 * Copyright (c) 2022 BayLibre
 */
#ifndef _MTK_DP_REG_H_
#define _MTK_DP_REG_H_

#define SEC_OFFSET	0x4000

#define MTK_DP_HPD_DISCONNECT		BIT(1)
#define MTK_DP_HPD_CONNECT		BIT(2)
#define MTK_DP_HPD_INTERRUPT		BIT(3)

/* offset: 0x0 */
#define DP_PHY_GLB_BIAS_GEN_00		0x0
#define RG_XTP_GLB_BIAS_INTR_CTRL		GENMASK(20, 16)
#define DP_PHY_GLB_DPAUX_TX		0x8
#define RG_CKM_PT0_CKTX_IMPSEL			GENMASK(23, 20)
#define MTK_DP_0034			0x34
#define DA_XTP_GLB_CKDET_EN_FORCE_VAL		BIT(15)
#define DA_XTP_GLB_CKDET_EN_FORCE_EN		BIT(14)
#define DA_CKM_INTCKTX_EN_FORCE_VAL		BIT(13)
#define DA_CKM_INTCKTX_EN_FORCE_EN		BIT(12)
#define DA_CKM_CKTX0_EN_FORCE_VAL		BIT(11)
#define DA_CKM_CKTX0_EN_FORCE_EN		BIT(10)
#define DA_CKM_XTAL_CK_FORCE_VAL		BIT(9)
#define DA_CKM_XTAL_CK_FORCE_EN			BIT(8)
#define DA_CKM_BIAS_LPF_EN_FORCE_VAL		BIT(7)
#define DA_CKM_BIAS_LPF_EN_FORCE_EN		BIT(6)
#define DA_CKM_BIAS_EN_FORCE_VAL		BIT(5)
#define DA_CKM_BIAS_EN_FORCE_EN			BIT(4)
#define DA_XTP_GLB_AVD10_ON_FORCE_VAL		BIT(3)
#define DA_XTP_GLB_AVD10_ON_FORCE		BIT(2)
#define DA_XTP_GLB_LDO_EN_FORCE_VAL		BIT(1)
#define DA_XTP_GLB_LDO_EN_FORCE_EN		BIT(0)
#define DP_PHY_LANE_TX_0		0x104
#define RG_XTP_LN0_TX_IMPSEL_PMOS		GENMASK(15, 12)
#define RG_XTP_LN0_TX_IMPSEL_NMOS		GENMASK(19, 16)
#define DP_PHY_LANE_TX_1		0x204
#define RG_XTP_LN1_TX_IMPSEL_PMOS		GENMASK(15, 12)
#define RG_XTP_LN1_TX_IMPSEL_NMOS		GENMASK(19, 16)
#define DP_PHY_LANE_TX_2		0x304
#define RG_XTP_LN2_TX_IMPSEL_PMOS		GENMASK(15, 12)
#define RG_XTP_LN2_TX_IMPSEL_NMOS		GENMASK(19, 16)
#define DP_PHY_LANE_TX_3		0x404
#define RG_XTP_LN3_TX_IMPSEL_PMOS		GENMASK(15, 12)
#define RG_XTP_LN3_TX_IMPSEL_NMOS		GENMASK(19, 16)
#define MTK_DP_1040			0x1040
#define RG_DPAUX_RX_VALID_DEGLITCH_EN		BIT(2)
#define RG_XTP_GLB_CKDET_EN			BIT(1)
#define RG_DPAUX_RX_EN				BIT(0)

/* offset: TOP_OFFSET (0x2000) */
#define MTK_DP_TOP_PWR_STATE		0x2000
#define DP_PWR_STATE_MASK			GENMASK(1, 0)
#define DP_PWR_STATE_BANDGAP			BIT(0)
#define DP_PWR_STATE_BANDGAP_TPLL		BIT(1)
#define DP_PWR_STATE_BANDGAP_TPLL_LANE		GENMASK(1, 0)
#define MTK_DP_TOP_SWING_EMP		0x2004
#define DP_TX0_VOLT_SWING_MASK			GENMASK(1, 0)
#define DP_TX0_VOLT_SWING_SHIFT			0
#define DP_TX0_PRE_EMPH_MASK			GENMASK(3, 2)
#define DP_TX0_PRE_EMPH_SHIFT			2
#define DP_TX1_VOLT_SWING_MASK			GENMASK(9, 8)
#define DP_TX1_VOLT_SWING_SHIFT			8
#define DP_TX1_PRE_EMPH_MASK			GENMASK(11, 10)
#define DP_TX2_VOLT_SWING_MASK			GENMASK(17, 16)
#define DP_TX2_PRE_EMPH_MASK			GENMASK(19, 18)
#define DP_TX3_VOLT_SWING_MASK			GENMASK(25, 24)
#define DP_TX3_PRE_EMPH_MASK			GENMASK(27, 26)
#define MTK_DP_TOP_RESET_AND_PROBE	0x2020
#define SW_RST_B_PHYD				BIT(4)
#define MTK_DP_TOP_IRQ_MASK		0x202c
#define IRQ_MASK_AUX_TOP_IRQ			BIT(2)
#define MTK_DP_TOP_MEM_PD		0x2038
#define MEM_ISO_EN				BIT(0)
#define FUSE_SEL				BIT(2)

/* offset: ENC0_OFFSET (0x3000) */
#define MTK_DP_ENC0_P0_3000			0x3000
#define LANE_NUM_DP_ENC0_P0_MASK			GENMASK(1, 0)
#define VIDEO_MUTE_SW_DP_ENC0_P0			BIT(2)
#define VIDEO_MUTE_SEL_DP_ENC0_P0			BIT(3)
#define ENHANCED_FRAME_EN_DP_ENC0_P0			BIT(4)
#define MTK_DP_ENC0_P0_3004			0x3004
#define VIDEO_M_CODE_SEL_DP_ENC0_P0_MASK		BIT(8)
#define DP_TX_ENCODER_4P_RESET_SW_DP_ENC0_P0		BIT(9)
#define MTK_DP_ENC0_P0_3010			0x3010
#define HTOTAL_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3014			0x3014
#define VTOTAL_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3018			0x3018
#define HSTART_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_301C			0x301c
#define VSTART_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3020			0x3020
#define HWIDTH_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3024			0x3024
#define VHEIGHT_SW_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3028			0x3028
#define HSW_SW_DP_ENC0_P0_MASK				GENMASK(14, 0)
#define HSP_SW_DP_ENC0_P0_MASK				BIT(15)
#define MTK_DP_ENC0_P0_302C			0x302c
#define VSW_SW_DP_ENC0_P0_MASK				GENMASK(14, 0)
#define VSP_SW_DP_ENC0_P0_MASK				BIT(15)
#define MTK_DP_ENC0_P0_3030			0x3030
#define HTOTAL_SEL_DP_ENC0_P0				BIT(0)
#define VTOTAL_SEL_DP_ENC0_P0				BIT(1)
#define HSTART_SEL_DP_ENC0_P0				BIT(2)
#define VSTART_SEL_DP_ENC0_P0				BIT(3)
#define HWIDTH_SEL_DP_ENC0_P0				BIT(4)
#define VHEIGHT_SEL_DP_ENC0_P0				BIT(5)
#define HSP_SEL_DP_ENC0_P0				BIT(6)
#define HSW_SEL_DP_ENC0_P0				BIT(7)
#define VSP_SEL_DP_ENC0_P0				BIT(8)
#define VSW_SEL_DP_ENC0_P0				BIT(9)
#define VBID_AUDIO_MUTE_FLAG_SW_DP_ENC0_P0		BIT(11)
#define VBID_AUDIO_MUTE_FLAG_SEL_DP_ENC0_P0		BIT(12)
#define MTK_DP_ENC0_P0_3034			0x3034
#define MTK_DP_ENC0_P0_3038			0x3038
#define VIDEO_SOURCE_SEL_DP_ENC0_P0_MASK		BIT(11)
#define MTK_DP_ENC0_P0_303C			0x303c
#define SRAM_START_READ_THRD_DP_ENC0_P0_MASK		GENMASK(5, 0)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_MASK		GENMASK(10, 8)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_16BIT		(0 << 8)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_12BIT		(1 << 8)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_10BIT		(2 << 8)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_8BIT		(3 << 8)
#define VIDEO_COLOR_DEPTH_DP_ENC0_P0_6BIT		(4 << 8)
#define PIXEL_ENCODE_FORMAT_DP_ENC0_P0_MASK		GENMASK(14, 12)
#define PIXEL_ENCODE_FORMAT_DP_ENC0_P0_RGB		(0 << 12)
#define PIXEL_ENCODE_FORMAT_DP_ENC0_P0_YCBCR422		(1 << 12)
#define PIXEL_ENCODE_FORMAT_DP_ENC0_P0_YCBCR420		(2 << 12)
#define VIDEO_MN_GEN_EN_DP_ENC0_P0			BIT(15)
#define MTK_DP_ENC0_P0_3040			0x3040
#define SDP_DOWN_CNT_DP_ENC0_P0_VAL			0x20
#define SDP_DOWN_CNT_INIT_DP_ENC0_P0_MASK		GENMASK(11, 0)
#define MTK_DP_ENC0_P0_304C			0x304c
#define VBID_VIDEO_MUTE_DP_ENC0_P0_MASK			BIT(2)
#define SDP_VSYNC_RISING_MASK_DP_ENC0_P0_MASK		BIT(8)
#define MTK_DP_ENC0_P0_3064			0x3064
#define HDE_NUM_LAST_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3088			0x3088
#define AU_EN_DP_ENC0_P0				BIT(6)
#define AUDIO_8CH_EN_DP_ENC0_P0_MASK			BIT(7)
#define AUDIO_8CH_SEL_DP_ENC0_P0_MASK			BIT(8)
#define AUDIO_2CH_EN_DP_ENC0_P0_MASK			BIT(14)
#define AUDIO_2CH_SEL_DP_ENC0_P0_MASK			BIT(15)
#define MTK_DP_ENC0_P0_308C			0x308c
#define CH_STATUS_0_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3090			0x3090
#define CH_STATUS_1_DP_ENC0_P0_MASK			GENMASK(15, 0)
#define MTK_DP_ENC0_P0_3094			0x3094
#define CH_STATUS_2_DP_ENC0_P0_MASK			GENMASK(7, 0)
#define MTK_DP_ENC0_P0_30A4			0x30a4
#define AU_TS_CFG_DP_ENC0_P0_MASK			GENMASK(7, 0)
#define MTK_DP_ENC0_P0_30A8			0x30a8
#define MTK_DP_ENC0_P0_30BC			0x30bc
#define ISRC_CONT_DP_ENC0_P0				BIT(0)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_MASK	GENMASK(10, 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_MUL_2	(1 << 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_MUL_4	(2 << 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_MUL_8	(3 << 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_DIV_2	(5 << 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_DIV_4	(6 << 8)
#define AUDIO_M_CODE_MULT_DIV_SEL_DP_ENC0_P0_DIV_8	(7 << 8)
#define MTK_DP_ENC0_P0_30D8			0x30d8
#define MTK_DP_ENC0_P0_312C			0x312c
#define ASP_HB2_DP_ENC0_P0_MASK				GENMASK(7, 0)
#define ASP_HB3_DP_ENC0_P0_MASK				GENMASK(15, 8)
#define MTK_DP_ENC0_P0_3154			0x3154
#define PGEN_HTOTAL_DP_ENC0_P0_MASK			GENMASK(13, 0)
#define MTK_DP_ENC0_P0_3158			0x3158
#define PGEN_HSYNC_RISING_DP_ENC0_P0_MASK		GENMASK(13, 0)
#define MTK_DP_ENC0_P0_315C			0x315c
#define PGEN_HSYNC_PULSE_WIDTH_DP_ENC0_P0_MASK		GENMASK(13, 0)
#define MTK_DP_ENC0_P0_3160			0x3160
#define PGEN_HFDE_START_DP_ENC0_P0_MASK			GENMASK(13, 0)
#define MTK_DP_ENC0_P0_3164			0x3164
#define PGEN_HFDE_ACTIVE_WIDTH_DP_ENC0_P0_MASK		GENMASK(13, 0)
#define MTK_DP_ENC0_P0_3168			0x3168
#define PGEN_VTOTAL_DP_ENC0_P0_MASK			GENMASK(12, 0)
#define MTK_DP_ENC0_P0_316C			0x316c
#define PGEN_VSYNC_RISING_DP_ENC0_P0_MASK		GENMASK(12, 0)
#define MTK_DP_ENC0_P0_3170			0x3170
#define PGEN_VSYNC_PULSE_WIDTH_DP_ENC0_P0_MASK		GENMASK(12, 0)
#define MTK_DP_ENC0_P0_3174			0x3174
#define PGEN_VFDE_START_DP_ENC0_P0_MASK			GENMASK(12, 0)
#define MTK_DP_ENC0_P0_3178			0x3178
#define PGEN_VFDE_ACTIVE_WIDTH_DP_ENC0_P0_MASK		GENMASK(12, 0)
#define MTK_DP_ENC0_P0_31B0			0x31b0
#define PGEN_PATTERN_SEL_VAL				4
#define PGEN_PATTERN_SEL_MASK				GENMASK(6, 4)
#define MTK_DP_ENC0_P0_31EC			0x31ec
#define AUDIO_CH_SRC_SEL_DP_ENC0_P0			BIT(4)
#define ISRC1_HB3_DP_ENC0_P0_MASK			GENMASK(15, 8)

/* offset: ENC1_OFFSET (0x3200) */
#define MTK_DP_ENC1_P0_3200			0x3200
#define MTK_DP_ENC1_P0_3280			0x3280
#define SDP_PACKET_TYPE_DP_ENC1_P0_MASK			GENMASK(4, 0)
#define SDP_PACKET_W_DP_ENC1_P0				BIT(5)
#define SDP_PACKET_W_DP_ENC1_P0_MASK			BIT(5)
#define MTK_DP_ENC1_P0_3300			0x3300
#define VIDEO_AFIFO_RDY_SEL_DP_ENC1_P0_VAL		2
#define VIDEO_AFIFO_RDY_SEL_DP_ENC1_P0_MASK		GENMASK(9, 8)
#define MTK_DP_ENC1_P0_3304			0x3304
#define AU_PRTY_REGEN_DP_ENC1_P0_MASK			BIT(8)
#define AU_CH_STS_REGEN_DP_ENC1_P0_MASK			BIT(9)
#define AUDIO_SAMPLE_PRSENT_REGEN_DP_ENC1_P0_MASK	BIT(12)
#define MTK_DP_ENC1_P0_3324			0x3324
#define AUDIO_SOURCE_MUX_DP_ENC1_P0_MASK		GENMASK(9, 8)
#define AUDIO_SOURCE_MUX_DP_ENC1_P0_DPRX		0
#define MTK_DP_ENC1_P0_3364			0x3364
#define SDP_DOWN_CNT_IN_HBLANK_DP_ENC1_P0_VAL		0x20
#define SDP_DOWN_CNT_INIT_IN_HBLANK_DP_ENC1_P0_MASK	GENMASK(11, 0)
#define FIFO_READ_START_POINT_DP_ENC1_P0_VAL		4
#define FIFO_READ_START_POINT_DP_ENC1_P0_MASK		GENMASK(15, 12)
#define MTK_DP_ENC1_P0_3368			0x3368
#define VIDEO_SRAM_FIFO_CNT_RESET_SEL_DP_ENC1_P0	BIT(0)
#define VIDEO_STABLE_CNT_THRD_DP_ENC1_P0		BIT(4)
#define SDP_DP13_EN_DP_ENC1_P0				BIT(8)
#define BS2BS_MODE_DP_ENC1_P0				BIT(12)
#define BS2BS_MODE_DP_ENC1_P0_MASK			GENMASK(13, 12)
#define BS2BS_MODE_DP_ENC1_P0_VAL			1
#define DP_ENC1_P0_3368_VAL				(VIDEO_SRAM_FIFO_CNT_RESET_SEL_DP_ENC1_P0 | \
							 VIDEO_STABLE_CNT_THRD_DP_ENC1_P0 | \
							 SDP_DP13_EN_DP_ENC1_P0 | \
							 BS2BS_MODE_DP_ENC1_P0)
#define MTK_DP_ENC1_P0_33F4			0x33f4
#define DP_ENC_DUMMY_RW_1_AUDIO_RST_EN			BIT(0)
#define DP_ENC_DUMMY_RW_1				BIT(9)

/* offset: TRANS_OFFSET (0x3400) */
#define MTK_DP_TRANS_P0_3400				0x3400
#define PATTERN1_EN_DP_TRANS_P0_MASK				BIT(12)
#define PATTERN2_EN_DP_TRANS_P0_MASK				BIT(13)
#define PATTERN3_EN_DP_TRANS_P0_MASK				BIT(14)
#define PATTERN4_EN_DP_TRANS_P0_MASK				BIT(15)
#define MTK_DP_TRANS_P0_3404				0x3404
#define DP_SCR_EN_DP_TRANS_P0_MASK				BIT(0)
#define MTK_DP_TRANS_P0_340C				0x340c
#define DP_TX_TRANSMITTER_4P_RESET_SW_DP_TRANS_P0		BIT(13)
#define MTK_DP_TRANS_P0_3410				0x3410
#define HPD_DEB_THD_DP_TRANS_P0_MASK				GENMASK(3, 0)
#define HPD_INT_THD_DP_TRANS_P0_MASK				GENMASK(7, 4)
#define HPD_INT_THD_DP_TRANS_P0_LOWER_500US			(2 << 4)
#define HPD_INT_THD_DP_TRANS_P0_UPPER_1100US			(2 << 6)
#define HPD_DISC_THD_DP_TRANS_P0_MASK				GENMASK(11, 8)
#define HPD_CONN_THD_DP_TRANS_P0_MASK				GENMASK(15, 12)
#define MTK_DP_TRANS_P0_3414				0x3414
#define HPD_DB_DP_TRANS_P0_MASK					BIT(2)
#define MTK_DP_TRANS_P0_3418				0x3418
#define IRQ_CLR_DP_TRANS_P0_MASK				GENMASK(3, 0)
#define IRQ_MASK_DP_TRANS_P0_MASK				GENMASK(7, 4)
#define IRQ_MASK_DP_TRANS_P0_DISC_IRQ				(BIT(1) << 4)
#define IRQ_MASK_DP_TRANS_P0_CONN_IRQ				(BIT(2) << 4)
#define IRQ_MASK_DP_TRANS_P0_INT_IRQ				(BIT(3) << 4)
#define IRQ_STATUS_DP_TRANS_P0_MASK				GENMASK(15, 12)
#define MTK_DP_TRANS_P0_342C				0x342c
#define XTAL_FREQ_DP_TRANS_P0_DEFAULT				(BIT(0) | BIT(3) | BIT(5) | BIT(6))
#define XTAL_FREQ_DP_TRANS_P0_MASK				GENMASK(7, 0)
#define MTK_DP_TRANS_P0_3430				0x3430
#define HPD_INT_THD_ECO_DP_TRANS_P0_MASK			GENMASK(1, 0)
#define HPD_INT_THD_ECO_DP_TRANS_P0_HIGH_BOUND_EXT		BIT(1)
#define MTK_DP_TRANS_P0_34A4				0x34a4
#define LANE_NUM_DP_TRANS_P0_MASK				GENMASK(3, 2)
#define MTK_DP_TRANS_P0_3540				0x3540
#define FEC_EN_DP_TRANS_P0_MASK					BIT(0)
#define FEC_CLOCK_EN_MODE_DP_TRANS_P0				BIT(3)
#define MTK_DP_TRANS_P0_3580				0x3580
#define POST_MISC_DATA_LANE0_OV_DP_TRANS_P0_MASK		BIT(8)
#define POST_MISC_DATA_LANE1_OV_DP_TRANS_P0_MASK		BIT(9)
#define POST_MISC_DATA_LANE2_OV_DP_TRANS_P0_MASK		BIT(10)
#define POST_MISC_DATA_LANE3_OV_DP_TRANS_P0_MASK		BIT(11)
#define MTK_DP_TRANS_P0_35C8				0x35c8
#define SW_IRQ_CLR_DP_TRANS_P0_MASK				GENMASK(15, 0)
#define SW_IRQ_STATUS_DP_TRANS_P0_MASK				GENMASK(15, 0)
#define MTK_DP_TRANS_P0_35D0				0x35d0
#define SW_IRQ_FINAL_STATUS_DP_TRANS_P0_MASK			GENMASK(15, 0)
#define MTK_DP_TRANS_P0_35F0				0x35f0
#define DP_TRANS_DUMMY_RW_0					BIT(3)
#define DP_TRANS_DUMMY_RW_0_MASK				GENMASK(3, 2)

/* offset: AUX_OFFSET (0x3600) */
#define MTK_DP_AUX_P0_360C			0x360c
#define AUX_TIMEOUT_THR_AUX_TX_P0_MASK			GENMASK(12, 0)
#define AUX_TIMEOUT_THR_AUX_TX_P0_VAL			0x1595
#define MTK_DP_AUX_P0_3614			0x3614
#define AUX_RX_UI_CNT_THR_AUX_TX_P0_MASK		GENMASK(6, 0)
#define AUX_RX_UI_CNT_THR_AUX_FOR_26M			13
#define MTK_DP_AUX_P0_3618			0x3618
#define AUX_RX_FIFO_FULL_AUX_TX_P0_MASK			BIT(9)
#define AUX_RX_FIFO_WRITE_POINTER_AUX_TX_P0_MASK	GENMASK(3, 0)
#define MTK_DP_AUX_P0_3620			0x3620
#define AUX_RD_MODE_AUX_TX_P0_MASK			BIT(9)
#define AUX_RX_FIFO_READ_PULSE_TX_P0			BIT(8)
#define AUX_RX_FIFO_READ_DATA_AUX_TX_P0_MASK		GENMASK(7, 0)
#define MTK_DP_AUX_P0_3624			0x3624
#define AUX_RX_REPLY_COMMAND_AUX_TX_P0_MASK		GENMASK(3, 0)
#define MTK_DP_AUX_P0_3628			0x3628
#define AUX_RX_PHY_STATE_AUX_TX_P0_MASK			GENMASK(9, 0)
#define AUX_RX_PHY_STATE_AUX_TX_P0_RX_IDLE		BIT(0)
#define MTK_DP_AUX_P0_362C			0x362c
#define AUX_NO_LENGTH_AUX_TX_P0				BIT(0)
#define AUX_TX_AUXTX_OV_EN_AUX_TX_P0_MASK		BIT(1)
#define AUX_RESERVED_RW_0_AUX_TX_P0_MASK		GENMASK(15, 2)
#define MTK_DP_AUX_P0_3630			0x3630
#define AUX_TX_REQUEST_READY_AUX_TX_P0			BIT(3)
#define MTK_DP_AUX_P0_3634			0x3634
#define AUX_TX_OVER_SAMPLE_RATE_AUX_TX_P0_MASK		GENMASK(15, 8)
#define AUX_TX_OVER_SAMPLE_RATE_FOR_26M			25
#define MTK_DP_AUX_P0_3640			0x3640
#define AUX_RX_AUX_RECV_COMPLETE_IRQ_AUX_TX_P0		BIT(6)
#define AUX_RX_EDID_RECV_COMPLETE_IRQ_AUX_TX_P0		BIT(5)
#define AUX_RX_MCCS_RECV_COMPLETE_IRQ_AUX_TX_P0		BIT(4)
#define AUX_RX_CMD_RECV_IRQ_AUX_TX_P0			BIT(3)
#define AUX_RX_ADDR_RECV_IRQ_AUX_TX_P0			BIT(2)
#define AUX_RX_DATA_RECV_IRQ_AUX_TX_P0			BIT(1)
#define AUX_400US_TIMEOUT_IRQ_AUX_TX_P0			BIT(0)
#define DP_AUX_P0_3640_VAL				(AUX_400US_TIMEOUT_IRQ_AUX_TX_P0 | \
							 AUX_RX_DATA_RECV_IRQ_AUX_TX_P0 | \
							 AUX_RX_ADDR_RECV_IRQ_AUX_TX_P0 | \
							 AUX_RX_CMD_RECV_IRQ_AUX_TX_P0 | \
							 AUX_RX_MCCS_RECV_COMPLETE_IRQ_AUX_TX_P0 | \
							 AUX_RX_EDID_RECV_COMPLETE_IRQ_AUX_TX_P0 | \
							 AUX_RX_AUX_RECV_COMPLETE_IRQ_AUX_TX_P0)
#define MTK_DP_AUX_P0_3644			0x3644
#define MCU_REQUEST_COMMAND_AUX_TX_P0_MASK		GENMASK(3, 0)
#define MTK_DP_AUX_P0_3648			0x3648
#define MCU_REQUEST_ADDRESS_LSB_AUX_TX_P0_MASK		GENMASK(15, 0)
#define MTK_DP_AUX_P0_364C			0x364c
#define MCU_REQUEST_ADDRESS_MSB_AUX_TX_P0_MASK		GENMASK(3, 0)
#define MTK_DP_AUX_P0_3650			0x3650
#define MCU_REQ_DATA_NUM_AUX_TX_P0_MASK			GENMASK(15, 12)
#define PHY_FIFO_RST_AUX_TX_P0_MASK			BIT(9)
#define MCU_ACK_TRAN_COMPLETE_AUX_TX_P0			BIT(8)
#define MTK_DP_AUX_P0_3658			0x3658
#define AUX_TX_OV_EN_AUX_TX_P0_MASK			BIT(0)
#define MTK_DP_AUX_P0_3690			0x3690
#define RX_REPLY_COMPLETE_MODE_AUX_TX_P0		BIT(8)
#define MTK_DP_AUX_P0_3704			0x3704
#define AUX_TX_FIFO_WDATA_NEW_MODE_T_AUX_TX_P0_MASK	BIT(1)
#define AUX_TX_FIFO_NEW_MODE_EN_AUX_TX_P0		BIT(2)
#define MTK_DP_AUX_P0_3708			0x3708
#define MTK_DP_AUX_P0_37C8			0x37c8
#define MTK_ATOP_EN_AUX_TX_P0				BIT(0)

#endif /*_MTK_DP_REG_H_*/
