/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.DataConversionException;
import com.mysql.cj.core.io.BaseDecoratingValueFactory;
import com.mysql.cj.core.io.MysqlTextValueDecoder;
import com.mysql.cj.core.profiler.ProfilerEventImpl;
import com.mysql.cj.core.util.LogUtils;
import com.mysql.cj.core.util.StringUtils;

public class StringConverter<T>
extends BaseDecoratingValueFactory<T> {
    private String encoding;
    private boolean emptyStringsConvertToZero = false;
    private ProfilerEventHandler eventSink;

    public StringConverter(String encoding, ValueFactory<T> targetVf) {
        super(targetVf);
        this.encoding = encoding;
    }

    public void setEmptyStringsConvertToZero(boolean val) {
        this.emptyStringsConvertToZero = val;
    }

    public void setEventSink(ProfilerEventHandler eventSink) {
        this.eventSink = eventSink;
    }

    private void issueConversionViaParsingWarning() {
        if (this.eventSink == null) {
            return;
        }
        String message = Messages.getString("ResultSet.CostlyConversion", new Object[]{this.targetVf.getTargetTypeName(), -1, "<unknown>", "<unknown>", "<unknown>", "<unknown>", "<unknown>", "<unknown>"});
        this.eventSink.consumeEvent(new ProfilerEventImpl(0, "", "<unknown>", -1L, -1, -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, LogUtils.findCallingClassAndMethod(new Throwable()), message));
    }

    @Override
    public T createFromBytes(byte[] origBytes, int offset, int length) {
        MysqlTextValueDecoder stringInterpreter = new MysqlTextValueDecoder();
        String s2 = StringUtils.toString(origBytes, offset, length, this.encoding);
        byte[] bytes = s2.getBytes();
        ValueFactory vf = this.targetVf;
        this.issueConversionViaParsingWarning();
        if (s2.length() == 0) {
            if (this.emptyStringsConvertToZero) {
                return this.targetVf.createFromLong(0L);
            }
        } else {
            if (s2.equalsIgnoreCase("true")) {
                return vf.createFromLong(1L);
            }
            if (s2.equalsIgnoreCase("false")) {
                return vf.createFromLong(0L);
            }
            if (s2.contains("e") || s2.contains("E") || s2.matches("-?(\\d+)?\\.\\d+")) {
                return stringInterpreter.decodeDouble(bytes, 0, bytes.length, vf);
            }
            if (s2.matches("-?\\d+")) {
                if (s2.charAt(0) == '-') {
                    return stringInterpreter.decodeInt8(bytes, 0, bytes.length, vf);
                }
                return stringInterpreter.decodeUInt8(bytes, 0, bytes.length, vf);
            }
            if (s2.length() == 10 && s2.charAt(4) == '-' && s2.charAt(7) == '-') {
                return stringInterpreter.decodeDate(bytes, 0, bytes.length, vf);
            }
            if (s2.length() >= 8 && s2.length() <= 17 && s2.charAt(2) == ':' && s2.charAt(5) == ':') {
                return stringInterpreter.decodeTime(bytes, 0, bytes.length, vf);
            }
            if (s2.length() >= 19 && (s2.length() <= 26 || s2.length() == 29) && s2.charAt(4) == '-' && s2.charAt(7) == '-' && s2.charAt(10) == ' ' && s2.charAt(13) == ':' && s2.charAt(16) == ':') {
                return stringInterpreter.decodeTimestamp(bytes, 0, bytes.length, vf);
            }
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnableToInterpretString", new Object[]{s2}));
    }
}

