/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.postgresql.core.Field;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResultHandler
implements ResultHandler {
    private PgStatement pgStatement;
    private BatchUpdateException batchException = null;
    private int resultIndex = 0;
    private final Query[] queries;
    private final ParameterList[] parameterLists;
    private final int[] updateCounts;
    private final boolean expectGeneratedKeys;
    private PgResultSet generatedKeys;
    private int committedRows;
    private List<List<byte[][]>> allGeneratedRows;
    private List<byte[][]> latestGeneratedRows;
    private PgResultSet latestGeneratedKeysRs;

    BatchResultHandler(PgStatement pgStatement, Query[] queries, ParameterList[] parameterLists, int[] updateCounts, boolean expectGeneratedKeys) {
        this.pgStatement = pgStatement;
        this.queries = queries;
        this.parameterLists = parameterLists;
        this.updateCounts = updateCounts;
        this.expectGeneratedKeys = expectGeneratedKeys;
        this.allGeneratedRows = !expectGeneratedKeys ? null : new ArrayList();
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor) {
        ++this.resultIndex;
        if (!this.expectGeneratedKeys) {
            return;
        }
        if (this.generatedKeys == null) {
            try {
                this.latestGeneratedKeysRs = (PgResultSet)this.pgStatement.createResultSet(fromQuery, fields, new ArrayList<byte[][]>(), cursor);
            }
            catch (SQLException e2) {
                this.handleError(e2);
            }
        }
        this.latestGeneratedRows = tuples;
    }

    @Override
    public void handleCommandStatus(String status, int updateCount, long insertOID) {
        if (this.latestGeneratedRows != null) {
            --this.resultIndex;
            if (updateCount > 0 && this.batchException == null) {
                this.allGeneratedRows.add(this.latestGeneratedRows);
                if (this.generatedKeys == null) {
                    this.generatedKeys = this.latestGeneratedKeysRs;
                }
            }
            this.latestGeneratedRows = null;
        }
        if (this.resultIndex >= this.updateCounts.length) {
            this.handleError(new PSQLException(GT.tr("Too many update results were returned."), PSQLState.TOO_MANY_RESULTS));
            return;
        }
        this.latestGeneratedKeysRs = null;
        this.updateCounts[this.resultIndex++] = updateCount;
    }

    public void secureProgress() {
        try {
            if (this.batchException == null && this.pgStatement.getConnection().getAutoCommit()) {
                this.committedRows = this.resultIndex;
                this.updateGeneratedKeys();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void updateGeneratedKeys() {
        if (this.allGeneratedRows == null || this.allGeneratedRows.isEmpty()) {
            return;
        }
        for (List<byte[][]> rows : this.allGeneratedRows) {
            this.generatedKeys.addRows(rows);
        }
        this.allGeneratedRows.clear();
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        this.pgStatement.addWarning(warning);
    }

    @Override
    public void handleError(SQLException newError) {
        if (this.batchException == null) {
            Arrays.fill(this.updateCounts, this.committedRows, this.updateCounts.length, -3);
            if (this.allGeneratedRows != null) {
                this.allGeneratedRows.clear();
            }
            String queryString = "<unknown>";
            if (this.resultIndex < this.queries.length) {
                queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
            }
            this.batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted.  Call getNextException to see the cause.", new Object[]{this.resultIndex, queryString}), newError.getSQLState(), this.updateCounts);
        }
        this.batchException.setNextException(newError);
    }

    @Override
    public void handleCompletion() throws SQLException {
        if (this.batchException != null) {
            throw this.batchException;
        }
        this.updateGeneratedKeys();
    }

    public ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }
}

