/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.fabric.jdbc;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.fabric.exceptions.FabricCommunicationException;
import com.mysql.cj.fabric.jdbc.FabricMySQLConnectionProxy;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.exceptions.SQLError;
import java.util.Properties;

public class ErrorReportingExceptionInterceptor
implements ExceptionInterceptor {
    private String hostname;
    private String port;
    private String fabricHaGroup;

    @Override
    public Exception interceptException(Exception sqlEx, MysqlConnection conn) {
        JdbcConnection mysqlConn = (JdbcConnection)conn;
        if (ConnectionImpl.class.isAssignableFrom(mysqlConn.getMultiHostSafeProxy().getClass())) {
            return null;
        }
        FabricMySQLConnectionProxy fabricProxy = (FabricMySQLConnectionProxy)mysqlConn.getMultiHostSafeProxy();
        try {
            return fabricProxy.interceptException(sqlEx, conn, this.fabricHaGroup, this.hostname, this.port);
        }
        catch (FabricCommunicationException ex) {
            return SQLError.createSQLException("Failed to report error to Fabric.", "08S01", ex, null);
        }
    }

    @Override
    public void init(MysqlConnection conn, Properties props, Log log) {
        this.hostname = props.getProperty("HOST");
        this.port = props.getProperty("PORT");
        String connectionAttributes = props.getProperty("connectionAttributes");
        this.fabricHaGroup = connectionAttributes.replaceAll("^.*\\bfabricHaGroup:(.+)\\b.*$", "$1");
    }

    @Override
    public void destroy() {
    }
}

