#!/bin/sh

# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1335  USA

# Ensure cmake and perl are there
cmake --help >/dev/null 2>&1 || HAVE_CMAKE=no
perl --version >/dev/null 2>&1 || HAVE_PERL=no
scriptdir=`dirname $0`
if test "$HAVE_CMAKE" = "no"
then
  echo "CMake is required to build MySQL."
  exit 1
elif test "$HAVE_PERL" = "no"
then
  echo "Perl is required to build MySQL using the configure to CMake translator."
  exit 1
else
  perl $scriptdir/cmake/configure.pl "$@"
fi

