-- $Id: tpch20.sql 2657 2007-06-12 16:08:15Z rdempsey $
-- TPC-H/TPC-R Potential Part Promotion Query (Q20)
-- Function Query Definition
-- Approved February 1998

define 1 = forest
define 2 = 1994-01-01
define 3 = CANADA

select
	s_name,
	s_address
from
	supplier,
	nation
where
	s_suppkey in (
		select
			ps_suppkey
		from
			partsupp
		where
			ps_partkey in (
				select
					p_partkey
				from
					part
				where
					p_name like '&1%'
			)
			and ps_availqty > (
				select
					0.5 * sum(l_quantity)
				from
					lineitem
				where
					l_partkey = ps_partkey
					and l_suppkey = ps_suppkey
					and l_shipdate >= date '&2'
					and l_shipdate < date '&2' + interval '1' year
			)
	)
	and s_nationkey = n_nationkey
	and n_name = '&3'
order by
	s_name;

