/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.util.Utils;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;

final class HelpOptionsParser {
    private static final String DIVIDER = "--------------------------------- -----------------------------";
    private static final String END_TEXT = "To see what values a running";
    private static final String NO_DEFAULT_VALUE = "(No default value)";
    private PrintStream err;
    private Utils utils;

    HelpOptionsParser(PrintStream err, Utils utils) {
        this.err = err;
        this.utils = utils;
    }

    public Map getOptionsFromHelp(String help) {
        String trimmed = this.trimToOptions(help);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] lines = this.utils.str().splitLines(trimmed);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.indexOf(32) <= 0) continue;
            String key = line.substring(0, line.indexOf(32));
            String val = line.substring(key.length()).trim();
            if (val.equals(NO_DEFAULT_VALUE)) {
                val = "";
            }
            map.put(key, val);
        }
        map.remove("help");
        map.remove("verbose");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String trimToOptions(String help) {
        boolean success = false;
        try {
            String trimmedHelp = this.trimToOptionsInner(help);
            success = true;
            String string = trimmedHelp;
            return string;
        }
        finally {
            if (!success) {
                PrintStream printStream = this.err;
                synchronized (printStream) {
                    this.printMsg(this.err, "parsing unseccessful:");
                    this.printMsg(this.err, "===== BEGIN MYSQLD HELP OPTIONS TEXT =====");
                    this.err.println(help);
                    this.printMsg(this.err, "===== END MYSQLD HELP OPTIONS TEXT =====");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String trimToOptionsInner(String help) {
        int dividerPos = help.indexOf(DIVIDER);
        int start = dividerPos + DIVIDER.length();
        int stop = help.indexOf(END_TEXT);
        if (dividerPos == -1) {
            PrintStream printStream = this.err;
            synchronized (printStream) {
                this.printMsg(this.err, "Divider=\"--------------------------------- -----------------------------\"");
                this.printMsg(this.err, "found at: " + dividerPos);
                this.printMsg(this.err, "Start Position:" + start);
                this.printMsg(this.err, "End Text=\"To see what values a running\"");
                this.printMsg(this.err, "found at: " + stop);
                this.printMsg(this.err, "HELP TEXT BEGIN");
                this.printMsg(this.err, help);
                this.printMsg(this.err, "HELP TEXT END");
            }
            throw new RuntimeException("could not parse help text");
        }
        if (stop < start) {
            stop = help.length();
        }
        String options = help.substring(start, stop);
        return options + System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMsg(PrintStream ps, String msg) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.print("[");
            ps.print(this.utils.str().shortClassName(this));
            ps.print("] ");
            ps.println(msg);
        }
    }
}

