/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.Files;
import com.mysql.management.util.ListToString;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MysqldResourceTestImpl
implements MysqldResourceI {
    public File baseDir;
    public File dataDir;
    public Map runningFakeMysqlds;
    private String running;
    private Map currentOptions;
    private List completionListensers;
    private String version;

    public MysqldResourceTestImpl(Map runningFakeMysqlds) {
        this(null, null, new HashMap(), runningFakeMysqlds);
    }

    public MysqldResourceTestImpl(File baseDir, File dataDir, Map runningFakeMysqlds) {
        this(baseDir, dataDir, new HashMap(), runningFakeMysqlds);
    }

    public MysqldResourceTestImpl(File baseDir, File dataDir, Map options, Map runningFakeMysqlds) {
        this.baseDir = baseDir == null ? new Files().nullFile() : baseDir;
        this.dataDir = dataDir;
        this.running = null;
        this.currentOptions = options;
        this.completionListensers = new ArrayList();
        this.runningFakeMysqlds = runningFakeMysqlds;
        this.version = "5.2.23";
    }

    public void start(String threadName, Map mysqldArgs) {
        this.start(threadName, mysqldArgs, false);
    }

    public void start(String threadName, Map mysqldArgs, boolean populateAllOptions) {
        if (this.running != null) {
            String msg = "already running " + this.running + " mysqldArgs: " + new ListToString().toString(mysqldArgs);
            throw new RuntimeException(msg);
        }
        this.currentOptions.putAll(mysqldArgs);
        this.running = threadName;
        this.runningFakeMysqlds.put(this.baseDir, this);
    }

    public void shutdown() {
        this.runningFakeMysqlds.remove(this.baseDir);
        this.running = null;
        for (int i = 0; i < this.completionListensers.size(); ++i) {
            Runnable listener = (Runnable)this.completionListensers.get(i);
            listener.run();
        }
    }

    public Map getServerOptions() {
        return new HashMap(this.currentOptions);
    }

    public boolean isRunning() {
        return this.running != null;
    }

    public String getVersion() {
        return this.version;
    }

    public void addCompletionListenser(Runnable listener) {
        this.completionListensers.add(listener);
    }

    public void setVersion(String version) {
        if (version == null) {
            this.version = "5.2.23";
        }
        this.version = version;
    }

    public void setKillDelay(int millis) {
        throw new RuntimeException("Millis: " + millis);
    }

    public boolean isReadyForConnections() {
        return this.isRunning();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public int getPort() {
        return 0;
    }
}

