/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

import com.ice.util.AWTUtilities;


public class
AboutPanel extends JPanel
	{
	private static final String		releaseStr = "1.5, April 27, 1998";

	private static final String		aboutText =
		"\n" +
		"jSQL is free software, which is licensed to you under the\n" +
		"GNU General Public License, version 2. Please see the file\n" +
		"LICENSE for more details, or visit 'www.gnu.org'.\n" +
		"\n" +
		"This software is provided AS-IS, with ABSOLUTELY NO WARRANTY.\n" +
		"\n" +
		"YOU ASSUME ALL RESPONSIBILITY FOR ANY AND ALL CONSEQUENCES\n" +
		"THAT MAY RESULT FROM THE USE OF THIS SOFTWARE!" +
		"\n" +
		"\n" +
		"Written by Tim Endres  <mailto:time@ice.com>  <http://www.ice.com/>\n" +
		"\n";


	private JTextArea		aboutTextArea;


	public
	AboutPanel()
		{
		this.setDoubleBuffered( true );
		this.establishContents();
		}

	private void
	establishContents()
		{
		this.setLayout( new GridBagLayout() );

		JLabel lbl;
		int row = 0;

		lbl = new JLabel( "jSQL - A Simple Java SQL Client" );
		lbl.setHorizontalAlignment( JLabel.CENTER );
		AWTUtilities.constrain(
			this, lbl,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 0.0 );

		lbl = new JLabel( "Release " +  AboutPanel.releaseStr );
		lbl.setHorizontalAlignment( JLabel.CENTER );
		AWTUtilities.constrain(
			this, lbl,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 0.0 );

/*
		lbl = new JLabel( "Written By Tim Endres  <mailto:time@ice.com>  <http://www.ice.com>" );
		lbl.setHorizontalAlignment( JLabel.CENTER );
		AWTUtilities.constrain(
			this, lbl,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 0.0 );

		lbl = new JLabel( "time@ice.com  --  http://www.ice.com" );
		lbl.setHorizontalAlignment( JLabel.CENTER );
		AWTUtilities.constrain(
			this, lbl,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 0.0 );
*/
		lbl = new JLabel( "Copyright (c) 1998 by Timothy Gerard Endres" );
		lbl.setHorizontalAlignment( JLabel.CENTER );
		AWTUtilities.constrain(
			this, lbl,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 0.0 );

		this.aboutTextArea = new JTextArea();
		this.aboutTextArea.setText( AboutPanel.aboutText );

		JScrollPane scroller = new JScrollPane();
		scroller.getViewport().add( this.aboutTextArea );
		AWTUtilities.constrain(
			this, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, row++, 1, 1, 1.0, 1.0 );
		}

	}


