/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.awt.Dimension;
import java.util.Properties;
import com.sun.java.swing.*;

import com.ice.util.UserProperties;
import com.ice.util.StringUtilities;


public class
SQLClient
	{
	public static final String		RCS_ID = "$Id: SQLClient.java,v 1.9 1998/04/30 18:39:44 time Exp $";
	public static final String		RCS_REV = "$Revision: 1.9 $";
	public static final String		RCS_NAME = "$Name:  $";

	public static final String		VERSION_STR = "1.5";

	private static final String		PROP_PREFIX = "SQLClient.";
	private static final String		PROP_PACKAGE = "com.ice.sqlclient";
	private static final String		DEFAULTS_RSRC =
										"/com/ice/sqlclient/defaults.txt";
	private static final String		LOCAL_PROPERTIES = "properties.txt";

	static public SQLClient			app = null;

	
	static public void
	main( String argv[] )
		{
		UserProperties.setPropertyPrefix( SQLClient.PROP_PREFIX );

		UserProperties.setDefaultsResource( SQLClient.DEFAULTS_RSRC );

		UserProperties.setLocalPropertyFile( SQLClient.LOCAL_PROPERTIES );

		String[] myArgs = UserProperties.processOptions( argv );

		// LOAD PROPERTIES 
		UserProperties.loadProperties( SQLClient.PROP_PACKAGE, null );

		SQLClient.app = new SQLClient();

		app.instanceMain( myArgs );
		}

	public void
	instanceMain( String args[] )
		{
		int		iArg = 0;

		for ( ; iArg < args.length ; ++iArg )
			{
			if ( ! args[iArg].startsWith( "-" ) )
				break;

			if ( args[iArg].equals( "-?" )
					|| args[iArg].equals( "-help" )
					|| args[iArg].equals( "-usage" ) )
				{
				this.printUsage();
				}
			else
				{
				System.err.println
					( "ignoring option '" + args[iArg] );
				}
			}

		System.err.println( "Loading jdbc drivers..." );

		this.loadJDBCDrivers();

		// CREATE MAIN WINDOW 
		String title =
			UserProperties.getProperty
				( "mainWindow.title",
					"SQL Client" );

		MainFrame frame = new MainFrame( title );

		int x =
			UserProperties.getProperty
				( "mainWindow.x", 20 );
		int y =
			UserProperties.getProperty
				( "mainWindow.y", 20 );

		frame.setLocation( x, y );

		int w =
			UserProperties.getProperty
				( "mainWindow.width", -1 );
		int h =
			UserProperties.getProperty
				( "mainWindow.height", -1 );

		frame.pack();

		Dimension fSz = frame.getSize();

		if ( w == -1 ) w = fSz.width;
		if ( h == -1 ) h = fSz.height;

		frame.setSize( w, h );

		frame.show();
		}

	private void
	loadJDBCDrivers()
		{		
		for ( int idx = 1 ; idx < 100 ; ++idx )
			{
			String propLine =
				UserProperties.getProperty
					( "jdbcDriver." + idx, null );
			
			if ( propLine == null )
				{
				System.err.println
					( "Loaded " + (idx - 1) + " drivers." );
				break;
				}

			// Name:Handler:Driver

			String[] pArgs =
				StringUtilities.splitString( propLine, ":" );

			if ( pArgs.length != 4 )
				{
				System.err.println
					( "Invalid driver property:\n\t" + propLine );
				continue;
				}

			if ( pArgs[0].equalsIgnoreCase( "MySQL" ) )
				{
				try {
					MySQLClient mysql =
						new MySQLClient( pArgs[1], pArgs[2], pArgs[3] );

					SQLClientHandler.addHandler( mysql );
					}
				catch ( ClassNotFoundException ex )
					{
					System.err.println
						( "ERROR creating SQL Handler '"
							+ pArgs[0] + "', " + ex.getMessage() );
					}
				}
			else
				{
				System.err.println
					( "UNKNOWN SQL Handler '" + pArgs[1] + "'" );
				}
			}
		}

	public void
	printUsage()
		{
		System.err.println
			( "usage: com.ice.sqlclient.SQLClient [options...]" );

		System.err.println( "SQLClient options:" );
		System.err.println( "    currently no options" );

		UserProperties.printUsage( System.err );
		}

	}



