// $Id: test_insert.java,v 1.3 1997/11/19 18:19:24 xzhu Exp $
// test_insert.java
//
// port from perl script 'test-insert'
//
// Test of creating a simple table and inserting $record_count records in it,
// $record_count in order, $record_count in reverse order and $record_count
// in random order
//
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/14
//
// Copyright (C) 1997, X.K.ZHU
//   The `test_insert.java' is free software and comes with NO WARRANTY of any
//   kind; you can redistribute it and/or modify it under the terms of the 
//   GNU Library General Public License as published by the Free Software 
//   Foundation; either version 2 of the License, or (at your option) any 
//   later version.
package bench;

import java.net.URL;
import java.sql.*;
import java.io.*;
import zxk.util.*;

public class test_insert implements DBugConstant
{
  // Change this to make test harder/easier
  // This is the default value for the count of records used in this test.
  private  int loopCount = 1000;

  private long second_orig;
  private InputStream myIn;

  private boolean skipCreate;
  private boolean skipIn;
  private boolean skipDelete;
  private boolean verbose;
  private boolean fastInsert;
  private boolean lockTables;
  private boolean fast;
  private boolean force;
  private String debugStr = null;

  private test_insert()
  {
    second_orig = -1;
    myIn = System.in;

    skipCreate = false;
    skipIn = false;
    skipDelete = false;
    verbose = false;
    fastInsert = false;
    lockTables = false;
    fast = false;
    force = false;
  }

  public void doit(String[] args)
  {
    String[] loName = { "fast", "fast_insert", "help", "host", "lock_tables",
      "password", "port", "skip_create", "skip_delete", "skip_in",
      "user", "debug" };
    int[] loHasArg = { GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG,
      GetOpt.REQ_ARG, GetOpt.NO_ARG, GetOpt.OPT_ARG, GetOpt.REQ_ARG,
      GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.NO_ARG, GetOpt.REQ_ARG,
      GetOpt.REQ_ARG };
    int[] loValue = { 'F', 'i', '?', 'h', 'l', 'p', 'P', 
      'c', 'd', 's', 'u', '#' };
    GetOpt g = new GetOpt();
    g.setInputArgs(args);
    g.setShortOption("#:?cdsiFh:lp::P:u:");
    g.setLongOptionName(loName);
    g.setLongOptionHasArg(loHasArg);
    g.setLongOptionValue(loValue);
    g.setOptionMode(GetOpt.LONG_OPT);

    String host = null;
    String port = null;
    String user = null;
    String password = null;
    String database = new String("test");
    int c;
    boolean tty_password = false;
    boolean error = false;

    try
    {
      while ( (c=g.getopt()) != GetOpt.EOF)
      {
        switch(c)
        {
          case '#':
            debugStr = g.getOptarg();
            break;
	  case 'F':
	    fast = true;
	    break;
	  case 'i':
	    fastInsert = true;
	    break;
	  case 'l':
	    lockTables = true;
	    break;
	  case 'c':
	    skipCreate = true;
	    break;
	  case 'd':
	    skipDelete = true;
	    break;
	  case 's':
	    skipIn = true;
	    break;
          case 'h':
	    host = g.getOptarg();
	    break;
	  case 'p':
	    password = g.getOptarg();
	    if (password == null)
	      tty_password = true;
	    break;
	  case 'u':
	    user = g.getOptarg();
	    break;
	  case 'P':
	    port = g.getOptarg();
	    break;
	  default:
	    String s = new Character((char)c).toString();
	    System.err.println("Illegal option character '" + s + "'");
	  case '?':
	    error = true;
	    break;
        }
      }
    }
    catch (GetOptException e)
    {
      System.err.println(e.getMessage());
      error = true;
    }

    if (error)
    {
      System.out.println("Usage: java test_connect [OPTIONS]");
      System.out.println("\n" +
  "-#, --debug=opt      debug string, default is NO, see DBug.java for details\n" +
  "-?, --help		display this help and exit\n" + 
  "-c, --skip_create	skip create tables\n" +
  "-d, --skip_delete	skip delete tables\n" +
  "-F, --fast		fast drop table.\n" +
  "-h, --host=#		connect to host\n" +
  "-i, --fast_insert	fast insert record\n" +
  "-l, --lock_tables	lock table\n" + 
  "-p, --password[=xxx]	password to use when connecting to server\n" +
  "                     If password is not given it's asked from the tty.\n" +
  "-P  --port=...	Port number to use for connection\n" + 
  "-s, --skip_in	skip `IN' at the select sentence" +
  "-u, --user=#		user for login if not current user\n");
      System.exit(1);
    }

    if (tty_password)
      password = getTtyPassword();
    
    if (debugStr == null)
      debugStr = new String("");
    if (zxk_debug)
      DBug.dbug.dbPush(debugStr);

    Connection conn;
    int i;
    int rows;
    //
    // Generating random keys
    //
    System.out.println("Generating random keys");
    int[] random = new int[loopCount];
    for (i=0 ; i<loopCount ; i++)
      random[i] = i + loopCount;
    for (i=0 ; i<loopCount ; i++)
    {
      int swap = (int)(loopCount * java.lang.Math.random());
      int tmp = random[i]; random[i] = random[swap]; random[swap] = tmp;
    }
    //
    // Connect and start timing
    //
    long zsec = System.currentTimeMillis();
    conn = executeConnect(host, port, user, password, database);
    try
    {
      //
      // Create needed tables
      //
      if (!skipCreate)
      {
        System.out.println("Creating tables.");
        Statement stmt = conn.createStatement();
	try 
	{ rows = stmt.executeUpdate("drop table test");
	} catch (SQLException e2) {}
        rows = stmt.executeUpdate("create table test (id int(5),primary key (id))");
	if (lockTables)
          rows = stmt.executeUpdate("LOCK TABLES test WRITE");
        //
        // Insert loopCount*3 records in order, in reverseorder and random.
        //
        second_orig = System.currentTimeMillis();
        StringBuffer sb1 = new StringBuffer();
        if (!fastInsert)
          sb1.append("insert into test (id) values (");
        else
          sb1.append("insert into test values (");
        System.out.println("Inserting " + loopCount + " rows in order...");
        for (i=0; i<loopCount; ++i)
          rows = stmt.executeUpdate(sb1.toString() + i + ")");
        System.out.println("Inserting " + loopCount + " rows in reverse order...");
        for (i=0; i<loopCount; ++i)
          rows = stmt.executeUpdate(sb1.toString() + (loopCount*3-1-i) + ")");
        System.out.println("Inserting " + loopCount + " rows in random order...");
        for (i=0; i<loopCount; ++i)
          rows = stmt.executeUpdate(sb1.toString() + random[i] + ")");
        System.out.println("Time to insert " + (loopCount*3) + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
        //
        // insert loopCount records with duplicate id
        //
        System.out.println("Testing insert of duplicates");
        second_orig = System.currentTimeMillis();
        for (i=0; i<loopCount; ++i)
        {
          int i1 = (int)(3*loopCount*java.lang.Math.random());
	  try
	  { rows = stmt.executeUpdate(sb1.toString() + i1 + ")");
	  } catch (SQLException e2) {}
        }
        System.out.println("Time for insert duplicates of " + loopCount + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      }
      // 
      // Do some selects on the table
      //
      Statement stmt = conn.createStatement();
      System.out.println("Retrieving data from the table");
      second_orig = System.currentTimeMillis();
      // It's really a small table, so we can try a select on everything
      ResultSet rs = stmt.executeQuery("select * from test");
      rows = 0;
      while (rs.next()) 
        rows++;    
      if (rows != (loopCount*3))
      {
        System.err.println("Got wrong number of rows when selecting whole table");
	System.exit(1);
      }
      rs = stmt.executeQuery("select * from test order by id");
      rs = stmt.executeQuery("select * from test order by id desc");
      System.out.println("Time for selct_big " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Test select that is very popular when using ODBC
      //
      second_orig = System.currentTimeMillis();
      for(int j=0; j<=200; j+=50)
      {
        StringBuffer sb1 = new StringBuffer();
        sb1.append("id = 100 ");
	StringBuffer sb2 = null;
	if (skipIn)
	{
	  sb2 = new StringBuffer();
	  sb2.append("id IN ( 100");
	}
        for (i=0; i<j; ++i)
	{
	  int i1 = (int)(10 * loopCount * java.lang.Math.random());
          sb1.append(" or id=" + i1);
	  if (skipIn)
	    sb2.append("," + i1);
	}
        rs = stmt.executeQuery("select * from test where " + sb1.toString());
	if (skipIn)
          rs = stmt.executeQuery("select * from test where " + sb2.toString() + ")");
	// Do it a little harder by setting a extra range
        rs = stmt.executeQuery("select * from test where (" + sb1.toString() + ") and id < 10");
      }
      System.out.println("Time for select_range: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Do some sample selects on direct key
      //
      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount; ++i)
      {
        int i1 = (int)(3*loopCount * java.lang.Math.random());
        rs = stmt.executeQuery("select * from test where id=" + i1);
      }
      //
      // Do some sample selects on keys that isn't found
      //
      for (i=0; i<loopCount; ++i)
      {
        try
	{
          int i1 = (int)(3*loopCount * java.lang.Math.random()) + 3*loopCount;
          rs = stmt.executeQuery("select * from test where id=" + i1);
	  if (rs.next())
	  {
	    System.err.println("Found rows on impossible id: "+ i1);
	    System.exit(1);
	  }
	} catch (SQLException e1) {} // empty exception
      }
      System.out.println("Time for select of " + (loopCount*2) + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // A lot of simpe selects on ranges
      //
      int[] totalRows = new int[20];
      String[] Q = new String[20];
      Q[0] = new String("select * from test where id=3 or id=2 or id=1 or id=4 or id=16 or id=10");
      totalRows[0] = 6;
      Q[1] = new String("select * from test where id>=" + (loopCount*3-1) +" or id<1");
      totalRows[1] = 2;
      Q[2] = new String("select * from test where id>=1 and id<=2");
      totalRows[2] = 2;
      Q[3] = new String("select * from test where id>=1 and id<=2 or id>=1 and id<=2");
      totalRows[3] = 2;
      Q[4] = new String("select * from test where id>=1 and id<=10 and id<=5");
      totalRows[4] = 5;
      Q[5] = new String("select * from test where id>0 and id<2 or id>=" + (loopCount*3-1));
      totalRows[5] = 2;
      Q[6] = new String("select * from test where id>0 and id<2 or id>="+(loopCount/2)+" and id <= "+(loopCount/2+2)+" or id ="+(loopCount-1));
      totalRows[6] = 5;
      Q[7] = new String("select * from test where id>=5 and id<=10 or id>=1 and id<=4");
      totalRows[7] = 10;
      Q[8] = new String("select * from test where (id=1 or id=2) and (id=3 or id=4)");
      totalRows[8] = 0;
      Q[9] = new String("select * from test where (id=1 or id=2) and (id=2 or id=3)");
      totalRows[9] = 1;
      Q[10] = new String("select * from test where (id=1 or id=5 or id=20 or id=40) and (id=1 or id>=20 or id=4)");
      totalRows[10] = 3;
      Q[11] = new String("select * from test where ((id=1 or id=3) or (id>1 and id<3)) and id<=2");
      totalRows[11] = 2;
      Q[12] = new String("select * from test where (id >= 0 and id < 4) or (id >=4 and id < 6)");
      totalRows[12] = 6;
      Q[13] = new String("select * from test where id <= -1 or (id >= 0 and id <= 5) or (id >=4 and id < 6) or (id >=6 and id <=7) or (id>7 and id <= 8)");
      totalRows[13] = 9;
      Q[14] = new String("select * from test where (id>=1 and id<=2 or id>=4 and id<=5) or (id>=0 and id <=10)");
      totalRows[14] = 11;
      Q[15] = new String("select * from test where (id>=1 and id<=2 or id>=4 and id<=5) or (id>2 and id <=10)");
      totalRows[15] = 10;
      Q[16] = new String("select * from test where (id>1 or id <1) and id<=2");
      totalRows[16] = 2;
      Q[17] = new String("select * from test where (id>1 or id <=1) and id<=2");
      totalRows[17] = 3;
      Q[18] = new String("select * from test where (id>=1 or id <1) and id<=2");
      totalRows[18] = 3;
      Q[19] = new String("select * from test where (id>=1 or id <=2) and id<=2");
      totalRows[19] = 3;

      second_orig = System.currentTimeMillis();
      for (int j=0; j<100; ++j)
        for (i=0; i<Q.length; ++i)
	{
          rs = stmt.executeQuery(Q[i]);
          rows = 0;
          while (rs.next()) 
            rows++;    
          if (rows != totalRows[i])
          {
            System.err.println("'" + Q[i] + "' returned wrong number of rows: " + rows + " instead of " + totalRows[i]);
	    System.exit(1);
          }
	}
      System.out.println("Time for select_range: " +(System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // some group gueries
      //
      second_orig = System.currentTimeMillis();
      rs = stmt.executeQuery("select count(*) from test");
      rows = 0;
      int i2 = 0;
      while (rs.next()) 
      {
        i2 = rs.getInt(1);
        rows++;    
      }
      if (rows != 1 || i2 != loopCount*3)
      {
        System.err.println("'select count(*) from test' returned wrong result");
	System.exit(1);
      }

      rs = stmt.executeQuery("select count(*) from test where id >= " + loopCount*2);
      rows = 0;
      i2 = 0;
      while (rs.next()) 
      {
        i2 = rs.getInt(1);
        rows++;    
      }
      if (rows != 1 || i2 != loopCount)
      {
        System.err.println("'select count(*) from test where id >= " + loopCount*2 + "' returned wrong result");
	System.exit(1);
      }
      
      rs = stmt.executeQuery("select count(id),sum(id),min(id),max(id),avg(id) from test");
      rows = 0;
      int[] i3 = new int[4];
      float f1 = 0.0f;
      while (rs.next()) 
      {
        for (i=1; i<=4; ++i)
          i3[i-1] = rs.getInt(i);
	f1 = rs.getFloat(5);
        rows++;    
      }
      if (rows != 1 || i3[0] != loopCount*3 || 
          i3[1] != ((loopCount*3-1)*loopCount*3/2) || 
	  i3[2] != 0 || i3[3] != loopCount*3-1 ||
          f1 != (loopCount*3-1.0f)/2.0)
      {
        System.err.println("'select count(id),sum(id),min(id),max(id),avg(id) from test' returned wrong result " + i3[0] + " " + i3[1] + " " + i3[2] + " " + i3[3] + " " + f1);
	System.exit(1);
      }

      rs = stmt.executeQuery("select mod(id,10) as last_digit,count(*) from test group by last_digit");
      rows = 0;
      while (rs.next()) 
        rows++;    
      if (rows != 10)
      {
        System.err.println("'select mod(id,10) as last_digit,count(*) from test group by last_digit' returned wrong result: "+rows);
	//System.exit(1);
      }

      rs = stmt.executeQuery("select id,id+1,id+2 from test where id < 100 group by 1 desc,2,3");
      rows = 0;
      while (rs.next()) 
        rows++;    
      if (rows != 100)
      {
        System.err.println("'select id,id+1,id+2 from test where id < 100 group by 1 desc,2,3' returned wrong result: "+ rows);
	//System.exit(1);
      }
      System.out.println("Time for select_group : " +(System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
      //
      // Some updates on the table
      //
      second_orig = System.currentTimeMillis();
      System.out.println("Testing update");
      for (i=0; i<loopCount; ++i)
      {
        int tmp = loopCount + random[i]; // loopCount*2 <= tmp < loopCount*3
        rows = stmt.executeUpdate("update test set id=-" + tmp + " where id=" + tmp);
      }
      System.out.println("Time for update_key of " + loopCount + " keys: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      second_orig = System.currentTimeMillis();
      for (i=0; i<loopCount/2; i+=10)
      {
        rows = stmt.executeUpdate("update test set id=-id where id >= 0 and id <= " + i);
      }
      rows = stmt.executeUpdate("update test set id=-id where id >= 0 and id <= " + loopCount);
      rows = stmt.executeUpdate("update test set id=-id where id >= " + loopCount + " and id <= " + (2*loopCount));
      // Check that every thing except id=0 was updated
      // In principle we shouldn't time this in the update loop...
      //
      rs = stmt.executeQuery("select * from test where id >= 0");
      rows = 0;
      while (rs.next()) 
        rows++;    
      if (rows != 1)
      {
        System.err.println("Update loop didn't update all records: "+rows);
	//System.exit(1);
      }
      // restore id to 0 <= id < loopCount*3
      rows = stmt.executeUpdate("update test set id=-id where id <= 0");
      System.out.println("Time for update_key_big of " + (loopCount*5) + " keys: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

      // Do some deletes on the table
      if (!skipDelete)
      {
        second_orig = System.currentTimeMillis();
        System.out.println("Testing delete");
        for (i=0; i<loopCount; ++i)
	{
	  int tmp = loopCount + random[i]; // loopCount*2 <= tmp < loopCount*3
          rows = stmt.executeUpdate("delete from test where id=" + tmp);
        }
        System.out.println("Time for delete of " + loopCount + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");

        second_orig = System.currentTimeMillis();
        for (i=0; i<loopCount/2; i+=10)
	{
          rows = stmt.executeUpdate("delete from test where id >= 0 and id <= " + i);
        }
        rows = stmt.executeUpdate("delete from test where id >= 0 and id <= " + loopCount);
	if (fast)
          rows = stmt.executeUpdate("delete from test");
	else
          rows = stmt.executeUpdate("delete from test where id < " + (loopCount*3));
        System.out.println("Time for big delete of " + (loopCount*2) + " rows: " + (System.currentTimeMillis() - second_orig)/1000.0 + " sec.");
  
        if (lockTables)
          rows = stmt.executeUpdate("UNLOCK TABLES ");
        rows = stmt.executeUpdate("drop table test");
      }
    }
    catch (SQLException e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    catch (Exception e)
    {
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(1);
    }
    executeClose(conn);

    // End of the test 
    // Finally print time used to execute the whole test
    System.out.println("Toal time: " + (System.currentTimeMillis() - zsec)/1000.0 + " sec.");
  }

  private Connection executeConnect(String host, String port, String user, 
    String password, String database)
  {
    boolean specialVersion = false;
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");

      StringBuffer bufferURL = new StringBuffer();
      bufferURL.append("jdbc:mysql:");
      if (host != null && host.length() != 0)
      {
        bufferURL.append("//" + host);
        if (port != null && port.length() != 0)
          bufferURL.append(":" + port + "/");
        else
          bufferURL.append("/");
      }
      else if (port != null && port.length() != 0)
      {
        bufferURL.append("//localhost:" + port + "/");
      }
      bufferURL.append(database);
      if (user == null || user.length() == 0)
        user = System.getProperty("user.name");
      bufferURL.append("?user=" + user);
      if (password == null)
        password = "";
      bufferURL.append(";password=" + password);
      String url = new String(bufferURL);
//System.out.println(url);

      return DriverManager.getConnection (url);
    } 
    catch (SQLException e) 
    {
      System.out.println (e.getMessage ());
      System.exit(1);
    } 
    catch (Exception e)
    { 
      e.printStackTrace(); 
      System.exit(1);
    }
    return null;
  }

  private void executeClose(Connection conn)
  {
    try
    {
      conn.close();
    } 
    catch (SQLException e)
    { 
      e.printStackTrace();
      System.exit(1);
    }
    /* System.out.println("wait for 10 sec for closing...");
    try
    {
          Thread.sleep(10000);
    } catch (InterruptedException e) {}
    */
  }

  private int displayResult(ResultSet rs)
    throws SQLException
  {               
    int i;          
    int rows = 0;
    ResultSetMetaData rsmd = rs.getMetaData ();
    int numCols = rsmd.getColumnCount ();
        
    try 
    {
    boolean hasMore = rs.next();
    if (hasMore)
    {
      // Display column headings
      System.out.print("|");
      for (i=1; i<=numCols; i++) 
      {
        System.out.print(rsmd.getColumnName(i));
        System.out.print("\t|");
      }
      System.out.println("");
      // Display data, fetching until end of the result set
      while (hasMore) 
      {          
        rows++;    
        System.out.print("|");
        for (i=1; i<=numCols; i++) 
        {
          System.out.print(rs.getString(i));
  	System.out.print("\t|");
        }
        System.out.println("");
	hasMore = rs.next();
      }
    }       
    } 
    catch (SQLException e)
    { throw e; }

    return rows;
  }       

  private String readLine()
  {
    StringBuffer line = new StringBuffer();
    int in = -1;
    
    try
    {
      while ( (in = myIn.read()) != 10 && in != 13 && in != -1)
      {
	//String s = new Character((char)in).toString();
        //System.out.print(" " + s);
        line.append(new Character((char)in));
      }
    } catch (IOException e)
    { e.printStackTrace(); }
    
    if (line.length() == 0 && in == -1)
      return null;
    return line.toString();
  }

  private String getTtyPassword()
  {
    System.out.print("Password:");
    return readLine();
  }

  public static void main (String[] args) 
  {
    test_insert admin = new test_insert();
    admin.doit(args);
  }
}
