/* Copyright (c) 2004, 2021, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  <mysql_fix_privilege_tables.sql>
*/
const char* mysql_fix_privilege_tables[]={
"-- Copyright (c) 2007, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is also distributed with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have included with MySQL.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- The system tables of MySQL Server\n"
  "--\n"
  "set @have_innodb= (select count(engine) from information_schema.engines where engine='INNODB' and support != 'NO');\n",
"set @is_mysql_encrypted = (select ENCRYPTION from information_schema.INNODB_TABLESPACES where NAME='mysql');\n",
"-- Tables below are NOT treated as DD tables by MySQL server yet.\n"
  "SET FOREIGN_KEY_CHECKS= 1;\n",
"# Added sql_mode elements and making it as SET, instead of ENUM\n"
  "set default_storage_engine=InnoDB;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS db\n"
  "(\n"
  "Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "Db char(64) binary DEFAULT '' NOT NULL,\n"
  "User char(32) binary DEFAULT '' NOT NULL,\n"
  "Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY Host (Host,Db,User), KEY User (User)\n"
  ")\n"
  "engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Database privileges' ROW_FORMAT=DYNAMIC"
  " TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if db table already existed\n"
  "set @had_db_table= @@warning_count != 0;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS user\n"
  "(\n"
  "Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "User char(32) binary DEFAULT '' NOT NULL,\n"
  "Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL,\n"
  "ssl_cipher BLOB NOT NULL,\n"
  "x509_issuer BLOB NOT NULL,\n"
  "x509_subject BLOB NOT NULL,\n"
  "max_questions int unsigned DEFAULT 0  NOT NULL,\n"
  "max_updates int unsigned DEFAULT 0  NOT NULL,\n"
  "max_connections int unsigned DEFAULT 0  NOT NULL,\n"
  "max_user_connections int unsigned DEFAULT 0  NOT NULL,\n"
  "plugin char(64) DEFAULT 'caching_sha2_password' NOT NULL,\n"
  "authentication_string TEXT,\n"
  "password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "password_last_changed timestamp NULL DEFAULT NULL,\n"
  "password_lifetime smallint unsigned NULL DEFAULT NULL,\n"
  "account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Create_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Drop_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "Password_reuse_history smallint unsigned NULL DEFAULT NULL,\n"
  "Password_reuse_time smallint unsigned NULL DEFAULT NULL,\n"
  "Password_require_current enum('N', 'Y') COLLATE utf8_general_ci DEFAULT NULL,\n"
  "User_attributes JSON DEFAULT NULL,\n"
  "PRIMARY KEY Host (Host,User)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Users and global privileges' ROW_FORM"
  "AT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS default_roles\n"
  "(\n"
  "HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "DEFAULT_ROLE_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '%' NOT NULL,\n"
  "DEFAULT_ROLE_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "PRIMARY KEY (HOST, USER, DEFAULT_ROLE_HOST, DEFAULT_ROLE_USER)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Default roles' ROW_FORMAT=DYNAMIC TAB"
  "LESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS role_edges\n"
  "(\n"
  "FROM_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "FROM_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "TO_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "TO_USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "WITH_ADMIN_OPTION ENUM('N', 'Y') COLLATE UTF8_GENERAL_CI DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY (FROM_HOST,FROM_USER,TO_HOST,TO_USER)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Role hierarchy and role grants' ROW_F"
  "ORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS global_grants\n"
  "(\n"
  "USER CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "PRIV CHAR(32) COLLATE UTF8_GENERAL_CI DEFAULT '' NOT NULL,\n"
  "WITH_GRANT_OPTION ENUM('N','Y') COLLATE UTF8_GENERAL_CI DEFAULT 'N' NOT NULL,\n"
  "PRIMARY KEY (USER,HOST,PRIV)\n"
  ") engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Extended global grants' ROW_FORMAT=DY"
  "NAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if user table already existed\n"
  "set @had_user_table= @@warning_count != 0;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS password_history\n"
  "(\n"
  "  Host CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "  User CHAR(32) BINARY DEFAULT '' NOT NULL,\n"
  "  Password_timestamp TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6),\n"
  "  Password TEXT,\n"
  "  PRIMARY KEY(Host, User, Password_timestamp DESC)\n"
  " ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin\n"
  " comment='Password history for user accounts' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS func (  name char(64) binary DEFAULT '' NOT NULL, ret tinyint DEFAULT '0' NOT NU"
  "LL, dl char(128) DEFAULT '' NOT NULL, type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL, PRIMARY KE"
  "Y (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin   comment='User defined functions' RO"
  "W_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS plugin ( name varchar(64) DEFAULT '' NOT NULL, dl varchar(128) DEFAULT '' NOT NU"
  "LL, PRIMARY KEY (name) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_general_ci comment='MySQL p"
  "lugins' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_topic ( help_topic_id int unsigned not null, name char(64) not null, help_c"
  "ategory_id smallint unsigned not null, description text not null, example text not null, url text not null, primary k"
  "ey (help_topic_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help topics' R"
  "OW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_category ( help_category_id smallint unsigned not null, name  char(64) not "
  "null, parent_category_id smallint unsigned null, url text not null, primary key (help_category_id), unique index (nam"
  "e) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help categories' ROW_FORMAT=DYNAMIC TABLESPACE=mysq"
  "l\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_relation ( help_topic_id int unsigned not null, help_keyword_id  int unsign"
  "ed not null, primary key (help_keyword_id, help_topic_id) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comme"
  "nt='keyword-topic relation' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS servers ( Server_name char(64) NOT NULL DEFAULT '', Host char(255) CHARACTER SET"
  " ASCII NOT NULL DEFAULT '', Db char(64) NOT NULL DEFAULT '', Username char(64) NOT NULL DEFAULT '', Password char(64)"
  " NOT NULL DEFAULT '', Port INT NOT NULL DEFAULT '0', Socket char(64) NOT NULL DEFAULT '', Wrapper char(64) NOT NULL D"
  "EFAULT '', Owner char(64) NOT NULL DEFAULT '', PRIMARY KEY (Server_name)) engine=InnoDB STATS_PERSISTENT=0 CHARACTER "
  "SET utf8 comment='MySQL Foreign Servers table' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS tables_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(64"
  ") binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NUL"
  "L, Grantor varchar(288) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT"
  "_TIMESTAMP, Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','"
  "Create View','Show view','Trigger') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Column_priv set('Select','Insert','U"
  "pdate','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name), KEY Grantor "
  "(Grantor) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8"
  " COLLATE utf8_bin   comment='Table privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS columns_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(6"
  "4) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NU"
  "LL, Column_name char(64) binary DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE"
  " CURRENT_TIMESTAMP, Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT N"
  "ULL, PRIMARY KEY (Host,Db,User,Table_name,Column_name) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE "
  "utf8_bin   comment='Column privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS help_keyword (   help_keyword_id  int unsigned not null, name char(64) not null,"
  " primary key (help_keyword_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='he"
  "lp keywords' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_name (   Name char(64) NOT NULL, Time_zone_id int unsigned NOT NULL, P"
  "RIMARY KEY Name (Name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone names' ROW_FORMAT=D"
  "YNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone (   Time_zone_id int unsigned NOT NULL auto_increment, Use_leap_second"
  "s enum('Y','N') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY TzId (Time_zone_id) ) engine=INNODB STATS_P"
  "ERSISTENT=0 CHARACTER SET utf8   comment='Time zones' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_transition (   Time_zone_id int unsigned NOT NULL, Transition_time big"
  "int signed NOT NULL, Transition_type_id int unsigned NOT NULL, PRIMARY KEY TzIdTranTime (Time_zone_id, Transition_tim"
  "e) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone transitions' ROW_FORMAT=DYNAMIC TABLESP"
  "ACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_transition_type (   Time_zone_id int unsigned NOT NULL, Transition_typ"
  "e_id int unsigned NOT NULL, Offset int signed DEFAULT 0 NOT NULL, Is_DST tinyint unsigned DEFAULT 0 NOT NULL, Abbrevi"
  "ation char(8) DEFAULT '' NOT NULL, PRIMARY KEY TzIdTrTId (Time_zone_id, Transition_type_id) ) engine=INNODB STATS_PER"
  "SISTENT=0 CHARACTER SET utf8   comment='Time zone transition types' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS time_zone_leap_second (   Transition_time bigint signed NOT NULL, Correction int"
  " signed NOT NULL, PRIMARY KEY TranTime (Transition_time) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comm"
  "ent='Leap seconds information for time zones' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS procs_priv ( Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Db char(64)"
  " binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Routine_name char(64) COLLATE utf8_general_ci "
  "DEFAULT '' NOT NULL, Routine_type enum('FUNCTION','PROCEDURE') NOT NULL, Grantor varchar(288) DEFAULT '' NOT NULL, Pr"
  "oc_priv set('Execute','Alter Routine','Grant') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Timestamp timestamp NOT N"
  "ULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (Host,Db,User,Routine_name,Routine_type), KEY "
  "Grantor (Grantor) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin   comment='Procedure privile"
  "ges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- bug#92988: Temporarily turn off sql_require_primary_key for the\n"
  "-- next 2 tables as this is not necessary as they do not replicate.\n"
  "SET @old_sql_require_primary_key = @@session.sql_require_primary_key;\n",
"SET @@session.sql_require_primary_key = 0;\n",
"-- Create general_log\n"
  "CREATE TABLE IF NOT EXISTS general_log (event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRE"
  "NT_TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, thread_id BIGINT UNSIGNED NOT NULL, server_id INTEGER UNSIGNED NOT NU"
  "LL, command_type VARCHAR(64) NOT NULL, argument MEDIUMBLOB NOT NULL) engine=CSV CHARACTER SET utf8 comment=\"General "
  "log\";\n",
"-- Create slow_log\n"
  "CREATE TABLE IF NOT EXISTS slow_log (start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_"
  "TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, query_time TIME(6) NOT NULL, lock_time TIME(6) NOT NULL, rows_sent INTEG"
  "ER NOT NULL, rows_examined INTEGER NOT NULL, db VARCHAR(512) NOT NULL, last_insert_id INTEGER NOT NULL, insert_id INT"
  "EGER NOT NULL, server_id INTEGER UNSIGNED NOT NULL, sql_text MEDIUMBLOB NOT NULL, thread_id BIGINT UNSIGNED NOT NULL)"
  " engine=CSV CHARACTER SET utf8 comment=\"Slow log\";\n",
"SET @@session.sql_require_primary_key = @old_sql_require_primary_key;\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS component ( component_id int unsigned NOT NULL AUTO_INCREMENT, component_group_i"
  "d int unsigned NOT NULL, component_urn text NOT NULL, PRIMARY KEY (component_id)) engine=INNODB DEFAULT CHARSET=utf8 "
  "COMMENT 'Components' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS slave_relay_log_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file or rows in the table. Used to versio"
  "n table definitions.',\n"
  "  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the current relay log file.',\n"
  "  Relay_log_pos BIGINT UNSIGNED COMMENT 'The relay log position of the last executed event.',\n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the master binary log file from which"
  " the events in the relay log file were read.',\n"
  "  Master_log_pos BIGINT UNSIGNED COMMENT 'The master log position of the last executed event.',\n"
  "  Sql_delay INTEGER COMMENT 'The number of seconds that the slave must lag behind the master.',\n"
  "  Number_of_workers INTEGER UNSIGNED,\n"
  "  Id INTEGER UNSIGNED COMMENT 'Internal Id that uniquely identifies this record.',\n"
  "  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave i"
  "s connected to a source. Used in Multisource Replication',\n"
  "  Privilege_checks_username CHAR(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'Username part of PRIVILEGE_CHECKS_USER.',"
  "\n"
  "  Privilege_checks_hostname CHAR(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL COMMENT 'Hostname par"
  "t of PRIVILEGE_CHECKS_USER.',\n"
  "  Require_row_format BOOLEAN NOT NULL COMMENT 'Indicates whether the channel shall only accept row based events.',\n"
  "  Require_table_primary_key_check ENUM('STREAM','ON','OFF') NOT NULL DEFAULT 'STREAM' COMMENT 'Indicates what is the "
  "channel policy regarding tables having primary keys on create and alter table queries',\n"
  "  Assign_gtids_to_anonymous_transactions_type ENUM('OFF', 'LOCAL', 'UUID')  NOT NULL DEFAULT 'OFF' COMMENT 'Indicates"
  " whether the channel will generate a new GTID for anonymous transactions. OFF means that anonymous transactions will "
  "remain anonymous. LOCAL means that anonymous transactions will be assigned a newly generated GTID based on server_uui"
  "d. UUID indicates that anonymous transactions will be assigned a newly generated GTID based on Assign_gtids_to_anonym"
  "ous_transactions_value',\n"
  "  Assign_gtids_to_anonymous_transactions_value TEXT CHARACTER SET utf8 COLLATE utf8_bin  COMMENT 'Indicates the UUID "
  "used while generating GTIDs for anonymous transactions',\n"
  "  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Relay Log Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_master_info (\n"
  "  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file.', \n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log curren"
  "tly being read from the master.', \n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last read event.', \n"
  "  Host CHAR(255) CHARACTER SET ASCII COMMENT 'The host name of the master.',\n"
  "  User_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The user name used to connect to the master.', \n"
  "  User_password TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The password used to connect to the master.', \n"
  "  Port INTEGER UNSIGNED NOT NULL COMMENT 'The network port used to connect to the master.', \n"
  "  Connect_retry INTEGER UNSIGNED NOT NULL COMMENT 'The period (in seconds) that the slave will wait before trying to "
  "reconnect to the master.', \n"
  "  Enabled_ssl BOOLEAN NOT NULL COMMENT 'Indicates whether the server supports SSL connections.', \n"
  "  Ssl_ca TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Authority (CA) certifica"
  "te.', \n"
  "  Ssl_capath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path to the Certificate Authority (CA) certificate"
  "s.', \n"
  "  Ssl_cert TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL certificate file.', \n"
  "  Ssl_cipher TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the cipher in use for the SSL connection.'"
  ", \n"
  "  Ssl_key TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL key file.', \n"
  "  Ssl_verify_server_cert BOOLEAN NOT NULL COMMENT 'Whether to verify the server certificate.', \n"
  "  Heartbeat FLOAT NOT NULL COMMENT '', \n"
  "  Bind TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Displays which interface is employed when connecting to the "
  "MySQL server', \n"
  "  Ignored_server_ids TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The number of server IDs to be ignored, follow"
  "ed by the actual server IDs', \n"
  "  Uuid TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The master server uuid.', \n"
  "  Retry_count BIGINT UNSIGNED NOT NULL COMMENT 'Number of reconnect attempts, to the master, before giving up.', \n"
  "  Ssl_crl TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Revocation List (CRL)',"
  " \n"
  "  Ssl_crlpath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certificate Revocation List (CRL) f"
  "iles', \n"
  "  Enabled_auto_position BOOLEAN NOT NULL COMMENT 'Indicates whether GTIDs will be used to retrieve events from the ma"
  "ster.',\n"
  "  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave i"
  "s connected to a source. Used in Multisource Replication',\n"
  "  Tls_version TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version',\n"
  "  Public_key_path TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file containing public key of master server.'"
  ",\n"
  "  Get_public_key BOOLEAN NOT NULL COMMENT 'Preference to get public key from master.',\n"
  "  Network_namespace TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Network namespace used for communication with t"
  "he master server.',\n"
  "  Master_compression_algorithm CHAR(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'Compression algorithm s"
  "upported for data transfer between master and slave.',\n"
  "  Master_zstd_compression_level INTEGER UNSIGNED NOT NULL COMMENT 'Compression level associated with zstd compression"
  " algorithm.',\n"
  "  Tls_ciphersuites TEXT CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT 'Ciphersuites used for TLS 1.3 commu"
  "nication with the master server.',\n"
  "  Source_connection_auto_failover BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates whether the channel connection fa"
  "ilover is enabled.',\n"
  "  Gtid_only BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates if this channel only uses GTIDs and does not persist po"
  "sitions.',\n"
  "  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Master Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS slave_worker_info (\n"
  "  Id INTEGER UNSIGNED NOT NULL,\n"
  "  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Checkpoint_relay_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  Checkpoint_master_log_pos BIGINT UNSIGNED NOT NULL,\n"
  "  Checkpoint_seqno INT UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_size INTEGER UNSIGNED NOT NULL,\n"
  "  Checkpoint_group_bitmap BLOB NOT NULL,\n"
  "  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave i"
  "s connected to a source. Used in Multisource Replication',\n"
  "  PRIMARY KEY(Channel_name, Id)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Worker Information'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd= \"CREATE TABLE IF NOT EXISTS gtid_executed (\n"
  "    source_uuid CHAR(36) NOT NULL COMMENT 'uuid of the source where the transaction was originally executed.',\n"
  "    interval_start BIGINT NOT NULL COMMENT 'First number of interval.',\n"
  "    interval_end BIGINT NOT NULL COMMENT 'Last number of interval.',\n"
  "    PRIMARY KEY(source_uuid, interval_start)) STATS_PERSISTENT=0\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_asynchronous_connection_failover table\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_asynchronous_connection_failover (\n"
  "    Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The replication channel name t"
  "hat connects source and replica.',\n"
  "    Host CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The source hostname that the replica will attempt to switch "
  "over the replication connection to in case of a failure.',\n"
  "    Port INTEGER UNSIGNED NOT NULL COMMENT 'The source port that the replica will attempt to switch over the replicat"
  "ion connection to in case of a failure.',\n"
  "    Network_namespace CHAR(64) COMMENT 'The source network namespace that the replica will attempt to switch over the"
  " replication connection to in case of a failure. If its value is empty, connections use the default (global) namespac"
  "e.',\n"
  "    Weight TINYINT UNSIGNED NOT NULL COMMENT 'The order in which the replica shall try to switch the connection over "
  "to when there are failures. Weight can be set to a number between 1 and 100, where 100 is the highest weight and 1 th"
  "e lowest.',\n"
  "    Managed_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the gro"
  "up which this server belongs to.',\n"
  "    PRIMARY KEY(Channel_name, Host, Port, Network_namespace, Managed_name), KEY(Channel_name, Managed_name)) DEFAULT "
  "CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'The source configuration details'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_asynchronous_connection_failover_managed table\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_asynchronous_connection_failover_managed (\n"
  "    Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The replication channel name t"
  "hat connects source and replica.',\n"
  "    Managed_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the sou"
  "rce which needs to be managed.',\n"
  "    Managed_type CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'Determines the mana"
  "ged type.',\n"
  "    Configuration JSON DEFAULT NULL COMMENT 'The data to help manage group. For Managed_type = GroupReplication, Conf"
  "iguration value should contain {\\\"Primary_weight\\\": 80, \\\"Secondary_weight\\\": 60}, so that it assigns weight=80 t"
  "o PRIMARY of the group, and weight=60 for rest of the members in mysql.replication_asynchronous_connection_failover t"
  "able.',\n"
  "    PRIMARY KEY(Channel_name, Managed_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'The managed source conf"
  "iguration details'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_group_member_actions\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_group_member_actions (\n"
  "    name CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The action name.',\n"
  "    event CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'The event that will trigger the action.',\n"
  "    enabled BOOLEAN NOT NULL COMMENT 'Whether the action is enabled.',\n"
  "    type CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'The action type.',\n"
  "    priority TINYINT UNSIGNED NOT NULL COMMENT 'The order on which the action will be run, value between 1 and 100, l"
  "ower values first.',\n"
  "    error_handling CHAR(64) CHARACTER SET ASCII NOT NULL COMMENT 'On errors during the action will be handled: IGNORE"
  ", CRITICAL.',\n"
  "    PRIMARY KEY(name, event), KEY(event)) DEFAULT CHARSET=utf8mb4 STATS_PERSISTENT=0 COMMENT 'The member actions conf"
  "iguration.'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- replication_group_configuration_version\n"
  "SET @cmd= \"CREATE TABLE IF NOT EXISTS replication_group_configuration_version (\n"
  "    name CHAR(255) CHARACTER SET ASCII NOT NULL COMMENT 'The configuration name.',\n"
  "    version BIGINT UNSIGNED NOT NULL COMMENT 'The version of the configuration name.',\n"
  "    PRIMARY KEY(name)) DEFAULT CHARSET=utf8mb4 STATS_PERSISTENT=0 COMMENT 'The group configuration version.'\";\n",
"SET @str=IF(@have_innodb <> 0, CONCAT(@cmd, ' ENGINE= INNODB ROW_FORMAT=DYNAMIC TABLESPACE=mysql ENCRYPTION=\\'', @is_mys"
  "ql_encrypted,'\\''), CONCAT(@cmd, ' ENGINE= MYISAM'));\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Optimizer Cost Model configuration\n"
  "-- (Note: Column definition for default_value needs to be updated when a\n"
  "--        default value is changed).\n"
  "--\n"
  "-- Server cost constants\n"
  "SET @cmd = \"CREATE TABLE IF NOT EXISTS server_cost (\n"
  "  cost_name   VARCHAR(64) NOT NULL,\n"
  "  cost_value  FLOAT DEFAULT NULL,\n"
  "  last_update TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  comment     VARCHAR(1024) DEFAULT NULL,\n"
  "  default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'disk_temptable_create_cost' THEN 20.0\n"
  "       WHEN 'disk_temptable_row_cost' THEN 0.5\n"
  "       WHEN 'key_compare_cost' THEN 0.05\n"
  "       WHEN 'memory_temptable_create_cost' THEN 1.0\n"
  "       WHEN 'memory_temptable_row_cost' THEN 0.1\n"
  "       WHEN 'row_evaluate_cost' THEN 0.1\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL,\n"
  "  PRIMARY KEY (cost_name)\n"
  ") ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"INSERT IGNORE INTO server_cost(cost_name) VALUES\n"
  "  (\"row_evaluate_cost\"), (\"key_compare_cost\"),\n"
  "  (\"memory_temptable_create_cost\"), (\"memory_temptable_row_cost\"),\n"
  "  (\"disk_temptable_create_cost\"), (\"disk_temptable_row_cost\");\n",
"-- Engine cost constants\n"
  "SET @cmd = \"CREATE TABLE IF NOT EXISTS engine_cost (\n"
  "  engine_name VARCHAR(64) NOT NULL,\n"
  "  device_type INTEGER NOT NULL,\n"
  "  cost_name   VARCHAR(64) NOT NULL,\n"
  "  cost_value  FLOAT DEFAULT NULL,\n"
  "  last_update TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "  comment     VARCHAR(1024) DEFAULT NULL,\n"
  "  default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'io_block_read_cost' THEN 1.0\n"
  "       WHEN 'memory_block_read_cost' THEN 0.25\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL,\n"
  "  PRIMARY KEY (cost_name, engine_name, device_type)\n"
  ") ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"INSERT IGNORE INTO engine_cost(engine_name, device_type, cost_name) VALUES\n"
  "  (\"default\", 0, \"memory_block_read_cost\"),\n"
  "  (\"default\", 0, \"io_block_read_cost\");\n",
"SET @cmd = \"CREATE TABLE IF NOT EXISTS proxies_priv (Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, User char("
  "32) binary DEFAULT '' NOT NULL, Proxied_host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, Proxied_user char(32)"
  " binary DEFAULT '' NOT NULL, With_grant BOOL DEFAULT 0 NOT NULL, Grantor varchar(288) DEFAULT '' NOT NULL, Timestamp "
  "timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY Host (Host,User,Proxied_host,Pr"
  "oxied_user), KEY Grantor (Grantor) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_bin comment='Us"
  "er proxy privileges' ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Remember for later if proxies_priv table already existed\n"
  "set @had_proxies_priv_table= @@warning_count != 0;\n",
"--\n"
  "-- Only create the ndb_binlog_index table if the server is built with ndb.\n"
  "-- Create this table last among the tables in the mysql schema to make it\n"
  "-- easier to keep tests agnostic wrt. the existence of this table.\n"
  "--\n"
  "SET @have_ndb= (select count(engine) from information_schema.engines where engine='ndbcluster');\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS ndb_binlog_index (\n"
  "  Position BIGINT UNSIGNED NOT NULL,\n"
  "  File VARCHAR(255) NOT NULL,\n"
  "  epoch BIGINT UNSIGNED NOT NULL,\n"
  "  inserts INT UNSIGNED NOT NULL,\n"
  "  updates INT UNSIGNED NOT NULL,\n"
  "  deletes INT UNSIGNED NOT NULL,\n"
  "  schemaops INT UNSIGNED NOT NULL,\n"
  "  orig_server_id INT UNSIGNED NOT NULL,\n"
  "  orig_epoch BIGINT UNSIGNED NOT NULL,\n"
  "  gci INT UNSIGNED NOT NULL,\n"
  "  next_position BIGINT UNSIGNED NOT NULL,\n"
  "  next_file VARCHAR(255) NOT NULL,\n"
  "  PRIMARY KEY(epoch, orig_server_id, orig_epoch)\n"
  "  ) ENGINE=INNODB CHARACTER SET latin1 STATS_PERSISTENT=0 ROW_FORMAT=DYNAMIC TABLESPACE=mysql\";\n",
"SET @str = CONCAT(@cmd, \" ENCRYPTION='\", @is_mysql_encrypted, \"'\");\n",
"SET @str = IF(@have_ndb = 1, @str, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Copyright (c) 2003, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License, version 2.0,\n"
  "-- as published by the Free Software Foundation.\n"
  "--\n"
  "-- This program is also distributed with certain software (including\n"
  "-- but not limited to OpenSSL) that is licensed under separate terms,\n"
  "-- as designated in a particular file or component or in included license\n"
  "-- documentation.  The authors of MySQL hereby grant you an additional\n"
  "-- permission to link the program and your derivative works with the\n"
  "-- separately licensed software that they have included with MySQL.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License, version 2.0, for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "# This part converts any old privilege tables to privilege tables suitable\n"
  "# for current version of MySQL\n"
  "# You can safely ignore all 'Duplicate column' and 'Unknown column' errors\n"
  "# because these just mean that your tables are already up to date.\n"
  "# This script is safe to run even if your tables are already up to date!\n"
  "# Warning message(s) produced for a statement can be printed by explicitly\n"
  "# adding a 'SHOW WARNINGS' after the statement.\n"
  "set default_storage_engine=InnoDB;\n",
"# We meed to turn off the default strict mode in case legacy data contains e.g.\n"
  "# zero dates ('0000-00-00-00:00:00'), otherwise, we risk to end up with\n"
  "# e.g. failing ALTER TABLE statements and incorrect table definitions.\n"
  "SET @old_sql_mode = @@session.sql_mode, @@session.sql_mode = '';\n",
"# Create a user mysql.infoschema@localhost as the owner of views in information_schema.\n"
  "# That user should be created at the beginning of the script, because a query against a\n"
  "# view from information_schema leads to check for presence of a user specified in view's DEFINER clause.\n"
  "# If the user mysql.infoschema@localhost hadn't been created at the beginning of the script,\n"
  "# the query from information_schema.tables below would have failed with the error\n"
  "# ERROR 1449 (HY000): The user specified as a definer ('mysql.infoschema'@'localhost') does not exist.\n"
  "INSERT IGNORE INTO mysql.user\n"
  "(host, user, select_priv, plugin, authentication_string, ssl_cipher, x509_issuer, x509_subject)\n"
  "VALUES ('localhost','mysql.infoschema','Y','caching_sha2_password','$A$005$THISISACOMBINATIONOFINVALIDSALTANDPASSWORD"
  "THATMUSTNEVERBRBEUSED','','','');\n",
"ALTER TABLE user add File_priv enum('N','Y') COLLATE utf8_general_ci NOT NULL;\n",
"# Detect whether or not we had the Grant_priv column\n"
  "SET @hadGrantPriv:=0;\n",
"SELECT @hadGrantPriv:=1 FROM user WHERE Grant_priv LIKE '%';\n",
"ALTER TABLE user add Grant_priv enum('N','Y') COLLATE utf8_general_ci NOT NULL,add References_priv enum('N','Y') COLLATE"
  " utf8_general_ci NOT NULL,add Index_priv enum('N','Y') COLLATE utf8_general_ci NOT NULL,add Alter_priv enum('N','Y') "
  "COLLATE utf8_general_ci NOT NULL;\n",
"ALTER TABLE db add Grant_priv enum('N','Y') COLLATE utf8_general_ci NOT NULL,add References_priv enum('N','Y') COLLATE u"
  "tf8_general_ci NOT NULL,add Index_priv enum('N','Y') COLLATE utf8_general_ci NOT NULL,add Alter_priv enum('N','Y') CO"
  "LLATE utf8_general_ci NOT NULL;\n",
"# Fix privileges for old tables\n"
  "UPDATE user SET Grant_priv=File_priv,References_priv=Create_priv,Index_priv=Create_priv,Alter_priv=Create_priv WHERE "
  "@hadGrantPriv = 0;\n",
"UPDATE db SET References_priv=Create_priv,Index_priv=Create_priv,Alter_priv=Create_priv WHERE @hadGrantPriv = 0;\n",
"#\n"
  "# The second alter changes ssl_type to new 4.0.2 format\n"
  "# Adding columns needed by GRANT .. REQUIRE (openssl)\n"
  "ALTER TABLE user\n"
  "ADD ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci NOT NULL,\n"
  "ADD ssl_cipher BLOB NOT NULL,\n"
  "ADD x509_issuer BLOB NOT NULL,\n"
  "ADD x509_subject BLOB NOT NULL;\n",
"ALTER TABLE user MODIFY ssl_type enum('','ANY','X509', 'SPECIFIED') NOT NULL;\n",
"#\n"
  "# tables_priv\n"
  "#\n"
  "ALTER TABLE tables_priv\n"
  "  ADD KEY Grantor (Grantor);\n",
"ALTER TABLE tables_priv\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(32) NOT NULL default '',\n"
  "  MODIFY Table_name char(64) NOT NULL default '',\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;\n",
"ALTER TABLE tables_priv\n"
  "  MODIFY Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL,\n"
  "  MODIFY Table_priv set('Select','Insert','Update','Delete','Create',\n"
  "                        'Drop','Grant','References','Index','Alter',\n"
  "                        'Create View','Show view','Trigger')\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL,\n"
  "  COMMENT='Table privileges';\n",
"#\n"
  "# columns_priv\n"
  "#\n"
  "#\n"
  "# Name change of Type -> Column_priv from MySQL 3.22.12\n"
  "#\n"
  "ALTER TABLE columns_priv\n"
  "  CHANGE Type Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE columns_priv\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(32) NOT NULL default '',\n"
  "  MODIFY Table_name char(64) NOT NULL default '',\n"
  "  MODIFY Column_name char(64) NOT NULL default '',\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin,\n"
  "  COMMENT='Column privileges';\n",
"ALTER TABLE columns_priv\n"
  "  MODIFY Column_priv set('Select','Insert','Update','References')\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL;\n",
"#\n"
  "#  Add the new 'type' column to the func table.\n"
  "#\n"
  "ALTER TABLE func add type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL;\n",
"#\n"
  "#  Change the user and db tables to current format\n"
  "#\n"
  "# Detect whether we had Show_db_priv\n"
  "SET @hadShowDbPriv:=0;\n",
"SELECT @hadShowDbPriv:=1 FROM user WHERE Show_db_priv LIKE '%';\n",
"ALTER TABLE user\n"
  "ADD Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Alter_priv,\n"
  "ADD Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Show_db_priv,\n"
  "ADD Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Super_priv,\n"
  "ADD Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_tmp_table_priv,\n"
  "ADD Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv,\n"
  "ADD Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Execute_priv,\n"
  "ADD Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Repl_slave_priv;\n",
"# Convert privileges so that users have similar privileges as before\n"
  "UPDATE user SET Show_db_priv= Select_priv, Super_priv=Process_priv, Execute_priv=Process_priv, Create_tmp_table_priv="
  "'Y', Lock_tables_priv='Y', Repl_slave_priv=file_priv, Repl_client_priv=File_priv where user<>\"\" AND @hadShowDbPriv "
  "= 0;\n",
"#  Add fields that can be used to limit number of questions and connections\n"
  "#  for some users.\n"
  "ALTER TABLE user\n"
  "ADD max_questions int NOT NULL DEFAULT 0 AFTER x509_subject,\n"
  "ADD max_updates   int unsigned NOT NULL DEFAULT 0 AFTER max_questions,\n"
  "ADD max_connections int unsigned NOT NULL DEFAULT 0 AFTER max_updates;\n",
"#\n"
  "# Update proxies_priv definition.\n"
  "#\n"
  "ALTER TABLE proxies_priv MODIFY User char(32) binary DEFAULT '' NOT NULL;\n",
"ALTER TABLE proxies_priv MODIFY Proxied_user char(32) binary DEFAULT '' NOT NULL;\n",
"ALTER TABLE proxies_priv MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL, ENGINE=InnoDB;\n",
"ALTER TABLE proxies_priv MODIFY Proxied_host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE proxies_priv MODIFY Grantor varchar(288) DEFAULT '' NOT NULL;\n",
"#\n"
  "#  Add Create_tmp_table_priv and Lock_tables_priv to db\n"
  "#\n"
  "ALTER TABLE db\n"
  "ADD Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "ADD Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"alter table user change max_questions max_questions int unsigned DEFAULT 0  NOT NULL;\n",
"alter table db comment='Database privileges';\n",
"alter table user comment='Users and global privileges';\n",
"alter table func comment='User defined functions';\n",
"# Convert all tables to UTF-8 with binary collation\n"
  "# and reset all char columns to correct width\n"
  "ALTER TABLE user\n"
  "  MODIFY User char(32) NOT NULL default '',\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;\n",
"ALTER TABLE user\n"
  "  MODIFY Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE db\n"
  "  MODIFY Db char(64) NOT NULL default '',\n"
  "  MODIFY User char(32) NOT NULL default '',\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;\n",
"ALTER TABLE db\n"
  "  MODIFY  Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL,\n"
  "  MODIFY  Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE func CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;\n",
"ALTER TABLE func\n"
  "  MODIFY type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL;\n",
"#\n"
  "# Modify log tables.\n"
  "#\n"
  "SET @old_log_state = @@global.general_log;\n",
"SET GLOBAL general_log = 'OFF';\n",
"SET @old_sql_require_primary_key = @@session.sql_require_primary_key;\n",
"SET @@session.sql_require_primary_key = 0;\n",
"ALTER TABLE general_log\n"
  "  MODIFY event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),\n"
  "  MODIFY user_host MEDIUMTEXT NOT NULL,\n"
  "  MODIFY thread_id INTEGER NOT NULL,\n"
  "  MODIFY server_id INTEGER UNSIGNED NOT NULL,\n"
  "  MODIFY command_type VARCHAR(64) NOT NULL,\n"
  "  MODIFY argument MEDIUMBLOB NOT NULL;\n",
"ALTER TABLE general_log\n"
  "  MODIFY thread_id BIGINT UNSIGNED NOT NULL;\n",
"SET GLOBAL general_log = @old_log_state;\n",
"SET @old_log_state = @@global.slow_query_log;\n",
"SET GLOBAL slow_query_log = 'OFF';\n",
"ALTER TABLE slow_log\n"
  "  MODIFY start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),\n"
  "  MODIFY user_host MEDIUMTEXT NOT NULL,\n"
  "  MODIFY query_time TIME(6) NOT NULL,\n"
  "  MODIFY lock_time TIME(6) NOT NULL,\n"
  "  MODIFY rows_sent INTEGER NOT NULL,\n"
  "  MODIFY rows_examined INTEGER NOT NULL,\n"
  "  MODIFY db VARCHAR(512) NOT NULL,\n"
  "  MODIFY last_insert_id INTEGER NOT NULL,\n"
  "  MODIFY insert_id INTEGER NOT NULL,\n"
  "  MODIFY server_id INTEGER UNSIGNED NOT NULL,\n"
  "  MODIFY sql_text MEDIUMBLOB NOT NULL;\n",
"ALTER TABLE slow_log\n"
  "  ADD COLUMN thread_id INTEGER NOT NULL AFTER sql_text;\n",
"ALTER TABLE slow_log\n"
  "  MODIFY thread_id BIGINT UNSIGNED NOT NULL;\n",
"SET GLOBAL slow_query_log = @old_log_state;\n",
"SET @@session.sql_require_primary_key = @old_sql_require_primary_key;\n",
"ALTER TABLE plugin\n"
  "  MODIFY name varchar(64) DEFAULT '' NOT NULL,\n"
  "  MODIFY dl varchar(128) DEFAULT '' NOT NULL,\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;\n",
"#\n"
  "# Detect whether we had Create_view_priv\n"
  "#\n"
  "SET @hadCreateViewPriv:=0;\n",
"SELECT @hadCreateViewPriv:=1 FROM user WHERE Create_view_priv LIKE '%';\n",
"#\n"
  "# Create VIEWs privileges (v5.0)\n"
  "#\n"
  "ALTER TABLE db ADD Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv"
  ";\n",
"ALTER TABLE db MODIFY Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Lock_tables_priv"
  ";\n",
"ALTER TABLE user ADD Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Repl_client_priv;\n",
"ALTER TABLE user MODIFY Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Repl_client_pr"
  "iv;\n",
"#\n"
  "# Show VIEWs privileges (v5.0)\n"
  "#\n"
  "ALTER TABLE db ADD Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE db MODIFY Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE user ADD Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv;\n",
"ALTER TABLE user MODIFY Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_view_priv"
  ";\n",
"#\n"
  "# Assign create/show view privileges to people who have create provileges\n"
  "#\n"
  "UPDATE user SET Create_view_priv=Create_priv, Show_view_priv=Create_priv where user<>\"\" AND @hadCreateViewPriv = 0;\n",
"#\n"
  "#\n"
  "#\n"
  "SET @hadCreateRoutinePriv:=0;\n",
"SELECT @hadCreateRoutinePriv:=1 FROM user WHERE Create_routine_priv LIKE '%';\n",
"#\n"
  "# Create PROCEDUREs privileges (v5.0)\n"
  "#\n"
  "ALTER TABLE db ADD Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_pri"
  "v;\n",
"ALTER TABLE db MODIFY Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_pri"
  "v;\n",
"ALTER TABLE user ADD Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_priv"
  ";\n",
"ALTER TABLE user MODIFY Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Show_view_p"
  "riv;\n",
"#\n"
  "# Alter PROCEDUREs privileges (v5.0)\n"
  "#\n"
  "ALTER TABLE db ADD Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine"
  "_priv;\n",
"ALTER TABLE db MODIFY Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine"
  "_priv;\n",
"ALTER TABLE user ADD Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_routine_"
  "priv;\n",
"ALTER TABLE user MODIFY Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_routi"
  "ne_priv;\n",
"ALTER TABLE db ADD Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"ALTER TABLE db MODIFY Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_priv;\n",
"#\n"
  "# Assign create/alter routine privileges to people who have create privileges\n"
  "#\n"
  "UPDATE user SET Create_routine_priv=Create_priv, Alter_routine_priv=Alter_priv where user<>\"\" AND @hadCreateRoutine"
  "Priv = 0;\n",
"UPDATE db SET Create_routine_priv=Create_priv, Alter_routine_priv=Alter_priv, Execute_priv=Select_priv where user<>\"\" "
  "AND @hadCreateRoutinePriv = 0;\n",
"#\n"
  "# Add max_user_connections resource limit\n"
  "#\n"
  "ALTER TABLE user ADD max_user_connections int unsigned DEFAULT '0' NOT NULL AFTER max_connections;\n",
"#\n"
  "# user.Create_user_priv\n"
  "#\n"
  "SET @hadCreateUserPriv:=0;\n",
"SELECT @hadCreateUserPriv:=1 FROM user WHERE Create_user_priv LIKE '%';\n",
"ALTER TABLE user ADD Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_pri"
  "v;\n",
"ALTER TABLE user MODIFY Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Alter_routine_"
  "priv;\n",
"UPDATE user LEFT JOIN db USING (Host,User) SET Create_user_priv='Y'\n"
  "  WHERE @hadCreateUserPriv = 0 AND\n"
  "        (user.Grant_priv = 'Y' OR db.Grant_priv = 'Y');\n",
"#\n"
  "# procs_priv\n"
  "#\n"
  "ALTER TABLE procs_priv\n"
  "  MODIFY User char(32) NOT NULL default '',\n"
  "  CONVERT TO CHARACTER SET utf8 COLLATE utf8_bin;\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Proc_priv set('Execute','Alter Routine','Grant')\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Routine_name char(64)\n"
  "    COLLATE utf8_general_ci DEFAULT '' NOT NULL;\n",
"ALTER TABLE procs_priv\n"
  "  ADD Routine_type enum('FUNCTION','PROCEDURE')\n"
  "    NOT NULL AFTER Routine_name;\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP AFTER Proc_priv;\n",
"#\n"
  "# EVENT privilege\n"
  "#\n"
  "SET @hadEventPriv := 0;\n",
"SELECT @hadEventPriv :=1 FROM user WHERE Event_priv LIKE '%';\n",
"ALTER TABLE user add Event_priv enum('N','Y') character set utf8 DEFAULT 'N' NOT NULL AFTER Create_user_priv;\n",
"ALTER TABLE user MODIFY Event_priv enum('N','Y') character set utf8 DEFAULT 'N' NOT NULL AFTER Create_user_priv;\n",
"UPDATE user SET Event_priv=Super_priv WHERE @hadEventPriv = 0;\n",
"ALTER TABLE db add Event_priv enum('N','Y') character set utf8 DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE db MODIFY Event_priv enum('N','Y') character set utf8 DEFAULT 'N' NOT NULL;\n",
"#\n"
  "# TRIGGER privilege\n"
  "#\n"
  "SET @hadTriggerPriv := 0;\n",
"SELECT @hadTriggerPriv :=1 FROM user WHERE Trigger_priv LIKE '%';\n",
"ALTER TABLE user ADD Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Event_priv;\n",
"ALTER TABLE user MODIFY Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Event_priv;\n",
"ALTER TABLE db ADD Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"ALTER TABLE db MODIFY Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET Trigger_priv=Super_priv WHERE @hadTriggerPriv = 0;\n",
"#\n"
  "# user.Create_tablespace_priv\n"
  "#\n"
  "SET @hadCreateTablespacePriv := 0;\n",
"SELECT @hadCreateTablespacePriv :=1 FROM user WHERE Create_tablespace_priv LIKE '%';\n",
"ALTER TABLE user ADD Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Trigger_pri"
  "v;\n",
"ALTER TABLE user MODIFY Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Trigger_"
  "priv;\n",
"UPDATE user SET Create_tablespace_priv = Super_priv WHERE @hadCreateTablespacePriv = 0;\n",
"--\n"
  "-- Unlike 'performance_schema', the 'mysql' database is reserved already,\n"
  "-- so no user procedure is supposed to be there.\n"
  "--\n"
  "-- NOTE: until upgrade is finished, stored routines are not available, because\n"
  "-- system tables might be not usable.\n"
  "--\n"
  "SET @global_automatic_sp_privileges = @@GLOBAL.automatic_sp_privileges;\n",
"SET GLOBAL automatic_sp_privileges = FALSE;\n",
"drop procedure if exists mysql.die;\n",
"create procedure mysql.die() signal sqlstate 'HY000' set message_text='Unexpected content found in the performance_schem"
  "a database.';\n",
"--\n"
  "-- For broken upgrades, SIGNAL the error\n"
  "--\n"
  "SET @cmd=\"call mysql.die()\";\n",
"SET @str = IF(@broken_pfs > 0, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"drop procedure mysql.die;\n",
"SET GLOBAL automatic_sp_privileges = @global_automatic_sp_privileges;\n",
"ALTER TABLE user ADD plugin char(64) DEFAULT 'caching_sha2_password' NOT NULL,  ADD authentication_string TEXT;\n",
"ALTER TABLE user MODIFY plugin char(64) DEFAULT 'caching_sha2_password' NOT NULL;\n",
"UPDATE user SET plugin=IF((length(password) = 41), 'mysql_native_password', '') WHERE plugin = '';\n",
"UPDATE user SET plugin=IF((length(password) = 0), 'caching_sha2_password', '') WHERE plugin = '';\n",
"ALTER TABLE user MODIFY authentication_string TEXT;\n",
"-- establish if the field is already there.\n"
  "SET @hadPasswordExpired:=0;\n",
"SELECT @hadPasswordExpired:=1 FROM user WHERE password_expired LIKE '%';\n",
"ALTER TABLE user ADD password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET password_expired = 'N' WHERE @hadPasswordExpired=0;\n",
"-- need to compensate for the ALTER TABLE user .. CONVERT TO CHARACTER SET above\n"
  "ALTER TABLE user MODIFY password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"-- Need to pre-fill mysql.proxies_priv with access for root even when upgrading from\n"
  "-- older versions\n"
  "SET @cmd=\"INSERT INTO proxies_priv VALUES ('localhost', 'root', '', '', TRUE, '', now())\";\n",
"SET @str = IF(@had_proxies_priv_table = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Checking for any duplicate hostname and username combination are exists.\n"
  "-- If exits we will throw error.\n"
  "-- We also need to avoid accessing privilege tables.\n"
  "SET @global_automatic_sp_privileges = @@GLOBAL.automatic_sp_privileges;\n",
"SET GLOBAL automatic_sp_privileges = FALSE;\n",
"DROP PROCEDURE IF EXISTS mysql.warn_duplicate_host_names;\n",
"CREATE PROCEDURE mysql.warn_duplicate_host_names() SIGNAL SQLSTATE '45000'  SET MESSAGE_TEXT = 'Multiple accounts exist "
  "for @user_name, @host_name that differ only in Host lettercase; remove all except one of them';\n",
"SET @cmd='call mysql.warn_duplicate_host_names()';\n",
"SET @duplicate_hosts=(SELECT count(*) FROM mysql.user GROUP BY user, lower(host) HAVING count(*) > 1 LIMIT 1);\n",
"SET @str=IF(@duplicate_hosts > 1, @cmd, 'SET @dummy=0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"-- Get warnings (if any)\n"
  "SHOW WARNINGS;\n",
"DROP PREPARE stmt;\n",
"DROP PROCEDURE mysql.warn_duplicate_host_names;\n",
"SET GLOBAL automatic_sp_privileges = @global_automatic_sp_privileges;\n",
"# Convering the host name to lower case for existing users\n"
  "UPDATE user SET host=LOWER( host ) WHERE LOWER( host ) <> host;\n",
"#\n"
  "# Alter mysql.component only if it exists already.\n"
  "#\n"
  "SET @have_component= (select count(*) from information_schema.tables where table_schema='mysql' and table_name='compo"
  "nent');\n",
"# Change row format to DYNAMIC\n"
  "SET @cmd=\"ALTER TABLE component ROW_FORMAT=DYNAMIC\";\n",
"SET @str = IF(@have_component = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"#\n"
  "# Alter mysql.ndb_binlog_index only if it exists already.\n"
  "#\n"
  "SET @have_ndb_binlog_index= (select count(*) from information_schema.tables where table_schema='mysql' and table_name"
  "='ndb_binlog_index');\n",
"# Change type from BIGINT to INT and row format to DYNAMIC\n"
  "SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  MODIFY inserts INT UNSIGNED NOT NULL,\n"
  "  MODIFY updates INT UNSIGNED NOT NULL,\n"
  "  MODIFY deletes INT UNSIGNED NOT NULL,\n"
  "  MODIFY schemaops INT UNSIGNED NOT NULL, ROW_FORMAT=DYNAMIC\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"# Add new columns\n"
  "SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  ADD orig_server_id INT UNSIGNED NOT NULL,\n"
  "  ADD orig_epoch BIGINT UNSIGNED NOT NULL,\n"
  "  ADD gci INT UNSIGNED NOT NULL\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"# New primary key\n"
  "SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  DROP PRIMARY KEY,\n"
  "  ADD PRIMARY KEY(epoch, orig_server_id, orig_epoch)\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Check for accounts with old pre-4.1 passwords and issue a warning\n"
  "--\n"
  "-- SCRAMBLED_PASSWORD_CHAR_LENGTH_323 = 16\n"
  "SET @deprecated_pwds=(SELECT COUNT(*) FROM mysql.user WHERE LENGTH(password) = 16);\n",
"-- signal the deprecation error\n"
  "SET @global_automatic_sp_privileges = @@GLOBAL.automatic_sp_privileges;\n",
"SET GLOBAL automatic_sp_privileges = FALSE;\n",
"DROP PROCEDURE IF EXISTS mysql.warn_pre41_pwd;\n",
"CREATE PROCEDURE mysql.warn_pre41_pwd() SIGNAL SQLSTATE '01000' SET MESSAGE_TEXT='Pre-4.1 password hash found. It is dep"
  "recated and will be removed in a future release. Please upgrade it to a new format.';\n",
"SET @cmd='call mysql.warn_pre41_pwd()';\n",
"SET @str=IF(@deprecated_pwds > 0, @cmd, 'SET @dummy=0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"-- Get warnings (if any)\n"
  "SHOW WARNINGS;\n",
"DROP PREPARE stmt;\n",
"DROP PROCEDURE mysql.warn_pre41_pwd;\n",
"SET GLOBAL automatic_sp_privileges = @global_automatic_sp_privileges;\n",
"--\n"
  "-- Add timestamp and expiry columns\n"
  "--\n"
  "ALTER TABLE user ADD password_last_changed timestamp NULL;\n",
"UPDATE user SET password_last_changed = CURRENT_TIMESTAMP WHERE plugin in ('caching_sha2_password','mysql_native_passwor"
  "d','sha256_password') and password_last_changed is NULL;\n",
"ALTER TABLE user ADD password_lifetime smallint unsigned NULL;\n",
"--\n"
  "-- Add account_locked column\n"
  "--\n"
  "SET @hadAccountLocked:=0;\n",
"SELECT @hadAccountLocked:=1 FROM user WHERE account_locked LIKE '%';\n",
"ALTER TABLE user ADD account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET account_locked = 'N' WHERE @hadAccountLocked=0;\n",
"-- need to compensate for the ALTER TABLE user .. CONVERT TO CHARACTER SET above\n"
  "ALTER TABLE user MODIFY account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
"UPDATE user SET account_locked ='Y' WHERE host = 'localhost' AND user = 'mysql.infoschema';\n",
"--\n"
  "-- Drop password column\n"
  "--\n"
  "SET @have_password= (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = 'mysql'\n"
  "                    AND TABLE_NAME='user'\n"
  "                    AND column_name='password');\n",
"SET @str=IF(@have_password <> 0, \"UPDATE user SET authentication_string = password where LENGTH(password) > 0 and plugi"
  "n = 'mysql_native_password'\", \"SET @dummy = 0\");\n",
"# We have already put mysql_native_password as plugin value in cases where length(PASSWORD) is either 0 or 41.\n"
  "PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @str=IF(@have_password <> 0, \"ALTER TABLE user DROP password\", \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Add the privilege XA_RECOVER_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige XA_RECOVER_ADMIN.\n"
  "SET @hadXARecoverAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'XA_RECOVER_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'XA_RECOVER_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadXARecoverAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege CLONE_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilege CLONE_ADMIN.\n"
  "SET @hadCloneAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'CLONE_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'CLONE_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadCloneAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege INNODB_REDO_LOG_ENABLE for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilege INNODB_REDO_LOG_ENABLE.\n"
  "SET @hadRedoLogEnablePriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'INNODB_REDO_LOG_ENABLE');\n",
"INSERT INTO global_grants SELECT user, host, 'INNODB_REDO_LOG_ENABLE', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadRedoLogEnablePriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege BACKUP_ADMIN for every user who has the privilege RELOAD\n"
  "-- provided that there isn't a user who already has the privilege BACKUP_ADMIN.\n"
  "SET @hadBackupAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'BACKUP_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'BACKUP_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadBackupAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege INNODB_REDO_LOG_ARCHIVE for every user who has the privilege BACKUP_ADMIN\n"
  "-- provided that there isn't a user who already has the privilege INNODB_REDO_LOG_ARCHIVE.\n"
  "SET @hadInnodbRedoLogArchivePriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'INNODB_REDO_LOG_ARCHIVE');\n",
"INSERT INTO global_grants SELECT user, host, 'INNODB_REDO_LOG_ARCHIVE', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadInnodbRedoLogArchivePriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege RESOURCE_GROUP_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilege RESOURCE_GROUP_ADMIN.\n"
  "SET @hadResourceGroupAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'RESOURCE_GROUP_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'RESOURCE_GROUP_ADMIN',\n"
  "IF(grant_priv = 'Y', 'Y', 'N') FROM mysql.user WHERE super_priv = 'Y' AND @hadResourceGroupAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SERVICE_CONNECTION_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilege SERVICE_CONNECTION_ADMIN.\n"
  "SET @hadServiceConnectionAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SERVICE_CONNECTION_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'SERVICE_CONNECTION_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadServiceConnectionAdminPriv = 0;\n",
"-- Add the privilege APPLICATION_PASSWORD_ADMIN for every user who has the\n"
  "-- privilege CREATE USER provided that there isn't a user who already has\n"
  "-- privilege APPLICATION_PASSWORD_ADMIN\n"
  "SET @hadApplicationPasswordAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'APPLICATION_PASSWORD_ADMIN')"
  ";\n",
"INSERT INTO global_grants SELECT user, host, 'APPLICATION_PASSWORD_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Create_user_priv = 'Y' AND @hadApplicationPasswordAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege AUDIT_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige AUDIT_ADMIN.\n"
  "SET @hadAuditAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'AUDIT_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'AUDIT_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadAuditAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege BINLOG_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige BINLOG_ADMIN.\n"
  "SET @hadBinLogAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'BINLOG_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'BINLOG_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadBinLogAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege BINLOG_ENCRYPTION_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige BINLOG_ENCRYPTION_ADMIN.\n"
  "SET @hadBinLogEncryptionAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'BINLOG_ENCRYPTION_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'BINLOG_ENCRYPTION_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadBinLogEncryptionAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege CONNECTION_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige CONNECTION_ADMIN.\n"
  "SET @hadConnectionAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'CONNECTION_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'CONNECTION_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadConnectionAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege ENCRYPTION_KEY_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige ENCRYPTION_KEY_ADMIN.\n"
  "SET @hadEncryptionKeyAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'ENCRYPTION_KEY_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'ENCRYPTION_KEY_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadEncryptionKeyAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege GROUP_REPLICATION_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige GROUP_REPLICATION_ADMIN.\n"
  "SET @hadGroupReplicationAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'GROUP_REPLICATION_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'GROUP_REPLICATION_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadGroupReplicationAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege PERSIST_RO_VARIABLES_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige PERSIST_RO_VARIABLES_ADMIN.\n"
  "SET @hadPersistRoVariablesAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'PERSIST_RO_VARIABLES_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'PERSIST_RO_VARIABLES_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadPersistRoVariablesAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege REPLICATION_SLAVE_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige REPLICATION_SLAVE_ADMIN.\n"
  "SET @hadReplicationSlaveAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'REPLICATION_SLAVE_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'REPLICATION_SLAVE_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadReplicationSlaveAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege RESOURCE_GROUP_USER for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige RESOURCE_GROUP_USER.\n"
  "SET @hadResourceGroupUserPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'RESOURCE_GROUP_USER');\n",
"INSERT INTO global_grants SELECT user, host, 'RESOURCE_GROUP_USER', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadResourceGroupUserPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege ROLE_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige ROLE_ADMIN.\n"
  "SET @hadRoleAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'ROLE_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'ROLE_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadRoleAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SESSION_VARIABLES_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige SESSION_VARIABLES_ADMIN.\n"
  "SET @hadSessionVariablesAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SESSION_VARIABLES_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'SESSION_VARIABLES_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadSessionVariablesAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SET_USER_ID for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige SET_USER_ID.\n"
  "SET @hadSetUserIdPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SET_USER_ID');\n",
"INSERT INTO global_grants SELECT user, host, 'SET_USER_ID', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadSetUserIdPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SYSTEM_VARIABLES_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige SYSTEM_VARIABLES_ADMIN.\n"
  "SET @hadSystemVariablesAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SYSTEM_VARIABLES_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'SYSTEM_VARIABLES_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadSystemVariablesAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SYSTEM_USER for every user who has privilege SET_USER_ID privilege\n"
  "SET @hadSystemUserPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SYSTEM_USER');\n",
"INSERT INTO global_grants SELECT user, host, 'SYSTEM_USER',\n"
  "IF (WITH_GRANT_OPTION = 'Y', 'Y', 'N') FROM global_grants WHERE priv = 'SET_USER_ID' AND @hadSystemUserPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SYSTEM_USER for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilege SYSTEM_USER\n"
  "SET @hadSystemUserPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SYSTEM_USER');\n",
"INSERT INTO global_grants SELECT user, host, 'SYSTEM_USER', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadSystemUserPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege TABLE_ENCRYPTION_ADMIN for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige TABLE_ENCRYPTION_ADMIN.\n"
  "SET @hadTableEncryptionAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'TABLE_ENCRYPTION_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'TABLE_ENCRYPTION_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadTableEncryptionAdminPriv = 0 AND user != 'mysql.session';\n",
"-- The TABLE_ENCRYPTION_ADMIN privilege was previously granted to 'mysql.session'\n"
  "-- during upgrade. However, this user should not have this privilege, so we need\n"
  "-- to explicitly revoke it.\n"
  "DELETE FROM global_grants WHERE user = 'mysql.session' AND host = 'localhost' AND priv = 'TABLE_ENCRYPTION_ADMIN';\n",
"COMMIT;\n",
"-- Add the privilege REPLICATION_APPLIER for every user who has the privilege SUPER\n"
  "-- provided that there isn't a user who already has the privilige REPLICATION_APPLIER.\n"
  "SET @hadReplicationApplierPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'REPLICATION_APPLIER');\n",
"INSERT INTO global_grants SELECT user, host, 'REPLICATION_APPLIER', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE super_priv = 'Y' AND @hadReplicationApplierPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege SHOW_ROUTINE for every user who has global SELECT privilege\n"
  "-- provided that there isn't a user who already has the privilege SHOW_ROUTINE\n"
  "SET @hadShowRoutinePriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'SHOW_ROUTINE');\n",
"INSERT INTO global_grants SELECT user, host, 'SHOW_ROUTINE', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE select_priv = 'Y' AND @hadShowRoutinePriv = 0 AND user NOT IN ('mysql.infoschema','mysql.sessio"
  "n','mysql.sys');\n",
"COMMIT;\n",
"-- Add the privilege AUTHENTICATION_POLICY_ADMIN for every user who has the SYSTEM_VARIABLES_ADMIN privilege\n"
  "-- provided that there isn't a user who already has the privilege AUTHENTICATION_POLICY_ADMIN.\n"
  "SET @hadAuthenticationPolicyAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'AUTHENTICATION_POLICY_ADMIN"
  "');\n",
"INSERT INTO global_grants SELECT mu.user, mu.host, 'AUTHENTICATION_POLICY_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user mu, global_grants gg WHERE mu.user = gg.user AND gg.priv = 'SYSTEM_VARIABLES_ADMIN' AND @hadAuthentic"
  "ationPolicyAdminPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege PASSWORDLESS_USER_ADMIN for every user who has the privilege CREATE USER\n"
  "-- provided that there isn't a user who already has the privilege PASSWORDLESS_USER_ADMIN.\n"
  "SET @hadPasswordlessUserAdminPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'PASSWORDLESS_USER_ADMIN');\n",
"INSERT INTO global_grants SELECT user, host, 'PASSWORDLESS_USER_ADMIN', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Create_user_priv = 'Y' AND @hadPasswordlessUserAdminPriv = 0;\n",
"COMMIT;\n",
"# Activate the new, possible modified privilege tables\n"
  "# This should not be needed, but gives us some extra testing that the above\n"
  "# changes was correct\n"
  "ALTER TABLE slave_master_info ADD Ssl_crl TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Cer"
  "tificate Revocation List (CRL)';\n",
"ALTER TABLE slave_master_info ADD Ssl_crlpath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certif"
  "icate Revocation List (CRL) files';\n",
"ALTER TABLE slave_master_info STATS_PERSISTENT=0;\n",
"ALTER TABLE slave_worker_info STATS_PERSISTENT=0;\n",
"ALTER TABLE slave_relay_log_info STATS_PERSISTENT=0;\n",
"ALTER TABLE replication_asynchronous_connection_failover STATS_PERSISTENT=0;\n",
"ALTER TABLE replication_asynchronous_connection_failover_managed STATS_PERSISTENT=0;\n",
"ALTER TABLE replication_group_member_actions STATS_PERSISTENT=0;\n",
"ALTER TABLE gtid_executed STATS_PERSISTENT=0;\n",
"#\n"
  "# From 5.7 onwards, all slave info tables have Channel_Name as a column.\n"
  "# This column is needed  for multi-source replication\n"
  "#\n"
  "ALTER TABLE slave_master_info\n"
  "  ADD Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the sla"
  "ve is connected to a source. Used in Multisource Replication',\n"
  "  DROP PRIMARY KEY,\n"
  "  ADD PRIMARY KEY(Channel_name);\n",
"ALTER TABLE slave_relay_log_info\n"
  "  ADD Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the sla"
  "ve is connected to a source. Used in Multisource Replication',\n"
  "  DROP PRIMARY KEY,\n"
  "  ADD PRIMARY KEY(Channel_name);\n",
"ALTER TABLE slave_worker_info\n"
  "  ADD Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the sla"
  "ve is connected to a source. Used in Multisource Replication',\n"
  "  DROP PRIMARY KEY,\n"
  "  ADD PRIMARY KEY(Channel_name, Id);\n",
"# The Tls_version field at slave_master_info should be added after the Channel_name field\n"
  "ALTER TABLE slave_master_info ADD Tls_version TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version';\n",
"# If the order of columns Channel_name and Tls_version is wrong, this will correct the order\n"
  "# in slave_master_info table.\n"
  "ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Tls_version TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version'\n"
  "  AFTER Channel_name;\n",
"# The Public_key_path field at slave_master_info should be added after the Tls_version field\n"
  "ALTER TABLE slave_master_info ADD Public_key_path TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file containi"
  "ng public key of master server.';\n",
"# The Get_public_key field at slave_master_info should be added after the slave_master_info field\n"
  "ALTER TABLE slave_master_info ADD Get_public_key BOOLEAN NOT NULL COMMENT 'Preference to get public key from master.'"
  ";\n",
"ALTER TABLE slave_master_info ADD Network_namespace TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Network namespace "
  "used for communication with the master server.';\n",
"ALTER TABLE slave_master_info ADD Master_compression_algorithm CHAR(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COM"
  "MENT 'Compression algorithm supported for data transfer between master and slave.',\n"
  "                              ADD Master_zstd_compression_level INTEGER UNSIGNED NOT NULL COMMENT 'Compression level "
  "associated with zstd compression algorithm.';\n",
"ALTER TABLE slave_master_info ADD Tls_ciphersuites TEXT CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT 'Cipher"
  "suites used for TLS 1.3 communication with the master server.';\n",
"ALTER TABLE slave_master_info ADD Source_connection_auto_failover BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates whet"
  "her the channel connection failover is enabled.';\n",
"ALTER TABLE slave_master_info ADD Gtid_only BOOLEAN NOT NULL DEFAULT FALSE COMMENT 'Indicates if this channel only uses "
  "GTIDs and does not persist positions.';\n",
"-- This would add the Managed_name column to\n"
  "-- replication_asynchronous_connection_failover table on upgrade from older\n"
  "-- mysql version.\n"
  "ALTER TABLE replication_asynchronous_connection_failover\n"
  "  ADD Managed_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'The name of the g"
  "roup which this server belongs to.',\n"
  "  DROP PRIMARY KEY,\n"
  "  ADD PRIMARY KEY(Channel_name, Host, Port, Network_namespace, Managed_name),\n"
  "  ADD KEY(Channel_name, Managed_name);\n",
"# If the order of column Public_key_path, Get_public_key is wrong, this will correct the order in\n"
  "# slave_master_info table.\n"
  "ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Public_key_path TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file containing public key of m"
  "aster server.'\n"
  "  AFTER Tls_version;\n",
"ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Get_public_key BOOLEAN NOT NULL COMMENT 'Preference to get public key from master.'\n"
  "  AFTER Public_key_path;\n",
"ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Network_namespace TEXT CHARACTER SET utf8 COLLATE utf8_bin\n"
  "  COMMENT 'Network namespace used for communication with the master server.'\n"
  "  AFTER Get_public_key;\n",
"ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Tls_ciphersuites TEXT CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL\n"
  "  COMMENT 'Ciphersuites used for TLS 1.3 communication with the master server.'\n"
  "  AFTER Master_zstd_compression_level;\n",
"ALTER TABLE slave_master_info\n"
  "  MODIFY COLUMN Source_connection_auto_failover BOOLEAN NOT NULL DEFAULT FALSE\n"
  "  COMMENT 'Indicates whether the channel connection failover is enabled.'\n"
  "  AFTER Tls_ciphersuites;\n",
"-- This would position the Managed_name column after Weight column.\n"
  "ALTER TABLE replication_asynchronous_connection_failover\n"
  "  MODIFY COLUMN Managed_name CHAR(64) CHARACTER SET utf8\n"
  "  COLLATE utf8_general_ci NOT NULL DEFAULT ''\n"
  "  COMMENT 'The name of the group which this server belongs to.'\n"
  "  AFTER Weight;\n",
"# Columns added to keep information about the replication applier thread\n"
  "# privilege context user\n"
  "ALTER TABLE slave_relay_log_info ADD Privilege_checks_username CHAR(32) COLLATE utf8_bin DEFAULT NULL COMMENT 'Userna"
  "me part of PRIVILEGE_CHECKS_USER.' AFTER Channel_name,\n"
  "                                 ADD Privilege_checks_hostname CHAR(255) CHARACTER SET ascii COLLATE ascii_general_ci"
  " DEFAULT NULL COMMENT 'Hostname part of PRIVILEGE_CHECKS_USER.' AFTER Privilege_checks_username;\n",
"# Columns added to keep information about REQUIRE_ROW_FORMAT replication field\n"
  "ALTER TABLE slave_relay_log_info ADD Require_row_format BOOLEAN NOT NULL COMMENT 'Indicates whether the channel shall"
  " only accept row based events.' AFTER Privilege_checks_hostname;\n",
"ALTER TABLE slave_relay_log_info MODIFY Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the"
  " current relay log file.',\n"
  "                                 MODIFY Relay_log_pos BIGINT UNSIGNED COMMENT 'The relay log position of the last exe"
  "cuted event.',\n"
  "                                 MODIFY Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of"
  " the master binary log file from which the events in the relay log file were read.',\n"
  "                                 MODIFY Master_log_pos BIGINT UNSIGNED COMMENT 'The master log position of the last e"
  "xecuted event.',\n"
  "                                 MODIFY Sql_delay INTEGER COMMENT 'The number of seconds that the slave must lag behi"
  "nd the master.',\n"
  "                                 MODIFY Number_of_workers INTEGER UNSIGNED,\n"
  "                                 MODIFY Id INTEGER UNSIGNED COMMENT 'Internal Id that uniquely identifies this record"
  ".';\n",
"# Columns added to keep information about REQUIRE_TABLE_PRIMARY_KEY_CHECK replication field\n"
  "ALTER TABLE slave_relay_log_info ADD Require_table_primary_key_check ENUM('STREAM','ON','OFF') NOT NULL DEFAULT 'STRE"
  "AM' COMMENT 'Indicates what is the channel policy regarding tables having primary keys on create and alter table quer"
  "ies' AFTER Require_row_format;\n",
"# Columns added to keep information about ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_TYPE replication field\n"
  "ALTER TABLE slave_relay_log_info ADD Assign_gtids_to_anonymous_transactions_type ENUM('OFF', 'LOCAL', 'UUID')  NOT NU"
  "LL DEFAULT 'OFF' COMMENT 'Indicates whether the channel will generate a new GTID for anonymous transactions. OFF mean"
  "s that anonymous transactions will remain anonymous. LOCAL means that anonymous transactions will be assigned a newly"
  " generated GTID based on server_uuid. UUID indicates that anonymous transactions will be assigned a newly generated G"
  "TID based on Assign_gtids_to_anonymous_transactions_value' AFTER Require_table_primary_key_check;\n",
"# Columns added to keep information about ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_VALUE replication field\n"
  "ALTER TABLE slave_relay_log_info ADD Assign_gtids_to_anonymous_transactions_value TEXT CHARACTER SET utf8 COLLATE utf"
  "8_bin COMMENT 'Indicates the UUID used while generating GTIDs for anonymous transactions' AFTER Assign_gtids_to_anony"
  "mous_transactions_type;\n",
"#\n"
  "# Drop legacy NDB distributed privileges function & procedures\n"
  "#\n"
  "DROP function  IF EXISTS mysql.mysql_cluster_privileges_are_distributed;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_backup_privileges;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_move_grant_tables;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_restore_local_privileges;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_restore_privileges;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_restore_privileges_from_local;\n",
"DROP procedure IF EXISTS mysql.mysql_cluster_move_privileges;\n",
"#\n"
  "# Alter mysql.ndb_binlog_index only if it exists already.\n"
  "#\n"
  "SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  ADD COLUMN next_position BIGINT UNSIGNED NOT NULL\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  ADD COLUMN next_file VARCHAR(255) NOT NULL\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE ndb_binlog_index\n"
  "  ENGINE=InnoDB STATS_PERSISTENT=0\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Check for non-empty host table and issue a warning\n"
  "--\n"
  "SET @global_automatic_sp_privileges = @@GLOBAL.automatic_sp_privileges;\n",
"SET GLOBAL automatic_sp_privileges = FALSE;\n",
"DROP PROCEDURE IF EXISTS mysql.warn_host_table_nonempty;\n",
"CREATE PROCEDURE mysql.warn_host_table_nonempty() SIGNAL SQLSTATE '01000' SET MESSAGE_TEXT='Table mysql.host is not empt"
  "y. It is deprecated and will be removed in a future release.';\n",
"SET @cmd='call mysql.warn_host_table_nonempty()';\n",
"SET @have_host_table=0;\n",
"SET @host_table_nonempty=0;\n",
"SET @have_host_table=(SELECT COUNT(*) FROM information_schema.tables WHERE table_name LIKE 'host' AND table_schema LIKE "
  "'mysql' AND table_type LIKE 'BASE TABLE');\n",
"SET @host_table_nonempty_str=IF(@have_host_table > 0, 'SET @host_table_nonempty=(SELECT COUNT(*) FROM mysql.host)', 'SET"
  " @dummy=0');\n",
"PREPARE stmt FROM @host_table_nonempty_str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @str=IF(@host_table_nonempty > 0, @cmd, 'SET @dummy=0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"-- Get warnings (if any)\n"
  "SHOW WARNINGS;\n",
"DROP PREPARE stmt;\n",
"DROP PROCEDURE mysql.warn_host_table_nonempty;\n",
"SET GLOBAL automatic_sp_privileges = @global_automatic_sp_privileges;\n",
"--\n"
  "-- Upgrade help tables\n"
  "--\n"
  "ALTER TABLE help_category MODIFY url TEXT NOT NULL;\n",
"ALTER TABLE help_topic MODIFY url TEXT NOT NULL;\n",
"--\n"
  "-- Upgrade help tables character set to utf8\n"
  "--\n"
  "ALTER TABLE help_topic CONVERT TO CHARACTER SET utf8;\n",
"ALTER TABLE help_category CONVERT TO CHARACTER SET utf8;\n",
"ALTER TABLE help_relation CONVERT TO CHARACTER SET utf8;\n",
"ALTER TABLE help_keyword CONVERT TO CHARACTER SET utf8;\n",
"--\n"
  "-- Upgrade a table engine from MyISAM to InnoDB for the system tables\n"
  "-- help_topic, help_category, help_relation, help_keyword, plugin, servers,\n"
  "-- time_zone, time_zone_leap_second, time_zone_name, time_zone_transition,\n"
  "-- time_zone_transition_type, columns_priv, db, procs_priv, proxies_priv,\n"
  "-- tables_priv, user.\n"
  "ALTER TABLE func ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE help_topic ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE help_category ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE help_relation ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE help_keyword ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE plugin ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE servers ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE time_zone ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE time_zone_leap_second ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE time_zone_name ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE time_zone_transition ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE time_zone_transition_type ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE db ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE user ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE tables_priv ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE columns_priv ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE procs_priv ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"ALTER TABLE proxies_priv ENGINE=InnoDB STATS_PERSISTENT=0;\n",
"--\n"
  "-- CREATE_ROLE_ACL and DROP_ROLE_ACL\n"
  "--\n"
  "ALTER TABLE user ADD Create_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER account_locked"
  ";\n",
"ALTER TABLE user MODIFY Create_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER account_locked"
  ";\n",
"ALTER TABLE user ADD Drop_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_role_priv;\n",
"ALTER TABLE user MODIFY Drop_role_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL AFTER Create_role_priv"
  ";\n",
"UPDATE user SET Create_role_priv= 'Y', Drop_role_priv= 'Y' WHERE Create_user_priv = 'Y';\n",
"--\n"
  "-- Password_reuse_history, Password_reuse_time and Password_require_current\n"
  "--\n"
  "ALTER TABLE user ADD Password_reuse_history smallint unsigned NULL DEFAULT NULL AFTER Drop_role_priv;\n",
"ALTER TABLE user ADD Password_reuse_time smallint unsigned NULL DEFAULT NULL AFTER Password_reuse_history;\n",
"ALTER TABLE user ADD Password_require_current enum('N', 'Y') COLLATE utf8_general_ci DEFAULT NULL AFTER Password_reuse_t"
  "ime;\n",
"ALTER TABLE user MODIFY Password_require_current enum('N','Y') COLLATE utf8_general_ci DEFAULT NULL AFTER Password_reuse"
  "_time;\n",
"ALTER TABLE user ADD User_attributes JSON DEFAULT NULL AFTER Password_require_current;\n",
"--\n"
  "-- Change engine of the firewall tables to InnoDB\n"
  "--\n"
  "SET @had_firewall_whitelist =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'firewall_whitelist' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"ALTER TABLE mysql.firewall_whitelist ENGINE=InnoDB\";\n",
"SET @str = IF(@had_firewall_whitelist > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.firewall_whitelist \"\n"
  "         \"MODIFY COLUMN USERHOST VARCHAR(288) NOT NULL\";\n",
"SET @str = IF(@had_firewall_whitelist > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @had_firewall_users =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'firewall_users' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"ALTER TABLE mysql.firewall_users ENGINE=InnoDB\";\n",
"SET @str = IF(@had_firewall_users > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.firewall_users \"\n"
  "         \"MODIFY COLUMN USERHOST VARCHAR(288)\";\n",
"SET @str = IF(@had_firewall_users > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Add a column that serves as a primary key of the table\n"
  "--\n"
  "SET @firewall_whitelist_id_column =\n"
  "  (SELECT COUNT(column_name) FROM information_schema.columns\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'firewall_whitelist' AND column_name = 'ID');\n",
"SET @cmd=\"ALTER TABLE mysql.firewall_whitelist ADD ID INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY\";\n",
"SET @str = IF(@had_firewall_whitelist > 0 AND @firewall_whitelist_id_column = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Add Firewall tables for group profiles\n"
  "--\n"
  "SET @had_user_allowlist =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'firewall_whitelist' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @had_group_allowlist =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'firewall_group_allowlist' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS mysql.firewall_group_allowlist(NAME VARCHAR(288) NOT NULL, RULE text NOT NULL, ID "
  "INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY) engine= InnoDB\";\n",
"SET @str = IF(@had_user_allowlist > 0 AND @had_group_allowlist = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS mysql.firewall_groups(NAME VARCHAR(288) PRIMARY KEY, MODE ENUM ('OFF', 'RECORDING'"
  ", 'PROTECTING', 'DETECTING') DEFAULT 'OFF', USERHOST VARCHAR(288)) engine= InnoDB\";\n",
"SET @str = IF(@had_user_allowlist > 0 AND @had_group_allowlist = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"CREATE TABLE IF NOT EXISTS mysql.firewall_membership(GROUP_ID VARCHAR(288), MEMBER_ID VARCHAR(288)) engine= I"
  "nnoDB\";\n",
"SET @str = IF(@had_user_allowlist > 0 AND @had_group_allowlist = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"UPDATE mysql.firewall_whitelist SET rule = RTRIM(rule) WHERE RIGHT(rule, 1) = ' '\";\n",
"SET @str = IF(@had_user_allowlist > 0 AND @had_group_allowlist = 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Change engine, size and charset for audit log tables.\n"
  "--\n"
  "SET @had_audit_log_user =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'audit_log_user' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user DROP FOREIGN KEY audit_log_user_ibfk_1\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user MODIFY COLUMN HOST VARCHAR(255) BINARY NOT NULL\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @had_audit_log_filter =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'audit_log_filter' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_filter ENGINE=InnoDB\";\n",
"SET @str = IF(@had_audit_log_filter > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_filter CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_as_ci\";\n",
"SET @str = IF(@had_audit_log_filter > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @had_audit_log_user =\n"
  "  (SELECT COUNT(table_name) FROM information_schema.tables\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'audit_log_user' AND\n"
  "           table_type = 'BASE TABLE');\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user ENGINE=InnoDB\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_as_ci\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user MODIFY COLUMN USER VARCHAR(32)\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.audit_log_user ADD FOREIGN KEY (FILTERNAME) REFERENCES mysql.audit_log_filter(NAME)\";\n",
"SET @str = IF(@had_audit_log_user > 0, @cmd, \"SET @dummy = 0\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"--\n"
  "-- Update default_value column for cost tables to new defaults\n"
  "-- Note: Column definition must be updated if a default value is changed\n"
  "-- (Must check if column exists to determine whether to add or modify column)\n"
  "--\n"
  "-- Update column definition for mysql.server_cost.default_value\n"
  "SET @have_server_cost_default =\n"
  "  (SELECT COUNT(column_name) FROM information_schema.columns\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'server_cost' AND\n"
  "           column_name = 'default_value');\n",
"SET @op = IF(@have_server_cost_default > 0, \"MODIFY COLUMN \", \"ADD COLUMN \");\n",
"SET @str = CONCAT(\"ALTER TABLE mysql.server_cost \", @op,\n"
  "   \"default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'disk_temptable_create_cost' THEN 20.0\n"
  "       WHEN 'disk_temptable_row_cost' THEN 0.5\n"
  "       WHEN 'key_compare_cost' THEN 0.05\n"
  "       WHEN 'memory_temptable_create_cost' THEN 1.0\n"
  "       WHEN 'memory_temptable_row_cost' THEN 0.1\n"
  "       WHEN 'row_evaluate_cost' THEN 0.1\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"-- Update column definition for mysql.engine_cost.default_value\n"
  "SET @have_engine_cost_default =\n"
  "  (SELECT COUNT(column_name) FROM information_schema.columns\n"
  "     WHERE table_schema = 'mysql' AND table_name = 'engine_cost' AND\n"
  "           column_name = 'default_value');\n",
"SET @op = IF(@have_engine_cost_default > 0, \"MODIFY COLUMN \", \"ADD COLUMN \");\n",
"SET @str = CONCAT(\"ALTER TABLE mysql.engine_cost \", @op,\n"
  "   \"default_value FLOAT GENERATED ALWAYS AS\n"
  "    (CASE cost_name\n"
  "       WHEN 'io_block_read_cost' THEN 1.0\n"
  "       WHEN 'memory_block_read_cost' THEN 0.25\n"
  "       ELSE NULL\n"
  "     END) VIRTUAL\");\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"#\n"
  "# SQL commands for creating the user in MySQL Server which can be used by the\n"
  "# internal server session service\n"
  "# Notes:\n"
  "# This user is disabled for login\n"
  "# This user has:\n"
  "# Select privileges into performance schema tables the mysql.user table.\n"
  "# SUPER, PERSIST_RO_VARIABLES_ADMIN, SYSTEM_VARIABLES_ADMIN, BACKUP_ADMIN,\n"
  "# CLONE_ADMIN, SHUTDOWN privileges\n"
  "#\n"
  "INSERT IGNORE INTO mysql.user VALUES ('localhost','mysql.session','N','N','N','N','N','N','N','Y','N','N','N','N','N'"
  ",'N','N','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'caching_sha2_password','$A$005$"
  "THISISACOMBINATIONOFINVALIDSALTANDPASSWORDTHATMUSTNEVERBRBEUSED','N',CURRENT_TIMESTAMP,NULL,'Y', 'N', 'N', NULL, NULL"
  ", NULL, NULL);\n",
"UPDATE user SET Create_role_priv= 'N', Drop_role_priv= 'N' WHERE User= 'mysql.session';\n",
"UPDATE user SET Shutdown_priv= 'Y' WHERE User= 'mysql.session';\n",
"INSERT IGNORE INTO mysql.tables_priv VALUES ('localhost', 'mysql', 'mysql.session', 'user', 'root\\@localhost', CURRENT_T"
  "IMESTAMP, 'Select', '');\n",
"INSERT IGNORE INTO mysql.db VALUES ('localhost', 'performance_schema', 'mysql.session','Y','N','N','N','N','N','N','N','"
  "N','N','N','N','N','N','N','N','N','N','N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'PERSIST_RO_VARIABLES_ADMIN', 'N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'SYSTEM_VARIABLES_ADMIN', 'N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'SESSION_VARIABLES_ADMIN', 'N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'BACKUP_ADMIN', 'N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'CLONE_ADMIN', 'N');\n",
"INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'CONNECTION_ADMIN', 'N');\n",
"# mysql.session is granted the SUPER and other administrative privileges.\n"
  "# This user should not be modified inadvertently. Therefore, server grants\n"
  "# the SYSTEM_USER privilege to this user at the time of initialization or\n"
  "# upgrade.\n"
  "INSERT IGNORE INTO mysql.global_grants VALUES ('mysql.session', 'localhost', 'SYSTEM_USER', 'N');\n",
"# Move all system tables with InnoDB storage engine to mysql tablespace.\n"
  "SET @cmd=\"ALTER TABLE mysql.db TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.user TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.tables_priv TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.columns_priv TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.procs_priv TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"SET @cmd=\"ALTER TABLE mysql.proxies_priv TABLESPACE = mysql\";\n",
"PREPARE stmt FROM @cmd;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"# Alter mysql.ndb_binlog_index only if it exists already.\n"
  "SET @cmd=\"ALTER TABLE ndb_binlog_index TABLESPACE = mysql\";\n",
"SET @str = IF(@have_ndb_binlog_index = 1, @cmd, 'SET @dummy = 0');\n",
"PREPARE stmt FROM @str;\n",
"EXECUTE stmt;\n",
"DROP PREPARE stmt;\n",
"ALTER TABLE mysql.func TABLESPACE = mysql;\n",
"ALTER TABLE mysql.plugin TABLESPACE = mysql;\n",
"ALTER TABLE mysql.servers TABLESPACE = mysql;\n",
"ALTER TABLE mysql.help_topic TABLESPACE = mysql;\n",
"ALTER TABLE mysql.help_category TABLESPACE = mysql;\n",
"ALTER TABLE mysql.help_relation TABLESPACE = mysql;\n",
"ALTER TABLE mysql.help_keyword TABLESPACE = mysql;\n",
"ALTER TABLE mysql.time_zone_name TABLESPACE = mysql;\n",
"ALTER TABLE mysql.time_zone TABLESPACE = mysql;\n",
"ALTER TABLE mysql.time_zone_transition TABLESPACE = mysql;\n",
"ALTER TABLE mysql.time_zone_transition_type TABLESPACE = mysql;\n",
"ALTER TABLE mysql.time_zone_leap_second TABLESPACE = mysql;\n",
"ALTER TABLE mysql.slave_relay_log_info TABLESPACE = mysql;\n",
"ALTER TABLE mysql.slave_master_info TABLESPACE = mysql;\n",
"ALTER TABLE mysql.slave_worker_info TABLESPACE = mysql;\n",
"ALTER TABLE mysql.replication_asynchronous_connection_failover TABLESPACE = mysql;\n",
"ALTER TABLE mysql.replication_asynchronous_connection_failover_managed TABLESPACE = mysql;\n",
"ALTER TABLE mysql.replication_group_member_actions TABLESPACE = mysql;\n",
"ALTER TABLE mysql.gtid_executed TABLESPACE = mysql;\n",
"ALTER TABLE mysql.server_cost TABLESPACE = mysql;\n",
"ALTER TABLE mysql.engine_cost TABLESPACE = mysql;\n",
"# Increase host name length. We need a separate ALTER TABLE to\n"
  "# alter the CHARACTER SET to ASCII, because the syntax\n"
  "# 'CONVERT TO CHARACTER...' above changes all field charset\n"
  "# to utf8_bin.\n"
  "ALTER TABLE db\n"
  "  MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE user\n"
  "  MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE default_roles\n"
  "MODIFY HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "MODIFY DEFAULT_ROLE_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '%' NOT NULL;\n",
"ALTER TABLE role_edges\n"
  "MODIFY FROM_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "MODIFY TO_HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE global_grants\n"
  "MODIFY HOST CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE password_history\n"
  "MODIFY Host CHAR(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE servers\n"
  "MODIFY Host char(255) CHARACTER SET ASCII NOT NULL DEFAULT '',\n"
  "MODIFY Port INT NOT NULL DEFAULT '0';\n",
"ALTER TABLE tables_priv\n"
  "MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "MODIFY Grantor varchar(288) DEFAULT '' NOT NULL;\n",
"ALTER TABLE columns_priv\n"
  "MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL;\n",
"ALTER TABLE slave_master_info\n"
  "MODIFY Host CHAR(255) CHARACTER SET ASCII COMMENT 'The host name of the master.';\n",
"ALTER TABLE procs_priv\n"
  "MODIFY Host char(255) CHARACTER SET ASCII DEFAULT '' NOT NULL,\n"
  "MODIFY Grantor varchar(288) DEFAULT '' NOT NULL;\n",
"# Update the table row format to DYNAMIC\n"
  "ALTER TABLE columns_priv ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE db ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE default_roles ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE engine_cost ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE func ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE global_grants ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE gtid_executed ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE help_category ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE help_keyword ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE help_relation ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE help_topic ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE plugin ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE password_history ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE procs_priv ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE proxies_priv ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE role_edges ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE servers ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE server_cost ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE slave_master_info ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE slave_worker_info ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE replication_asynchronous_connection_failover ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE replication_asynchronous_connection_failover_managed ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE replication_group_member_actions ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE slave_relay_log_info ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE tables_priv ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE time_zone ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE time_zone_name ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE time_zone_leap_second ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE time_zone_transition ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE time_zone_transition_type ROW_FORMAT=DYNAMIC;\n",
"ALTER TABLE user ROW_FORMAT=DYNAMIC;\n",
"-- GRANT SYSTEM_USER ON *.* TO 'mysql.infoschema'@localhost\n"
  "INSERT IGNORE INTO global_grants (USER,HOST,PRIV,WITH_GRANT_OPTION)\n"
  "  VALUES ('mysql.infoschema','localhost','SYSTEM_USER','N');\n",
"-- Add the privilege FLUSH_OPTIMIZER_COSTS for every user who has the\n"
  "-- privilege RELOAD provided that there isn't a user who already has\n"
  "-- privilege FLUSH_OPTIMIZER_COSTS\n"
  "SET @hadFlushOptimizerCostsPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'FLUSH_OPTIMIZER_COSTS');\n",
"INSERT INTO global_grants SELECT user, host, 'FLUSH_OPTIMIZER_COSTS', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadFlushOptimizerCostsPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege FLUSH_STATUS for every user who has the\n"
  "-- privilege RELOAD provided that there isn't a user who already has\n"
  "-- privilege FLUSH_STATUS\n"
  "SET @hadFlushStatusPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'FLUSH_STATUS');\n",
"INSERT INTO global_grants SELECT user, host, 'FLUSH_STATUS', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadFlushStatusPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege FLUSH_USER_RESOURCES for every user who has the\n"
  "-- privilege RELOAD provided that there isn't a user who already has\n"
  "-- privilege FLUSH_USER_RESOURCES\n"
  "SET @hadFlushUserResourcesPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'FLUSH_USER_RESOURCES');\n",
"INSERT INTO global_grants SELECT user, host, 'FLUSH_USER_RESOURCES', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadFlushUserResourcesPriv = 0;\n",
"COMMIT;\n",
"-- Add the privilege FLUSH_TABLES for every user who has the\n"
  "-- privilege RELOAD provided that there isn't a user who already has\n"
  "-- privilege FLUSH_TABLES\n"
  "SET @hadFlushTablesPriv = (SELECT COUNT(*) FROM global_grants WHERE priv = 'FLUSH_TABLES');\n",
"INSERT INTO global_grants SELECT user, host, 'FLUSH_TABLES', IF(grant_priv = 'Y', 'Y', 'N')\n"
  "FROM mysql.user WHERE Reload_priv = 'Y' AND @hadFlushTablesPriv = 0;\n",
"COMMIT;\n",
"SET @@session.sql_mode = @old_sql_mode;\n",
"-- Fixes to inconsistent system table upgrades.\n"
  "ALTER TABLE func\n"
  "  MODIFY ret tinyint DEFAULT '0' NOT NULL;\n",
"ALTER TABLE gtid_executed\n"
  "  CONVERT TO CHARACTER SET utf8mb4;\n",
"ALTER TABLE slave_master_info\n"
  "  MODIFY Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the "
  "slave is connected to a source. Used in Multisource Replication',\n"
  "  MODIFY Bind TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Displays which interface is employed when connecting "
  "to the MySQL server',\n"
  "  MODIFY Ignored_server_ids TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The number of server IDs to be ignored,"
  " followed by the actual server IDs',\n"
  "  MODIFY Uuid TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The master server uuid.',\n"
  "  MODIFY Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log"
  " currently being read from the master.',\n"
  "  MODIFY Ssl_ca TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Authority (CA) ce"
  "rtificate.',\n"
  "  MODIFY Ssl_capath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path to the Certificate Authority (CA) cert"
  "ificates.',\n"
  "  MODIFY Ssl_cert TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL certificate file.',\n"
  "  MODIFY Ssl_cipher TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the cipher in use for the SSL conne"
  "ction.',\n"
  "  MODIFY Ssl_key TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL key file.',\n"
  "  MODIFY Ssl_crl TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Revocation List "
  "(CRL)',\n"
  "  MODIFY Ssl_crlpath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certificate Revocation List "
  "(CRL) files',\n"
  "  MODIFY User_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The user name used to connect to the master.',\n"
  "  MODIFY User_password TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The password used to connect to the master.'"
  ";\n",
"ALTER TABLE slave_relay_log_info\n"
  "  MODIFY Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the "
  "slave is connected to a source. Used in Multisource Replication';\n",
"ALTER TABLE slave_worker_info\n"
  "  MODIFY Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the "
  "slave is connected to a source. Used in Multisource Replication',\n"
  "  MODIFY Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  MODIFY Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  MODIFY Checkpoint_relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  MODIFY Checkpoint_master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,\n"
  "  MODIFY Checkpoint_group_bitmap BLOB NOT NULL;\n",
"ALTER TABLE slave_relay_log_info\n"
  "  MODIFY Require_row_format BOOLEAN NOT NULL COMMENT 'Indicates whether the channel shall only accept row based event"
  "s.';\n",
"ALTER TABLE procs_priv\n"
  "  MODIFY Routine_type enum('FUNCTION', 'PROCEDURE') NOT NULL;\n",
"ALTER TABLE user\n"
  "  MODIFY max_updates int unsigned DEFAULT 0 NOT NULL,\n"
  "  MODIFY max_connections int unsigned DEFAULT 0 NOT NULL,\n"
  "  MODIFY max_user_connections int unsigned DEFAULT 0  NOT NULL,\n"
  "  MODIFY ssl_cipher BLOB NOT NULL,\n"
  "  MODIFY x509_issuer BLOB NOT NULL,\n"
  "  MODIFY x509_subject BLOB NOT NULL;\n",
"ALTER TABLE time_zone\n"
  "  MODIFY Use_leap_seconds enum('Y','N') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL;\n",
NULL
};
