/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.IdBase;

public abstract class AbstractQueryTest
extends AbstractClusterJModelTest {
    protected QueryHolder holder;
    private boolean autotransaction;
    protected Long skip = null;
    protected Long limit = null;
    protected Query.Ordering ordering = null;
    protected String[] orderingFields = null;
    PredicateProvider extraEqualPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraEqual;
        }

        public String toString() {
            return " equal";
        }
    };
    PredicateProvider extraNotEqualPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraEqual.not();
        }

        public String toString() {
            return " not equal";
        }
    };
    PredicateProvider extraBetweenPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraBetween;
        }

        public String toString() {
            return " between";
        }
    };
    PredicateProvider extraInPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraIn;
        }

        public String toString() {
            return " in";
        }
    };
    PredicateProvider extraIsNullPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraIsNull;
        }

        public String toString() {
            return " isNull";
        }
    };
    PredicateProvider extraIsNotNullPredicateProvider = new PredicateProvider(){

        @Override
        public Predicate getPredicate(QueryHolder queryHolder) {
            return queryHolder.extraIsNotNull;
        }

        public String toString() {
            return " isNotNull";
        }
    };

    abstract void createInstances(int var1);

    @Override
    protected int getNumberOfInstances() {
        return 10;
    }

    abstract Class<?> getInstanceType();

    @Override
    public void localSetUp() {
        this.setAutotransaction(false);
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        int n = this.getNumberOfInstances();
        this.createInstances(n);
        this.session.deletePersistentAll(this.getInstanceType());
        this.session.makePersistentAll((Iterable)this.instances);
        if (this.getCleanupAfterTest()) {
            this.addTearDownClasses(this.getInstanceType());
        }
    }

    protected void setAutotransaction(boolean bl) {
        this.autotransaction = bl;
    }

    protected void setLimit(long l) {
        this.skip = null;
        this.limit = l;
    }

    protected void setLimits(long l, long l2) {
        this.skip = l;
        this.limit = l2;
    }

    protected void setOrdering(Query.Ordering ordering, String ... stringArray) {
        this.ordering = ordering;
        this.orderingFields = stringArray;
    }

    protected void printResultInstance(IdBase idBase) {
    }

    public void noWhereQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " noWhere");
        this.tx.commit();
    }

    public void equalQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.equal);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " equal");
        this.tx.commit();
    }

    public void isNullQuery(String string, String string2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.isNull);
        queryHolder.createQuery(this.session);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " isNull");
        this.tx.commit();
    }

    public void isNotNullQuery(String string, String string2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.isNotNull);
        queryHolder.createQuery(this.session);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " isNotNull");
        this.tx.commit();
    }

    public void likeQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.like);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " like");
        this.tx.commit();
    }

    public void deleteEqualQuery(String string, String string2, Object object, int n) {
        if (!this.autotransaction) {
            this.tx.begin();
        }
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.equal);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.checkDeletePersistentAll(string + " delete equal", n);
        if (!this.autotransaction) {
            this.tx.commit();
        }
    }

    public void equalOrEqualQuery(String string, Object object, String string2, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        queryHolder.dobj.where(queryHolder.equalOrEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExtraParameterEqual(object2);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " equal or equal");
        this.tx.commit();
    }

    public void equalOrInQuery(String string, Object object, String string2, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        queryHolder.dobj.where(queryHolder.equalOrIn);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExtraParameterIn(object2);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " equal or in");
        this.tx.commit();
    }

    public void inQuery(String string, Object object, String string2, int ... nArray) {
        this.inQuery("", string, object, string2, nArray);
    }

    public void inQuery(String string, String string2, Object object, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string2, string3);
        queryHolder.dobj.where(queryHolder.in);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterIn(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + string2 + " in");
        this.tx.commit();
    }

    public void inAndInQuery(String string, Object object, String string2, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        queryHolder.dobj.where(queryHolder.inAndIn);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterIn(object);
        queryHolder.setExtraParameterIn(object2);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " in and " + string2 + " in");
        this.tx.commit();
    }

    public void inAndBetweenQuery(String string, Object object, String string2, Object object2, Object object3, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        queryHolder.dobj.where(queryHolder.inAndBetween);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterIn(object);
        queryHolder.setExtraParameterLower(object2);
        queryHolder.setExtraParameterUpper(object3);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " in and " + string2 + " between");
        this.tx.commit();
    }

    public void betweenAndInQuery(String string, Object object, Object object2, String string2, Object object3, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        queryHolder.dobj.where(queryHolder.betweenAndIn);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterLower(object);
        queryHolder.setParameterUpper(object2);
        queryHolder.setExtraParameterIn(object3);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " between and " + string2 + " in");
        this.tx.commit();
    }

    public void greaterThanQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterThan");
        this.tx.commit();
    }

    public void greaterEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterEqual");
        this.tx.commit();
    }

    public void lessThanQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.lessThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessThan");
        this.tx.commit();
    }

    public void lessEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.lessEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessEqual");
        this.tx.commit();
    }

    public void betweenQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.between);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " between");
        this.tx.commit();
    }

    public void greaterThanAndLessThanQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndLessThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessThanAndGreaterThan");
        this.tx.commit();
    }

    public void greaterThanAndLikeQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndLike);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterThanAndLike");
        this.tx.commit();
    }

    public void deleteGreaterThanAndLessThanQuery(String string, String string2, Object object, Object object2, int n) {
        if (!this.autotransaction) {
            this.tx.begin();
        }
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndLessThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.checkDeletePersistentAll(string + " delete lessThanAndGreaterThan", n);
        if (!this.autotransaction) {
            this.tx.commit();
        }
    }

    public void greaterEqualAndLessThanQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqualAndLessThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessThanAndGreaterEqual");
        this.tx.commit();
    }

    public void greaterThanAndLessEqualQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndLessEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessEqualAndGreaterThan");
        this.tx.commit();
    }

    public void greaterEqualAndLessEqualQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqualAndLessEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " lessEqualAndGreaterEqual");
        this.tx.commit();
    }

    public void greaterEqualAndLikeQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqualAndLike);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterEqualAndLike");
        this.tx.commit();
    }

    public void equalAnd1ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.equal.and(predicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(object);
        this.holder.setParameterLower(object);
        this.holder.setParameterUpper(object);
        this.holder.setExtraParameterEqual(object2);
        this.holder.setExtraParameterLower(object2);
        this.holder.setExtraParameterUpper(object2);
        this.holder.setExpectedResultIds(nArray);
        this.holder.checkResults(string + " equal and " + predicate);
        this.tx.commit();
    }

    public void greaterThanAnd1ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.greaterThan.and(predicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(object);
        this.holder.setParameterLower(object);
        this.holder.setParameterUpper(object);
        this.holder.setExtraParameterEqual(object2);
        this.holder.setExtraParameterLower(object2);
        this.holder.setExtraParameterUpper(object2);
        this.holder.setExpectedResultIds(nArray);
        this.holder.checkResults(string + " greater than and " + string2 + predicateProvider.toString());
        this.tx.commit();
    }

    public void greaterEqualAnd1ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.greaterEqual.and(predicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(object);
        this.holder.setParameterLower(object);
        this.holder.setParameterUpper(object);
        this.holder.setExtraParameterEqual(object2);
        this.holder.setExtraParameterLower(object2);
        this.holder.setExtraParameterUpper(object2);
        this.holder.setExpectedResultIds(nArray);
        this.holder.checkResults(string + " greater equal and " + string2 + predicateProvider.toString());
        this.tx.commit();
    }

    public void lessThanAnd1ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.lessThan.and(predicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(object);
        this.holder.setParameterLower(object);
        this.holder.setParameterUpper(object);
        this.holder.setExtraParameterEqual(object2);
        this.holder.setExtraParameterLower(object2);
        this.holder.setExtraParameterUpper(object2);
        this.holder.setExpectedResultIds(nArray);
        this.holder.checkResults(string + " less than and " + string2 + predicateProvider.toString());
        this.tx.commit();
    }

    public void lessEqualAnd1ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, String string3, int ... nArray) {
        this.tx.begin();
        this.holder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(this.holder);
        this.holder.dobj.where(this.holder.lessEqual.and(predicate));
        this.holder.createQuery(this.session);
        this.holder.setParameterEqual(object);
        this.holder.setParameterLower(object);
        this.holder.setParameterUpper(object);
        this.holder.setExtraParameterEqual(object2);
        this.holder.setExtraParameterLower(object2);
        this.holder.setExtraParameterUpper(object2);
        this.holder.setExpectedResultIds(nArray);
        this.holder.checkResults(string + " less equal and " + string2 + predicateProvider.toString());
        this.tx.commit();
    }

    public void equalAnd2ExtraQuery(String string, Object object, String string2, PredicateProvider predicateProvider, Object object2, Object object3, String string3, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string3, string2);
        Predicate predicate = predicateProvider.getPredicate(queryHolder);
        queryHolder.dobj.where(queryHolder.equal.and(predicate));
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setParameterLower(object);
        queryHolder.setParameterUpper(object);
        queryHolder.setExtraParameterEqual(object2);
        queryHolder.setExtraParameterLower(object2);
        queryHolder.setExtraParameterUpper(object3);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " equal and " + predicate);
        this.tx.commit();
    }

    public void notEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not equal");
        this.tx.commit();
    }

    public void notNotEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notEqual.not());
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not not equal");
        this.tx.commit();
    }

    public void notNotNotEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.dobj.not(queryHolder.notEqual.not()));
        queryHolder.createQuery(this.session);
        queryHolder.setParameterEqual(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not not not equal");
        this.tx.commit();
    }

    public void notGreaterThanQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notGreaterThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not greaterThan");
        this.tx.commit();
    }

    public void notGreaterEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notGreaterEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not greaterEqual");
        this.tx.commit();
    }

    public void notLessThanQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notLessThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not lessThan");
        this.tx.commit();
    }

    public void notLessEqualQuery(String string, String string2, Object object, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notLessEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not lessEqual");
        this.tx.commit();
    }

    public void notBetweenQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.notBetween);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " not between");
        this.tx.commit();
    }

    public void greaterThanAndNotGreaterThanQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndNotGreaterThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterThanAndNotGreaterThan");
        this.tx.commit();
    }

    public void greaterEqualAndNotGreaterThanQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqualAndNotGreaterThan);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterEqualAndNotGreaterThan");
        this.tx.commit();
    }

    public void greaterThanAndNotGreaterEqualQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterThanAndNotGreaterEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterThanAndNotGreaterEqual");
        this.tx.commit();
    }

    public void greaterEqualAndNotGreaterEqualQuery(String string, String string2, Object object, Object object2, int ... nArray) {
        this.tx.begin();
        QueryHolder queryHolder = new QueryHolder(this.getInstanceType(), string, string2);
        queryHolder.dobj.where(queryHolder.greaterEqualAndNotGreaterEqual);
        queryHolder.createQuery(this.session);
        queryHolder.setParameterUpper(object2);
        queryHolder.setParameterLower(object);
        queryHolder.setExpectedResultIds(nArray);
        queryHolder.checkResults(string + " greaterEqualAndNotGreaterEqual");
        this.tx.commit();
    }

    public static interface PredicateProvider {
        public Predicate getPredicate(QueryHolder var1);
    }

    class QueryHolder {
        public QueryBuilder builder;
        public QueryDomainType<?> dobj;
        public String propertyName;
        public String extraPropertyName;
        public PredicateOperand propertyPredicate;
        public PredicateOperand paramEqualPredicate;
        public PredicateOperand paramLowerPredicate;
        public PredicateOperand paramUpperPredicate;
        public PredicateOperand paramInPredicate;
        public Predicate equal;
        public Predicate isNull;
        public Predicate isNotNull;
        public Predicate equalOrEqual;
        public Predicate greaterThan;
        public Predicate greaterEqual;
        public Predicate in;
        public Predicate lessThan;
        public Predicate lessEqual;
        public Predicate between;
        public Predicate greaterThanAndLessThan;
        public Predicate greaterEqualAndLessThan;
        public Predicate greaterThanAndLessEqual;
        public Predicate greaterThanAndLike;
        public Predicate greaterEqualAndLessEqual;
        public Predicate greaterEqualAndLike;
        public Predicate notEqual;
        public Predicate notGreaterThan;
        public Predicate notGreaterEqual;
        public Predicate notLessThan;
        public Predicate notLessEqual;
        public Predicate notBetween;
        public Predicate like;
        public Predicate greaterThanAndNotGreaterThan;
        public Predicate greaterEqualAndNotGreaterThan;
        public Predicate greaterThanAndNotGreaterEqual;
        public Predicate greaterEqualAndNotGreaterEqual;
        public PredicateOperand extraParamEqualPredicate;
        public PredicateOperand extraParamLowerPredicate;
        public PredicateOperand extraParamUpperPredicate;
        public PredicateOperand extraParamInPredicate;
        public PredicateOperand extraProperty;
        public Predicate extraEqual;
        public Predicate extraIsNull;
        public Predicate extraIsNotNull;
        public Predicate extraGreaterThan;
        public Predicate extraGreaterEqual;
        public Predicate extraLessThan;
        public Predicate extraLessEqual;
        public Predicate extraBetween;
        public Predicate extraGreaterThanAndLessThan;
        public Predicate extraGreaterEqualAndLessThan;
        public Predicate extraGreaterThanAndLessEqual;
        public Predicate extraGreaterEqualAndLessEqual;
        public Query<?> query;
        public Set<Integer> expectedSet = new HashSet<Integer>();
        public List<Integer> expectedList = new ArrayList<Integer>();
        public List<IdBase> resultList;
        public String expectedIndex;
        private Predicate equalOrIn;
        private Predicate extraIn;
        private Predicate inAndIn;
        private Predicate inAndBetween;
        private Predicate betweenAndIn;

        public QueryHolder(Class<?> clazz, String string, String string2) {
            this.propertyName = string;
            this.builder = AbstractQueryTest.this.session.getQueryBuilder();
            this.dobj = this.builder.createQueryDefinition(clazz);
            this.expectedIndex = string2;
            this.paramEqualPredicate = this.dobj.param("equal");
            this.paramLowerPredicate = this.dobj.param("lower");
            this.paramUpperPredicate = this.dobj.param("upper");
            this.paramInPredicate = this.dobj.param("in");
            this.propertyPredicate = this.dobj.get(string);
            this.equal = this.propertyPredicate.equal(this.paramEqualPredicate);
            this.isNull = this.propertyPredicate.isNull();
            this.isNotNull = this.propertyPredicate.isNotNull();
            this.greaterThan = this.propertyPredicate.greaterThan(this.paramLowerPredicate);
            this.greaterEqual = this.propertyPredicate.greaterEqual(this.paramLowerPredicate);
            this.lessThan = this.propertyPredicate.lessThan(this.paramUpperPredicate);
            this.lessEqual = this.propertyPredicate.lessEqual(this.paramUpperPredicate);
            this.between = this.propertyPredicate.between(this.paramLowerPredicate, this.paramUpperPredicate);
            this.greaterThanAndLessThan = this.lessThan.and(this.greaterThan);
            this.greaterEqualAndLessThan = this.lessThan.and(this.greaterEqual);
            this.greaterThanAndLessEqual = this.lessEqual.and(this.greaterThan);
            this.greaterEqualAndLessEqual = this.lessEqual.and(this.greaterEqual);
            this.in = this.propertyPredicate.in(this.paramInPredicate);
            this.notEqual = this.equal.not();
            this.notGreaterThan = this.greaterThan.not();
            this.notGreaterEqual = this.greaterEqual.not();
            this.notLessThan = this.lessThan.not();
            this.notLessEqual = this.lessEqual.not();
            this.notBetween = this.between.not();
            this.like = this.propertyPredicate.like(this.paramEqualPredicate);
            this.greaterThanAndNotGreaterThan = this.greaterThan.and(this.propertyPredicate.greaterThan(this.paramUpperPredicate).not());
            this.greaterEqualAndNotGreaterThan = this.greaterEqual.and(this.propertyPredicate.greaterThan(this.paramUpperPredicate).not());
            this.greaterThanAndNotGreaterEqual = this.greaterThan.and(this.propertyPredicate.greaterEqual(this.paramUpperPredicate).not());
            this.greaterEqualAndNotGreaterEqual = this.greaterEqual.and(this.propertyPredicate.greaterEqual(this.paramUpperPredicate).not());
            this.greaterThanAndLike = this.greaterThan.and(this.propertyPredicate.like(this.paramUpperPredicate));
            this.greaterEqualAndLike = this.greaterEqual.and(this.propertyPredicate.like(this.paramUpperPredicate));
        }

        public QueryHolder(Class<?> clazz, String string, String string2, String string3) {
            this(clazz, string, string2);
            this.extraPropertyName = string3;
            this.extraParamEqualPredicate = this.dobj.param("extraEqual");
            this.extraParamLowerPredicate = this.dobj.param("extraLower");
            this.extraParamUpperPredicate = this.dobj.param("extraUpper");
            this.extraParamInPredicate = this.dobj.param("extraIn");
            this.extraProperty = this.dobj.get(string3);
            this.extraEqual = this.extraProperty.equal(this.extraParamEqualPredicate);
            this.extraIsNull = this.extraProperty.isNull();
            this.extraIsNotNull = this.extraProperty.isNotNull();
            this.extraGreaterThan = this.extraProperty.greaterThan(this.extraParamLowerPredicate);
            this.extraGreaterEqual = this.extraProperty.greaterEqual(this.extraParamLowerPredicate);
            this.extraLessThan = this.extraProperty.lessThan(this.extraParamUpperPredicate);
            this.extraLessEqual = this.extraProperty.lessEqual(this.extraParamUpperPredicate);
            this.extraBetween = this.extraProperty.between(this.extraParamLowerPredicate, this.extraParamUpperPredicate);
            this.extraGreaterThanAndLessThan = this.extraLessThan.and(this.extraGreaterThan);
            this.extraGreaterEqualAndLessThan = this.extraLessThan.and(this.extraGreaterEqual);
            this.extraGreaterThanAndLessEqual = this.extraLessEqual.and(this.extraGreaterThan);
            this.extraGreaterEqualAndLessEqual = this.extraLessEqual.and(this.extraGreaterEqual);
            this.equalOrEqual = this.equal.or(this.extraEqual);
            this.extraIn = this.extraProperty.in(this.extraParamInPredicate);
            this.equalOrIn = this.equal.or(this.extraIn);
            this.inAndIn = this.in.and(this.extraIn);
            this.inAndBetween = this.in.and(this.extraBetween);
            this.betweenAndIn = this.between.and(this.extraIn);
        }

        public void createQuery(Session session) {
            this.query = session.createQuery(this.dobj);
        }

        public void setParameterEqual(Object object) {
            this.query.setParameter("equal", object);
        }

        public void setParameterLower(Object object) {
            this.query.setParameter("lower", object);
        }

        public void setParameterUpper(Object object) {
            this.query.setParameter("upper", object);
        }

        public void setParameterIn(Object object) {
            this.query.setParameter("in", object);
        }

        public void setExpectedResultIds(int ... nArray) {
            for (int n : nArray) {
                this.expectedSet.add(n);
                this.expectedList.add(n);
            }
        }

        public void setExtraParameterEqual(Object object) {
            this.query.setParameter("extraEqual", object);
        }

        public void setExtraParameterLower(Object object) {
            this.query.setParameter("extraLower", object);
        }

        public void setExtraParameterUpper(Object object) {
            this.query.setParameter("extraUpper", object);
        }

        public void setExtraParameterIn(Object object) {
            this.query.setParameter("extraIn", object);
        }

        public void checkResults(String string) {
            if (AbstractQueryTest.this.limit != null) {
                if (AbstractQueryTest.this.skip != null) {
                    this.query.setLimits(AbstractQueryTest.this.skip.longValue(), AbstractQueryTest.this.limit.longValue());
                } else {
                    this.query.setLimits(0L, AbstractQueryTest.this.limit.longValue());
                }
            }
            if (AbstractQueryTest.this.ordering != null) {
                this.query.setOrdering(AbstractQueryTest.this.ordering, AbstractQueryTest.this.orderingFields);
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.resultList = this.query.getResultList();
            for (IdBase idBase : this.resultList) {
                AbstractQueryTest.this.printResultInstance(idBase);
                hashSet.add(idBase.getId());
                arrayList.add(idBase.getId());
            }
            AbstractQueryTest.this.errorIfNotEqual("Wrong index used for " + string + " query: ", this.expectedIndex, this.query.explain().get("IndexUsed"));
            if (AbstractQueryTest.this.ordering != null) {
                AbstractQueryTest.this.errorIfNotEqual("Wrong ids returned from ordered " + AbstractQueryTest.this.ordering + " " + string + " query: ", this.expectedList, arrayList);
            } else {
                AbstractQueryTest.this.errorIfNotEqual("Wrong ids returned from " + string + " query: ", this.expectedSet, hashSet);
            }
        }

        public void checkDeletePersistentAll(String string, int n) {
            if (AbstractQueryTest.this.limit != null) {
                if (AbstractQueryTest.this.skip != null) {
                    this.query.setLimits(AbstractQueryTest.this.skip.longValue(), AbstractQueryTest.this.limit.longValue());
                } else {
                    this.query.setLimits(0L, AbstractQueryTest.this.limit.longValue());
                }
            }
            int n2 = this.query.deletePersistentAll();
            AbstractQueryTest.this.errorIfNotEqual("Wrong index used for " + string + " delete  query: ", this.expectedIndex, this.query.explain().get("IndexUsed"));
            AbstractQueryTest.this.errorIfNotEqual("Wrong number of instances deleted for " + string, n, n2);
        }
    }
}

