/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.BinaryPK;

public class BinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<BinaryPK> instances = new ArrayList<BinaryPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(BinaryPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(BinaryPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] byArray = this.getStoragePK(i);
            BinaryPK binaryPK = (BinaryPK)this.session.find(BinaryPK.class, (Object)byArray);
            this.verifyResult("find ", binaryPK, i, false);
        }
    }

    protected void update() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.createInstance(n);
            object.setName(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent(object);
            this.verifyStorage("update ", (BinaryPK)object, n, true);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.getStoragePK(n);
            BinaryPK binaryPK = (BinaryPK)this.session.find(BinaryPK.class, object);
            this.verifyResult("update verify ", binaryPK, n, true);
        }
    }

    protected void delete() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.createInstance(n);
            this.session.deletePersistent(object);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.getStoragePK(n);
            BinaryPK binaryPK = (BinaryPK)this.session.find(BinaryPK.class, object);
            this.errorIfNotEqual("Failed to delete instance: " + n, null, binaryPK);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            BinaryPK binaryPK = this.createInstance(i);
            if (this.getDebug()) {
                System.out.println(this.toString(binaryPK));
            }
            this.instances.add(binaryPK);
        }
    }

    protected BinaryPK createInstance(int n) {
        BinaryPK binaryPK = (BinaryPK)this.session.newInstance(BinaryPK.class);
        binaryPK.setId(this.getStoragePK(n));
        binaryPK.setNumber(n);
        binaryPK.setName(this.getValue(n));
        return binaryPK;
    }

    protected String toString(BinaryPK binaryPK) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BinaryPK[");
        stringBuffer.append(this.toString(binaryPK.getId()));
        stringBuffer.append("]: ");
        stringBuffer.append(binaryPK.getNumber());
        stringBuffer.append(", \"");
        stringBuffer.append(binaryPK.getName());
        stringBuffer.append("\".");
        return stringBuffer.toString();
    }

    protected byte[] getStoragePK(int n) {
        return new byte[]{0, (byte)(n / 256 + 65), (byte)(n % 256 + 65)};
    }

    protected byte[] getResultPK(int n) {
        byte[] byArray = new byte[255];
        byArray[1] = (byte)(n / 256 + 65);
        byArray[2] = (byte)(n % 256 + 65);
        return byArray;
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verifyStorage(String string, BinaryPK binaryPK, int n, boolean bl) {
        this.errorIfNotEqual(string + "mismatch on number", n, binaryPK.getNumber());
        if (bl) {
            this.errorIfNotEqual(string + "mismatch on name", this.getValue(this.NUMBER_OF_INSTANCES - n), binaryPK.getName());
        } else {
            this.errorIfNotEqual(string + "mismatch on name", this.getValue(n), binaryPK.getName());
        }
    }

    protected void verifyResult(String string, BinaryPK binaryPK, int n, boolean bl) {
        this.errorIfNotEqual(string + "mismatch on id", this.toString(this.getResultPK(n)), this.toString(binaryPK.getId()));
        this.errorIfNotEqual("mismatch on number", n, binaryPK.getNumber());
        if (bl) {
            this.errorIfNotEqual(string + "mismatch on name", this.getValue(this.NUMBER_OF_INSTANCES - n), binaryPK.getName());
        } else {
            this.errorIfNotEqual(string + "mismatch on name", this.getValue(n), binaryPK.getName());
        }
    }

    private String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i]));
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }
}

