/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class FindByPrimaryKeyTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 60;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(60);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void testFind() {
        Employee employee;
        int n;
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        int n2 = 0;
        for (n = 0; n < 60; ++n) {
            this.session.makePersistent(this.employees.get(n));
            ++n2;
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 60; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            this.consistencyCheck(employee);
            int n3 = employee.getId();
            if (n3 == n) continue;
            this.error("Expected Employee.id " + n + " but got " + n3);
        }
        this.tx.commit();
        this.failOnError();
        Employee employee2 = (Employee)this.session.find(Employee.class, (Object)160);
        if (employee2 != null) {
            this.error("Autocommit found non-existing row " + employee2.getId());
        }
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        employee = (Employee)this.session.find(Employee.class, (Object)160);
        this.tx.commit();
        if (employee != null) {
            this.error("Non-autocommit found non-existing row " + employee.getId());
        }
    }
}

